
/*
 * This package contains scripts used by the control frame for assignments. 
 * The functions drawJumpControl() and drawHintControl() are used for look
 * and feel. The remianing functions implement interactions between the
 * control bar and the frame that contains the questions.
 */
setIconFolder("modules/skin/images/buttons/assignment");
function onLoad() {
	initControlbar();
}
function onPress(id) {
	window.status = "Loading...";
	doAction(id);
	window.status = "Done";
}
function viewDetails() {
	var frm = document.forms["edu_form"];
	if (document.getElementById("test") != null) {
		frm.action = "modules/viewRecord.TestDetails";
		frm.submit();
	} else {
		onPress("showAllQuestions");
	}
}
function backToGrade() {
	parent.history.back();
}

function gotoJump() {
	if( document.getElementById("jump_ctrl") ) {
		var k = document.getElementById("jump_ctrl").selectedIndex;
		if (k >= 0) {
			document.edu_form.elements["goto"].value = k;
			doAction("goto");
		}
	}
}

function doQuit() {
	parent.close();
}

var numOfFckeditors = 0;

function FCKeditor_OnComplete( editorInstance ){
	numOfFckeditors -= 1;
	if(numOfFckeditors <= 0){
		enabler();
	}
}

function enabler(){
	$("td.menuitem > div").mouseover(function(){
		hover(this);
	}).mouseout(function(){
		hoverOff(this);
	});
	$("td.menuitem > div > span.disabled").removeAttr('class');
	$("td.menuitem > div > a.disabled").removeAttr('class').attr('onclick','').unbind('click');
}

$(function(){
	if (numOfFckeditors == 0){
		enabler();
	}
});

