<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@page import="com.maplesoft.mapleta.session.Context"%>

<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<tiles:useAttribute name="question"/>
<c:set var="classDTO" value="<%= Context.getContext(request.getSession()).getClassDTO() %>"/>
<c:set var="shadow">false</c:set>
<c:if test="${question.author.id != classDTO.id}">
	<c:set var="shadow">true</c:set>
</c:if>

<fmt:bundle	basename="com.maplesoft.mapleta.application.ApplicationResources">

<table>
	<tr>
		<td><strong><fmt:message key="QuestionRepositoryActionForm.name.label"/></strong>:</td>
		<td class="question">
			<span class="<c:if test='${not question.questionPrivate}'>public</c:if>">${question.name}</span>
		</td>
		<td class="preview " colspan="2">
<c:if test="${question.id != 0}">
			<a class="questionLink" href="javascript:displayQuestion(${question.id})"/>
				<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/preview.gif" title="<fmt:message key='QuestionRepositoryActionForm.preview.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.preview.title'/>"/>
			</a>
		<c:if test="${not shadow && question.questionPrivate}">
			<a class="questionLink" href="<%= request.getContextPath() %>/modules/dbEdit.Display?id=${question.id}"/>
				<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/edit.gif" title="<fmt:message key='QuestionRepositoryActionForm.edit.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.edit.title'/>"/>
			</a>
		</c:if>
			<a class="questionLink" href="<%= request.getContextPath() %>/qbeditor/ModifyQuestionGroups.do?id=${question.id}"/>
				<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/modify_groups.gif" title="<fmt:message key='QuestionRepositoryActionForm.modify.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.modify.title'/>"/>
			</a>
			<a class="questionLink" href="<%= request.getContextPath() %>/qbeditor/SelectQuestions.do?questions=${question.id}&dispatch=clone"/>
				<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/clone.gif" title="<fmt:message key='QuestionRepositoryActionForm.clone.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.clone.title'/>"/>
			</a>
	<c:if test="${not shadow}">
		<c:choose>
			<c:when test="${question.deleted}">
			<a class="questionLink" href="<%= request.getContextPath() %>/qbeditor/SelectQuestions.do?questions=${question.id}&dispatch=undelete"/>
				<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/undelete.gif" title="<fmt:message key='QuestionRepositoryActionForm.undelete.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.undelete.title'/>"/>
			</a>
			</c:when>
			<c:when test="${question.questionPrivate}">
			<a class="questionLink" href="<%= request.getContextPath() %>/qbeditor/SelectQuestions.do?questions=${question.id}&dispatch=delete"/>
				<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/delete.gif" title="<fmt:message key='QuestionRepositoryActionForm.delete.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.delete.title'/>"/>
			</a>
			</c:when>
		</c:choose>
		<c:choose>
			<c:when test="${question.questionPrivate}">
				<a class="questionLink" href="<%= request.getContextPath() %>/qbeditor/SelectQuestions.do?questions=${question.id}&dispatch=make_public"/>
					<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/public.gif" title="<fmt:message key='QuestionRepositoryActionForm.makePublic.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.makePublic.title'/>"/>
				</a>
			</c:when>
			<c:otherwise>
				<a class="questionLink" href="<%= request.getContextPath() %>/qbeditor/SelectQuestions.do?questions=${question.id}&dispatch=make_private"/>
					<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/private.gif" title="<fmt:message key='QuestionRepositoryActionForm.makePrivate.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.makePrivate.title'/>"/>
				</a>
			</c:otherwise>
		</c:choose>
	</c:if>		
</c:if>		
		
		</td>
	</tr>
	<tr>
		<td><strong><fmt:message key="QuestionRepositoryActionForm.author.label"/></strong>:</td>
		<td>${question.author.name}</td>
		<td>
			<c:choose>
			<c:when test="${not empty question.comment}">
				<img src="<%=request.getContextPath()%>/modules/dbEdit/images/hasComment.gif" width="13" height="13">
			</c:when>
			<c:otherwise><img src="<%=request.getContextPath()%>/modules/dbEdit/images/empty.gif" width="13" height="13"></c:otherwise>
			</c:choose>
			<c:choose>
			<c:when test="${not empty question.hint}">
				<img src="<%=request.getContextPath()%>/modules/dbEdit/images/hasHints.gif" width="13" height="13">
			</c:when>
			<c:otherwise><img src="<%=request.getContextPath()%>/modules/dbEdit/images/empty.gif" width="13" height="13"></c:otherwise>
			</c:choose>
			<c:choose>
			<c:when test="${not empty question.algorithm}">
				<img src="<%=request.getContextPath()%>/modules/dbEdit/images/hasAlgorithm.gif" width="13" height="13">
			</c:when>
			<c:otherwise><img src="<%=request.getContextPath()%>/modules/dbEdit/images/empty.gif" width="13" height="13"></c:otherwise>
			</c:choose>
			<c:choose>
			<c:when test="${not empty question.solution}">
				<img src="<%=request.getContextPath()%>/modules/dbEdit/images/hasSolution.gif" width="13" height="13">
			</c:when>
			<c:otherwise><img src="<%=request.getContextPath()%>/modules/dbEdit/images/empty.gif" width="13" height="13"></c:otherwise>
			</c:choose>

		</td>
		
	</tr>
	<tr>
		<td><strong><fmt:message key="QuestionRepositoryActionForm.modeDescription.label"/></strong>:</td>
		<td>${question.modeDescription}</td>
		<td>
	<c:choose>
		<c:when test="${question.deleted}">
			<img src="<%=request.getContextPath()%>/modules/dbEdit/images/deleteQuestion.gif" width="13" height="13">
		</c:when>
		<c:when test="${shadow}">
			<img src="<%=request.getContextPath()%>/modules/configureTest/images/shared.gif" width="13" height="13">
		</c:when>
		<c:otherwise>&nbsp;</c:otherwise>
	</c:choose>
		</td>		
	</tr>
	<tr>
		<td><strong><fmt:message key="QuestionRepositoryActionForm.mode.label"/></strong>:</td>
		<td>${question.mode}</td>
		<td>
	<c:if test="${not shadow && fn:length(question.revisions)>0 }">
			<a href="<%= request.getContextPath() %>/qbeditor/Revisions.do?id=${question.id}"><fmt:message key="QuestionRepositoryActionForm.revisions.label"/></a>
	</c:if>
		</td>
	</tr>
	<tr>
		<td><strong><fmt:message key="ModifyQuestionGroupActionForm.created.label"/></strong>:</td>
		<td><fmt:formatDate value="${question.created}" dateStyle="short" type="date"/> <fmt:formatDate value="${question.created}" timeStyle="short" type="time"/></td>
		<td>&nbsp;</td>
	</tr>
</table>

</fmt:bundle>
