<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>
<%@page import="java.util.Date"%>

<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<tiles:useAttribute name="question"/>
<tiles:useAttribute name="annotate"/>

<script src="<%=request.getContextPath()%>/modules/scripts/ajax.js"></script>
<script src="<%=request.getContextPath()%>/modules/scripts/repository.js"></script>
<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/modules/skin/css/repository.css">

<style>
</style>

<fmt:bundle	basename="com.maplesoft.mapleta.application.ApplicationResources">

<div class="container">

<logic:messagesPresent>
<html:messages id="msg" message="false" property="<%= org.apache.struts.Globals.ERROR_KEY %>">
	<span class="errorStyle1" id="error"><c:out value='${msg}' escapeXml="false"/></span>
	<br>
</html:messages>
<br/>
</logic:messagesPresent>

<em class="divider"><fmt:message key="FinishQuestion.FinishQuestion.Label" /></em>
<br/>
<em class="title"><fmt:message key="SelectQuestionsForm.addToGroups.msg"/></em>
<br/><br/>


<html:form action="/SaveQuestion">
<input type="hidden" name="id" value="${question.id}"/>

<tiles:insert definition=".qbeditor.repository.questions.info" flush="false">
	<tiles:put name="question" beanName="question" />
</tiles:insert>
<table>
	<tr>
		<td><strong><fmt:message key="QuestionRepositoryActionForm.public.label"/></strong></td>
		<td><html:checkbox property="questionPublic"/></td>
	</tr>
</table> 
<c:choose>
	<c:when test="${annotate}">
<br/>
<div>
		<strong><fmt:message key="FinishQuestion.DescribeChanges.Label" /></strong><br/>
		<textarea name="annotation" cols="50" rows="4"></textarea>
</div>
	</c:when>
	<c:otherwise>
		<input type="hidden" name="annotation"/>
	</c:otherwise>
</c:choose>

<br/>
<strong><fmt:message key="FinishQuestion.AddToGroups.Label" /></strong>
<div style="position:relative;width:500px;">
	<tiles:insert definition=".qbeditor.repository.group.manager.nosearch" flush="false" />
</div>
<html:submit styleClass="button"><fmt:message key="JspDefault.Submit.Button"/></html:submit>

</html:form>

</div>

</fmt:bundle>
