/*
 * Decompiled with CFR 0.152.
 */
package applets.grapher;

import applets.MessageUtilities;
import applets.grapher.Function;
import applets.grapher.Token;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

class Parser
implements Cloneable,
Serializable,
Function {
    protected Token op = new Token("0", "number");
    protected Parser left = null;
    protected Parser right = null;
    public final short MULTI_CHAR_PER_VAR = 1;
    public final int USE_RESTRICTED_FUNCTIONS = 2;
    public final int DEFAULT_MODE = 0;
    final String[][] CONSTANTS = new String[][]{{"Pi", "3.141592653589793"}, {"pi", "3.141592653589793"}, {"e", "2.718281828459045"}};
    private final String[] FULL_FUNCTIONS = new String[]{"sin", "cos", "tan", "log", "ln", "exp", "abs", "sqrt", "arcsin", "arccos", "arctan", "asin", "acos", "atan", "sec", "csc", "cot", "fact", "erf", "studentst", "binomial", "sum"};
    private final String[] RESTRICTED_FUNCTIONS = new String[]{"sqrt", "Sqrt"};
    protected static final String number = "number";
    protected static final String variable = "variable";
    protected static final String operator = "operator";
    protected static final String unary = "unary";
    protected static final String function = "function";
    protected static final String openParen = "(";
    protected static final String closeParen = ")";
    protected static final String string = "string";
    private Locale mtaLocale = new Locale("en", "US");

    public Parser(Locale theLocale) {
        this.mtaLocale = theLocale;
    }

    public Parser() {
    }

    public void parse(String f) {
        this.buildTree(this.tokenize(f, 0));
    }

    private static Token[] arrayCut(Token[] a, int i, int j, Locale theLocale) {
        if (j - i + 1 <= 0) {
            throw new NumberFormatException(String.valueOf(MessageUtilities.getMessage(theLocale, "Grapher.Parser.Error.ProblemWithExpression")) + " " + Parser.tokenListToString(a));
        }
        Token[] r = new Token[j - i + 1];
        int k = 0;
        while (k < j - i + 1) {
            r[k] = a[k + i];
            ++k;
        }
        return r;
    }

    void buildTree(Token[] tokenList) {
        block20: {
            int breakPos = -1;
            int parCount = 0;
            int lastPrecedence = -1;
            this.left = null;
            this.right = null;
            if (tokenList == null || tokenList.length == 0) {
                throw new NumberFormatException(MessageUtilities.getMessage(this.mtaLocale, "Grapher.Parser.Error.FormulaHasNoSymbols"));
            }
            int i = 0;
            while (i < tokenList.length) {
                int currentPrecedence;
                if (tokenList[i].type == openParen) {
                    ++parCount;
                } else if (tokenList[i].type == closeParen) {
                    --parCount;
                } else if (parCount == 0 && tokenList[i].type == operator && (currentPrecedence = this.operatorPrecedence(tokenList[i])) >= lastPrecedence) {
                    breakPos = i;
                    lastPrecedence = currentPrecedence;
                }
                ++i;
            }
            try {
                if (parCount > 0) {
                    throw new NumberFormatException(String.valueOf(MessageUtilities.getMessage(this.mtaLocale, "Grapher.Parser.Error.NonMatchingParentheses")) + " " + Parser.tokenListToString(tokenList));
                }
                if (parCount < 0) {
                    throw new NumberFormatException(String.valueOf(MessageUtilities.getMessage(this.mtaLocale, "Grapher.Parser.Error.NotMatchingParentheses")) + " " + Parser.tokenListToString(tokenList));
                }
                if (tokenList[0].type == unary && lastPrecedence <= this.operatorPrecedence(tokenList[0])) {
                    if (tokenList[0].text.equals("-")) {
                        this.op = tokenList[0];
                        this.right = (Parser)super.clone();
                        this.right.buildTree(Parser.arrayCut(tokenList, 1, tokenList.length - 1, this.mtaLocale));
                    } else {
                        this.buildTree(Parser.arrayCut(tokenList, 1, tokenList.length - 1, this.mtaLocale));
                    }
                    break block20;
                }
                if (breakPos > 0) {
                    this.left = (Parser)super.clone();
                    this.left.buildTree(Parser.arrayCut(tokenList, 0, breakPos - 1, this.mtaLocale));
                    this.op = tokenList[breakPos];
                    this.right = (Parser)super.clone();
                    this.right.buildTree(Parser.arrayCut(tokenList, breakPos + 1, tokenList.length - 1, this.mtaLocale));
                    break block20;
                }
                if (tokenList.length == 1 && (tokenList[0].type == variable || tokenList[0].type == number)) {
                    this.op = tokenList[0];
                    break block20;
                }
                if (tokenList[0].type == openParen && tokenList[tokenList.length - 1].type == closeParen) {
                    this.buildTree(Parser.arrayCut(tokenList, 1, tokenList.length - 2, this.mtaLocale));
                    break block20;
                }
                if (tokenList[0].type == function) {
                    this.op = tokenList[0];
                    this.right = (Parser)super.clone();
                    this.right.buildTree(Parser.arrayCut(tokenList, 1, tokenList.length - 1, this.mtaLocale));
                    break block20;
                }
                if (tokenList[0].type == string) {
                    this.op = tokenList[0];
                    if (tokenList.length > 1) {
                        this.right = (Parser)super.clone();
                        this.right.buildTree(Parser.arrayCut(tokenList, 1, tokenList.length - 1, this.mtaLocale));
                    }
                    break block20;
                }
                throw new NumberFormatException(String.valueOf(MessageUtilities.getMessage(this.mtaLocale, "Grapher.Parser.Error.ProblemWithExpression")) + " " + Parser.tokenListToString(tokenList));
            }
            catch (CloneNotSupportedException e) {
                throw new NumberFormatException(MessageUtilities.getMessage(this.mtaLocale, "Grapher.Parser.Error.ShouldNeverHappen"));
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Parser p = (Parser)super.clone();
        p.left = p.left != null ? (Parser)p.left.clone() : null;
        p.right = p.right != null ? (Parser)p.right.clone() : null;
        return p;
    }

    public final Object eval(String[] variables, double[] values) {
        if (this.op.type == variable) {
            if (variables != null) {
                int i = 0;
                while (i < variables.length) {
                    if (this.op.text.equals(variables[i])) {
                        return new Double(values[i]);
                    }
                    ++i;
                }
            }
            return this.op.text;
        }
        Object leftValue = this.left == null ? null : this.left.eval(variables, values);
        Object rightValue = this.right == null ? null : this.right.eval(variables, values);
        return this.evaluate(leftValue, this.op, rightValue);
    }

    public final double eval(double x) {
        String[] variable = new String[]{"x"};
        double[] value = new double[]{x};
        Object y = this.eval(variable, value);
        if (y instanceof Double) {
            return (Double)y;
        }
        return Double.NaN;
    }

    Object evaluate(Object leftValue, Token op, Object rightValue) {
        if (op.type == unary) {
            if (rightValue instanceof Double) {
                return new Double(-((Double)rightValue).doubleValue());
            }
            return "-(" + rightValue + closeParen;
        }
        if (op.type == operator) {
            if (leftValue instanceof Double && rightValue instanceof Double) {
                double l = (Double)leftValue;
                double r = (Double)rightValue;
                switch (op.text.charAt(0)) {
                    case '+': {
                        return new Double(l + r);
                    }
                    case '-': {
                        return new Double(l - r);
                    }
                    case '*': {
                        return new Double(l * r);
                    }
                    case '/': {
                        return new Double(l / r);
                    }
                    case '^': {
                        return new Double(Math.pow(l, r));
                    }
                }
            } else {
                String l = leftValue.toString();
                String r = rightValue.toString();
                if (leftValue instanceof String) {
                    l = openParen + l + closeParen;
                }
                if (rightValue instanceof String) {
                    r = openParen + r + closeParen;
                }
                switch (op.text.charAt(0)) {
                    case '+': {
                        return String.valueOf(l) + "+" + r;
                    }
                    case '-': {
                        return String.valueOf(l) + "-" + r;
                    }
                    case '*': {
                        return String.valueOf(l) + "*" + r;
                    }
                    case '/': {
                        return String.valueOf(l) + "/" + r;
                    }
                    case '^': {
                        return String.valueOf(l) + "^" + r;
                    }
                }
            }
        } else {
            if (op.type == function) {
                if (rightValue instanceof Double) {
                    double x = (Double)rightValue;
                    try {
                        if (op.text.equals("sin")) {
                            return new Double(Math.sin(x));
                        }
                        if (op.text.equals("cos")) {
                            return new Double(Math.cos(x));
                        }
                        if (op.text.equals("tan")) {
                            return new Double(Math.tan(x));
                        }
                        if (op.text.equals("log")) {
                            return new Double(Math.log(x) / Math.log(10.0));
                        }
                        if (op.text.equals("ln")) {
                            return new Double(Math.log(x));
                        }
                        if (op.text.equals("exp")) {
                            return new Double(Math.exp(x));
                        }
                        if (op.text.equals("abs")) {
                            return new Double(Math.abs(x));
                        }
                        if (op.text.equals("sqrt") || op.text.equals("Sqrt")) {
                            return new Double(Math.sqrt(x));
                        }
                        if (op.text.equals("asin") || op.text.equals("arcsin")) {
                            return new Double(Math.asin(x));
                        }
                        if (op.text.equals("acos") || op.text.equals("arccos")) {
                            return new Double(Math.acos(x));
                        }
                        if (op.text.equals("atan") || op.text.equals("arctan")) {
                            return new Double(Math.atan(x));
                        }
                        if (op.text.equals("sec")) {
                            return new Double(1.0 / Math.cos(x));
                        }
                        if (op.text.equals("csc")) {
                            return new Double(1.0 / Math.sin(x));
                        }
                        if (op.text.equals("cot")) {
                            return new Double(1.0 / Math.tan(x));
                        }
                        throw new ArithmeticException(String.valueOf(MessageUtilities.getMessage(this.mtaLocale, "Grapher.Parser.Error.UnknownFunction")) + " " + op.text);
                    }
                    catch (ArithmeticException e) {
                        if (e.toString().equals(String.valueOf(MessageUtilities.getMessage(this.mtaLocale, "Grapher.Parser.Error.UnknownFunction")) + " " + op.text)) {
                            throw e;
                        }
                        return String.valueOf(op.text) + openParen + rightValue + closeParen;
                    }
                }
                return String.valueOf(op.text) + openParen + rightValue + closeParen;
            }
            if (op.type == number) {
                return new Double(op.text);
            }
            if (op.type == string) {
                return rightValue == null ? op.text : String.valueOf(op.text) + rightValue;
            }
            if (op.type == variable) {
                throw new IllegalArgumentException(MessageUtilities.getMessage(this.mtaLocale, "Grapher.Parser.Error.InvalidToken"));
            }
            throw new ArithmeticException(String.valueOf(MessageUtilities.getMessage(this.mtaLocale, "Grapher.Parser.Error.CannotEvaluateToken")) + " " + op.type);
        }
        return null;
    }

    boolean foundFunctionIn(Token thisToken, boolean useFullFunctions) {
        String name = thisToken.text.toLowerCase();
        if (useFullFunctions) {
            int i = 0;
            while (i < this.FULL_FUNCTIONS.length) {
                if (name.equals(this.FULL_FUNCTIONS[i])) {
                    thisToken.type = function;
                    thisToken.text = name;
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.RESTRICTED_FUNCTIONS.length) {
                if (name.equals(this.RESTRICTED_FUNCTIONS[i])) {
                    thisToken.type = function;
                    thisToken.text = name;
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < this.FULL_FUNCTIONS.length) {
                if (name.equals(this.FULL_FUNCTIONS[i])) {
                    throw new NumberFormatException(MessageUtilities.getMessage(this.mtaLocale, "Grapher.Parser.Error.IllegalUseOfFunction", thisToken.text));
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isNum(char c) {
        return c >= '0' && c <= '9';
    }

    boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '^';
    }

    private static boolean isWhite(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public static void main(String[] args) {
        Parser p = new Parser();
        p.parse(args[0]);
        System.out.println(p);
    }

    int operatorPrecedence(Token t) {
        if (t.type == operator) {
            switch (t.text.charAt(0)) {
                case '^': {
                    return 1;
                }
                case '/': {
                    return 3;
                }
                case '*': {
                    return 4;
                }
                case '-': {
                    return 5;
                }
                case '+': {
                    return 6;
                }
            }
            throw new NumberFormatException(MessageUtilities.getMessage(this.mtaLocale, "Grapher.Parser.Error.UnknownBinaryOperator", t));
        }
        if (t.type == unary) {
            return 2;
        }
        throw new NumberFormatException(MessageUtilities.getMessage(this.mtaLocale, "Grapher.Parser.Error.BadBinaryOperator", t));
    }

    protected boolean substitutedForConstantsIn(Token thisToken) {
        int i = 0;
        while (i < this.CONSTANTS.length) {
            if (thisToken.text.equals(this.CONSTANTS[i][0])) {
                thisToken.text = this.CONSTANTS[i][1];
                thisToken.type = number;
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        return this.eval(null, null).toString();
    }

    private static String tokenListToString(Token[] tokens) {
        String s = "";
        int i = 0;
        while (i < tokens.length) {
            s = String.valueOf(s) + tokens[i++].text;
        }
        return s;
    }

    /*
     * Unable to fully structure code
     */
    private Token[] tokenize(String s, int mode) {
        tokens = new Vector<Token>();
        pos = 0;
        useFullFunctions = true;
        if ((mode & 2) == 2) {
            useFullFunctions = false;
        }
        oneCharPerVar = true;
        if ((mode & 1) == 1) {
            oneCharPerVar = false;
        }
        s = String.valueOf(s) + " ";
        c = s.charAt(pos++);
        block0: while (pos < s.length()) {
            if (Parser.isWhite(c)) {
                c = s.charAt(pos++);
                continue;
            }
            if (Parser.isAlpha(c)) {
                sb = new StringBuffer();
                thisToken = new Token();
                tokens.addElement(thisToken);
                do {
                    sb.append(c);
                    c = s.charAt(pos++);
                    thisToken.text = sb.toString();
                    if (this.foundFunctionIn(thisToken, useFullFunctions)) continue block0;
                } while (Parser.isAlpha(c));
                if (this.substitutedForConstantsIn(thisToken)) continue;
                thisToken.type = "variable";
                if (!oneCharPerVar) continue;
                pos -= thisToken.text.length();
                c = s.charAt(pos++);
                thisToken.text = "" + thisToken.text.charAt(0);
                continue;
            }
            if (Parser.isNum(c) || c == '.') {
                sb = new StringBuffer();
                thisToken = new Token();
                tokens.addElement(thisToken);
                if (Parser.isNum(c)) {
                    do {
                        sb.append(c);
                    } while (Parser.isNum(c = s.charAt(pos++)));
                }
                if (c == '.') {
                    do {
                        sb.append(c);
                    } while (Parser.isNum(c = s.charAt(pos++)));
                }
                if (c == 'E') {
                    sb.append('E');
                    c = s.charAt(pos++);
                    while (Parser.isWhite(c) && pos < s.length()) {
                        c = s.charAt(pos++);
                    }
                    if (c == '-') {
                        sb.append(c);
                        c = s.charAt(pos++);
                    }
                    if (c == '+') {
                        c = s.charAt(pos++);
                    }
                    if (Parser.isNum(c)) {
                        do {
                            sb.append(c);
                        } while (Parser.isNum(c = s.charAt(pos++)));
                    } else {
                        throw new NumberFormatException(MessageUtilities.getMessage(this.mtaLocale, "Grapher.Parser.Error.BadNumberFormat", new Object[]{sb}));
                    }
                }
                thisToken.text = sb.toString();
                thisToken.type = "number";
                continue;
            }
            thisToken = new Token("" + c, "");
            if (c == '(') {
                thisToken.type = "(";
            } else if (c == ')') {
                thisToken.type = ")";
            } else if (this.isOperator(c)) {
                thisToken.type = "operator";
            } else if (c == '\"') {
                sb = new StringBuffer();
                while (pos < s.length() && (c = s.charAt(pos)) != '\"') {
                    sb.append(c);
                    ++pos;
                }
                thisToken.type = "string";
                thisToken.text = sb.toString();
            } else {
                throw new NumberFormatException(MessageUtilities.getMessage(this.mtaLocale, "Grapher.Parser.Error.IllegalCharacterInFormula", new Object[]{Character.valueOf(c)}));
            }
            tokens.addElement(thisToken);
            v0 = ++pos;
            ++pos;
            c = s.charAt(v0);
        }
        m = new Token("*", "operator");
        i = 0;
        while (i < tokens.size()) {
            a = i == 0 ? null : (Token)tokens.elementAt(i - 1);
            b = (Token)tokens.elementAt(i);
            if ((i == 0 || a.type == "(" || a.type == "operator" || a.type == "unary") && (b.text.equals("+") || b.text.equals("-")) && b.type != "string") {
                b.type = "unary";
            } else if (i > 0 && (a.type == "variable" || a.type == "number" || a.type == ")") && b.type != "operator" && b.type != ")") {
                tokens.insertElementAt(m, i++);
            }
            ++i;
        }
        v = new Vector<Token>();
        i = 0;
        while (i < tokens.size()) {
            a = (Token)tokens.elementAt(i);
            if (a.type != "unary" || i + 1 >= tokens.size()) ** GOTO lbl-1000
            b = (Token)tokens.elementAt(i + 1);
            if (b.type == "number") {
                b.text = String.valueOf(a.text) + b.text;
                v.addElement(b);
                ++i;
            } else lbl-1000:
            // 2 sources

            {
                v.addElement(a);
            }
            ++i;
        }
        tokens = v;
        r = new Token[tokens.size()];
        tokens.copyInto(r);
        return r;
    }
}

