<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://displaytag.sf.net" prefix="display" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>
<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>

<tiles:useAttribute name="students" />
<tiles:useAttribute name="delete" />
<tiles:useAttribute name="externalList" />

<script>
function doSubmit(_action) {
	var form = document.forms['AddExternalForm'];	
	var action = '<%= request.getContextPath() %>/' + _action;
	form.action = action;
	form.submit();
}
function doAction(_action) {
	action(_action, '');
}

function action(_action, _param) {
	var form = document.forms['viewSearchForm'];
	var action = '<%= request.getContextPath() %>/gradebook/' + _action + '.do'
	
	form.action= action + '?' + _param;
	form.submit();
}

function doDelete() {
	if( !confirm("<fmt:message key='gbk.gradebooks.confirmDelete.msg'/>") ) {
		return false;
	}	
	var frm = document.getElementById('AddExternalForm');
	frm.action = 'gradebook/DeleteExternal.do';
	frm.submit();	
}
function doLoad() {
	var obj = document.getElementById('extId');
	if( obj.length == 0 || obj.value < 1) {
		alert("<fmt:message key='msg.external.none_selected.msg'/>");
		return false;
	} 

	document.location.href = '<%= request.getContextPath() %>/gradebook/External.do?asgnId=' + obj.value;
}
function doNew() {
	document.location.href = '<%= request.getContextPath() %>/gradebook/External.do';
}
</script>
<%-- 
<fmt:bundle basename="com.maplesoft.mapleta.gradebook.struts.app.ApplicationResources">
 --%>
 <fmt:bundle basename="com.maplesoft.mapleta.application.ApplicationResources">

<logic:messagesPresent>
<html:messages id="msg" message="false">
	<span class="errorStyle1"><c:out value='${msg}' escapeXml="false"/></span>
	<br>
</html:messages>
<br/>
</logic:messagesPresent>


<em class="divider"><fmt:message key="label.external.assignment"/></em>
<br/>

<c:if test="${not empty externalList}">
	<strong><fmt:message key="AddExternalForm.choose.label"/></strong>:
	<select id="extId" name=extId">
		<option value="-1"></option>
	<c:forEach var="asgn" items="${externalList}">
		
		<option 
		<c:if test="${AddExternalForm.id == asgn.id}">selected="selected"</c:if>
		value="${asgn.id}">${asgn.name}</option>
	</c:forEach>
	</select>
	<br/><br/>
</c:if>
<html2:form action="/SaveExternal" validatorForm="AddExternalForm" focus="name" enctype="multipart/form-data">
<input type="hidden" name="add_external" id="add_external" value="submit" />
<input type="hidden" name="actionID" id="actionID" value="add_external" />
<html2:hidden property="id"/>
<input type="hidden" name="showStudents" value="true" />
<input type="hidden" name="showGivenName" value="true" />
<input type="hidden" name="showLastName" value="true" />
<input type="hidden" name="showAsgnAveScore" value="true" />
<input type="hidden" name="showAsgnTotalPoints" value="true" />


<input type="button" class="button" onclick="doNew();" value='<fmt:message key="gbk.gradebooks.new.label" />'/>
<c:if test="${not empty externalList}">
	<input type="button" class="button" onclick="doLoad();" value='<fmt:message key="gbk.gradebooks.load.label" />'/>
</c:if>
<html:submit styleClass="button"><fmt:message key="AddExternalForm.save.label"/></html:submit>

<c:if test="${delete}">
	<input type="button" class="button" onclick="doDelete();" value='<fmt:message key="AddExternalForm.delete.label" />'/>
</c:if>

<br/><br/>
<table>
<tr>
	<html2:field property="name">
	<td><strong><html2:label/>:</strong></td>
	<td><html2:text property="name" size="40"/></td>
	<td><html2:error styleClass="errorStyle1"/></td>
	</html2:field>
</tr>
<tr>
	<html2:field property="totalPoints">
	<td><strong><html2:label/>:</strong></td>
	<td><html2:text property="totalPoints" size="2"/></td>
	<td><html2:error /></td>
	</html2:field>
</tr>
<tr>
	<html2:field property="passingScore">
	<td><strong><html2:label/>:</strong></td>
	<td><html2:text property="passingScore" size="2"/></td>
	<td><html2:error /></td>
	</html2:field>
</tr>

<table class="simple">
	<thead>
		<tr>
			<th><fmt:message key="AddExternalForm.student.label"/></th>
			<th><fmt:message key="AddExternalForm.scores.label"/></th>
			<th><fmt:message key="AddExternalForm.comment.label"/></th>
		</tr>
	</thead>
<c:forEach var="student" items="${students}" varStatus="counter">
	<tr>
		<td>${student.givenName} ${student.sn}
			<html:hidden property="users" value="${student.id}"/>
			<html:hidden property="trIds" value="${AddExternalForm.trIds[counter.count-1]}"/>
		</td>
		<td><input type="text" name="scores" value="${AddExternalForm.scores[counter.count-1]}" size="2"/></td>
		<td><input type="text" name="comments" value="${AddExternalForm.comments[counter.count-1]}" size="60"/></td>
	</tr>
</c:forEach>
</table>
</html2:form>

</fmt:bundle>
