<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>

<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic" %>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<script src="<%=GatewayService.getServerURL()%>modules/scripts/repository.js"></script>
<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/skin/css/gbk.css">
<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/skin/css/repository.css">

<tiles:useAttribute name="action"/>

<script>
function doSubmit(_action) {
	var form = document.forms['viewSearchForm'];	
	var action = '<%= request.getContextPath() %>/' + _action;
	form.action = action;
	form.submit();
}

function doAction(_action) {
	action(_action, '');
}

function action(_action, _param) {
	var form = document.forms['viewSearchForm'];
	
	var action = '<%= request.getContextPath() %>/gradebook/' + _action + '.do';
	
	form.action= action + '?' + _param;
	form.submit();
}
function sort(_sort) {
	var form = document.forms['viewSearchForm'];
	var sortAction = '<%= request.getContextPath() %>/gradebook${action}Sort.do'
	
	form.action= sortAction + '?sort=' + _sort;
	form.submit();
} 
function sortGrade(_sort, _id) {
	var form = document.forms['viewSearchForm'];
	var sortAction = '<%= request.getContextPath() %>/gradebook${action}Sort.do'
	
	form.action= sortAction + '?sort=' + _sort + '&sortId=' + _id;
	form.submit();
} 
function page(_page) {
	var form = document.forms['viewSearchForm'];
	var pageAction = '<%= request.getContextPath() %>/gradebook${action}Page.do'
	
	form.action= pageAction + '?page=' + _page;
	form.submit();
} 
function refresh(_export) {
	var form = document.forms['viewSearchForm'];
	var view = document.getElementById('refreshView');
	
	var pageAction = '';
	var exp = '';
	if( _export ) {
		exp = '?export=' + _export;
	}
	if( view.value == 'refresh.class' ) {
		pageAction = '<%= request.getContextPath() %>/gradebook/RefreshClass.do' + exp;
	}
	else if( view.value == 'refresh.assignment' ) {
		pageAction = '<%= request.getContextPath() %>/gradebook/RefreshAssignment.do' + exp;
	}
	else if( view.value == 'refresh.qugroup' ) {
		pageAction = '<%= request.getContextPath() %>/gradebook/RefreshQGroup.do' + exp;
	}
	else if( view.value == 'refresh.user' ) {
		pageAction = '<%= request.getContextPath() %>/gradebook/RefreshUser.do' + exp;
	}
	else if( view.value == 'refresh.student' ) {
		pageAction = '<%= request.getContextPath() %>/gradebook/RefreshStudent.do' + exp;
	}
	else if( view.value == 'refresh.details.instructor' ) {
		pageAction = '<%= request.getContextPath() %>/gradebook/RefreshDetails.do' + exp;
	}
	else if( view.value == 'refresh.details.question' ) {
		pageAction = '<%= request.getContextPath() %>/gradebook/RefreshQuestionDetails.do' + exp;
	}
	
	var oldAction = form.action;

	form.action= pageAction;
	form.submit();
	
	form.action = oldAction;
}

function showDetails(_id) {
	var details = document.getElementById(_id);
	if( details ) { 
		details.className='showDetails';
	}
}
function showGradeDetails(_id) {
	var details = document.getElementById(_id);
	if( details ) { 
		details.className='showGradeDetails';
	}
}
function hideDetails(_id) {
	var details = document.getElementById(_id);
	if( details ) { 
		details.className='hidden';
	}
}

</script>


<fmt:setBundle 
	basename="com.maplesoft.mapleta.application.ApplicationResources" 
	scope="request"/>

<html:form action="${action}" styleId="viewSearchForm" enctype="multipart/form-data" >
	<html:hidden styleId="viewSearchFormAction" property="actionID"/>
	<html:hidden styleId="viewSearchFormAssignmentId" property="assignmentId"/>
	<html:hidden styleId="viewSearchFormTrId" property="trId"/>
	
<div>
	<tiles:insert attribute="panel" flush="false"/>
</div>

<div id="searchSummary">
	<tiles:insert definition=".gbk.common.searchSummary"/>
</div>

<logic:notEmpty name="csvFile" scope="request">
<div>
<fmt:message key="RosterAdmin.csv.begin.msg"/>
<a href="<%=request.getContextPath()%>${csvFile}">
	<fmt:message key="RosterAdmin.csv.download.label"/>
</a>
</div>
</logic:notEmpty>

<div id="gradeContent">

<logic:messagesPresent>
<br/>
<html:messages id="msg" message="false">
	<span class="errorStyle1"><c:out value='${msg}' escapeXml="false"/></span>
	<br>
</html:messages>
</logic:messagesPresent>

<div id="gradesTable">
	<tiles:insert attribute="table"/>
</div>

</div>

</html:form>
<script>initTwisty();</script>

