/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mapleta.hotfix.installer;

import com.maplesoft.mapleta.hotfix.installer.FileOperationSpec;
import com.maplesoft.mapleta.hotfix.installer.InstallableFileOperationSpec;
import com.maplesoft.mapleta.hotfix.installer.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotfixDef {
    private final String hotfixDefFilename = "hotfix.def";
    private static Pattern idPattern = Pattern.compile("^Id\\s*=\\s*(.*)$");
    private static Pattern idParserPattern = Pattern.compile("^(\\d+)-((([a-zA-Z][a-zA-Z])(-([a-zA-Z][a-zA-Z]))*)|(\\d{3}))((-SP)|(-BB)|(-\\d{3}))*$");
    private static Pattern descriptionPattern = Pattern.compile("^Description\\s*=\\s*(.*)");
    private static Pattern tomcatFolderattern = Pattern.compile("^TomcatInstallPath\\s*=\\s*(.*)");
    private static Pattern mapleTAContextNamePattern = Pattern.compile("^MapleTAContextName\\s*=\\s*(.*)");
    private static Pattern fileOperationSpecPattern = Pattern.compile("^(Update|Add|Delete)\\s*source\\s*=\\s*(.*)\\s+target\\s*=\\s*(.*)");
    private String hotfixId = "";
    private String hotfixFlatVersionNumber = "";
    private String hotfixOrdinal = "";
    private String description = "";
    private String tomcatFolder = "";
    private String contextName = "mapleta";
    private List<FileOperationSpec> fileOperationSpecs = new ArrayList<FileOperationSpec>();

    public String getHotfixId() {
        return this.hotfixId;
    }

    public String getHotfixFlatVersionNumber() {
        return this.hotfixFlatVersionNumber;
    }

    public String getHotfixOrdinal() {
        return this.hotfixOrdinal;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTomcatFolder() {
        return this.tomcatFolder;
    }

    public String getContextName() {
        return this.contextName;
    }

    public List<FileOperationSpec> getFileOperationSpecs() {
        return this.fileOperationSpecs;
    }

    public List<InstallableFileOperationSpec> getInstallableFileOperationSpecs(String mapleTADeploymentFolder) {
        ArrayList<InstallableFileOperationSpec> specs = new ArrayList<InstallableFileOperationSpec>();
        for (FileOperationSpec spec : this.getFileOperationSpecs()) {
            specs.add(new InstallableFileOperationSpec(spec, mapleTADeploymentFolder));
        }
        return specs;
    }

    public HotfixDef() throws Exception {
        try {
            this.ParseDef();
        }
        catch (Exception ex) {
            throw new Exception(String.format("Hotfix Installer: error while processing file '%s'.", "hotfix.def"), ex);
        }
    }

    private void ParseDef() throws Exception {
        String line;
        LineNumberReader reader = null;
        reader = new LineNumberReader(new FileReader("hotfix.def"));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            Matcher matcher = idPattern.matcher(line);
            if (matcher.find()) {
                this.hotfixId = matcher.group(1);
                matcher = idParserPattern.matcher(this.hotfixId);
                if (matcher.find()) {
                    this.hotfixFlatVersionNumber = matcher.group(1);
                    this.hotfixOrdinal = matcher.group(2);
                    continue;
                }
                throw new Exception(String.format("Hotfix id '%s' is not valid.", this.hotfixId));
            }
            matcher = mapleTAContextNamePattern.matcher(line);
            if (matcher.find()) {
                this.contextName = matcher.group(1).trim();
                continue;
            }
            matcher = descriptionPattern.matcher(line);
            if (matcher.find()) {
                this.description = matcher.group(1);
                continue;
            }
            matcher = tomcatFolderattern.matcher(line);
            if (matcher.find()) {
                this.tomcatFolder = Platform.NormalizePathSeparators(matcher.group(1));
                continue;
            }
            matcher = fileOperationSpecPattern.matcher(line);
            if (!matcher.find()) continue;
            FileOperationSpec.FileOperation op = matcher.group(1).equals("Add") ? FileOperationSpec.FileOperation.ADD : (matcher.group(1).equals("Delete") ? FileOperationSpec.FileOperation.DELETE : FileOperationSpec.FileOperation.UPDATE);
            this.fileOperationSpecs.add(new FileOperationSpec(op, matcher.group(2), matcher.group(3)));
        }
        if (this.tomcatFolder.length() > 0) {
            File folder = new File(this.tomcatFolder);
            if (!folder.isDirectory()) {
                throw new Exception(String.format("tomcatFolder value '%s' is not a directory.", this.tomcatFolder));
            }
            File taFolder = new File(String.valueOf(this.tomcatFolder) + File.separatorChar + "webapps" + File.separatorChar + this.contextName);
            if (!taFolder.isDirectory()) {
                throw new Exception(String.format("tomcatFolder value '%s' does not appear to contain a Maple T.A. deployment.", taFolder.getAbsolutePath()));
            }
        }
    }
}

