/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mapleta.hotfix.installer;

import com.maplesoft.mapleta.hotfix.installer.Installer;
import com.maplesoft.mapleta.hotfix.installer.MapleTADataSource;
import com.maplesoft.mapleta.hotfix.installer.Platform;
import com.maplesoft.mapleta.hotfix.installer.TomcatFolderFinder;
import com.maplesoft.mapleta.hotfix.installer.UpdateLogger;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TomcatInstallationManager {
    private static Pattern versionPattern = Pattern.compile(".*>Maple T.A. (\\d+)\\.(\\d+)<");
    private String tomcatFolder = "";
    private String mapletaDeploymentFolder = "";
    private String majorTAVersion = "";
    private String minorTAVersion = "";
    private MapleTADataSource mapleTADataSource;

    public String getTomcatFolder() {
        return this.tomcatFolder;
    }

    public String getMapletaDeploymentFolder() {
        return this.mapletaDeploymentFolder;
    }

    public String getMajorTAVersion() {
        return this.majorTAVersion;
    }

    public String getMinorTAVersion() {
        return this.minorTAVersion;
    }

    public MapleTADataSource getMapleTADataSource() {
        return this.mapleTADataSource;
    }

    public TomcatInstallationManager(String userSpecifiedTomcatFolder) throws Exception {
        this.tomcatFolder = userSpecifiedTomcatFolder;
        if (this.tomcatFolder.length() == 0) {
            UpdateLogger.getLogger().Log("Searching for a Tomcat Maple T.A. deployment.");
            TomcatFolderFinder finder = new TomcatFolderFinder();
            if (Platform.IsWindows()) {
                this.tomcatFolder = finder.findFromRegistry();
            }
            if (this.tomcatFolder.length() == 0) {
                this.tomcatFolder = finder.find();
            }
            if (this.tomcatFolder.length() == 0) {
                List<String> tomcatFolders = finder.getTomcatFolders();
                if (tomcatFolders.size() == 0) {
                    UpdateLogger.getLogger().Log("Unable to find a Tomcat Maple T.A. deployment.");
                } else {
                    UpdateLogger.getLogger().Log("Found Multiple Tomcat Maple T.A. deployments.");
                    int i = 0;
                    while (i < tomcatFolders.size()) {
                        UpdateLogger.getLogger().Log(String.format("%d. '%s'.", i + 1, tomcatFolders.get(i)));
                        ++i;
                    }
                }
                throw new Exception("Please edit hotfix.def and specify the Tomcat installation folder to hotfix.");
            }
        }
        this.mapletaDeploymentFolder = String.valueOf(this.tomcatFolder) + File.separatorChar + "webapps" + File.separatorChar + Installer.getHotfixDef().getContextName();
        this.InitializeTAVersion();
        this.InitializeMapleTADataSource();
        UpdateLogger.getLogger().Log(String.format("Hotfixing deployment '%s'.", this.mapletaDeploymentFolder));
    }

    /*
     * Exception decompiling
     */
    private void InitializeTAVersion() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void InitializeMapleTADataSource() throws Exception {
        String contextXmlPath = String.valueOf(this.mapletaDeploymentFolder) + File.separatorChar + "META-INF" + File.separatorChar + "context.xml";
        File file = new File(contextXmlPath);
        if (!file.isFile()) {
            throw new Exception(String.format("Maple T.A. configuration file not found: '%s'.", contextXmlPath));
        }
        try {
            this._InitializeMapleTADataSource(file);
        }
        catch (Exception ex) {
            throw new Exception(String.format("Error while processing '%s'.", contextXmlPath), ex);
        }
    }

    private void _InitializeMapleTADataSource(File contextXmlPathFile) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(contextXmlPathFile);
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Node mapletaResource = (Node)xpath.evaluate("/Context/Resource[@name='jdbc/LocalMapleTADataSource']", doc, XPathConstants.NODE);
        String user = xpath.evaluate("@username", mapletaResource);
        String password = xpath.evaluate("@password", mapletaResource);
        String jdbcUrl = xpath.evaluate("@url", mapletaResource);
        this.mapleTADataSource = new MapleTADataSource(user, password, jdbcUrl);
    }
}

