/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.commandlineoptions;

import com.maplesoft.util.commandlineoptions.AbstractOptionHandler;
import com.maplesoft.util.commandlineoptions.CommandOptionException;
import com.maplesoft.util.commandlineoptions.CommandOptionParser;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeometryOptionHandler
extends AbstractOptionHandler {
    private int specifiedWidth = 0;
    private int specifiedHeight = 0;
    private int specifiedXPosition = 0;
    private int specifiedYPosition = 0;
    private boolean wasSet = false;
    public static final String GEOMETRY_OPTION = "geometry";
    public static final String CONCATENATION_CLEANING_SPEC = "eometry";
    public static final String GEOMETRY_REGEX = "(\\d+)x(\\d+)([\\+-])(-?\\d+)([\\+-])(-?\\d+)";

    public GeometryOptionHandler() {
        this.addOptionNames(new String[]{GEOMETRY_OPTION});
    }

    public void handle(CommandOptionParser commandOptionParser, String[] stringArray) throws CommandOptionException {
        try {
            this.wasSet = false;
            String string = this.cleanSpecification(stringArray[1]);
            Pattern pattern = Pattern.compile(GEOMETRY_REGEX);
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                String string4 = matcher.group(3);
                String string5 = matcher.group(4);
                String string6 = matcher.group(5);
                String string7 = matcher.group(6);
                this.specifiedWidth = Integer.parseInt(string2);
                this.specifiedHeight = Integer.parseInt(string3);
                this.specifiedXPosition = Integer.parseInt(string5);
                this.specifiedYPosition = Integer.parseInt(string7);
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                if (string4.equals("-")) {
                    this.specifiedXPosition = (int)dimension.getWidth() - this.specifiedWidth - this.specifiedXPosition;
                }
                if (string6.equals("-")) {
                    this.specifiedYPosition = (int)dimension.getHeight() - this.specifiedHeight - this.specifiedYPosition;
                }
                this.wasSet = true;
            }
        }
        catch (Exception exception) {
            throw new CommandOptionException("Problem with format of geometry specification (" + this.cleanSpecification(stringArray[0]) + ")");
        }
    }

    private String cleanSpecification(String string) {
        return string.startsWith(CONCATENATION_CLEANING_SPEC) ? string.substring(CONCATENATION_CLEANING_SPEC.length()) : string;
    }

    public boolean isConcatenationAllowed() {
        return true;
    }

    public int numArgs() {
        return 1;
    }

    public boolean isConfigured() {
        return this.wasSet;
    }

    public int getWidth() {
        return this.specifiedWidth;
    }

    public int getHeight() {
        return this.specifiedHeight;
    }

    public int getXPosition() {
        return this.specifiedXPosition;
    }

    public int getYPosition() {
        return this.specifiedYPosition;
    }
}

