/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.WmiStartupMonitor;
import java.lang.reflect.Method;

public class WmiStartup {
    protected static boolean printTiming;
    protected static long startTime;
    private static long expectedTime;
    private static long expectedClassCount;
    private static Method classcountMethod;
    private static WmiStartupMonitor startupMonitor;
    private static Object startupWaiters;
    static final /* synthetic */ boolean $assertionsDisabled;

    private WmiStartup() {
    }

    public static void setExpectedStartupTime(long l) {
        expectedTime = l;
    }

    public static void setExpectedClassCount(int n) {
        expectedClassCount = n;
    }

    protected static boolean startupPercentageKnown() {
        return expectedTime != 0L || expectedClassCount != 0L;
    }

    public static long getTime() {
        long l = System.currentTimeMillis() - startTime;
        return l;
    }

    public static long estimateTimeLeft() {
        return Math.max(expectedTime - WmiStartup.getTime(), 0L);
    }

    public static int getClassCount() {
        try {
            ClassLoader classLoader = WmiStartup.class.getClassLoader();
            if (classcountMethod == null) {
                classcountMethod = classLoader.getClass().getMethod("getClassCount", null);
            }
            Integer n = (Integer)classcountMethod.invoke((Object)classLoader, null);
            return n;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return 0;
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION: " + exception);
            exception.printStackTrace();
            return 0;
        }
    }

    protected static void debugPrint(String string) {
        if (printTiming) {
            // empty if block
        }
    }

    public static int percentDone() {
        int n = 0;
        int n2 = 0;
        if (expectedTime != 0L) {
            ++n2;
            n += (int)((double)WmiStartup.getTime() * 100.0 / (double)expectedTime);
        }
        if (expectedClassCount != 0L) {
            ++n2;
            n += (int)((double)WmiStartup.getClassCount() * 100.0 / (double)expectedClassCount);
        }
        if (n2 == 0) {
            return 0;
        }
        return n / n2;
    }

    public static void progress(String string) {
        if (printTiming) {
            // empty if block
        }
        if (startupMonitor != null) {
            startupMonitor.showProgress(WmiStartup.percentDone());
        }
    }

    public static void setStartupMonitor(WmiStartupMonitor wmiStartupMonitor) {
        if (!$assertionsDisabled && wmiStartupMonitor == null) {
            throw new AssertionError((Object)"call startupComplete instead");
        }
        startupMonitor = wmiStartupMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startupComplete() {
        startupMonitor = null;
        Object object = startupWaiters;
        synchronized (object) {
            startupWaiters.notifyAll();
            startupWaiters = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForStartupCompletion(int n) {
        if (startupWaiters != null) {
            try {
                Object object = startupWaiters;
                synchronized (object) {
                    startupWaiters.wait(WmiStartup.estimateTimeLeft() + 10000L);
                }
                if (n > 0) {
                    Thread.sleep(n);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        $assertionsDisabled = !WmiStartup.class.desiredAssertionStatus();
        printTiming = false;
        startTime = System.currentTimeMillis();
        startupWaiters = new Object();
    }
}

