/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

public class RuntimePlatform {
    public static final int MAC_OS_X_VERSION_UNDEFINED = -1;
    public static final int MAC_OS_X_VERSION_10_2_JAGUAR = 2;
    public static final int MAC_OS_X_VERSION_10_3_PANTHER = 3;
    public static final int MAC_OS_X_VERSION_10_4_TIGER = 4;
    public static final int MAC_OS_X_VERSION_10_5_LEOPARD = 5;
    private static boolean isJava15;
    private static boolean isMac;
    private static boolean isIntelMac;
    private static int macOsVersion;
    private static boolean isWindows;
    private static boolean isUnix;
    private static boolean isDec;
    private static boolean isIrix;
    private static boolean isSolaris;
    private static boolean isLinux;
    private static boolean forceEsstix;

    private RuntimePlatform() {
    }

    public static boolean isMac() {
        return isMac;
    }

    public static boolean isIntelMac() {
        return isIntelMac;
    }

    public static int getMacOSVersion() {
        return macOsVersion;
    }

    public static boolean isMac_10_2() {
        return RuntimePlatform.getMacOSVersion() == 2;
    }

    public static boolean isJava15() {
        return isJava15;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isUnix() {
        return isUnix;
    }

    public static boolean isDec() {
        return isDec;
    }

    public static boolean isIrix() {
        return isIrix;
    }

    public static boolean isSolaris() {
        return isSolaris;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static void setOS(String string) {
        if (string != null) {
            isWindows = false;
            isMac = false;
            isUnix = false;
            isDec = false;
            isIrix = false;
            isSolaris = false;
            isLinux = false;
            if (string.equalsIgnoreCase("win")) {
                isWindows = true;
            } else if (string.equalsIgnoreCase("mac")) {
                isMac = true;
            } else if (string.equalsIgnoreCase("unix")) {
                isUnix = true;
            }
        }
    }

    public static boolean isEsstix() {
        return forceEsstix || RuntimePlatform.isMac();
    }

    public static void setEsstix(boolean bl) {
        forceEsstix = bl;
    }

    static {
        String string;
        isJava15 = false;
        isMac = false;
        isIntelMac = false;
        macOsVersion = -1;
        isWindows = false;
        isUnix = false;
        isDec = false;
        isIrix = false;
        isSolaris = false;
        isLinux = false;
        forceEsstix = false;
        String string2 = System.getProperty("os.name");
        String string3 = System.getProperty("java.version");
        if (string3 != null) {
            isJava15 = string3.startsWith("1.5");
        }
        if (string2.startsWith("Mac")) {
            isMac = true;
            try {
                string = System.getProperty("os.version");
                char c = string.charAt(3);
                macOsVersion = c - 48;
            }
            catch (SecurityException securityException) {
                macOsVersion = -1;
            }
        } else if (string2.startsWith("Win")) {
            isWindows = true;
        } else {
            isUnix = true;
            isIrix = string2.startsWith("Irix");
            isDec = string2.startsWith("OSF");
            isSolaris = string2.startsWith("Solaris");
            isLinux = string2.startsWith("Linux");
        }
        if (isMac && (string = System.getProperty("os.arch")) != null && string.startsWith("i386")) {
            isIntelMac = true;
        }
    }
}

