/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.MapleFontLoaderUtil;
import com.maplesoft.util.ResourceLoader;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.util.HashMap;

public class MapleFontLoader
extends MapleFontLoaderUtil {
    public static final String fontPackage = "/com/maplesoft/client/resources/fonts/";
    private static final HashMap mappings = new HashMap();
    private static final String[] fontFiles = new String[]{"COBO____.ttf", "COB_____.ttf", "CON_____.ttf", "COO_____.ttf", "HEBO____.ttf", "HEB_____.ttf", "HEN_____.ttf", "HEO_____.ttf", "MP______.ttf", "SYP_____.ttf", "THBI____.ttf", "THB_____.ttf", "THI_____.ttf", "THR_____.ttf"};

    public static void addFontMapping(String string, String string2) {
        mappings.put(string, string2);
    }

    public static Font getResourceAsFont(String string) throws IllegalArgumentException, FontFormatException, IOException {
        if (!mappings.containsKey(string)) {
            throw new IllegalArgumentException("No Mapping from " + string + " to a font resource.");
        }
        return ResourceLoader.getResourceAsFont((String)mappings.get(string));
    }

    public static Font getResourceAsFont(String string, float f) throws IllegalArgumentException, FontFormatException, IOException {
        if (!mappings.containsKey(string)) {
            throw new IllegalArgumentException("No Mapping from " + string + " to a font resource.");
        }
        Font font = ResourceLoader.getResourceAsFont((String)mappings.get(string), f);
        return font;
    }

    public static Font getResourceAsFont(String string, int n, float f) throws IllegalArgumentException, FontFormatException, IOException {
        if (!mappings.containsKey(string)) {
            throw new IllegalArgumentException("No Mapping from " + string + " to a font resource.");
        }
        Font font = ResourceLoader.getResourceAsFont((String)mappings.get(string), n, f);
        return font;
    }

    public static void installFonts() {
        try {
            for (int i = 0; i < fontFiles.length; ++i) {
                ResourceLoader.getResourceAsFont(fontPackage + fontFiles[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    static {
        mappings.put("Courant Bold Italic", "/com/maplesoft/client/resources/fonts/COBO____.ttf");
        mappings.put("CourantBoldItalic", "/com/maplesoft/client/resources/fonts/COBO____.ttf");
        mappings.put("Courant Bold", "/com/maplesoft/client/resources/fonts/COB_____.ttf");
        mappings.put("CourantBold", "/com/maplesoft/client/resources/fonts/COB_____.ttf");
        mappings.put("Courant", "/com/maplesoft/client/resources/fonts/CON_____.ttf");
        mappings.put("Courant Regular", "/com/maplesoft/client/resources/fonts/CON_____.ttf");
        mappings.put("CourantRegular", "/com/maplesoft/client/resources/fonts/CON_____.ttf");
        mappings.put("Courant Italic", "/com/maplesoft/client/resources/fonts/COO_____.ttf");
        mappings.put("CourantItalic", "/com/maplesoft/client/resources/fonts/COO_____.ttf");
        mappings.put("Helonia Bold Italic", "/com/maplesoft/client/resources/fonts/HEBO____.ttf");
        mappings.put("HeloniaBoldItalic", "/com/maplesoft/client/resources/fonts/HEBO____.ttf");
        mappings.put("Helonia Bold", "/com/maplesoft/client/resources/fonts/HEB_____.ttf");
        mappings.put("HeloniaBold", "/com/maplesoft/client/resources/fonts/HEB_____.ttf");
        mappings.put("Helonia", "/com/maplesoft/client/resources/fonts/HEN_____.ttf");
        mappings.put("Helonia Regular", "/com/maplesoft/client/resources/fonts/HEN_____.ttf");
        mappings.put("HeloniaRegular", "/com/maplesoft/client/resources/fonts/HEN_____.ttf");
        mappings.put("Helonia Italic", "/com/maplesoft/client/resources/fonts/HEO_____.ttf");
        mappings.put("HeloniaItalic", "/com/maplesoft/client/resources/fonts/HEO_____.ttf");
        mappings.put("MaplePi", "/com/maplesoft/client/resources/fonts/MP______.ttf");
        mappings.put("MaplePiRegular", "/com/maplesoft/client/resources/fonts/MP______.ttf");
        mappings.put("Maple Pi", "/com/maplesoft/client/resources/fonts/MP______.ttf");
        mappings.put("Maple Pi Regular", "/com/maplesoft/client/resources/fonts/MP______.ttf");
        mappings.put("SymbolPiRegular", "/com/maplesoft/client/resources/fonts/SYP_____.ttf");
        mappings.put("Symbol Pi Regular", "/com/maplesoft/client/resources/fonts/SYP_____.ttf");
        mappings.put("SymbolPi Regular", "/com/maplesoft/client/resources/fonts/SYP_____.ttf");
        mappings.put("Thames Bold Italic", "/com/maplesoft/client/resources/fonts/THBI____.ttf");
        mappings.put("ThamesBoldItalic", "/com/maplesoft/client/resources/fonts/THBI____.ttf");
        mappings.put("Thames Bold", "/com/maplesoft/client/resources/fonts/THB_____.ttf");
        mappings.put("ThamesBold", "/com/maplesoft/client/resources/fonts/THB_____.ttf");
        mappings.put("ThamesItalic", "/com/maplesoft/client/resources/fonts/THI_____.ttf");
        mappings.put("Thames Italic", "/com/maplesoft/client/resources/fonts/THI_____.ttf");
        mappings.put("Thames Regular", "/com/maplesoft/client/resources/fonts/THR_____.ttf");
        mappings.put("ThamesRegular", "/com/maplesoft/client/resources/fonts/THR_____.ttf");
        mappings.put("Thames", "/com/maplesoft/client/resources/fonts/THR_____.ttf");
    }
}

