/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

public class Base64Encoder {
    private static final String BASIS64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final int ASCII6 = 64;
    private static final int ASCII7 = 128;
    private static char[] chEncode = new char[64];
    private static char[] chDecode = new char[128];

    public static String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Base64Encoder.decode(string, stringBuffer);
        return stringBuffer.toString();
    }

    public static void decode(String string, StringBuffer stringBuffer) {
        int n;
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        for (n = string.length(); n > 4; n -= 4) {
            Base64Encoder.decode4to3(string, cArray, n2, n3);
            n2 += 4;
            n3 += 3;
        }
        if (n == 4) {
            if (string.endsWith("==")) {
                Base64Encoder.decode4to1(string, cArray, n2, n3);
                ++n3;
            } else if (string.endsWith("=")) {
                Base64Encoder.decode4to2(string, cArray, n2, n3);
                n3 += 2;
            } else {
                Base64Encoder.decode4to3(string, cArray, n2, n3);
                n3 += 3;
            }
        }
        stringBuffer.append(new String(cArray, 0, n3));
    }

    public static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Base64Encoder.encode(string, stringBuffer);
        return stringBuffer.toString();
    }

    public static void encode(String string, StringBuffer stringBuffer) {
        int n;
        char[] cArray = new char[4 * n / 3 + 4];
        int n2 = 0;
        int n3 = 0;
        for (n = string.length(); n >= 3; n -= 3) {
            Base64Encoder.encode3to4(string, cArray, n2, n3);
            n2 += 3;
            n3 += 4;
        }
        switch (n) {
            case 2: {
                Base64Encoder.encode2to4(string, cArray, n2, n3);
                n3 += 4;
                break;
            }
            case 1: {
                Base64Encoder.encode1to4(string, cArray, n2, n3);
                n3 += 4;
            }
        }
        stringBuffer.append(new String(cArray, 0, n3));
    }

    public static String slashify(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Base64Encoder.slashify(stringBuffer);
        return stringBuffer.toString();
    }

    public static void slashify(StringBuffer stringBuffer) {
        stringBuffer.append("\"{}");
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c != '\"' && c != '{' && c != '}' && c != '\\') continue;
            stringBuffer.insert(i, '\\');
            ++i;
        }
    }

    private static void decode4to3(String string, char[] cArray, int n, int n2) {
        int n3 = 0;
        char c = '\u0000';
        int n4 = 0;
        for (n3 = n; n3 < n + 4; ++n3) {
            c = chDecode[string.charAt(n3)];
            n4 <<= 6;
            n4 |= c;
        }
        for (n3 = 2; n3 >= 0; --n3) {
            cArray[n2 + n3] = (char)(n4 & 0xFF);
            n4 >>= 8;
        }
    }

    private static void decode4to2(String string, char[] cArray, int n, int n2) {
        char c = chDecode[string.charAt(n)];
        char c2 = chDecode[string.charAt(n + 1)];
        char c3 = chDecode[string.charAt(n + 2)];
        cArray[n2] = (char)(c << 2 | c2 >> 4);
        cArray[n2 + 1] = (char)((c2 & 0xF) << 4 | c3 >> 2);
    }

    private static void decode4to1(String string, char[] cArray, int n, int n2) {
        char c;
        char c2 = chDecode[string.charAt(n)];
        char c3 = chDecode[string.charAt(n + 1)];
        cArray[n2] = c = (char)(c2 << 2 | c3 >> 4);
    }

    private static void encode3to4(String string, char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 18;
        for (n4 = n; n4 < n + 3; ++n4) {
            n3 <<= 8;
            n3 |= (byte)string.charAt(n4);
        }
        for (n4 = 0; n4 < 4; ++n4) {
            cArray[n2 + n4] = chEncode[n3 >> n5 & 0x3F];
            n5 -= 6;
        }
    }

    private static void encode2to4(String string, char[] cArray, int n, int n2) {
        cArray[n2] = chEncode[(byte)string.charAt(n) >> 2 & 0x3F];
        cArray[n2 + 1] = chEncode[(byte)(string.charAt(n) & 3) << 4 | (byte)string.charAt(n + 1) >> 4 & 0xF];
        cArray[n2 + 2] = chEncode[((byte)string.charAt(n + 1) & 0xF) << 2];
        cArray[n2 + 3] = 61;
    }

    private static void encode1to4(String string, char[] cArray, int n, int n2) {
        cArray[n2] = chEncode[(byte)string.charAt(n) >> 2 & 0x3F];
        cArray[n2 + 1] = chEncode[((byte)string.charAt(n) & 3) << 4];
        cArray[n2 + 2] = 61;
        cArray[n2 + 3] = 61;
    }

    static {
        int n = BASIS64.length();
        for (int i = 0; i < n; ++i) {
            char c;
            Base64Encoder.chEncode[i] = c = BASIS64.charAt(i);
            Base64Encoder.chDecode[c] = (char)i;
        }
    }
}

