/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiAbstractOperatorRenderer;
import java.awt.Graphics;
import java.awt.Rectangle;

public class WmiUnaryMinusRenderer
extends WmiAbstractOperatorRenderer {
    private static final float WIDTH_ASPECT_RATIO = 0.7f;
    private static final float CLIP_ASPECT_RATIO = 0.8f;

    public boolean applyRenderer(WmiMathOperatorView wmiMathOperatorView, int n) throws WmiNoReadAccessException {
        boolean bl = false;
        WmiMathOperatorModel wmiMathOperatorModel = (WmiMathOperatorModel)wmiMathOperatorView.getModel();
        String string = wmiMathOperatorModel.getSemanticLabel();
        if ("&uminus0;".equals(string)) {
            bl = true;
        }
        return bl;
    }

    public boolean isStretchy() {
        return false;
    }

    public void layoutView(WmiMathOperatorView wmiMathOperatorView, int n) throws WmiNoReadAccessException {
        WmiTextLayout wmiTextLayout = wmiMathOperatorView.getLayout();
        n = wmiTextLayout.getHeight();
        int n2 = wmiTextLayout.getWidth();
        wmiMathOperatorView.setWidth(Math.round(0.7f * (float)n2));
        wmiMathOperatorView.setStretchHeight(n);
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle, WmiMathOperatorView wmiMathOperatorView) {
        Rectangle rectangle2 = graphics.getClipBounds();
        int n = wmiRenderPath.getHorizontalOffset() + wmiMathOperatorView.getHorizontalOffset();
        int n2 = wmiRenderPath.getVerticalOffset() + wmiMathOperatorView.getVerticalOffset();
        if (wmiRenderPath.cloneGCForClip()) {
            graphics = graphics.create();
        }
        graphics.clipRect(n, n2, Math.round(0.8f * (float)wmiMathOperatorView.getWidth()), wmiMathOperatorView.getHeight());
        wmiMathOperatorView.drawText(graphics, wmiRenderPath, rectangle);
        if (wmiRenderPath.cloneGCForClip()) {
            graphics.dispose();
        } else {
            graphics.setClip(rectangle2);
        }
    }
}

