/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.view.math.renderers.WmiBracketRenderer;
import java.awt.Font;
import java.awt.Graphics;

public class WmiScalableOperatorRenderer
extends WmiBracketRenderer {
    public WmiScalableOperatorRenderer(char[] cArray) {
        super(cArray);
    }

    protected WmiBracketRenderer.RenderedBracket createBracket(Font font, int n) {
        ScalableRenderedBracket scalableRenderedBracket = new ScalableRenderedBracket(this.data, font, n);
        this.cache.setBracket(font, n, scalableRenderedBracket);
        return scalableRenderedBracket;
    }

    protected static class ScalableRenderedBracket
    implements WmiBracketRenderer.RenderedBracket {
        private static final int SINGLE_HEIGHT_CHAR_INDEX = 0;
        private static final int DOUBLE_HEIGHT_CHAR_INDEX = 1;
        private static final int TRIPLE_HEIGHT_CHAR_INDEX = 2;
        private static final float DOUBLE_HEIGHT_SCALE_FACTOR = 2.0f;
        private static final float TRIPLE_HEIGHT_SCALE_FACTOR = 3.0f;
        private static final float DOUBLE_HEIGHT_SCALE_THRESHOLD = 2.0f;
        private static final float TRIPLE_HEIGHT_SCALE_THRESHOLD = 3.1f;
        private Font font;
        private char ch;
        private String value;
        private int yOffset;
        private int width;

        public ScalableRenderedBracket(char[] cArray, Font font, int n) {
            Font font2 = WmiBracketRenderer.getOversizedBracketFont();
            float f = font.getSize2D();
            this.font = font2.deriveFont(0, f);
            WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(this.font);
            this.ch = cArray[0];
            int n2 = wmiFontMetrics.getCharacterProperty(4, this.ch, false);
            int n3 = wmiFontMetrics.getCharacterProperty(5, this.ch, false);
            int n4 = n2 + n3;
            if ((float)n > 3.1f * (float)n4) {
                this.ch = cArray[2];
                f *= 3.0f;
            } else if ((float)n > 2.0f * (float)n4) {
                this.ch = cArray[1];
                f *= 2.0f;
            } else {
                this.ch = cArray[0];
            }
            this.value = Character.toString(this.ch);
            this.font = font2.deriveFont(0, f);
            wmiFontMetrics = WmiFontResolver.getFontMetrics(this.font);
            n2 = wmiFontMetrics.getCharacterProperty(4, this.ch, false);
            n3 = wmiFontMetrics.getCharacterProperty(5, this.ch, false);
            n4 = n2 + n3;
            int n5 = Math.round(0.5f * (float)(n - n4));
            this.yOffset = n5 + n2;
            this.width = wmiFontMetrics.getCharacterProperty(0, this.ch, false);
        }

        public void draw(Graphics graphics, int n, int n2, boolean bl) {
            Font font = graphics.getFont();
            graphics.setFont(this.font);
            graphics.drawString(this.value, n, n2 + this.yOffset);
        }

        public int getWidth(boolean bl) {
            return this.width;
        }

        public void validateLayout(boolean bl) {
        }

        public boolean singleCharacterBracketAllowed() {
            return true;
        }
    }

    public static class RightDoubleAngleBracket
    extends WmiScalableOperatorRenderer {
        private static final char[] CHARS = new char[]{'J', 'J', 'J'};

        public RightDoubleAngleBracket() {
            super(CHARS);
        }
    }

    public static class LeftDoubleAngleBracket
    extends WmiScalableOperatorRenderer {
        private static final char[] CHARS = new char[]{'I', 'I', 'I'};

        public LeftDoubleAngleBracket() {
            super(CHARS);
        }
    }

    public static class RightAngleBracket
    extends WmiScalableOperatorRenderer {
        private static final char[] CHARS = new char[]{'D', '*', '7'};

        public RightAngleBracket() {
            super(CHARS);
        }
    }

    public static class LeftAngleBracket
    extends WmiScalableOperatorRenderer {
        private static final char[] CHARS = new char[]{'C', ')', '6'};

        public LeftAngleBracket() {
            super(CHARS);
        }
    }

    public static class RightWhiteSquareBracket
    extends WmiScalableOperatorRenderer {
        private static final char[] CHARS = new char[]{'F', ',', '9'};

        public RightWhiteSquareBracket() {
            super(CHARS);
        }
    }

    public static class LeftWhiteSquareBracket
    extends WmiScalableOperatorRenderer {
        private static final char[] CHARS = new char[]{'E', '+', '8'};

        public LeftWhiteSquareBracket() {
            super(CHARS);
        }
    }
}

