/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiGlyphRenderer;
import java.awt.Font;

public abstract class WmiParenRenderer
extends WmiGlyphRenderer {
    private static final float MAX_PRIMARY_STRETCH = 0.5f;
    private static final float SMALL_MEDIUM_TRANSITION_SCALE = 1.3f;
    private static final float MEDIUM_LARGE_TRANSITION_SCALE = 1.6f;
    private static final float[][] BIG_PAREN_OUTLINE = new float[][]{{0.3701031f, 0.9852577f}, {0.3536082f, 1.0f}, {0.0484536f, 0.8731959f, 0.0484536f, 0.5103093f}, {0.0484536f, 0.4896907f}, {0.0484536f, 0.1268041f, 0.3636082f, 0.0f}, {0.3701031f, 0.0247423f}, {0.1783505f, 0.1556702f, 0.1474227f, 0.243299f}, {0.108866f, 0.3523704f, 0.108866f, 0.4896907f}, {0.108866f, 0.5103093f}, {0.108866f, 0.6690722f, 0.1474227f, 0.756701f}, {0.1783505f, 0.8379381f, 0.3701031f, 0.9852577f}};
    private static int[] BIG_PAREN_MORPH = new int[]{3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3};
    private static final float[][] MEDIUM_PAREN_OUTLINE = new float[][]{{0.17951669f, 1.0f}, {0.10471807f, 0.9309551f, 0.050632913f, 0.7848101f}, {0.0f, 0.64787114f, 0.0f, 0.5373993f}, {0.0f, 0.46144995f}, {0.0f, 0.3521289f, 0.050632913f, 0.21403913f}, {0.10471807f, 0.06904488f, 0.17951669f, 0.0f}, {0.17951669f, 0.0287687f}, {0.10471807f, 0.16915995f, 0.081703104f, 0.25546604f}, {0.0575374f, 0.3475259f, 0.0575374f, 0.49942464f}, {0.0575374f, 0.6513234f, 0.081703104f, 0.74453396f}, {0.10471807f, 0.83084005f, 0.17951669f, 0.9712313f}, {0.17951669f, 1.0f}, new float[0]};
    private static final int[] MEDIUM_PAREN_MORPH = new int[]{3, 3, 3, 1, 1, 1, 1, 1, 6, 3, 3, 3, 0};
    private static final float[][] SMALL_PAREN_OUTLINE = new float[][]{{0.22147653f, 0.97449666f}, {0.20536913f, 1.0f}, {0.0f, 0.87248325f, 0.0f, 0.49f}, {0.0f, 0.5f}, {0.0f, 0.51f}, {0.0f, 0.1261745f, 0.20536913f, 0.0f}, {0.22147653f, 0.024161074f}, {0.13020135f, 0.102013424f, 0.09932886f, 0.24295303f}, {0.08053692f, 0.33020136f, 0.08053692f, 0.49f}, {0.08053692f, 0.5f}, {0.08053692f, 0.51f}, {0.08053692f, 0.6684564f, 0.09932886f, 0.7557047f}, {0.13020135f, 0.89664435f, 0.22147653f, 0.97449666f}, new float[0]};
    private static final int[] SMALL_PAREN_MORPH = new int[]{3, 3, 3, 0, 1, 1, 1, 1, 1, 0, 3, 3, 3, 0};
    private static final float[][][] OUTLINES = new float[][][]{SMALL_PAREN_OUTLINE, MEDIUM_PAREN_OUTLINE, BIG_PAREN_OUTLINE};
    private static final int[][] MORPHS = new int[][]{SMALL_PAREN_MORPH, MEDIUM_PAREN_MORPH, BIG_PAREN_MORPH};

    protected float[][] getGlyphOutline() {
        return SMALL_PAREN_OUTLINE;
    }

    protected int[] getStretchRules() {
        return SMALL_PAREN_MORPH;
    }

    public WmiGlyphRenderer.RenderedGlyph createGlyph(Font font, int n) {
        float f = font.getSize2D();
        float f2 = (float)n / f;
        int n2 = 0;
        if (f2 > 1.6f) {
            n2 = 2;
        } else {
            f *= f2;
            if (f2 > 1.3f) {
                n2 = 1;
            }
        }
        int[] nArray = MORPHS[n2];
        float[][] fArray = OUTLINES[n2];
        float[][] fArrayArray = new float[fArray.length][];
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray2 = fArray[i];
            fArrayArray[i] = new float[fArray2.length];
            System.arraycopy(fArray2, 0, fArrayArray[i], 0, fArray2.length);
        }
        this.morphGlyph(fArrayArray, f, n, nArray);
        return new WmiGlyphRenderer.RenderedGlyph(fArrayArray);
    }

    protected boolean isBracket() {
        return true;
    }

    public boolean forcePreKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
        return true;
    }

    public boolean forcePostKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
        return true;
    }

    protected void morphGlyph(float[][] fArray, float f, int n, int[] nArray) {
    }

    protected void applyScaling(float[][] fArray, float f, int n, int[] nArray) {
        if (nArray == BIG_PAREN_MORPH) {
            float[] fArray2;
            int n2;
            this.uniformScale(fArray, f);
            float f2 = ((float)n - f) / f;
            float f3 = 0.5f * f;
            float f4 = 0.5f * ((float)n - f);
            boolean bl = false;
            if (f2 > 0.5f) {
                f2 = 0.5f;
                bl = true;
                f4 = 0.5f * f2 * f;
            }
            for (n2 = 0; n2 < fArray.length; ++n2) {
                fArray2 = fArray[n2];
                if (fArray2.length == 2) {
                    fArray2[1] = fArray2[1] + (f4 - (f3 - fArray2[1]) * f2);
                    if (!(fArray2[1] < 0.0f)) continue;
                    if (f2 == 0.5f) {
                        System.out.print("** ");
                    }
                    System.out.println(f + ", " + fArray2[1]);
                    continue;
                }
                if (fArray2.length != 4) continue;
                fArray2[1] = fArray2[1] + (f4 - (f3 - fArray2[1]) * f2);
                fArray2[3] = fArray2[3] + (f4 - (f3 - fArray2[3]) * f2);
            }
            if (bl) {
                f3 = 0.5f * (f2 + 1.0f) * f;
                f4 = (float)n - 2.0f * f3;
                for (n2 = 0; n2 < fArray.length; ++n2) {
                    fArray2 = fArray[n2];
                    if (fArray2.length == 2) {
                        if (!(fArray2[1] > f3)) continue;
                        fArray2[1] = fArray2[1] + f4;
                        continue;
                    }
                    if (fArray2.length != 4) continue;
                    if (fArray2[1] > f3) {
                        fArray2[1] = fArray2[1] + f4;
                    }
                    if (!(fArray2[3] > f3)) continue;
                    fArray2[3] = fArray2[3] + f4;
                }
            }
        } else {
            this.stretchScale(fArray, f, n, nArray);
        }
    }

    public static class WmiRightParenRenderer
    extends WmiParenRenderer {
        protected void morphGlyph(float[][] fArray, float f, int n, int[] nArray) {
            this.applyScaling(fArray, f, n, nArray);
            this.rotate180(fArray);
        }
    }

    public static class WmiLeftParenRenderer
    extends WmiParenRenderer {
        protected void morphGlyph(float[][] fArray, float f, int n, int[] nArray) {
            this.applyScaling(fArray, f, n, nArray);
        }
    }
}

