/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.WmiOverView;
import com.maplesoft.mathdoc.view.math.WmiUnderOverView;
import com.maplesoft.mathdoc.view.math.WmiUnderView;
import com.maplesoft.mathdoc.view.math.renderers.WmiGlyphRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public abstract class WmiHorizontalStretchyRenderer
extends WmiGlyphRenderer {
    public static final char NULL_CHARACTER = '\u0000';
    public static final float MIN_STRETCH_SCALE = 0.7f;
    public static ArrayList stretchyOperators = new ArrayList();
    protected float[][] outline = null;
    protected int[] morphRules = null;

    public static boolean isStretchyOperator(WmiModel wmiModel) throws WmiNoReadAccessException {
        String string;
        boolean bl = false;
        if (wmiModel instanceof WmiMathOperatorModel && (string = ((WmiMathOperatorModel)wmiModel).getText()).length() == 1) {
            bl = stretchyOperators.contains(new Character(string.charAt(0)));
        }
        return bl;
    }

    public static boolean resetStretchyOperator(WmiView wmiView) throws WmiNoReadAccessException {
        boolean bl = false;
        WmiMathOperatorView wmiMathOperatorView = WmiHorizontalStretchyRenderer.getStretchyOperator(wmiView);
        if (wmiMathOperatorView != null) {
            wmiMathOperatorView.markInvalid(1);
            wmiMathOperatorView.setWidth(0);
            bl = true;
        }
        return bl;
    }

    public static WmiMathOperatorView getStretchyOperator(WmiView wmiView) throws WmiNoReadAccessException {
        WmiMathOperatorView wmiMathOperatorView = null;
        WmiModel wmiModel = wmiView.getModel();
        WmiModelTag wmiModelTag = wmiModel.getTag();
        if (wmiModelTag == WmiModelTag.MATH_ROW) {
            WmiCompositeView wmiCompositeView = (WmiCompositeView)wmiView;
            int n = wmiCompositeView.getChildCount();
            WmiModelTag wmiModelTag2 = null;
            WmiPositionedView wmiPositionedView = null;
            WmiModel wmiModel2 = null;
            for (int i = 0; i < n; ++i) {
                WmiPositionedView wmiPositionedView2 = (WmiPositionedView)wmiCompositeView.getChild(i);
                wmiModel = wmiPositionedView2.getModel();
                wmiModelTag = wmiModel.getTag();
                if (wmiModelTag == WmiModelTag.MATH_IDENTIFIER) {
                    if (wmiPositionedView2.getWidth() <= 0) continue;
                    wmiModelTag2 = null;
                    break;
                }
                if (wmiModelTag == WmiModelTag.MATH_OPERATOR) {
                    if (wmiModelTag2 != null) {
                        wmiModelTag2 = null;
                        break;
                    }
                    wmiModelTag2 = wmiModelTag;
                    wmiPositionedView = wmiPositionedView2;
                    wmiModel2 = wmiModel;
                    continue;
                }
                wmiModelTag2 = null;
                break;
            }
            wmiModelTag = wmiModelTag2;
            wmiView = wmiPositionedView;
            wmiModel = wmiModel2;
        }
        if (wmiModelTag == WmiModelTag.MATH_OPERATOR && WmiHorizontalStretchyRenderer.isStretchyOperator((WmiMathModel)wmiModel)) {
            wmiMathOperatorView = (WmiMathOperatorView)wmiView;
        }
        return wmiMathOperatorView;
    }

    public static boolean isOverElement(WmiView wmiView) {
        WmiCompositeView wmiCompositeView;
        WmiView wmiView2 = wmiView;
        for (wmiCompositeView = wmiView.getParentView(); !(wmiCompositeView == null || wmiCompositeView instanceof WmiOverView || wmiCompositeView instanceof WmiUnderView || wmiCompositeView instanceof WmiUnderOverView); wmiCompositeView = wmiCompositeView.getParentView()) {
            wmiView2 = wmiCompositeView;
        }
        return wmiCompositeView instanceof WmiOverView && wmiCompositeView.indexOf(wmiView2) == 1;
    }

    public static boolean isUnderElement(WmiView wmiView) {
        WmiCompositeView wmiCompositeView;
        WmiView wmiView2 = wmiView;
        for (wmiCompositeView = wmiView.getParentView(); !(wmiCompositeView == null || wmiCompositeView instanceof WmiOverView || wmiCompositeView instanceof WmiUnderView || wmiCompositeView instanceof WmiUnderOverView); wmiCompositeView = wmiCompositeView.getParentView()) {
            wmiView2 = wmiCompositeView;
        }
        return wmiCompositeView instanceof WmiUnderView && wmiCompositeView.indexOf(wmiView2) == 1 || wmiCompositeView instanceof WmiUnderOverView && wmiCompositeView.indexOf(wmiView2) == 1;
    }

    public boolean isLayoutOnly() {
        return false;
    }

    public void layoutView(WmiMathOperatorView wmiMathOperatorView, int n) throws WmiNoReadAccessException {
        this.layoutView(wmiMathOperatorView);
    }

    public int extraPaddingAbove(WmiGlyphRenderer.RenderedGlyph renderedGlyph) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutView(WmiMathOperatorView wmiMathOperatorView) throws WmiNoReadAccessException {
        Font font = this.getFont(wmiMathOperatorView);
        int n = this.computeStretchySize(wmiMathOperatorView, font);
        WmiGlyphRenderer.GlyphCache glyphCache = this.cache;
        synchronized (glyphCache) {
            Rectangle2D.Float float_;
            WmiGlyphRenderer.RenderedGlyph renderedGlyph = this.cache.getGlyph(font, n);
            if (renderedGlyph == null && (renderedGlyph = this.createGlyph(font, n)) != null) {
                float_ = renderedGlyph.getBounds();
                int n2 = (int)Math.ceil(float_.width);
                this.cache.setGlyph(font, n, renderedGlyph);
                if (n2 != n) {
                    this.cache.setGlyph(font, n2, renderedGlyph);
                }
                WmiTextLayout wmiTextLayout = wmiMathOperatorView.getLayout();
                int n3 = wmiTextLayout.computeSpaceAbove();
                int n4 = wmiTextLayout.computeSpaceBelow();
                renderedGlyph.setVerticalPadding(n3 + this.extraPaddingAbove(renderedGlyph), n4);
            }
            if (renderedGlyph != null) {
                float_ = renderedGlyph.getBounds();
                wmiMathOperatorView.setHeight((int)Math.ceil(float_.height));
                wmiMathOperatorView.setWidth((int)Math.ceil(float_.width) + wmiMathOperatorView.getLeftPadding() + wmiMathOperatorView.getRightPadding());
                wmiMathOperatorView.setStretchHeight((int)Math.ceil(float_.height));
            }
        }
        wmiMathOperatorView.setStretchWidth(n);
    }

    public boolean applyRenderer(WmiMathOperatorView wmiMathOperatorView, int n) throws WmiNoReadAccessException {
        return this.applyRenderer(wmiMathOperatorView);
    }

    public boolean applyRenderer(WmiMathOperatorView wmiMathOperatorView) throws WmiNoReadAccessException {
        WmiModel wmiModel;
        WmiModelTag wmiModelTag;
        boolean bl = false;
        WmiCompositeView wmiCompositeView = wmiMathOperatorView.getParentView();
        if (wmiCompositeView instanceof WmiMathInlineView && WmiHorizontalStretchyRenderer.getStretchyOperator(wmiCompositeView) != null) {
            wmiCompositeView = wmiCompositeView.getParentView();
        }
        if ((wmiModelTag = (wmiModel = wmiCompositeView.getModel()).getTag()) == WmiModelTag.MATH_OVER || wmiModelTag == WmiModelTag.MATH_UNDER || wmiModelTag == WmiModelTag.MATH_UNDER_OVER) {
            bl = true;
        }
        return bl;
    }

    protected WmiPositionedView getBaseView(WmiView wmiView) {
        WmiPositionedView wmiPositionedView = null;
        boolean bl = false;
        if (wmiView instanceof WmiOverView) {
            wmiPositionedView = (WmiPositionedView)((WmiOverView)wmiView).getChild(0);
        } else if (wmiView instanceof WmiUnderOverView) {
            wmiPositionedView = (WmiPositionedView)((WmiUnderOverView)wmiView).getChild(0);
        } else if (wmiView instanceof WmiUnderView) {
            wmiPositionedView = (WmiPositionedView)((WmiUnderView)wmiView).getChild(0);
        }
        return wmiPositionedView;
    }

    protected WmiCompositeView getParentView(WmiView wmiView) {
        WmiCompositeView wmiCompositeView;
        for (wmiCompositeView = wmiView.getParentView(); !(wmiCompositeView == null || wmiCompositeView instanceof WmiOverView || wmiCompositeView instanceof WmiUnderOverView || wmiCompositeView instanceof WmiUnderView); wmiCompositeView = wmiCompositeView.getParentView()) {
        }
        return wmiCompositeView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean drawAsCharacter(WmiMathOperatorView wmiMathOperatorView) {
        boolean bl = false;
        WmiCompositeView wmiCompositeView = this.getParentView(wmiMathOperatorView);
        WmiPositionedView wmiPositionedView = this.getBaseView(wmiCompositeView);
        int n = 0;
        WmiModel wmiModel = wmiPositionedView.getModel();
        if (wmiModel instanceof WmiTextModel && WmiModelLock.readLock(wmiModel, true)) {
            try {
                char c;
                n = ((WmiTextModel)wmiModel).getText().length();
                if (n == 1 && !stretchyOperators.contains(new Character(c = ((WmiTextModel)wmiModel).getText().charAt(0)))) {
                    bl = true;
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.readUnlock(wmiModel);
            }
        }
        return bl;
    }

    protected int getCharacterWidth(WmiMathOperatorView wmiMathOperatorView, WmiTextLayout wmiTextLayout) {
        int n = wmiTextLayout.getWidth();
        if (n == 0) {
            char c = wmiTextLayout.getMappedCharacter(0);
            Font font = wmiTextLayout.getMappedFont(0);
            WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
            n = wmiFontMetrics.getCharacterProperty(0, c, wmiMathOperatorView.getDocumentView().isPrintView());
        }
        return n;
    }

    protected int getCharacterCount(int n, int n2) {
        int n3 = n / n2;
        if (n3 * n2 < n) {
            ++n3;
        }
        return n3;
    }

    protected int getStretchySize(WmiPositionedView wmiPositionedView) {
        int n = wmiPositionedView.getWidth();
        if (wmiPositionedView instanceof WmiMathOperatorView) {
            n = ((WmiMathOperatorView)wmiPositionedView).getStretchWidth();
        }
        return n;
    }

    protected int computeStretchySize(WmiPositionedView wmiPositionedView, Font font) throws WmiNoReadAccessException {
        int n = wmiPositionedView.getWidth();
        WmiView wmiView = wmiPositionedView;
        WmiCompositeView wmiCompositeView = wmiPositionedView.getParentView();
        boolean bl = false;
        while (!bl) {
            WmiModel wmiModel = wmiView.getModel();
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiCompositeView.getModel();
            WmiModelTag wmiModelTag = wmiCompositeModel.getTag();
            if (wmiModelTag == WmiModelTag.MATH_OVER || wmiModelTag == WmiModelTag.MATH_UNDER || wmiModelTag == WmiModelTag.MATH_UNDER_OVER) {
                if (wmiCompositeModel.getChild(0) == wmiModel) {
                    n = 0;
                    int n2 = wmiCompositeView.getChildCount();
                    for (int i = 1; i < n2; ++i) {
                        WmiPositionedView wmiPositionedView2 = (WmiPositionedView)wmiCompositeView.getChild(i);
                        if (n >= wmiPositionedView2.getWidth()) continue;
                        n = wmiPositionedView2.getWidth();
                    }
                    n = (int)((float)n + font.getSize2D());
                } else {
                    WmiPositionedView wmiPositionedView3 = (WmiPositionedView)wmiCompositeView.getChild(0);
                    n = wmiPositionedView3.getWidth();
                }
                bl = true;
            }
            if (wmiModelTag == null) break;
            wmiView = wmiCompositeView;
            wmiCompositeView = wmiView.getParentView();
        }
        return n;
    }

    public int computePostKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
        return 0;
    }

    public int computePreKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
        return 0;
    }

    protected void morphGlyph(float[][] fArray, Font font, int n) {
        float f = font.getSize2D();
        int n2 = Math.round(0.7f * f);
        if (n < n2) {
            n = n2;
        }
        this.stretchScale(fArray, f, n, this.getStretchRules());
    }

    protected float[][] getGlyphOutline() {
        return this.outline;
    }

    protected int[] getStretchRules() {
        return this.morphRules;
    }

    static {
        stretchyOperators.add(new Character('\u00af'));
        stretchyOperators.add(new Character('^'));
        stretchyOperators.add(new Character('~'));
        stretchyOperators.add(new Character('\u2190'));
        stretchyOperators.add(new Character('\u2192'));
        stretchyOperators.add(new Character('\u2194'));
        stretchyOperators.add(new Character('\u21c0'));
        stretchyOperators.add(new Character('\u21c1'));
        stretchyOperators.add(new Character('\u21bc'));
        stretchyOperators.add(new Character('\u21bd'));
        stretchyOperators.add(new Character('\u0305'));
        stretchyOperators.add(new Character('\u21cc'));
        stretchyOperators.add(new Character('\u21cb'));
        stretchyOperators.add(new Character('\u21d0'));
        stretchyOperators.add(new Character('\u21d2'));
        stretchyOperators.add(new Character('\u21da'));
        stretchyOperators.add(new Character('\u21db'));
        stretchyOperators.add(new Character('\u219a'));
        stretchyOperators.add(new Character('\u219b'));
        stretchyOperators.add(new Character('\u21c7'));
        stretchyOperators.add(new Character('\u21c9'));
        stretchyOperators.add(new Character('\u21c6'));
        stretchyOperators.add(new Character('\u21c4'));
        stretchyOperators.add(new Character('\u21d4'));
        stretchyOperators.add(new Character('\u21cd'));
        stretchyOperators.add(new Character('\u21cf'));
        stretchyOperators.add(new Character('\u21ce'));
        stretchyOperators.add(new Character('\u21a6'));
        stretchyOperators.add(new Character('\u2905'));
        stretchyOperators.add(new Character('\u219e'));
        stretchyOperators.add(new Character('\u21a0'));
        stretchyOperators.add(new Character('\u21a2'));
        stretchyOperators.add(new Character('\u21a3'));
        stretchyOperators.add(new Character('\u21ad'));
        stretchyOperators.add(new Character('\u21dd'));
        stretchyOperators.add(new Character('\u22c0'));
        stretchyOperators.add(new Character('\u2227'));
        stretchyOperators.add(new Character('\u02c6'));
        stretchyOperators.add(new Character('\ufe37'));
        stretchyOperators.add(new Character('\ufe38'));
    }
}

