/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiAbstractOperatorRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;

public abstract class WmiGlyphRenderer
extends WmiAbstractOperatorRenderer {
    protected static final int FIXED_POS = 0;
    protected static final int MOVE_UP = 1;
    protected static final int STRETCH_UP = 2;
    protected static final int MOVE_FIXED_UP = 2;
    protected static final int MOVE_DOWN = 3;
    protected static final int STRETCH_DOWN = 4;
    protected static final int MOVE_FIXED_DOWN = 4;
    protected static final int MOVE_UP_DOWN = 5;
    protected static final int MOVE_UP_FIXED = 6;
    protected static final int MOVE_DOWN_FIXED = 7;
    protected static final int MOVE_LEFT = 8;
    protected static final int MOVE_RIGHT = 9;
    protected static final int MOVE_UPHALF = 10;
    protected static final int MOVE_RIGHT_FIXED = 11;
    protected static final int MOVE_LEFT_FIXED = 12;
    protected static final int MOVE_FIXED_RIGHT = 13;
    protected static final int MOVE_FIXED_LEFT = 14;
    protected static final int MOVE_RIGHT_LEFT = 15;
    protected static final int MOVE_LEFT_LEFT_FIXED = 16;
    protected static final int MOVE_FIXED_RIGHT_RIGHT = 17;
    protected static final int MOVE_FIXED_LEFT_LEFT = 18;
    protected static final int MOVE_RIGHT_RIGHT_FIXED = 19;
    protected static final int MOVE_RIGHT_RIGHT_RIGHT = 20;
    protected static final int MOVE_LEFT_LEFT_LEFT = 21;
    protected static final int MOVE_LEFTHALF = 22;
    protected static final int MOVE_UPRIGHT = 23;
    private static final float BRACKET_SHIFT_FACTOR = 0.25f;
    protected GlyphCache cache = new GlyphCache();

    protected int getStretchySize(WmiPositionedView wmiPositionedView) {
        return wmiPositionedView.getHeight();
    }

    protected boolean isBracket() {
        return false;
    }

    protected float getBracketShiftFactor() {
        return 0.25f;
    }

    public RenderedGlyph createGlyph(Font font, int n) {
        float[][] fArray = this.getGlyphOutline();
        float[][] fArrayArray = new float[fArray.length][];
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray2 = fArray[i];
            fArrayArray[i] = new float[fArray2.length];
            System.arraycopy(fArray2, 0, fArrayArray[i], 0, fArray2.length);
        }
        this.morphGlyph(fArrayArray, font, n);
        return new RenderedGlyph(fArrayArray);
    }

    protected abstract float[][] getGlyphOutline();

    protected void morphGlyph(float[][] fArray, Font font, int n) {
    }

    protected int[] getStretchRules() {
        return null;
    }

    protected void uniformScale(float[][] fArray, float f) {
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray2 = fArray[i];
            int n = 0;
            while (n < fArray2.length) {
                float[] fArray3 = fArray[i];
                int n2 = n++;
                fArray3[n2] = fArray3[n2] * f;
            }
        }
    }

    protected void nonuniformScale(float[][] fArray, float f, float f2) {
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray2 = fArray[i];
            for (int j = 0; j < fArray2.length; j += 2) {
                float[] fArray3 = fArray[i];
                int n = j;
                fArray3[n] = fArray3[n] * f;
                float[] fArray4 = fArray[i];
                int n2 = j + 1;
                fArray4[n2] = fArray4[n2] * f2;
            }
        }
    }

    protected void horizontalReflection(float[][] fArray) {
        int n;
        float f = 0.0f;
        for (n = 0; n < fArray.length; ++n) {
            float[] fArray2 = fArray[n];
            for (int i = 0; i < fArray2.length; i += 2) {
                if (!(f < fArray[n][i])) continue;
                f = fArray[n][i];
            }
        }
        n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float[] fArray3 = fArray[i];
            int n2 = fArray3.length;
            for (int j = 0; j < n2; j += 2) {
                fArray3[j] = f - fArray3[j];
            }
        }
    }

    protected float[] findBounds(float[][] fArray) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float[] fArray2 = fArray[i];
            for (int j = 0; j < fArray2.length; j += 2) {
                if (f < fArray2[j]) {
                    f = fArray2[j];
                }
                if (!(f2 < fArray2[j + 1])) continue;
                f2 = fArray2[j + 1];
            }
        }
        float[] fArray3 = new float[]{f, f2};
        return fArray3;
    }

    protected void rotate180(float[][] fArray) {
        float[] fArray2 = this.findBounds(fArray);
        float f = fArray2[0];
        float f2 = fArray2[1];
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float[] fArray3 = fArray[i];
            int n2 = fArray3.length;
            for (int j = 0; j < n2; j += 2) {
                fArray3[j] = f - fArray3[j];
                fArray3[j + 1] = f2 - fArray3[j + 1];
            }
        }
    }

    protected void verticalReflection(float[][] fArray) {
        int n;
        float[] fArray2;
        int n2;
        float f = 0.0f;
        for (n2 = 0; n2 < fArray.length; ++n2) {
            fArray2 = fArray[n2];
            for (n = 0; n < fArray2.length; n += 2) {
                if (!(f < fArray[n2][n + 1])) continue;
                f = fArray[n2][n + 1];
            }
        }
        for (n2 = 0; n2 < fArray.length; ++n2) {
            fArray2 = fArray[n2];
            for (n = 0; n < fArray2.length; n += 2) {
                fArray[n2][n + 1] = f - fArray[n2][n + 1];
            }
        }
    }

    protected void xyReflection(float[][] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray2 = fArray[i];
            for (int j = 0; j < fArray2.length; j += 2) {
                float f = fArray2[j];
                fArray2[j] = fArray2[j + 1];
                fArray2[j + 1] = f;
            }
        }
    }

    protected void rotate90AboutCenter(float[][] fArray) {
        float[] fArray2 = this.findBounds(fArray);
        float f = fArray2[0] / 2.0f;
        float f2 = fArray2[1] / 2.0f;
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray3 = fArray[i];
            for (int j = 0; j < fArray3.length; j += 2) {
                float f3 = fArray3[j];
                fArray3[j] = f + f2 - fArray3[j + 1];
                fArray3[j + 1] = f3 - f + f2;
            }
        }
    }

    protected void rotate90(float[][] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray2 = fArray[i];
            for (int j = 0; j < fArray2.length; j += 2) {
                float f = fArray2[j];
                fArray2[j] = 1.0f - fArray2[j + 1];
                fArray2[j + 1] = f;
            }
        }
    }

    protected void stretchScale(float[][] fArray, float f, float f2, int[] nArray) {
        int n;
        float[] fArray2;
        int n2;
        this.uniformScale(fArray, f);
        float f3 = 0.5f * (f2 - f);
        block25: for (int i = 0; i < fArray.length; ++i) {
            float[] fArray3 = fArray[i];
            switch (nArray[i]) {
                case 1: {
                    for (n2 = 0; n2 < fArray3.length; n2 += 2) {
                        int n3 = n2 + 1;
                        fArray3[n3] = fArray3[n3] - f3;
                    }
                    continue block25;
                }
                case 2: {
                    fArray3[3] = fArray3[3] - f3;
                    continue block25;
                }
                case 6: {
                    fArray3[1] = fArray3[1] - f3;
                    continue block25;
                }
                case 3: {
                    for (n2 = 0; n2 < fArray3.length; n2 += 2) {
                        int n4 = n2 + 1;
                        fArray3[n4] = fArray3[n4] + f3;
                    }
                    continue block25;
                }
                case 7: {
                    fArray3[1] = fArray3[1] + f3;
                    continue block25;
                }
                case 4: {
                    fArray3[3] = fArray3[3] + f3;
                    continue block25;
                }
                case 5: {
                    fArray3[1] = fArray3[1] - f3;
                    fArray3[3] = fArray3[3] + f3;
                    continue block25;
                }
                case 8: {
                    for (n2 = 0; n2 < fArray3.length; n2 += 2) {
                        int n5 = n2;
                        fArray3[n5] = fArray3[n5] - f3;
                    }
                    continue block25;
                }
                case 9: {
                    for (n2 = 0; n2 < fArray3.length; n2 += 2) {
                        int n6 = n2;
                        fArray3[n6] = fArray3[n6] + f3;
                    }
                    continue block25;
                }
                case 10: {
                    for (n2 = 0; n2 < fArray3.length; n2 += 2) {
                        int n7 = n2 + 1;
                        fArray3[n7] = (float)((double)fArray3[n7] - Math.min(0.15 * (double)f3, 0.5 * (double)f));
                    }
                    continue block25;
                }
                case 11: {
                    fArray3[0] = fArray3[0] + f3;
                    continue block25;
                }
                case 12: {
                    fArray3[0] = fArray3[0] - f3;
                    continue block25;
                }
                case 13: {
                    fArray3[2] = fArray3[2] + f3;
                    continue block25;
                }
                case 14: {
                    fArray3[2] = fArray3[2] - f3;
                    continue block25;
                }
                case 15: {
                    fArray3[0] = fArray3[0] + f3;
                    fArray3[2] = fArray3[2] - f3;
                    continue block25;
                }
                case 16: {
                    fArray3[0] = fArray3[0] - f3;
                    fArray3[2] = fArray3[2] - f3;
                    continue block25;
                }
                case 17: {
                    fArray3[2] = fArray3[2] + f3;
                    fArray3[4] = fArray3[4] + f3;
                    continue block25;
                }
                case 18: {
                    fArray3[2] = fArray3[2] - f3;
                    fArray3[4] = fArray3[4] - f3;
                    continue block25;
                }
                case 19: {
                    fArray3[0] = fArray3[0] + f3;
                    fArray3[2] = fArray3[2] + f3;
                    continue block25;
                }
                case 21: {
                    fArray3[0] = fArray3[0] - f3;
                    fArray3[2] = fArray3[2] - f3;
                    fArray3[4] = fArray3[4] - f3;
                    continue block25;
                }
                case 20: {
                    fArray3[0] = fArray3[0] + f3;
                    fArray3[2] = fArray3[2] + f3;
                    fArray3[4] = fArray3[4] + f3;
                    continue block25;
                }
                case 22: {
                    for (n2 = 0; n2 < fArray3.length; n2 += 2) {
                        int n8 = n2;
                        fArray3[n8] = (float)((double)fArray3[n8] - Math.min(0.15 * (double)f3, 0.5 * (double)f));
                    }
                    continue block25;
                }
                case 23: {
                    fArray3[0] = fArray3[0] + f3 / 2.0f;
                    fArray3[1] = fArray3[1] - f3;
                    continue block25;
                }
            }
        }
        float f4 = fArray[0][0];
        float f5 = fArray[0][0];
        for (n2 = 0; n2 < fArray.length; ++n2) {
            fArray2 = fArray[n2];
            for (n = 0; n < fArray2.length; n += 2) {
                if (fArray2[n] < f4) {
                    f4 = fArray2[n];
                }
                if (!(fArray2[n + 1] < f5)) continue;
                f5 = fArray2[n + 1];
            }
        }
        for (n2 = 0; n2 < fArray.length; ++n2) {
            fArray2 = fArray[n2];
            for (n = 0; n < fArray2.length; n += 2) {
                int n9 = n;
                fArray2[n9] = fArray2[n9] - f4;
                int n10 = n + 1;
                fArray2[n10] = fArray2[n10] - f5;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutView(WmiMathOperatorView wmiMathOperatorView, int n) throws WmiNoReadAccessException {
        WmiTextLayout wmiTextLayout = wmiMathOperatorView.getLayout();
        int n2 = 0;
        int n3 = 0;
        Font font = this.getFont(wmiMathOperatorView);
        if (this.isBracket()) {
            Font font2 = wmiTextLayout.getFont();
            n2 = (int)(this.getBracketShiftFactor() * font2.getSize2D());
            n3 = 0;
        } else {
            n2 = wmiTextLayout.computeSpaceAbove();
            n3 = wmiTextLayout.computeSpaceBelow();
        }
        int n4 = wmiTextLayout.getHeight();
        if (n < n4) {
            n = n4;
        }
        wmiMathOperatorView.setStretchHeight(n);
        wmiMathOperatorView.setHeight(n);
        GlyphCache glyphCache = this.cache;
        synchronized (glyphCache) {
            RenderedGlyph renderedGlyph = this.cache.getGlyph(font, n);
            if (renderedGlyph == null && (renderedGlyph = this.createGlyph(font, n - n2 - n3)) != null) {
                renderedGlyph.setVerticalPadding(n2, n3);
                this.cache.setGlyph(font, n, renderedGlyph);
            }
            if (renderedGlyph != null) {
                Rectangle2D.Float float_ = renderedGlyph.getBounds();
                int n5 = Math.round(float_.width);
                int n6 = wmiMathOperatorView.getLeftPadding();
                int n7 = wmiMathOperatorView.getRightPadding();
                wmiMathOperatorView.setWidth(n5 + n6 + n7);
                wmiMathOperatorView.setStretchWidth(n5 + n6 + n7);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle, WmiMathOperatorView wmiMathOperatorView) {
        Object object;
        Object object2;
        Font font = this.getFont(wmiMathOperatorView);
        int n = wmiRenderPath.getHorizontalOffset();
        int n2 = wmiRenderPath.getVerticalOffset();
        int n3 = this.getStretchySize(wmiMathOperatorView);
        int n4 = wmiMathOperatorView.getWidth();
        WmiFontAttributeSet wmiFontAttributeSet = wmiMathOperatorView.getFontAttributes();
        boolean bl = wmiRenderPath.isMidpointSelected(wmiMathOperatorView);
        if (bl) {
            object2 = wmiMathOperatorView.getDocumentView();
            object = ((WmiMathDocumentView)object2).getColor(3);
            graphics.setColor((Color)object);
        } else {
            if (wmiFontAttributeSet.isOpaque()) {
                graphics.setColor(new Color(wmiFontAttributeSet.getBackground()));
                graphics.fillRect(n + wmiMathOperatorView.getHorizontalOffset(), n2, n4, wmiMathOperatorView.getHeight());
            }
            graphics.setColor(new Color(wmiFontAttributeSet.getForeground()));
        }
        object2 = this.cache;
        synchronized (object2) {
            object = this.cache.getGlyph(font, n3);
            if (object == null) {
                object = this.createGlyph(font, n3);
                this.cache.setGlyph(font, n3, (RenderedGlyph)object);
            }
            if (object != null) {
                ((RenderedGlyph)object).draw((Graphics2D)graphics, n + wmiMathOperatorView.getHorizontalOffset() + wmiMathOperatorView.getLeftPadding(), n2 + wmiMathOperatorView.getVerticalOffset());
            } else {
                WmiErrorLog.log(new Exception("Failed to find glyph: size = " + n3));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int computeSpaceAbove(WmiMathOperatorView wmiMathOperatorView) {
        int n = 0;
        Font font = this.getFont(wmiMathOperatorView);
        int n2 = this.getStretchySize(wmiMathOperatorView);
        GlyphCache glyphCache = this.cache;
        synchronized (glyphCache) {
            RenderedGlyph renderedGlyph = this.cache.getGlyph(font, n2);
            if (renderedGlyph != null) {
                n = renderedGlyph.getSpaceAbove();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int computeSpaceBelow(WmiMathOperatorView wmiMathOperatorView) {
        int n = 0;
        Font font = this.getFont(wmiMathOperatorView);
        int n2 = this.getStretchySize(wmiMathOperatorView);
        GlyphCache glyphCache = this.cache;
        synchronized (glyphCache) {
            RenderedGlyph renderedGlyph = this.cache.getGlyph(font, n2);
            if (renderedGlyph != null) {
                n = renderedGlyph.getSpaceBelow();
            }
        }
        return n;
    }

    public int computePostKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
        return 0;
    }

    public int computePreKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
        return 0;
    }

    public static class GlyphCache {
        private HashMap map = new HashMap();

        public synchronized RenderedGlyph getGlyph(Font font, int n) {
            RenderedGlyph renderedGlyph = null;
            RenderedGlyph[] renderedGlyphArray = (RenderedGlyph[])this.map.get(font);
            if (renderedGlyphArray != null && n < renderedGlyphArray.length) {
                renderedGlyph = renderedGlyphArray[n];
            }
            return renderedGlyph;
        }

        public synchronized void setGlyph(Font font, int n, RenderedGlyph renderedGlyph) {
            RenderedGlyph[] renderedGlyphArray = (RenderedGlyph[])this.map.get(font);
            if (renderedGlyphArray == null || renderedGlyphArray.length <= n) {
                int n2 = n == 0 ? 2 : n * 2;
                RenderedGlyph[] renderedGlyphArray2 = new RenderedGlyph[n2];
                if (renderedGlyphArray != null) {
                    System.arraycopy(renderedGlyphArray, 0, renderedGlyphArray2, 0, renderedGlyphArray.length);
                }
                renderedGlyphArray = renderedGlyphArray2;
            }
            renderedGlyphArray[n] = renderedGlyph;
            this.map.put(font, renderedGlyphArray);
        }
    }

    public class RenderedGlyph {
        private GeneralPath gp;
        private Rectangle2D.Float bounds;
        private int spaceAbove = 0;
        private int spaceBelow = 0;

        public RenderedGlyph(float[][] fArray) {
            this.createGeneralPath(fArray);
        }

        private void createGeneralPath(float[][] fArray) {
            float f = 0.0f;
            float f2 = 0.0f;
            this.gp = new GeneralPath();
            boolean bl = true;
            block5: for (int i = 0; i < fArray.length; ++i) {
                float[] fArray2 = fArray[i];
                for (int j = 0; j != fArray2.length; j += 2) {
                    float f3 = fArray2[j];
                    float f4 = fArray2[j + 1];
                    if (f3 > f) {
                        f = f3;
                    }
                    if (!(f4 > f2)) continue;
                    f2 = f4;
                }
                if (bl) {
                    this.gp.moveTo(fArray2[0], fArray2[1]);
                    bl = false;
                    continue;
                }
                switch (fArray2.length) {
                    case 2: {
                        this.gp.lineTo(fArray2[0], fArray2[1]);
                        continue block5;
                    }
                    case 4: {
                        this.gp.quadTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
                        continue block5;
                    }
                    case 6: {
                        this.gp.curveTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3], fArray2[4], fArray2[5]);
                        continue block5;
                    }
                    default: {
                        this.gp.closePath();
                        bl = true;
                    }
                }
            }
            this.bounds = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
        }

        public void draw(Graphics2D graphics2D, int n, int n2) {
            graphics2D.translate(n, n2 + this.spaceAbove);
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fill(this.gp);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            graphics2D.translate(-n, -n2 - this.spaceAbove);
        }

        public Rectangle2D.Float getBounds() {
            return this.bounds;
        }

        public void setVerticalPadding(int n, int n2) {
            this.spaceAbove = n;
            this.spaceBelow = n2;
            this.bounds.y -= (float)n;
            this.bounds.height += (float)(n + n2);
        }

        public int getSpaceAbove() {
            return this.spaceAbove;
        }

        public int getSpaceBelow() {
            return this.spaceBelow;
        }
    }
}

