/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiAbstractOperatorRenderer;
import com.maplesoft.util.ResourceLoader;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.HashMap;

public class WmiBracketRenderer
extends WmiAbstractOperatorRenderer {
    public static final float BRACKET_APPLY_SCALE_FACTOR = 1.5f;
    protected static final int TOP_INDEX = 0;
    protected static final int FILL_INDEX = 1;
    protected static final int BOTTOM_INDEX = 2;
    protected static final int SINGLE_INDEX = 3;
    protected static final String MULTICHARACTER_BRACKET_FONT_MAPLEPI = "/com/maplesoft/mathdoc/font/resources/MaplePi.ttf";
    protected static final String MULTICHARACTER_BRACKET_FONT_ESSTIX = "/com/maplesoft/mathdoc/font/resources/ESSTIX8_.TTF";
    protected static final String OVERSIZED_BRACKET_FONT = "/com/maplesoft/mathdoc/font/resources/ESSTIX7_.TTF";
    protected static Font multicharacterFontSourceMaplePi = null;
    protected static Font multicharacterFontSourceEsstix = null;
    protected static Font oversizeBracketFontSource = null;
    protected char[] data;
    protected BracketCache cache = new BracketCache();

    protected WmiBracketRenderer() {
    }

    protected WmiBracketRenderer(char[] cArray) {
        this.data = cArray;
    }

    protected WmiBracketRenderer(char c, char c2, char c3) {
        this.data = new char[3];
        this.data[0] = c;
        this.data[1] = c2;
        this.data[2] = c3;
    }

    public static Font getOversizedBracketFont() {
        if (oversizeBracketFontSource == null) {
            try {
                oversizeBracketFontSource = ResourceLoader.getResourceAsFont(WmiBracketRenderer.getOversizedBracketFontName());
            }
            catch (FontFormatException fontFormatException) {
                WmiErrorLog.log(fontFormatException);
            }
            catch (IOException iOException) {
                WmiErrorLog.log(iOException);
            }
        }
        return oversizeBracketFontSource;
    }

    public static String getOversizedBracketFontName() {
        return OVERSIZED_BRACKET_FONT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutView(WmiMathOperatorView wmiMathOperatorView, int n) throws WmiNoReadAccessException {
        WmiBracketRenderer.getOversizedBracketFont();
        wmiMathOperatorView.setStretchHeight(n);
        wmiMathOperatorView.setHeight(n);
        Font font = this.getFont(wmiMathOperatorView);
        BracketCache bracketCache = this.cache;
        synchronized (bracketCache) {
            RenderedBracket renderedBracket = this.cache.getBracket(font, n);
            if (renderedBracket == null) {
                renderedBracket = this.createBracket(font, n);
            }
            if (renderedBracket != null) {
                boolean bl = wmiMathOperatorView.getDocumentView().isPrintView();
                renderedBracket.validateLayout(bl);
                int n2 = renderedBracket.getWidth(bl);
                int n3 = wmiMathOperatorView.getLeftPadding();
                int n4 = wmiMathOperatorView.getRightPadding();
                wmiMathOperatorView.setWidth(n2 + n3 + n4);
            }
        }
    }

    protected RenderedBracket createBracket(Font font, int n) {
        DefaultRenderedBracket defaultRenderedBracket = new DefaultRenderedBracket(this.data, font, this.getOversizeBracketFontSource(), n, this.canShrink(), this.forceFont());
        this.cache.setBracket(font, n, defaultRenderedBracket);
        return defaultRenderedBracket;
    }

    protected Font forceFont() {
        return null;
    }

    protected boolean canShrink() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle, WmiMathOperatorView wmiMathOperatorView) {
        Object object;
        Object object2;
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        Font font2 = this.getFont(wmiMathOperatorView);
        WmiFontAttributeSet wmiFontAttributeSet = wmiMathOperatorView.getFontAttributes();
        graphics.setFont(font2);
        int n = wmiRenderPath.getHorizontalOffset();
        int n2 = wmiRenderPath.getVerticalOffset();
        int n3 = wmiMathOperatorView.getWidth();
        int n4 = wmiMathOperatorView.getHorizontalOffset();
        boolean bl = false;
        if (wmiRenderPath.getSelection() != null && wmiRenderPath.getSelection().contains(wmiMathOperatorView) != 0) {
            bl = wmiRenderPath.isSelected(n4 + n, n3);
        }
        if (bl) {
            object2 = wmiMathOperatorView.getDocumentView();
            object = ((WmiMathDocumentView)object2).getColor(3);
            graphics.setColor((Color)object);
        } else {
            if (wmiFontAttributeSet.isOpaque()) {
                graphics.setColor(new Color(wmiFontAttributeSet.getBackground()));
                graphics.fillRect(n + wmiMathOperatorView.getHorizontalOffset(), n2, n3, wmiMathOperatorView.getHeight());
            }
            graphics.setColor(new Color(wmiFontAttributeSet.getForeground()));
        }
        object2 = this.cache;
        synchronized (object2) {
            object = this.cache.getBracket(font2, wmiMathOperatorView.getHeight());
            if (object == null) {
                object = this.createBracket(font2, wmiMathOperatorView.getHeight());
            }
            if (object != null) {
                boolean bl2 = wmiMathOperatorView.getDocumentView().isPrintView();
                object.validateLayout(bl2);
                object.draw(graphics, n + wmiMathOperatorView.getHorizontalOffset() + wmiMathOperatorView.getLeftPadding(), n2 + wmiMathOperatorView.getVerticalOffset(), bl2);
            } else {
                WmiErrorLog.log(new Exception("Failed to find bracket: height = " + wmiMathOperatorView.getHeight()));
            }
        }
        graphics.setFont(font);
        graphics.setColor(color);
    }

    public Font getOversizeBracketFontSource() {
        return oversizeBracketFontSource;
    }

    public boolean applyRenderer(WmiMathOperatorView wmiMathOperatorView, int n) {
        boolean bl = false;
        if (n > 0) {
            Font font = this.getFont(wmiMathOperatorView);
            WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
            int n2 = wmiFontMetrics.getFontProperty(3, wmiMathOperatorView.getDocumentView().isPrintView());
            bl = (float)n > 1.5f * (float)n2;
        }
        return bl;
    }

    static {
        try {
            multicharacterFontSourceMaplePi = ResourceLoader.getResourceAsFont(MULTICHARACTER_BRACKET_FONT_MAPLEPI);
            multicharacterFontSourceEsstix = ResourceLoader.getResourceAsFont(MULTICHARACTER_BRACKET_FONT_ESSTIX);
            oversizeBracketFontSource = ResourceLoader.getResourceAsFont(OVERSIZED_BRACKET_FONT);
        }
        catch (IOException iOException) {
            WmiErrorLog.log(iOException);
        }
        catch (FontFormatException fontFormatException) {
            WmiErrorLog.log(fontFormatException);
        }
    }

    public static class BracketCache {
        private HashMap map = new HashMap();

        public synchronized RenderedBracket getBracket(Font font, int n) {
            RenderedBracket renderedBracket = null;
            RenderedBracket[] renderedBracketArray = (RenderedBracket[])this.map.get(font);
            if (renderedBracketArray != null && n < renderedBracketArray.length) {
                renderedBracket = renderedBracketArray[n];
            }
            return renderedBracket;
        }

        public synchronized void setBracket(Font font, int n, RenderedBracket renderedBracket) {
            RenderedBracket[] renderedBracketArray = (RenderedBracket[])this.map.get(font);
            if (renderedBracketArray == null || renderedBracketArray.length <= n) {
                int n2 = n == 0 ? 2 : n * 2;
                RenderedBracket[] renderedBracketArray2 = new RenderedBracket[n2];
                if (renderedBracketArray != null) {
                    System.arraycopy(renderedBracketArray, 0, renderedBracketArray2, 0, renderedBracketArray.length);
                }
                renderedBracketArray = renderedBracketArray2;
            }
            renderedBracketArray[n] = renderedBracket;
            this.map.put(font, renderedBracketArray);
        }
    }

    protected static class DefaultRenderedBracket
    implements RenderedBracket {
        private int[] screenPositions;
        private int[] printPositions;
        private Font font;
        private Font screenFont = null;
        private Font printFont = null;
        private char[] data;
        private int screenWidth = 0;
        private int printWidth = 0;
        private Font oversize;
        boolean shrinkable;
        private int height;

        protected DefaultRenderedBracket(char[] cArray, Font font, Font font2, int n, boolean bl) {
            this(cArray, font, font2, n, bl, null);
        }

        protected DefaultRenderedBracket(char[] cArray, Font font, Font font2, int n, boolean bl, Font font3) {
            this.data = cArray;
            this.oversize = font2;
            this.shrinkable = bl;
            this.height = n;
            this.screenPositions = null;
            this.printPositions = null;
            this.font = font3 != null ? font3.deriveFont(0, font.getSize2D()) : (RuntimePlatform.isEsstix() ? multicharacterFontSourceEsstix.deriveFont(0, font.getSize2D()) : multicharacterFontSourceMaplePi.deriveFont(0, font.getSize2D()));
        }

        protected String getSingleCharacterFont() {
            return WmiBracketRenderer.OVERSIZED_BRACKET_FONT;
        }

        public boolean singleCharacterBracketAllowed() {
            return true;
        }

        public void validateLayout(boolean bl) {
            if (bl && this.printPositions == null || !bl && this.screenPositions == null) {
                this.layoutBracket(bl);
            }
        }

        protected void layoutBracket(boolean bl) {
            int[] nArray;
            int n = 0;
            Font font = this.font;
            WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
            char c = this.data[0];
            int n2 = wmiFontMetrics.getCharacterProperty(4, c, bl);
            int n3 = wmiFontMetrics.getCharacterProperty(5, c, bl);
            int n4 = n2 + n3;
            n = wmiFontMetrics.getCharacterProperty(2, c, bl) + wmiFontMetrics.getCharacterProperty(3, c, bl);
            c = this.data[1];
            int n5 = wmiFontMetrics.getCharacterProperty(4, c, bl);
            int n6 = wmiFontMetrics.getCharacterProperty(5, c, bl);
            int n7 = n5 + n6;
            c = this.data[2];
            int n8 = wmiFontMetrics.getCharacterProperty(4, c, bl);
            int n9 = wmiFontMetrics.getCharacterProperty(5, c, bl);
            int n10 = n8 + n9;
            n += wmiFontMetrics.getCharacterProperty(1, c, bl);
            if (this.height < n4 + n10 && this.singleCharacterBracketAllowed()) {
                int n11 = font.getSize();
                wmiFontMetrics = WmiFontResolver.getFontMetrics(font = this.oversize.deriveFont(0, n11));
                n2 = wmiFontMetrics.getCharacterProperty(4, c = this.data[3], bl);
                n4 = n2 + (n3 = wmiFontMetrics.getCharacterProperty(5, c, bl));
                float f = (float)this.height / (float)n4;
                int n12 = Math.round(f * (float)n11);
                if (n12 != n11) {
                    font = this.oversize.deriveFont(0, n12);
                    wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
                    c = this.data[3];
                    n2 = wmiFontMetrics.getCharacterProperty(4, c, bl);
                }
                n = wmiFontMetrics.getCharacterProperty(2, c, bl);
                nArray = new int[]{n2};
            } else {
                int n13;
                int n14 = this.height - n4 - n10;
                int n15 = 1 + n14 / n7;
                int n16 = n7 * n15 - n14;
                int n17 = (int)Math.ceil((float)n16 / (float)(n15 + 2));
                n15 = 1 + n14 / (n7 - n17);
                int n18 = 0;
                if (n17 > n4 / 4 && this.shrinkable && n15 > 0) {
                    n13 = n4 + n10 + --n15 * n7;
                    n17 = 0;
                    n18 = 1 + (this.height - n13) / 2;
                }
                nArray = new int[n15 + 2];
                nArray[0] = n2 + n18;
                nArray[n15 + 1] = this.height - n9 - n18;
                n13 = n4 + n5 - n17 + n18;
                for (int i = 0; i < n15; ++i) {
                    nArray[i + 1] = n13;
                    n13 += n7 - n17;
                }
                if (n15 > 1) {
                    nArray[nArray.length - 2] = this.height - n10 - n18 - n6 + 2;
                }
            }
            if (bl) {
                this.printWidth = n;
                this.printPositions = nArray;
                this.printFont = font;
            } else {
                this.screenWidth = n;
                this.screenPositions = nArray;
                this.screenFont = font;
            }
        }

        public void draw(Graphics graphics, int n, int n2, boolean bl) {
            int[] nArray;
            Font font = graphics.getFont();
            Object object = null;
            if (graphics instanceof Graphics2D) {
                object = ((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (bl) {
                nArray = this.printPositions;
                graphics.setFont(this.printFont);
            } else {
                nArray = this.screenPositions;
                graphics.setFont(this.screenFont);
            }
            if (nArray != null) {
                int n3 = nArray.length;
                if (n3 == 1) {
                    graphics.drawString(Character.toString(this.data[3]), n, n2 + nArray[0]);
                } else {
                    graphics.drawString(Character.toString(this.data[0]), n, n2 + nArray[0]);
                    String string = Character.toString(this.data[1]);
                    for (int i = 1; i < n3 - 1; ++i) {
                        graphics.drawString(string, n, n2 + nArray[i]);
                    }
                    graphics.drawString(Character.toString(this.data[2]), n, n2 + nArray[n3 - 1]);
                }
            }
            graphics.setFont(font);
            if (object != null) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
        }

        public int getWidth(boolean bl) {
            return bl ? this.printWidth : this.screenWidth;
        }
    }

    public static interface RenderedBracket {
        public void draw(Graphics var1, int var2, int var3, boolean var4);

        public int getWidth(boolean var1);

        public void validateLayout(boolean var1);

        public boolean singleCharacterBracketAllowed();
    }
}

