/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.linebreaker;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.view.WmiAdaptiveLayoutView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiLinebrokenView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.linebreaker.WmiForceBreakSet;
import com.maplesoft.mathdoc.view.math.linebreaker.WmiLineBreaker;
import com.maplesoft.mathdoc.view.math.renderers.WmiOperatorRenderer;

public class WmiDefaultLineBreaker
implements WmiLineBreaker {
    private static final float INDENT_SCALE_FACTOR = 0.2f;
    private static final float SPACING_SCALE_FACTOR = 0.0f;

    public void linebreak(WmiLinebrokenView wmiLinebrokenView, WmiView wmiView, WmiForceBreakSet wmiForceBreakSet, int n, boolean bl) throws WmiNoReadAccessException {
        if (wmiView instanceof WmiCompositeView) {
            this.linebreakComposite(wmiLinebrokenView, (WmiCompositeView)wmiView, wmiForceBreakSet, n, bl);
        } else if (wmiView != null) {
            this.linebreakChild(wmiLinebrokenView, wmiView, wmiForceBreakSet, n, bl);
        }
    }

    public synchronized WmiRowView lineBreakChildren(WmiCompositeView wmiCompositeView, int n) throws WmiNoReadAccessException {
        return null;
    }

    public void linebreakComposite(WmiLinebrokenView wmiLinebrokenView, WmiCompositeView wmiCompositeView, WmiForceBreakSet wmiForceBreakSet, int n, boolean bl) throws WmiNoReadAccessException {
        if (this.keepOnLine(wmiLinebrokenView, wmiCompositeView, wmiForceBreakSet, n)) {
            this.addChild(wmiLinebrokenView, wmiCompositeView);
        } else {
            int n2 = wmiCompositeView.getChildCount();
            for (int i = 0; i < n2; ++i) {
                WmiView wmiView = wmiCompositeView.getChild(i);
                if (wmiView == null) continue;
                this.linebreakChild(wmiLinebrokenView, wmiView, wmiForceBreakSet, n, bl);
            }
        }
    }

    public void linebreakChild(WmiLinebrokenView wmiLinebrokenView, WmiView wmiView, WmiForceBreakSet wmiForceBreakSet, int n, boolean bl) throws WmiNoReadAccessException {
        if (this.keepOnLine(wmiLinebrokenView, wmiView, wmiForceBreakSet, n) && !bl && !wmiForceBreakSet.hasModels()) {
            this.addChild(wmiLinebrokenView, wmiView);
        } else if (this.keepOnLine(wmiLinebrokenView, wmiView, wmiForceBreakSet, n) || bl) {
            WmiDefaultLineBreaker.nextLinebreak(wmiLinebrokenView, wmiView, wmiForceBreakSet, n, false);
        } else {
            if (!(wmiView instanceof WmiCompositeView)) {
                if (!bl && !this.isEmptyLine(wmiLinebrokenView)) {
                    this.finishCurrentRow(wmiLinebrokenView, wmiForceBreakSet);
                    this.createNewRow(wmiLinebrokenView);
                }
            } else if (!bl && !this.hasGoodBreakPoint(wmiLinebrokenView, wmiView, wmiForceBreakSet, n, 0)) {
                this.finishCurrentRow(wmiLinebrokenView, wmiForceBreakSet);
                this.createNewRow(wmiLinebrokenView);
            }
            if (this.keepOnLine(wmiLinebrokenView, wmiView, wmiForceBreakSet, n)) {
                this.addChild(wmiLinebrokenView, wmiView);
            } else {
                WmiDefaultLineBreaker.nextLinebreak(wmiLinebrokenView, wmiView, wmiForceBreakSet, n, false);
            }
        }
    }

    protected boolean isEmptyLine(WmiLinebrokenView wmiLinebrokenView) {
        boolean bl = true;
        int n = wmiLinebrokenView.getChildCount();
        if (n > 0) {
            WmiInlineView wmiInlineView = (WmiInlineView)wmiLinebrokenView.getChild(n - 1);
            bl = wmiInlineView.getChildCount() == 0;
        }
        return bl;
    }

    protected void createNewRow(WmiLinebrokenView wmiLinebrokenView) throws WmiNoReadAccessException {
        if (!this.isLastRowEmpty(wmiLinebrokenView)) {
            wmiLinebrokenView.addRow();
        }
        int n = this.getIndent(wmiLinebrokenView);
        WmiModel wmiModel = wmiLinebrokenView.getModel();
        WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
        int n2 = (int)((float)wmiMathDocumentModel.getZoomFactor() * 0.0f);
        int n3 = wmiLinebrokenView.getChildCount();
        if (n3 > 0) {
            WmiInlineView wmiInlineView = (WmiInlineView)wmiLinebrokenView.getChild(n3 - 1);
            wmiInlineView.setPadding(n, 0);
            wmiInlineView.setPadding(n2, 2);
            wmiInlineView.setPadding(wmiLinebrokenView.getBreakWidth(), 1);
        }
    }

    protected int getIndent(WmiLinebrokenView wmiLinebrokenView) throws WmiNoReadAccessException {
        int n = wmiLinebrokenView.getMathIndentLevel();
        WmiModel wmiModel = wmiLinebrokenView.getModel();
        WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
        n *= wmiMathDocumentModel.getZoomFactor();
        n = (int)((float)n * 0.2f);
        return n;
    }

    protected void finishCurrentRow(WmiLinebrokenView wmiLinebrokenView, WmiForceBreakSet wmiForceBreakSet) throws WmiNoReadAccessException {
        WmiInlineView wmiInlineView;
        int n;
        int n2 = this.getLineWidth(wmiLinebrokenView);
        int n3 = wmiLinebrokenView.getBreakWidth();
        if (n3 > n2 && (n = wmiLinebrokenView.getChildCount()) > 0 && (wmiInlineView = (WmiInlineView)wmiLinebrokenView.getChild(n - 1)).getChildCount() > 0) {
            wmiInlineView.setPadding(n3 - n2, 1);
        }
    }

    private boolean isLastRowEmpty(WmiLinebrokenView wmiLinebrokenView) {
        WmiInlineView wmiInlineView;
        boolean bl = false;
        int n = wmiLinebrokenView.getChildCount();
        if (n > 0 && (wmiInlineView = (WmiInlineView)wmiLinebrokenView.getChild(n - 1)).getChildCount() == 0) {
            bl = true;
        }
        return bl;
    }

    protected WmiPositionedView addChild(WmiLinebrokenView wmiLinebrokenView, WmiView wmiView) throws WmiNoReadAccessException {
        int n = wmiLinebrokenView.getChildCount();
        if (n == 0) {
            wmiLinebrokenView.addRow();
            ++n;
        }
        WmiInlineView wmiInlineView = (WmiInlineView)wmiLinebrokenView.getChild(n - 1);
        wmiInlineView.applyMathRules(true);
        wmiInlineView.lockOperatorSize(true);
        if (wmiView instanceof WmiAdaptiveLayoutView) {
            ((WmiAdaptiveLayoutView)wmiView).restoreOriginalView();
        }
        wmiInlineView.appendView(wmiView);
        return (WmiPositionedView)wmiView;
    }

    protected boolean fitsOnNewLine(WmiLinebrokenView wmiLinebrokenView, WmiView wmiView) throws WmiNoReadAccessException {
        int n = this.getIndent(wmiLinebrokenView);
        int n2 = wmiLinebrokenView.getBreakWidth();
        return wmiView instanceof WmiPositionedView ? n2 > ((WmiPositionedView)wmiView).getWidth() + n : false;
    }

    protected boolean keepOnLine(WmiLinebrokenView wmiLinebrokenView, WmiView wmiView, WmiForceBreakSet wmiForceBreakSet, int n) throws WmiNoReadAccessException {
        Object object;
        boolean bl = false;
        int n2 = wmiLinebrokenView.getChildCount();
        if (n2 > 0 && wmiView instanceof WmiPositionedView) {
            object = (WmiPositionedView)wmiView;
            int n3 = wmiLinebrokenView.getBreakWidth() - this.getLineWidth(wmiLinebrokenView);
            if (wmiView instanceof WmiAdaptiveLayoutView) {
                object = (WmiPositionedView)((WmiAdaptiveLayoutView)object).getPreferredView(n3, -1);
            }
            boolean bl2 = bl = ((WmiPositionedView)wmiView).getWidth() <= n3;
        }
        if (bl) {
            object = wmiView.getModel();
            bl = !wmiForceBreakSet.contains((WmiModel)object);
        }
        return bl;
    }

    protected int getLineWidth(WmiLinebrokenView wmiLinebrokenView) throws WmiNoReadAccessException {
        int n = 0;
        int n2 = wmiLinebrokenView.getChildCount();
        if (n2 > 0) {
            WmiInlineView wmiInlineView = (WmiInlineView)wmiLinebrokenView.getChild(n2 - 1);
            n = wmiInlineView.getPadding(0);
            n2 = wmiInlineView.getChildCount();
            for (int i = 0; i < n2; ++i) {
                WmiPositionedView wmiPositionedView = (WmiPositionedView)wmiInlineView.getChild(i);
                n += wmiPositionedView.getWidth();
            }
        }
        return n;
    }

    public boolean hasGoodBreakPoint(WmiLinebrokenView wmiLinebrokenView, WmiView wmiView, WmiForceBreakSet wmiForceBreakSet, int n, int n2) throws WmiNoReadAccessException {
        boolean bl = false;
        return bl;
    }

    public static void nextLinebreak(WmiLinebrokenView wmiLinebrokenView, WmiView wmiView, WmiForceBreakSet wmiForceBreakSet, int n, boolean bl) throws WmiNoReadAccessException {
    }

    protected void addBracket(WmiLinebrokenView wmiLinebrokenView, WmiForceBreakSet wmiForceBreakSet, WmiCompositeModel wmiCompositeModel, WmiPositionedView wmiPositionedView, String string, WmiMathDocumentModel wmiMathDocumentModel, WmiMathDocumentView wmiMathDocumentView, WmiMathContext wmiMathContext) throws WmiNoReadAccessException {
        WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, string, wmiMathContext);
        try {
            wmiMathTokenModel.setParent(wmiCompositeModel);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        WmiMathOperatorView wmiMathOperatorView = new WmiMathOperatorView(wmiMathTokenModel, wmiMathDocumentView);
        wmiMathOperatorView.invalidate(1);
        wmiMathOperatorView.layoutView();
        int n = wmiPositionedView.getHeight();
        wmiMathOperatorView.setStretchHeight(n);
        WmiOperatorRenderer wmiOperatorRenderer = WmiMathOperatorView.getRenderer(string);
        wmiOperatorRenderer.layoutView(wmiMathOperatorView, n);
        wmiMathOperatorView.setBaseline(wmiPositionedView.getBaseline());
        int n2 = wmiLinebrokenView.getBreakWidth() - this.getLineWidth(wmiLinebrokenView);
        if (!this.keepOnLine(wmiLinebrokenView, wmiMathOperatorView, wmiForceBreakSet, n2)) {
            this.finishCurrentRow(wmiLinebrokenView, wmiForceBreakSet);
            this.createNewRow(wmiLinebrokenView);
        }
        this.addChild(wmiLinebrokenView, wmiMathOperatorView);
    }
}

