/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.view.WmiAdjustableTextBounds;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiTextAdjustmentUtils;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMultiscriptView;
import com.maplesoft.mathdoc.view.math.WmiSuperscriptView;
import com.maplesoft.mathdoc.view.math.WmiTraversableCompositeMathView;
import java.awt.Point;

public class WmiSubscriptView
extends WmiTraversableCompositeMathView
implements WmiAdjustableTextBounds {
    public static final int BASE_INDEX = 0;
    public static final int SUBSCRIPT_INDEX = 1;

    public WmiSubscriptView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.validateChildren();
            super.layoutView();
            try {
                WmiFontMetrics wmiFontMetrics = WmiViewUtil.getFontMetrics(this);
                WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
                WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(1);
                if (wmiPositionedView != null && wmiPositionedView2 != null) {
                    int n = wmiPositionedView2.getWidth();
                    int n2 = wmiPositionedView.getWidth();
                    wmiPositionedView2.setHorizontalOffset(n2);
                    WmiPositionedView wmiPositionedView3 = wmiPositionedView;
                    if (wmiPositionedView instanceof WmiMultiscriptView) {
                        wmiPositionedView3 = (WmiPositionedView)((WmiCompositeView)((Object)wmiPositionedView3)).getChild(0);
                    }
                    int n3 = WmiSubscriptView.getSubscriptVOffset(this, wmiPositionedView3, wmiPositionedView2, wmiFontMetrics);
                    if (wmiPositionedView != wmiPositionedView3) {
                        n3 += wmiPositionedView3.getVerticalOffset();
                    }
                    wmiPositionedView.setVerticalOffset(0);
                    wmiPositionedView2.setVerticalOffset(n3);
                    this.height = n3 + wmiPositionedView2.getHeight();
                    this.width = n2 + n;
                    this.baseline = wmiPositionedView.getBaseline() + wmiPositionedView.getVerticalOffset();
                    this.addNavigationLinks();
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }
    }

    public static int getSubscriptVOffset(WmiView wmiView, WmiPositionedView wmiPositionedView, WmiPositionedView wmiPositionedView2, WmiFontMetrics wmiFontMetrics) throws WmiNoReadAccessException {
        int n = wmiFontMetrics.getFontProperty(5, wmiView.getDocumentView().isPrintView());
        int n2 = n / 2;
        int n3 = 0;
        try {
            WmiMathDocumentView wmiMathDocumentView;
            WmiAttributeSet wmiAttributeSet = wmiView.getModel().getAttributes();
            if (wmiAttributeSet instanceof WmiSubscriptModel.WmiSubscriptAttributeSet) {
                n3 = ((WmiSubscriptModel.WmiSubscriptAttributeSet)wmiAttributeSet).getSubscriptShift();
            }
            if ((wmiMathDocumentView = wmiPositionedView.getDocumentView()) != null) {
                int n4 = wmiMathDocumentView.getZoomFactor();
                n3 = Math.round(n4 * n3 / 100);
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        int n5 = wmiPositionedView.getHeight();
        if (n5 < n) {
            n5 = n;
        }
        return n5 - n2 + n3;
    }

    public void addNavigationLinks() {
        WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
        WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(1);
        if (wmiPositionedView != null && wmiPositionedView2 != null) {
            wmiPositionedView.setNextView(wmiPositionedView2, 3);
            wmiPositionedView2.setNextView(wmiPositionedView, 2);
            this.setNextView(wmiPositionedView, -2);
            this.setNextView(null, -1);
            this.setNextView(wmiPositionedView, -4);
            this.setNextView(wmiPositionedView2, -3);
        }
    }

    public WmiPositionedView getNextView(int n) {
        WmiPositionMarker wmiPositionMarker;
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        boolean bl = false;
        if (wmiMathDocumentView != null && (wmiPositionMarker = wmiMathDocumentView.getPositionMarker()) != null) {
            bl = wmiPositionMarker.getView() == this.getChild(1);
        }
        int n2 = bl && n == 0 ? 3 : n;
        return super.getNextView(n2);
    }

    public WmiPositionedView getViewForNavigation(int n, Point point) {
        WmiPositionedView wmiPositionedView = this.getNextView(n);
        if (wmiPositionedView == null) {
            return this.getNearestChildView(point);
        }
        return wmiPositionedView;
    }

    public int computePreKernAdjustment() {
        return WmiTextAdjustmentUtils.computePreKernAdjustment(this, 0);
    }

    public int computePostKernAdjustment() {
        return WmiTextAdjustmentUtils.computePostKernAdjustment(this, 1);
    }

    public int computeSpaceAbove() {
        return WmiTextAdjustmentUtils.computeSpaceAbove(this, 0);
    }

    public int computeSpaceBelow() {
        return WmiTextAdjustmentUtils.computeSpaceBelow(this, 1);
    }

    public int getNearestSearchRule() {
        return 2;
    }

    public int doImplicitLinebreak(WmiParagraphView wmiParagraphView, int n, int n2, int n3) throws WmiNoReadAccessException {
        return WmiSuperscriptView.doImplicitScriptBreak(this, wmiParagraphView, n, n2, n3);
    }
}

