/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class WmiFencedView
extends WmiMathInlineView
implements WmiTraversableView {
    private static final float MINIMUM_WIDTH_SCALE_FACTOR = 0.3f;
    private static final float MIN_HEIGHT_BASELINE_ADJUST = 0.8f;
    private WmiMathOperatorView leftView = null;
    private WmiMathOperatorView rightView = null;
    private WmiMathOperatorView[] sepViews = null;
    private boolean suppressLeft = false;
    private boolean suppressRight = false;
    private boolean addTrailingSeparator = false;

    public WmiFencedView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            int n;
            int n2;
            super.layoutView();
            this.createFenceViews(this.getModel());
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (this.leftView != null) {
                this.leftView.layoutView();
                n2 = this.leftView.getHeight();
                if (n2 > this.height) {
                    n = Math.round(0.8f * (float)n2);
                    n4 = n - this.baseline;
                    this.baseline = n;
                    this.height = n2;
                }
                if (this.leftView.layoutStretchView(this.height)) {
                    this.leftView.setBaseline(this.baseline);
                }
                n6 = n3 = this.leftView.getWidth();
                n5 = Math.round(0.3f * (float)n3);
            }
            n2 = this.getChildCount();
            for (n = 0; n < n2; ++n) {
                WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(n);
                wmiPositionedView.setHorizontalOffset(wmiPositionedView.getHorizontalOffset() + n3);
                if (n4 != 0) {
                    wmiPositionedView.setVerticalOffset(wmiPositionedView.getVerticalOffset() + n4);
                }
                if (this.sepViews == null || n >= this.sepViews.length) continue;
                WmiMathOperatorView wmiMathOperatorView = this.sepViews[n];
                wmiMathOperatorView.layoutView();
                wmiMathOperatorView.setHorizontalOffset(wmiPositionedView.getHorizontalOffset() + wmiPositionedView.getWidth());
                wmiMathOperatorView.setVerticalOffset(wmiPositionedView.getVerticalOffset() + wmiPositionedView.getBaseline() - wmiMathOperatorView.getBaseline());
                n3 += wmiMathOperatorView.getWidth();
            }
            n = 0;
            if (this.rightView != null) {
                this.rightView.layoutView();
                if (this.rightView.layoutStretchView(this.height)) {
                    this.rightView.setBaseline(this.baseline);
                }
                this.rightView.setHorizontalOffset(this.width + n3);
                n = this.rightView.getWidth();
                n6 += n;
                n3 += n;
                if (0.3f * (float)n > (float)n5) {
                    n5 = Math.round(0.3f * (float)n);
                }
            }
            this.width += n3;
            if (this.rightView != null && this.width - n6 < n5) {
                this.width = n5 + n6;
                this.rightView.setHorizontalOffset(this.width - n);
            }
        }
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        super.draw(graphics, wmiRenderPath, rectangle);
        wmiRenderPath.push(this.x, this.y);
        if (this.leftView != null) {
            this.leftView.draw(graphics, wmiRenderPath, rectangle);
        }
        if (this.rightView != null) {
            this.rightView.draw(graphics, wmiRenderPath, rectangle);
        }
        if (this.sepViews != null) {
            for (int i = 0; i < this.sepViews.length; ++i) {
                this.sepViews[i].draw(graphics, wmiRenderPath, rectangle);
            }
        }
        wmiRenderPath.pop();
    }

    protected void createFenceViews(WmiModel wmiModel) throws WmiNoReadAccessException {
        if (wmiModel instanceof WmiMathFencedModel) {
            WmiModel wmiModel2;
            WmiView wmiView;
            WmiMathFencedModel wmiMathFencedModel = (WmiMathFencedModel)wmiModel;
            int n = this.getChildCount();
            boolean bl = n > 1;
            int n2 = 0;
            if (bl) {
                wmiView = this.getChild(0);
                wmiModel2 = wmiView.getModel();
                WmiCompositeModel wmiCompositeModel = wmiModel2.getParent();
                n2 = wmiCompositeModel.indexOf(wmiModel2);
            }
            Cloneable cloneable = wmiView = !this.suppressLeft ? (WmiMathOperatorModel)wmiMathFencedModel.getModelForLeft() : null;
            WmiModel wmiModel3 = !this.suppressRight ? (WmiMathOperatorModel)wmiMathFencedModel.getModelForRight() : (wmiModel2 = this.addTrailingSeparator ? (WmiMathOperatorModel)wmiMathFencedModel.getModelForSeparator(n + n2) : null);
            if (wmiView != null) {
                this.leftView = new WmiMathOperatorView((WmiModel)((Object)wmiView), this.getDocumentView());
                this.leftView.setParentView(this);
            } else {
                this.leftView = null;
            }
            if (wmiModel2 != null) {
                this.rightView = new WmiMathOperatorView(wmiModel2, this.getDocumentView());
                this.rightView.setParentView(this);
            } else {
                this.rightView = null;
            }
            if (bl) {
                this.sepViews = new WmiMathOperatorView[n - 1];
                for (int i = 0; i < n - 1; ++i) {
                    WmiMathOperatorModel wmiMathOperatorModel = (WmiMathOperatorModel)wmiMathFencedModel.getModelForSeparator(i + n2);
                    this.sepViews[i] = new WmiMathOperatorView(wmiMathOperatorModel, this.getDocumentView());
                    this.sepViews[i].setParentView(this);
                }
            } else {
                this.sepViews = null;
            }
        }
    }

    public WmiPositionedView getLeftBracket() {
        return this.leftView;
    }

    public WmiPositionedView getRightBracket() {
        return this.rightView;
    }

    public WmiPositionedView getSeparator(int n) {
        WmiMathOperatorView wmiMathOperatorView = null;
        if (this.sepViews != null && this.sepViews.length > n) {
            wmiMathOperatorView = this.sepViews[n];
        }
        return wmiMathOperatorView;
    }

    public void setPositionMarker(int n) {
        WmiMathCaret.setBoundaryCaret(this, n);
    }

    public WmiPositionedView getNearestChildView(Point point) {
        return this.getNearestChildView(point, this.getNearestSearchRule());
    }

    protected WmiPositionedView getNearestChildView(Point point, int n) {
        WmiPositionedView wmiPositionedView = super.getNearestChildView(point, n);
        return wmiPositionedView;
    }

    public int getNearestSearchRule() {
        return 2;
    }

    public int getTraversalType() {
        int n = 0;
        if (this.leftView != null) {
            n |= 2;
        }
        if (this.rightView != null) {
            n |= 4;
        }
        return n;
    }

    public int getOffset(Point point) {
        return 0;
    }

    public int getTraversableCount() {
        return this.leftView != null || this.rightView != null ? 2 : 0;
    }

    public boolean isRepeatable() {
        return false;
    }

    public WmiView splitView(int n, int n2) {
        WmiFencedView wmiFencedView = (WmiFencedView)super.splitView(n, n2);
        wmiFencedView.suppressRight = true;
        wmiFencedView.addTrailingSeparator = this.addTrailingSeparator;
        this.suppressLeft = true;
        this.addTrailingSeparator = false;
        this.markInvalid(1);
        wmiFencedView.markInvalid(1);
        return wmiFencedView;
    }

    public void updateLayout() {
    }

    public void addNavigationLinks() {
        super.addNavigationLinks();
        if (this.leftView != null) {
            this.leftView.setNextView(this.getNextView(-4), 3);
        }
        if (this.rightView != null) {
            this.rightView.setNextView(this.getNextView(-3), 2);
        }
    }

    public void adjustVerticalLayout() throws WmiNoReadAccessException {
        this.markInvalid(1);
        this.layoutView();
    }

    public int doImplicitLinebreak(WmiParagraphView wmiParagraphView, int n, int n2, int n3) throws WmiNoReadAccessException {
        int n4 = 0;
        if (n + this.getWidth() < n2 && this.rightView != null && this.leftView == null) {
            int n5;
            WmiCompositeView wmiCompositeView = this.getParentView();
            int n6 = n5 = wmiCompositeView != null ? wmiCompositeView.indexOf(this) : -1;
            if (n5 >= 0) {
                wmiParagraphView.split(wmiCompositeView, n5 + 1, 0);
                n4 = 2;
            }
        }
        if (n4 == 0) {
            n4 = super.doImplicitLinebreak(wmiParagraphView, n, n2, n3);
        }
        if (n4 == 0 && n3 == 2 && this.leftView != null) {
            wmiParagraphView.split(this, 0, 0);
            n4 = 2;
        }
        return n4;
    }

    protected int breakAtDelimiter(WmiParagraphView wmiParagraphView, int n) throws WmiNoReadAccessException {
        int n2 = this.getChildCount();
        if (n2 > 1) {
            this.addTrailingSeparator = true;
            wmiParagraphView.split(this, n, 0);
            return 2;
        }
        return super.breakAtDelimiter(wmiParagraphView, n);
    }

    public WmiPositionedView getChildView(Point point) {
        WmiPositionedView wmiPositionedView = null;
        if (!(this.leftView != null && point.x < this.leftView.getWidth() || this.rightView != null && point.x > this.getWidth() - this.rightView.getWidth())) {
            wmiPositionedView = super.getChildView(point);
        }
        return wmiPositionedView;
    }
}

