/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeComparator;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentHierarchyValidator;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.WmiTaskWrapperModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiRootModel;
import com.maplesoft.mathdoc.util.WmiAncestorPath;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiDefaultPositionUpdateHandler;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMapleTACompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiResizableContainerView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionHighlighter;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Toolkit;
import java.util.MissingResourceException;
import java.util.Stack;

public class WmiViewPathInterval
implements WmiSelection {
    private static final int SELECTION_START_MODE = 0;
    private static final int SELECTION_END_MODE = 1;
    public static final int SELECTION_START_INDEX = 0;
    public static final int SELECTION_END_INDEX = 1;
    public static final int SELECTION_BOUNDS = 2;
    private static String undoDeleteSelectionText;
    public static String undoReplaceSelectionText;
    protected WmiMathDocumentView docView;
    protected WmiViewPath lowerBound;
    protected WmiViewPath upperBound;
    private WmiViewPath anchor;
    private WmiSelectionHighlighter highlighter;
    private WmiModel startModel;
    private int startOffset;
    private WmiModel endModel;
    private int endOffset;
    private static int ONBOUNDERY;
    private static int OUTSIDEBOUNDRY;
    private static int INSIDEBOUNDRY;
    private static int ONBOUNDERYPARTIALLY;
    private static int ONBOUNDERYFULLY;
    static /* synthetic */ Class class$com$maplesoft$mathdoc$model$WmiParagraphModel;

    public WmiViewPathInterval(WmiMathDocumentView wmiMathDocumentView) {
        this.docView = wmiMathDocumentView;
        this.anchor = null;
        this.upperBound = null;
        this.lowerBound = null;
        this.endModel = null;
        this.startModel = null;
    }

    public WmiViewPathInterval(WmiMathDocumentView wmiMathDocumentView, WmiViewPath wmiViewPath, WmiViewPath wmiViewPath2) {
        int[] nArray;
        WmiView wmiView;
        this.docView = wmiMathDocumentView;
        this.anchor = (WmiViewPath)wmiViewPath.clone();
        boolean bl = true;
        if (wmiViewPath2.greaterThan(this.anchor)) {
            this.lowerBound = (WmiViewPath)wmiViewPath.clone();
            this.upperBound = (WmiViewPath)wmiViewPath2.clone();
        } else {
            this.lowerBound = (WmiViewPath)wmiViewPath2.clone();
            this.upperBound = (WmiViewPath)wmiViewPath.clone();
            bl = false;
        }
        this.validateSelectionInterval();
        WmiViewPath wmiViewPath3 = null;
        if (bl) {
            this.anchor = (WmiViewPath)this.lowerBound.clone();
            wmiViewPath3 = (WmiViewPath)this.upperBound.clone();
        } else {
            this.anchor = (WmiViewPath)this.upperBound.clone();
            wmiViewPath3 = (WmiViewPath)this.lowerBound.clone();
        }
        if (wmiViewPath3 != null && (wmiView = wmiViewPath3.extractView(wmiMathDocumentView, nArray = new int[1])) instanceof WmiPositionedView) {
            ((WmiPositionedView)wmiView).setPositionMarker(nArray[0]);
        }
        if (wmiMathDocumentView != null) {
            this.computeModelBounds();
            this.highlighter = new WmiSelectionHighlighter(wmiMathDocumentView, this, null);
        }
    }

    public void updateModelSelection(WmiModel wmiModel, int n, WmiModel wmiModel2, int n2) {
        this.startModel = wmiModel;
        this.startOffset = n;
        this.endModel = wmiModel2;
        this.endOffset = n2;
    }

    public void updateSelection(WmiViewPath wmiViewPath) {
        if (this.anchor == null) {
            if (this.lowerBound != null && this.upperBound != null) {
                this.anchor = wmiViewPath.greaterThan(this.lowerBound) ? (WmiViewPath)this.lowerBound.clone() : (WmiViewPath)this.upperBound.clone();
            } else if (this.lowerBound != null) {
                this.anchor = (WmiViewPath)this.lowerBound.clone();
            } else if (this.upperBound != null) {
                this.anchor = (WmiViewPath)this.upperBound.clone();
            }
        }
        if (this.anchor != null) {
            int[] nArray;
            WmiView wmiView;
            WmiViewPath wmiViewPath2;
            if (wmiViewPath.greaterThan(this.anchor)) {
                wmiViewPath2 = this.upperBound = (WmiViewPath)wmiViewPath.clone();
                this.lowerBound = (WmiViewPath)this.anchor.clone();
            } else {
                wmiViewPath2 = this.lowerBound = (WmiViewPath)wmiViewPath.clone();
                this.upperBound = (WmiViewPath)this.anchor.clone();
            }
            this.validateSelectionInterval();
            if (wmiViewPath2 != null && (wmiView = wmiViewPath2.extractView(this.docView, nArray = new int[1])) instanceof WmiPositionedView && !(wmiView instanceof WmiResizableContainerView)) {
                ((WmiPositionedView)wmiView).setPositionMarker(nArray[0]);
            }
            if (this.docView != null) {
                this.computeModelBounds();
                this.highlighter = new WmiSelectionHighlighter(this.docView, this, this.highlighter);
            }
        }
    }

    public void updateSelection(WmiModel wmiModel, int n, WmiModel wmiModel2, int n2) throws WmiNoReadAccessException {
        this.updateModelSelection(wmiModel, n, wmiModel2, n2);
        boolean bl = false;
        if (this.startModel != null && this.startModel.getParent() == null || this.endModel != null && this.endModel.getParent() == null) {
            bl = false;
        }
        this.lowerBound = this.modelToPath(this.startModel, this.startOffset, 0);
        this.upperBound = this.modelToPath(this.endModel, this.endOffset, 1);
        if (this.docView != null && bl && this.lowerBound != null && this.upperBound != null) {
            this.validateSelectionInterval();
        }
        if (this.docView != null && this.lowerBound != null && this.upperBound != null) {
            this.computeModelBounds();
            this.highlighter = new WmiSelectionHighlighter(this.docView, this, this.highlighter);
        }
    }

    public void getModelInterval(WmiModelPosition[] wmiModelPositionArray) {
        wmiModelPositionArray[0] = new WmiModelPosition(this.startModel, this.startOffset);
        wmiModelPositionArray[1] = new WmiModelPosition(this.endModel, this.endOffset);
    }

    public boolean getModelInterval(WmiModel[] wmiModelArray, int[] nArray) {
        wmiModelArray[0] = this.startModel;
        wmiModelArray[1] = this.endModel;
        nArray[0] = this.startOffset;
        nArray[1] = this.endOffset;
        return true;
    }

    protected void computeModelBounds() {
        if (this.docView != null) {
            WmiModelPosition wmiModelPosition = this.pathToModel(this.lowerBound);
            this.startModel = wmiModelPosition.getModel();
            this.startOffset = wmiModelPosition.getOffset();
            wmiModelPosition = this.pathToModel(this.upperBound);
            this.endModel = wmiModelPosition.getModel();
            this.endOffset = wmiModelPosition.getOffset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateSelectionInterval() {
        WmiView wmiView;
        WmiView wmiView2 = this.upperBound != null ? this.upperBound.extractView(this.docView) : null;
        WmiView wmiView3 = wmiView = this.lowerBound != null ? this.lowerBound.extractView(this.docView) : null;
        if (wmiView != null && wmiView2 != null) {
            WmiViewPath wmiViewPath;
            WmiView wmiView4;
            WmiScrollableContainerView wmiScrollableContainerView;
            WmiScrollableContainerView wmiScrollableContainerView2 = wmiView == null ? null : WmiViewUtil.findEnclosingContainer(wmiView);
            WmiScrollableContainerView wmiScrollableContainerView3 = wmiScrollableContainerView = wmiView2 == null ? null : WmiViewUtil.findEnclosingContainer(wmiView2);
            if (wmiScrollableContainerView2 != wmiScrollableContainerView) {
                if (wmiScrollableContainerView2 != null && !wmiScrollableContainerView2.isDocumentView()) {
                    this.lowerBound = new WmiViewPath(wmiScrollableContainerView2);
                }
                if (wmiScrollableContainerView != null && !wmiScrollableContainerView.isDocumentView()) {
                    this.upperBound = new WmiViewPath(wmiScrollableContainerView);
                }
            }
            WmiModel wmiModel = (wmiView4 = (wmiViewPath = WmiViewPath.commonParent(this.lowerBound, this.upperBound)).extractView(this.docView)) != null ? wmiView4.getModel() : null;
            WmiModel wmiModel2 = wmiView.getModel();
            WmiModel wmiModel3 = wmiView2.getModel();
            boolean bl = WmiModelLock.readLock(wmiModel2, false);
            try {
                WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModel2, WmiModelTag.MATH_TABLE_ROW);
                WmiCompositeModel wmiCompositeModel2 = WmiModelUtil.findAncestorOfTag(wmiModel3, WmiModelTag.MATH_TABLE_ROW);
                if (wmiCompositeModel != null && wmiCompositeModel2 != null && wmiCompositeModel != wmiCompositeModel2) {
                    wmiView4 = WmiViewUtil.findAncestorOfTag(wmiView, WmiModelTag.MATH_TABLE);
                    if (wmiView4 != null) {
                        this.lowerBound = new WmiViewPath(wmiView4);
                        this.lowerBound.push(0);
                        this.upperBound = new WmiViewPath(wmiView4);
                        this.upperBound.push(-1);
                    }
                } else if (wmiModel != null && wmiModel2 != wmiModel3 && !wmiModel.isSubselectable()) {
                    this.lowerBound = new WmiViewPath(wmiView4);
                    this.lowerBound.push(0);
                    this.upperBound = new WmiViewPath(wmiView4);
                    this.upperBound.push(-1);
                } else if (wmiView4 != null) {
                    this.applyViewBoundaryConstraints();
                    if (!this.applyModelConstraints()) {
                        this.lowerBound = this.adjustPath(this.lowerBound, wmiView4, 0);
                        this.upperBound = this.adjustPath(this.upperBound, wmiView4, -1);
                    }
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                if (bl) {
                    WmiModelLock.readUnlock(wmiModel2);
                }
            }
        }
    }

    private void applyViewBoundaryConstraints() throws WmiNoReadAccessException {
        for (WmiView wmiView = this.anchor.extractView(this.docView); wmiView != null; wmiView = wmiView.getParentView()) {
            WmiTraversableView wmiTraversableView;
            int n;
            if (!(wmiView instanceof WmiTraversableView) || ((n = (wmiTraversableView = (WmiTraversableView)wmiView).getTraversalType()) & 0x10) == 0) continue;
            WmiView wmiView2 = this.upperBound.extractView(this.docView);
            boolean bl = true;
            for (WmiView wmiView3 = this.lowerBound.extractView(this.docView); wmiView3 != null; wmiView3 = wmiView3.getParentView()) {
                if (wmiView3 != wmiView) continue;
                bl = false;
                break;
            }
            boolean bl2 = true;
            while (wmiView2 != null) {
                if (wmiView2 == wmiView) {
                    bl2 = false;
                    break;
                }
                wmiView2 = wmiView2.getParentView();
            }
            if (bl) {
                this.lowerBound = new WmiViewPath(wmiView);
                this.lowerBound.push(0);
            }
            if (!bl2) break;
            this.upperBound = new WmiViewPath(wmiView);
            this.upperBound.push(-1);
            break;
        }
    }

    private boolean applyModelConstraints() throws WmiNoReadAccessException {
        boolean bl = false;
        this.computeModelBounds();
        WmiModelPath wmiModelPath = new WmiModelPath(this.startModel);
        WmiModelPath wmiModelPath2 = new WmiModelPath(this.endModel);
        WmiModelPath wmiModelPath3 = (WmiModelPath)WmiAncestorPath.commonPath(wmiModelPath, wmiModelPath2);
        if (wmiModelPath3 != null) {
            WmiModel wmiModel;
            bl = true;
            WmiModelPosition wmiModelPosition = wmiModelPath3.getModelPosition((WmiMathDocumentModel)this.docView.getModel());
            WmiModel wmiModel2 = wmiModelPosition.getModel();
            boolean bl2 = false;
            for (wmiModel = this.startModel; wmiModel != wmiModel2; wmiModel = wmiModel.getParent()) {
                if (!(wmiModel instanceof WmiCompositeModel) || wmiModel.isCrossBoundarySubselectable()) continue;
                this.startModel = wmiModel;
                this.startOffset = 0;
                bl2 = true;
            }
            for (wmiModel = this.endModel; wmiModel != wmiModel2; wmiModel = wmiModel.getParent()) {
                if (!(wmiModel instanceof WmiCompositeModel) || wmiModel.isCrossBoundarySubselectable()) continue;
                this.endModel = wmiModel;
                this.endOffset = -1;
                bl2 = true;
            }
            if (bl2) {
                this.updateSelection(this.startModel, this.startOffset, this.endModel, this.endOffset);
            }
        }
        return bl;
    }

    private WmiViewPath adjustPath(WmiViewPath wmiViewPath, WmiView wmiView, int n) {
        int n2;
        WmiView wmiView2;
        WmiViewPath wmiViewPath2 = wmiViewPath;
        Object object = null;
        WmiView wmiView3 = wmiView2;
        for (wmiView2 = wmiViewPath.extractView(this.docView); wmiView2 != null && wmiView2 != wmiView; wmiView2 = wmiView2.getParentView()) {
            WmiModel wmiModel = wmiView2.getModel();
            if (wmiModel == null || wmiModel.isCrossBoundarySubselectable()) continue;
            object = wmiView2;
        }
        if (object != null && !object.equals(wmiView3)) {
            wmiViewPath2 = new WmiViewPath((WmiView)object);
            wmiViewPath2.push(n);
        }
        if ((n2 = wmiViewPath2.peek(wmiViewPath2.depth() - 1)) != n) {
            wmiViewPath2 = new WmiViewPath(wmiViewPath2);
            wmiViewPath2.push(n);
        }
        return wmiViewPath2;
    }

    public void resync() throws WmiNoReadAccessException {
        if (this.docView != null) {
            WmiViewPath wmiViewPath;
            if (this.startModel != null && (wmiViewPath = this.modelToPath(this.startModel, this.startOffset, 0)) != null) {
                this.lowerBound = wmiViewPath;
            }
            if (this.endModel != null && (wmiViewPath = this.modelToPath(this.endModel, this.endOffset, 1)) != null) {
                this.upperBound = wmiViewPath;
            }
            this.highlighter = new WmiSelectionHighlighter(this.docView, this, this.highlighter);
            this.highlighter.repaintDirtyRegions();
        }
    }

    public void scrollVisible() {
        if (this.highlighter != null) {
            this.highlighter.scrollVisible();
        }
    }

    public WmiViewPath getAnchor() {
        return this.anchor;
    }

    public int contains(WmiViewPath wmiViewPath) {
        int n;
        int n2;
        int n3 = wmiViewPath.depth();
        int n4 = this.lowerBound.depth();
        int n5 = this.upperBound.depth();
        boolean bl = true;
        int n6 = Math.max(n3, n4);
        for (n2 = 0; n2 < n6; ++n2) {
            n = n2 < n3 ? wmiViewPath.peek(n2) : 0;
            if (n2 >= n4) {
                bl = true;
                break;
            }
            if (n2 >= n3) continue;
            if (n < this.lowerBound.peek(n2)) {
                bl = false;
                break;
            }
            if (n > this.lowerBound.peek(n2)) {
                bl = true;
                break;
            }
            if (n2 != n6 - 1) continue;
            bl = true;
        }
        n = 0;
        n6 = n3;
        for (n2 = 0; n2 < n6; ++n2) {
            int n7 = wmiViewPath.peek(n2);
            if (n2 >= n5) {
                n = 1;
                break;
            }
            if (n7 > this.upperBound.peek(n2)) {
                n = 0;
                break;
            }
            if (n7 < this.upperBound.peek(n2)) {
                n = 1;
                break;
            }
            if (n2 != n3 - 1) continue;
            if (n5 > n3) {
                n = 0;
                break;
            }
            n = 1;
            break;
        }
        if (!bl && n == 0) {
            return 0;
        }
        if (bl && n != 0) {
            return 2;
        }
        return 1;
    }

    public int contains(WmiView wmiView) {
        boolean bl;
        int n = 2;
        WmiViewPath wmiViewPath = new WmiViewPath(wmiView);
        WmiMathDocumentView wmiMathDocumentView = wmiView.getDocumentView();
        int n2 = this.startOffset == -1 ? this.lowerBound.depth() : this.lowerBound.depth() - 1;
        int n3 = this.endOffset == -1 ? this.upperBound.depth() : this.upperBound.depth() - 1;
        int n4 = ONBOUNDERY;
        int n5 = ONBOUNDERY;
        for (int i = 0; i < wmiViewPath.depth(); ++i) {
            if (n4 == ONBOUNDERY && i < n2) {
                if (wmiViewPath.peek(i) < this.lowerBound.peek(i)) {
                    n4 = OUTSIDEBOUNDRY;
                } else if (wmiViewPath.peek(i) > this.lowerBound.peek(i)) {
                    n4 = INSIDEBOUNDRY;
                }
            }
            if (n4 == ONBOUNDERY && i == n2) {
                n4 = wmiViewPath.peek(i) >= this.startOffset ? INSIDEBOUNDRY : OUTSIDEBOUNDRY;
            }
            if (n5 == ONBOUNDERY && i < n3) {
                if (wmiViewPath.peek(i) < this.upperBound.peek(i)) {
                    n5 = INSIDEBOUNDRY;
                } else if (wmiViewPath.peek(i) > this.upperBound.peek(i)) {
                    n5 = OUTSIDEBOUNDRY;
                }
            }
            if (n5 != ONBOUNDERY || i != n3) continue;
            n5 = wmiViewPath.peek(i) <= this.endOffset || this.endOffset == -1 ? INSIDEBOUNDRY : OUTSIDEBOUNDRY;
        }
        if (n4 == ONBOUNDERY) {
            WmiView wmiView2 = this.lowerBound.extractView(wmiMathDocumentView);
            bl = true;
            if (this.startOffset != 0) {
                bl = false;
            }
            int n6 = n2 - 1;
            while (wmiView2 != wmiView && bl) {
                bl = bl && this.lowerBound.peek(n6) == 0;
                wmiView2 = wmiView2.getParentView();
            }
            n4 = bl ? ONBOUNDERYFULLY : ONBOUNDERYPARTIALLY;
        }
        if (n5 == ONBOUNDERY) {
            WmiView wmiView3 = this.upperBound.extractView(wmiMathDocumentView);
            bl = true;
            if (this.endOffset != -1) {
                bl = false;
            }
            while (wmiView3 != null && wmiView3 != wmiView && bl) {
                WmiCompositeView wmiCompositeView = wmiView3.getParentView();
                if (wmiCompositeView != null) {
                    bl = bl && wmiCompositeView.indexOf(wmiView3) == wmiCompositeView.getChildCount() - 1;
                }
                wmiView3 = wmiCompositeView;
            }
            n5 = bl ? ONBOUNDERYFULLY : ONBOUNDERYPARTIALLY;
        }
        if (n4 == INSIDEBOUNDRY || n4 == ONBOUNDERYFULLY) {
            if (n5 == INSIDEBOUNDRY || n5 == ONBOUNDERYFULLY) {
                n = 2;
            } else if (n5 == ONBOUNDERYPARTIALLY) {
                n = 1;
            }
        }
        if (n5 == OUTSIDEBOUNDRY) {
            n = 0;
        }
        if (n4 == ONBOUNDERYPARTIALLY) {
            n = 1;
        }
        if (n4 == OUTSIDEBOUNDRY) {
            n = 0;
        }
        return n;
    }

    public boolean contains(WmiView wmiView, int n) {
        boolean bl;
        WmiViewPath wmiViewPath = new WmiViewPath(wmiView);
        boolean bl2 = bl = this.contains(wmiViewPath) != 0;
        if (bl) {
            WmiModelPosition wmiModelPosition = this.pathToModel(wmiViewPath);
            WmiModel wmiModel = wmiModelPosition.getModel();
            if (wmiView instanceof WmiTextView) {
                n += ((WmiTextView)wmiView).getStartOffset();
            }
            if (this.startModel == this.endModel) {
                if (n < this.startOffset || n > this.endOffset) {
                    bl = false;
                }
            } else if (wmiModel == this.startModel && n < this.startOffset) {
                bl = false;
            } else if (wmiModel == this.endModel && n > this.endOffset) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean hideCaret() {
        return true;
    }

    public WmiViewPath getSelectionStartPath() {
        return this.lowerBound;
    }

    public WmiViewPath getSelectionEndPath() {
        return this.upperBound;
    }

    public boolean isCompoundSelection() {
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.lowerBound.toString());
        stringBuffer.append(" ---> ");
        stringBuffer.append(this.upperBound.toString());
        if (this.anchor != null) {
            stringBuffer.append(" anchor = ");
            stringBuffer.append(this.anchor.toString());
        }
        return stringBuffer.toString();
    }

    public void deleteSelection() {
        this.deleteSelection(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelection(boolean bl) {
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)this.docView.getModel();
        try {
            WmiModelLock.writeLock(wmiMathDocumentModel, true);
            WmiModelPosition wmiModelPosition = new WmiModelPosition(this.startModel, this.startOffset);
            WmiModelPosition wmiModelPosition2 = new WmiModelPosition(this.endModel, this.endOffset);
            WmiPathDeletionHandler wmiPathDeletionHandler = new WmiPathDeletionHandler(wmiModelPosition, wmiModelPosition2, this.docView);
            this.docView.resetSelectionOnUpdate();
            wmiPathDeletionHandler.deleteSelection();
            if (bl) {
                wmiMathDocumentModel.update(undoDeleteSelectionText);
            }
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
            WmiErrorLog.log(wmiNoUpdateAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        finally {
            WmiModelLock.writeUnlock(wmiMathDocumentModel);
        }
    }

    private boolean handlePlaceholder(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCompositeModel wmiCompositeModel;
        int n;
        boolean bl = false;
        WmiAttributeSet wmiAttributeSet = this.startModel.getAttributesForRead();
        if (wmiAttributeSet != null && "true".equals(wmiAttributeSet.getAttribute("placeholder")) && (n = (wmiCompositeModel = this.startModel.getParent()).indexOf(this.startModel)) != 0) {
            WmiModel wmiModel = wmiCompositeModel.getChild(n - 1);
            if (wmiCompositeModel.getChildCount() > n + 1) {
                WmiModel wmiModel2 = wmiCompositeModel.getChild(n + 1);
                if (wmiModel instanceof WmiTextModel) {
                    int n2 = ((WmiTextModel)wmiModel).getLength();
                    if (wmiModel2 instanceof WmiTextModel) {
                        WmiAttributeSet wmiAttributeSet2 = wmiModel2.getAttributes();
                        WmiAttributeSet wmiAttributeSet3 = wmiModel.getAttributes();
                        if (wmiAttributeSet2 != null && wmiAttributeSet3 != null && WmiAttributeComparator.isEqual(wmiAttributeSet2, wmiAttributeSet3)) {
                            WmiModelPosition wmiModelPosition = new WmiModelPosition(wmiModel, n2 + string.length());
                            this.docView.setPendingPosition(wmiModelPosition);
                            String string2 = ((WmiTextModel)wmiModel2).getText();
                            try {
                                ((WmiTextModel)wmiModel).appendText(string + string2);
                                wmiCompositeModel.removeChild(n);
                                wmiCompositeModel.removeChild(n);
                                bl = true;
                            }
                            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSelection(String string) {
        WmiMathDocumentModel wmiMathDocumentModel = this.startModel.getDocument();
        WmiModel wmiModel = this.startModel;
        WmiModel wmiModel2 = this.endModel;
        int n = this.startOffset;
        int n2 = this.endOffset;
        if (WmiModelLock.writeLock(wmiMathDocumentModel, true)) {
            try {
                while (wmiModel instanceof WmiCompositeModel && ((WmiCompositeModel)wmiModel).getChildCount() > 0) {
                    wmiModel = ((WmiCompositeModel)wmiModel).getChild(0);
                    n = 0;
                }
                while (wmiModel2 instanceof WmiCompositeModel && ((WmiCompositeModel)wmiModel2).getChildCount() > 0) {
                    if ((wmiModel2 = ((WmiCompositeModel)wmiModel2).getChild(((WmiCompositeModel)wmiModel2).getChildCount() - 1)) instanceof WmiTextModel) {
                        n2 = ((WmiTextModel)wmiModel2).getLength();
                        continue;
                    }
                    if (wmiModel2 instanceof WmiCompositeModel) {
                        n2 = ((WmiCompositeModel)wmiModel2).getChildCount() - 1;
                        continue;
                    }
                    n2 = 0;
                }
                WmiModel[] wmiModelArray = new WmiTextModel[1];
                boolean bl = false;
                boolean bl2 = false;
                if (wmiModel != null && wmiModel2 != null && wmiModel instanceof WmiTextModel && !(bl2 = this.handlePlaceholder(string))) {
                    if (n < 0) {
                        n = 0;
                    }
                    this.docView.setPendingPosition(new WmiModelPosition(wmiModel, n + string.length()));
                    if (wmiModel == wmiModel2) {
                        ((WmiTextModel)wmiModel).replaceText(string, n, n2 - n);
                        bl2 = true;
                    } else if (wmiMathDocumentModel.isMutableModel(wmiModel)) {
                        ((WmiTextModel)wmiModel).insertText(string, n);
                        WmiViewPathInterval wmiViewPathInterval = new WmiViewPathInterval(this.docView);
                        wmiViewPathInterval.updateSelection(wmiModel, n + string.length(), wmiModel2, n2);
                        WmiModelPosition wmiModelPosition = this.pathToModel(wmiViewPathInterval.getSelectionStartPath());
                        WmiModel wmiModel3 = wmiModelPosition.getModel();
                        WmiModelPosition wmiModelPosition2 = this.pathToModel(wmiViewPathInterval.getSelectionEndPath());
                        WmiModel wmiModel4 = wmiModelPosition2.getModel();
                        WmiViewPath wmiViewPath = WmiViewPath.commonParent(wmiViewPathInterval.getSelectionStartPath(), wmiViewPathInterval.getSelectionEndPath());
                        WmiModel wmiModel5 = this.pathToModel(wmiViewPath).getModel();
                        WmiCompositeModel wmiCompositeModel = null;
                        if (wmiModel5 instanceof WmiCompositeModel) {
                            wmiCompositeModel = (WmiCompositeModel)wmiModel5;
                        } else {
                            WmiErrorLog.log(new WmiModelException("Model is not composite", wmiModel5));
                            Toolkit.getDefaultToolkit().beep();
                        }
                        if (wmiModel3 instanceof WmiTextModel) {
                            wmiViewPathInterval.deleteSelection(false);
                        } else {
                            bl = true;
                            wmiModelArray[0] = new WmiTextModel(wmiMathDocumentModel, string);
                            int n3 = wmiCompositeModel.indexOf(wmiModel4) - wmiCompositeModel.indexOf(wmiModel3) + 1;
                            if (wmiCompositeModel.indexOf(wmiModel3) >= 0 && n3 > 0) {
                                wmiCompositeModel.replaceChildren(wmiModelArray, wmiCompositeModel.indexOf(wmiModel3), n3);
                            }
                        }
                        if (!bl) {
                            this.docView.setPendingPosition(new WmiModelPosition(wmiModel, n + string.length()));
                        } else {
                            this.docView.setPendingPosition(new WmiModelPosition(wmiModelArray[0], string.length()));
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    wmiMathDocumentModel.update(undoReplaceSelectionText);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                WmiErrorLog.log(wmiNoUpdateAccessException);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.writeUnlock(this.startModel);
            }
        }
    }

    public void repaintDirtyRegions() {
        if (this.highlighter != null) {
            this.highlighter.repaintDirtyRegions();
        }
    }

    public WmiModelPosition pathToModel(WmiViewPath wmiViewPath) {
        WmiModelPosition wmiModelPosition = new WmiModelPosition(null, 0);
        try {
            wmiModelPosition = wmiViewPath.createModelPosition(this.docView);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            // empty catch block
        }
        return wmiModelPosition;
    }

    public WmiViewPath modelToPath(WmiModel wmiModel, int n, int n2) throws WmiNoReadAccessException {
        WmiView wmiView;
        if (wmiModel instanceof WmiTaskWrapperModel) {
            if (n2 == 0) {
                wmiModel = WmiModelUtil.findFirstDescendantLeaf((WmiCompositeModel)wmiModel);
            } else if (n2 == 1) {
                wmiModel = WmiModelUtil.findLastDescendantLeaf((WmiCompositeModel)wmiModel);
            }
        }
        WmiViewPath wmiViewPath = null;
        boolean bl = false;
        if (wmiModel instanceof WmiTextModel) {
            int n3 = ((WmiTextModel)wmiModel).getLength();
            if (n == -1) {
                n = n3;
            }
            while (n > n3) {
                int n4;
                bl = true;
                WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
                int n5 = n4 = wmiCompositeModel != null ? wmiCompositeModel.indexOf(wmiModel) : -1;
                if (n4 >= 0 && n4 < wmiCompositeModel.getChildCount() - 1) {
                    WmiModel wmiModel2 = wmiCompositeModel.getChild(n4 + 1);
                    if (wmiModel2 instanceof WmiTextModel) {
                        n -= n3;
                        wmiModel = wmiModel2;
                        n3 = ((WmiTextModel)wmiModel).getLength();
                        continue;
                    }
                    n = n3;
                    continue;
                }
                n = n3;
            }
        }
        if (bl) {
            if (n2 == 0) {
                this.startModel = wmiModel;
                this.startOffset = n;
            } else {
                this.endModel = wmiModel;
                this.endOffset = n;
            }
        }
        if ((wmiView = WmiViewUtil.modelToView(this.docView, wmiModel, n)) == null) {
            wmiView = this.findNearestVisibleView(wmiModel);
        }
        if (wmiView != null) {
            wmiViewPath = new WmiViewPath(wmiView);
        }
        if (wmiView == null) {
            WmiErrorLog.log(new Exception("couldn't find view"));
        }
        if (wmiView instanceof WmiTraversableView) {
            if (n < 0) {
                wmiViewPath.push(n);
            } else if (wmiView instanceof WmiTextView) {
                wmiViewPath.push(n -= ((WmiTextView)wmiView).getStartOffset());
            }
        } else if (n < 0) {
            wmiViewPath.push(n);
        }
        return wmiViewPath;
    }

    private WmiView findNearestVisibleView(WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel;
        WmiView wmiView = null;
        WmiCompositeModel wmiCompositeModel2 = wmiCompositeModel = wmiModel != null ? wmiModel.getParent() : null;
        while (wmiView == null && wmiCompositeModel != null) {
            wmiView = WmiViewUtil.modelToView(this.docView, wmiCompositeModel, 0);
            if (wmiView != null) continue;
            wmiModel = wmiCompositeModel;
            wmiCompositeModel = wmiModel.getParent();
        }
        return wmiView;
    }

    public boolean isReadOnly() throws WmiNoReadAccessException {
        boolean bl = false;
        if (this.startModel != null) {
            WmiMathDocumentModel wmiMathDocumentModel = this.startModel.getDocument();
            boolean bl2 = bl = !wmiMathDocumentModel.isMutableModel(this.startModel);
            if (bl) {
                bl = !wmiMathDocumentModel.isMutableModel(this.endModel);
            }
        }
        return bl;
    }

    public WmiMathDocumentView getSourceDocument() {
        return this.docView;
    }

    public WmiHighlightPainter getSelectionHighlighter() {
        return this.highlighter;
    }

    public boolean isValid() {
        return this.lowerBound != null && this.upperBound != null && !this.lowerBound.equals(this.upperBound);
    }

    static {
        try {
            WmiResourcePackage wmiResourcePackage = WmiResourcePackage.getResourcePackage("com.maplesoft.mathdoc.view.resources.View");
            undoDeleteSelectionText = wmiResourcePackage.getStringForKey("DeleteSelection.undo");
            undoReplaceSelectionText = wmiResourcePackage.getStringForKey("ReplaceSelection.undo");
        }
        catch (MissingResourceException missingResourceException) {
            WmiErrorLog.log(missingResourceException);
        }
        ONBOUNDERY = 0;
        OUTSIDEBOUNDRY = 1;
        INSIDEBOUNDRY = 2;
        ONBOUNDERYPARTIALLY = 3;
        ONBOUNDERYFULLY = 4;
    }

    protected static class WmiPathDeletionHandler {
        protected WmiModel startModel;
        protected WmiModel endModel;
        protected WmiModel parentModel;
        protected WmiModel deleteLimit;
        protected int startOffset;
        protected int endOffset;
        private Stack startStack;
        private Stack endStack;
        private WmiDeleteManager manager;
        private WmiMathDocumentView docView;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected WmiPathDeletionHandler(WmiModelPosition wmiModelPosition, WmiModelPosition wmiModelPosition2, WmiMathDocumentView wmiMathDocumentView) {
            this.docView = wmiMathDocumentView;
            this.manager = new WmiDeleteManager();
            this.startModel = wmiModelPosition.getModel();
            this.startOffset = wmiModelPosition.getOffset();
            this.endModel = wmiModelPosition2.getModel();
            this.endOffset = wmiModelPosition2.getOffset();
            WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
            boolean bl = this.startModel == wmiMathDocumentModel && this.endModel == wmiMathDocumentModel && this.startOffset == -1 && this.endOffset == -1;
            this.startStack = this.createStack(this.startModel, this.startOffset, 0);
            this.endStack = this.createStack(this.endModel, this.endOffset, 1);
            boolean bl2 = WmiModelLock.readLock(this.startModel, true);
            try {
                int n = this.startStack.size();
                int n2 = this.endStack.size();
                while (n != n2 && n * n2 != 0) {
                    WmiCompositeModel wmiCompositeModel;
                    if (n > n2) {
                        wmiCompositeModel = this.startModel.getParent();
                        if (wmiCompositeModel.indexOf(this.startModel) != 0) break;
                        this.startModel = wmiCompositeModel;
                        this.startStack.remove(0);
                        --n;
                        continue;
                    }
                    wmiCompositeModel = this.endModel.getParent();
                    if (wmiCompositeModel.indexOf(this.endModel) != wmiCompositeModel.getChildCount() - 1) break;
                    this.endModel = wmiCompositeModel;
                    this.endStack.remove(0);
                    --n2;
                }
                if (bl) {
                    this.parentModel = wmiMathDocumentModel;
                    this.startStack.pop();
                    this.endStack.pop();
                } else {
                    this.parentModel = this.trimStacks(this.startStack, this.endStack);
                }
                this.deleteLimit = null;
                if (this.startModel != null) {
                    WmiModel wmiModel = this.deleteLimit = this.startModel != this.endModel ? this.parentModel : this.startModel.getParent();
                    if (this.deleteLimit != null) {
                        this.deleteLimit = wmiMathDocumentView.getDeleteBoundary((WmiCompositeModel)this.deleteLimit);
                    }
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                if (bl2) {
                    WmiModelLock.readUnlock(this.startModel);
                }
            }
        }

        private boolean canDeleteParent(WmiCompositeModel wmiCompositeModel, int n) throws WmiNoReadAccessException {
            boolean bl = false;
            if (!this.forceDeleteHandling(wmiCompositeModel)) {
                if (n == 0 && wmiCompositeModel.getChildCount() == 1) {
                    bl = true;
                } else if (WmiModelUtil.getRemainingChildCount(wmiCompositeModel) == 1 && n == WmiModelUtil.getFirstNonDeletePlaceHolderPosition(wmiCompositeModel)) {
                    bl = true;
                } else {
                    boolean bl2 = false;
                    int n2 = wmiCompositeModel.getChildCount();
                    for (int i = 0; i < n2; ++i) {
                        WmiModel wmiModel;
                        if (i == n || !(wmiModel = wmiCompositeModel.getChild(i)).isVisible()) continue;
                        bl2 = true;
                        break;
                    }
                    bl = !bl2;
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Stack createStack(WmiModel wmiModel, int n, int n2) {
            Stack<WmiModel> stack = new Stack<WmiModel>();
            WmiModel wmiModel2 = this.docView.getModel();
            try {
                int n3;
                WmiModelLock.readLock(wmiModel2, true);
                WmiModelPath wmiModelPath = new WmiModelPath(wmiModel);
                boolean bl = false;
                int n4 = wmiModelPath.depth();
                WmiModel[] wmiModelArray = new WmiModel[n4 + 1];
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel2;
                wmiModelArray[0] = wmiModel2;
                for (n3 = 0; n3 < n4; ++n3) {
                    WmiModel wmiModel3;
                    wmiModelArray[n3 + 1] = wmiModel3 = wmiCompositeModel.getChild(wmiModelPath.peek(n3));
                    if (!(wmiModel3 instanceof WmiCompositeModel)) {
                        if (!bl || !(wmiModel3 instanceof WmiTextModel)) break;
                        if (n2 == 0) {
                            this.startOffset = 0;
                            break;
                        }
                        this.endOffset = ((WmiTextModel)wmiModel3).getLength();
                        break;
                    }
                    wmiCompositeModel = (WmiCompositeModel)wmiModel3;
                }
                for (n3 = n4; n3 >= 0; --n3) {
                    if (wmiModelArray[n3] == null) continue;
                    stack.push(wmiModelArray[n3]);
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.readUnlock(wmiModel2);
            }
            return stack;
        }

        private WmiModel trimStacks(Stack stack, Stack stack2) {
            WmiModel wmiModel = null;
            while (!stack.isEmpty() && !stack2.isEmpty() && stack.peek() == stack2.peek()) {
                wmiModel = (WmiModel)stack.peek();
                stack.pop();
                stack2.pop();
            }
            return wmiModel;
        }

        private void deleteSelection() throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
            this.refreshSemantics(this.parentModel);
            if (this.startModel == this.endModel && !this.startModel.isSubselectable()) {
                this.deleteModel(this.startModel);
            } else if (this.parentModel instanceof WmiCompositeModel) {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)this.parentModel;
                if (this.startModel == this.endModel && this.startModel == this.parentModel) {
                    this.deleteModel(this.parentModel);
                } else {
                    int n;
                    int n2;
                    if (!this.startStack.isEmpty() && !this.endStack.isEmpty() && (n2 = wmiCompositeModel.indexOf((WmiModel)this.startStack.peek())) != (n = wmiCompositeModel.indexOf((WmiModel)this.endStack.peek()))) {
                        boolean bl = this.pruneHead(this.endStack);
                        if (bl) {
                            ++n;
                        }
                        this.pruneIntermediates(wmiCompositeModel, n2, n);
                    }
                    this.pruneTail(this.startStack);
                    this.postDeleteMerge();
                }
            } else if (this.parentModel instanceof WmiTextModel) {
                WmiTextModel wmiTextModel = (WmiTextModel)this.parentModel;
                this.deleteText(wmiTextModel, this.startOffset, this.endOffset);
            } else if (this.parentModel != null) {
                this.deleteModel(this.parentModel);
            }
            this.manager.update();
            this.overrideCursorPosition();
        }

        private boolean pruneHead(Stack stack) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            boolean bl = false;
            WmiModel wmiModel = (WmiModel)stack.pop();
            if (wmiModel instanceof WmiCompositeModel && !stack.isEmpty()) {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
                WmiModel wmiModel2 = (WmiModel)stack.peek();
                if (wmiModel2 != null) {
                    int n = wmiCompositeModel.indexOf(wmiModel2);
                    int n2 = wmiCompositeModel.getChildCount();
                    boolean bl2 = this.pruneHead(stack);
                    if (bl2) {
                        ++n;
                    }
                    if (n > 0) {
                        this.deleteChildren(wmiCompositeModel, 0, n);
                    }
                    bl = n2 <= n;
                }
            } else if (wmiModel instanceof WmiTextModel) {
                int n;
                WmiTextModel wmiTextModel = (WmiTextModel)wmiModel;
                if (!wmiTextModel.isCrossBoundarySubselectable()) {
                    this.endOffset = wmiTextModel.getLength();
                }
                if (this.endOffset == (n = wmiTextModel.getLength())) {
                    bl = true;
                } else if (this.endOffset > 0 || n == 0) {
                    this.deleteText(wmiTextModel, 0, this.endOffset);
                    bl = false;
                } else {
                    bl = false;
                }
            } else {
                bl = true;
            }
            return bl;
        }

        private void pruneIntermediates(WmiCompositeModel wmiCompositeModel, int n, int n2) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
            if (n2 > wmiCompositeModel.getChildCount()) {
                n2 = wmiCompositeModel.getChildCount();
            }
            if (n2 - n > 1) {
                this.deleteChildren(wmiCompositeModel, n + 1, n2 - n - 1);
            }
        }

        private void deleteChildren(WmiCompositeModel wmiCompositeModel, int n, int n2) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            if (wmiCompositeModel.getDeleteHandler() == null) {
                for (int i = n; i < n2; ++i) {
                    WmiModel wmiModel = wmiCompositeModel.getChild(i);
                    if (!(wmiModel instanceof WmiCompositeModel)) continue;
                    this.manager.unMark((WmiCompositeModel)wmiModel);
                }
                wmiCompositeModel.removeChildren(n, n2);
            } else {
                for (int i = 0; i < n2; ++i) {
                    this.deleteChild(wmiCompositeModel, n + i);
                }
            }
        }

        private void deleteChild(WmiCompositeModel wmiCompositeModel, int n) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            if (wmiCompositeModel.getDeleteHandler() == null) {
                wmiCompositeModel.removeChild(n);
            } else {
                WmiModel wmiModel = wmiCompositeModel.getChild(n);
                WmiDeletePlaceholderModel wmiDeletePlaceholderModel = new WmiDeletePlaceholderModel(wmiModel);
                wmiCompositeModel.replaceChild(wmiDeletePlaceholderModel, n);
                this.manager.mark(wmiCompositeModel);
            }
        }

        private void appendChildForDelete(WmiCompositeModel wmiCompositeModel, WmiModel wmiModel) throws WmiNoWriteAccessException {
            if (wmiCompositeModel.getDeleteHandler() != null) {
                WmiDeletePlaceholderModel wmiDeletePlaceholderModel = new WmiDeletePlaceholderModel(wmiModel);
                wmiCompositeModel.appendChild(wmiDeletePlaceholderModel);
                this.manager.mark(wmiCompositeModel);
            }
        }

        private void pruneTail(Stack stack) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            while (!stack.isEmpty()) {
                WmiModel wmiModel = (WmiModel)stack.pop();
                if (wmiModel instanceof WmiCompositeModel && !stack.isEmpty()) {
                    WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
                    WmiModel wmiModel2 = (WmiModel)stack.peek();
                    if (wmiModel2 == null) continue;
                    int n = 0;
                    int n2 = 0;
                    WmiView wmiView = WmiViewUtil.modelToView(this.docView, wmiCompositeModel, 0);
                    if (wmiView instanceof WmiMapleTACompositeView) {
                        WmiGenericView wmiGenericView = ((WmiMapleTACompositeView)wmiView).getCurrentView();
                        wmiModel2 = wmiGenericView.getModel();
                        n2 = 0;
                    } else {
                        n = wmiCompositeModel.indexOf(wmiModel2);
                        n2 = wmiCompositeModel.getChildCount() - (n + 1);
                    }
                    if (n2 <= 0) continue;
                    this.deleteChildren(wmiCompositeModel, n + 1, n2);
                    continue;
                }
                if (wmiModel instanceof WmiTextModel) {
                    int n = ((WmiTextModel)wmiModel).getLength();
                    if (n <= this.startOffset && this.startOffset != 0) break;
                    this.deleteText((WmiTextModel)wmiModel, this.startOffset, n);
                    break;
                }
                this.deleteModel(wmiModel);
            }
        }

        private void deleteText(WmiTextModel wmiTextModel, int n, int n2) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
            if (n <= 0 && n2 >= wmiTextModel.getLength()) {
                this.deleteModel(wmiTextModel);
            } else {
                wmiTextModel.deleteText(n, n2 - n);
            }
        }

        private boolean isDeleteableParagraph(WmiParagraphModel wmiParagraphModel, WmiModel wmiModel) throws WmiNoReadAccessException {
            boolean bl = false;
            if (wmiParagraphModel.isEmpty(wmiModel)) {
                bl = true;
            } else {
                boolean bl2 = bl = wmiParagraphModel != this.parentModel && !WmiModelUtil.isModelAncestorOfModel(wmiParagraphModel, this.parentModel);
            }
            if (bl) {
                WmiCompositeModel wmiCompositeModel;
                for (wmiCompositeModel = wmiParagraphModel.getParent(); wmiCompositeModel != null && !wmiCompositeModel.isDeletionBoundary(); wmiCompositeModel = wmiCompositeModel.getParent()) {
                }
                if (wmiCompositeModel != null && wmiCompositeModel.isDeletionBoundary()) {
                    bl = WmiModelUtil.findNextModel((WmiModel)wmiCompositeModel, (WmiModel)wmiParagraphModel, class$com$maplesoft$mathdoc$model$WmiParagraphModel == null ? (class$com$maplesoft$mathdoc$model$WmiParagraphModel = WmiViewPathInterval.class$("com.maplesoft.mathdoc.model.WmiParagraphModel")) : class$com$maplesoft$mathdoc$model$WmiParagraphModel) != null || WmiModelUtil.findPreviousModel((WmiModel)wmiCompositeModel, (WmiModel)wmiParagraphModel, class$com$maplesoft$mathdoc$model$WmiParagraphModel == null ? (class$com$maplesoft$mathdoc$model$WmiParagraphModel = WmiViewPathInterval.class$("com.maplesoft.mathdoc.model.WmiParagraphModel")) : class$com$maplesoft$mathdoc$model$WmiParagraphModel) != null;
                }
            }
            return bl;
        }

        private void deleteModel(WmiModel wmiModel) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
            if (wmiModel == this.endModel) {
                this.endModel = null;
            }
            if (wmiModel == this.startModel) {
                this.startModel = null;
            }
            if (wmiModel instanceof WmiMathDocumentModel) {
                WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiModel;
                int n = wmiMathDocumentModel.getChildCount();
                wmiMathDocumentModel.removeChildren(0, n);
                this.manager.clear();
                this.docView.setPendingPosition(new WmiModelPosition(wmiMathDocumentModel, 0));
            } else {
                WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
                if (wmiCompositeModel != null) {
                    int n = wmiCompositeModel.indexOf(wmiModel);
                    if (n < 0) {
                        if (wmiCompositeModel instanceof WmiMathFencedModel) {
                            this.appendChildForDelete(wmiCompositeModel, wmiModel);
                            return;
                        }
                        if (wmiCompositeModel instanceof WmiRootModel || wmiCompositeModel instanceof WmiFractionModel) {
                            Toolkit.getDefaultToolkit().beep();
                            return;
                        }
                        throw new WmiModelIndexOutOfBoundsException(wmiModel, n);
                    }
                    if (this.canDeleteParent(wmiCompositeModel, n)) {
                        if (wmiCompositeModel instanceof WmiMathDocumentModel) {
                            this.manager.clear();
                            wmiCompositeModel.removeChild(0);
                            this.docView.setPendingPosition(new WmiModelPosition(wmiCompositeModel, 0));
                        } else if (wmiCompositeModel == this.deleteLimit) {
                            this.manager.clear();
                            this.deleteChild(wmiCompositeModel, 0);
                            this.docView.setPendingPosition(new WmiModelPosition(wmiCompositeModel, 0));
                        } else if (wmiCompositeModel instanceof WmiParagraphModel && !this.isDeleteableParagraph((WmiParagraphModel)wmiCompositeModel, wmiModel)) {
                            this.manager.clear();
                            this.deleteChild(wmiCompositeModel, 0);
                            this.docView.setPendingPosition(new WmiModelPosition(wmiCompositeModel, 0));
                        } else {
                            this.manager.unMark(wmiCompositeModel);
                            this.deleteModel(wmiCompositeModel);
                        }
                    } else {
                        this.deleteChild(wmiCompositeModel, n);
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        private void postDeleteMerge() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            boolean bl = this.endModel != null && this.startModel != null;
            WmiMathDocumentModel wmiMathDocumentModel = this.startModel != null ? this.startModel.getDocument() : null;
            WmiMathDocumentHierarchyValidator wmiMathDocumentHierarchyValidator = wmiMathDocumentModel != null ? wmiMathDocumentModel.getModelHierarchyValidator() : null;
            bl &= wmiMathDocumentHierarchyValidator != null & this.startModel != null && wmiMathDocumentHierarchyValidator.hasPostDeletePermission(this.startModel.getTag());
            while (bl && this.startModel.getParent() != this.endModel.getParent()) {
                this.startModel = this.startModel.getParent();
                this.endModel = this.endModel.getParent();
                if (this.startModel == null || this.endModel == null) {
                    bl = false;
                }
                if (!wmiMathDocumentHierarchyValidator.hasPostDeletePermission(this.startModel.getTag())) {
                    bl = false;
                }
                if (wmiMathDocumentHierarchyValidator.hasPostDeletePermission(this.endModel.getTag())) continue;
                bl = false;
            }
            if (bl) {
                this.postDeleteMerge(this.startModel, this.endModel);
            }
        }

        private void postDeleteMerge(WmiModel wmiModel, WmiModel wmiModel2) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            if (wmiModel.getTag() == wmiModel2.getTag()) {
                if (wmiModel instanceof WmiCompositeModel) {
                    WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
                    WmiCompositeModel wmiCompositeModel2 = (WmiCompositeModel)wmiModel2;
                    if (wmiCompositeModel != wmiCompositeModel2) {
                        int n = wmiCompositeModel.getChildCount();
                        int n2 = wmiCompositeModel2.getChildCount();
                        for (int i = 0; i < n2; ++i) {
                            wmiCompositeModel.appendChild(wmiCompositeModel2.getChild(i));
                        }
                        WmiCompositeModel wmiCompositeModel3 = wmiModel2.getParent();
                        int n3 = wmiCompositeModel3.indexOf(wmiModel2);
                        if (n3 >= 0) {
                            wmiCompositeModel3.removeChild(n3);
                        }
                        if (n > 0 && n < wmiCompositeModel.getChildCount()) {
                            this.postDeleteMerge(wmiCompositeModel.getChild(n - 1), wmiCompositeModel.getChild(n));
                        }
                    }
                } else if (wmiModel instanceof WmiTextModel) {
                    WmiCompositeModel wmiCompositeModel;
                    int n;
                    WmiFontAttributeSet wmiFontAttributeSet;
                    WmiTextModel wmiTextModel = (WmiTextModel)wmiModel;
                    WmiTextModel wmiTextModel2 = (WmiTextModel)wmiModel2;
                    WmiFontAttributeSet wmiFontAttributeSet2 = (WmiFontAttributeSet)wmiTextModel.getAttributes();
                    if (wmiFontAttributeSet2.equals(wmiFontAttributeSet = (WmiFontAttributeSet)wmiTextModel2.getAttributes()) && (n = (wmiCompositeModel = wmiModel2.getParent()).indexOf(wmiModel2)) >= 0) {
                        int n4 = wmiTextModel.getLength();
                        this.manager.setModelToReposition(new WmiModelPosition(wmiTextModel, n4));
                        wmiTextModel.appendText(wmiTextModel2.getText());
                        wmiCompositeModel.removeChild(n);
                    }
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WmiDeletionHandler[");
            stringBuffer.append(this.startModel);
            stringBuffer.append("@");
            stringBuffer.append(System.identityHashCode(this.startModel));
            stringBuffer.append(":");
            stringBuffer.append(this.startOffset);
            stringBuffer.append("-->");
            stringBuffer.append(this.endModel);
            stringBuffer.append("@");
            stringBuffer.append(System.identityHashCode(this.endModel));
            stringBuffer.append(":");
            stringBuffer.append(this.endOffset);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        private void overrideCursorPosition() {
            WmiModelPosition wmiModelPosition = this.manager.getModelToReposition();
            if (wmiModelPosition != null && wmiModelPosition.getModel() != null) {
                WmiDefaultPositionUpdateHandler wmiDefaultPositionUpdateHandler = new WmiDefaultPositionUpdateHandler(this.docView, wmiModelPosition);
                this.docView.setPendingPositionUpdateHandler(wmiDefaultPositionUpdateHandler);
            }
        }

        private void refreshSemantics(WmiModel wmiModel) throws WmiNoReadAccessException {
            WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
            while (wmiCompositeModel instanceof WmiMathModel) {
                ((WmiMathModel)((Object)wmiCompositeModel)).setSemantics(null);
                wmiCompositeModel = wmiCompositeModel.getParent();
            }
        }

        public boolean forceDeleteHandling(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
            boolean bl = false;
            if (this.startModel != null && WmiModelUtil.isModelAncestorOfModel(this.startModel, wmiCompositeModel)) {
                bl = false;
            } else if (this.endModel != null && WmiModelUtil.isModelAncestorOfModel(this.endModel, wmiCompositeModel)) {
                bl = false;
            } else {
                WmiDeleteHandler wmiDeleteHandler = wmiCompositeModel.getDeleteHandler();
                if (wmiDeleteHandler != null) {
                    bl = wmiDeleteHandler.forceDeleteHandling();
                }
            }
            return bl;
        }
    }
}

