/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelObserver;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiAccessibleContext;
import com.maplesoft.mathdoc.view.WmiAdjustableTextBounds;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextFragmentView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.util.StringTools;
import com.maplesoft.util.WmiUnicodeMapper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.MissingResourceException;
import javax.accessibility.AccessibleContext;

public class WmiTextView
extends WmiGenericView
implements WmiTraversableView,
WmiAdjustableTextBounds {
    private static final int LOW_ASCII_LIMIT = 128;
    private static final float ITALIC_ADJUST = 0.194f;
    public static final int UNDERLINE_OFFSET = 1;
    private static final float[] COMPOSED_DASH;
    public static final BasicStroke COMPOSED_STROKE;
    public static final BasicStroke CONVERTED_STROKE;
    public static final float SUPERSCRIPT_SCALE_FACTOR = 0.8f;
    public static final float SUPERSCRIPT_RAISE_FACTOR = 0.5f;
    public static final float SUBSCRIPT_LOWER_FACTOR = 0.35f;
    private static final char[] JAPANESE_NO_STARTS;
    private static final char[] JAPANESE_NO_ENDS;
    private static WmiUnicodeMapper noStarts;
    private static WmiUnicodeMapper noEnds;
    private static String undoInsertText;
    private static String undoDeleteText;
    protected WmiTextLayout layout = null;
    protected WmiFontAttributeSet attributes = null;
    protected int baselineAdjust = 0;
    private static int[] caretBounds;

    public WmiTextView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public static String getUndoInsertTextName() {
        return undoInsertText;
    }

    public String debugPrint(int n) throws WmiNoReadAccessException {
        return System.getProperty("line.separator") + this.createIndent(n) + "<Text x = " + this.x + " y = " + this.y + " width = " + this.width + " height = " + this.height + ">" + this.getText() + "</Text>";
    }

    public boolean isRepeatable() {
        return false;
    }

    public int getTraversalType() {
        return 1;
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            boolean bl;
            String string = this.getText();
            int n = 0;
            WmiModel wmiModel = this.getModel();
            WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
            boolean bl2 = bl = wmiMathDocumentView != null ? wmiMathDocumentView.isPrintView() : false;
            if (wmiModel == null) {
                WmiErrorLog.log(new Exception("null model: might be pointing to a dead view"));
            }
            this.attributes = (WmiFontAttributeSet)wmiModel.getAttributesForRead();
            int n2 = this.getCorrectedZoomFactor();
            Font font = WmiFontResolver.getFont(this.attributes, n2, bl);
            boolean bl3 = this.attributes.isSuperscript();
            boolean bl4 = this.attributes.isSubscript();
            if (wmiModel instanceof WmiAbstractMathTokenModel) {
                n = ((WmiAbstractMathTokenModel)wmiModel).getGlyphCount();
            }
            if (n > 0) {
                WmiAbstractMathTokenModel wmiAbstractMathTokenModel = (WmiAbstractMathTokenModel)wmiModel;
                boolean bl5 = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH) != null;
                this.layout = WmiTextLayout.createTextLayout(wmiAbstractMathTokenModel, font, this.getDocumentView(), bl5);
                this.width = this.layout.getWidth();
                this.baseline = this.layout.getBaseline();
                this.height = this.layout.getHeight();
            } else if (string != null && string.length() > 0) {
                boolean bl6 = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH) != null;
                this.layout = WmiTextLayout.createTextLayout(string, font, this.getDocumentView(), bl6);
                this.width = this.layout.getWidth();
                this.baseline = this.layout.getBaseline();
                this.height = this.layout.getHeight();
            } else {
                this.layout = null;
                this.width = this.getEmptyTextWidth();
                WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
                this.baseline = wmiFontMetrics.getFontProperty(0, bl) + wmiFontMetrics.getFontProperty(3, bl);
                this.height = this.baseline + wmiFontMetrics.getFontProperty(4, bl);
            }
            this.baselineAdjust = 0;
            if (bl3) {
                this.baselineAdjust -= Math.round((float)this.height * 0.5f);
                this.height -= this.baselineAdjust;
                this.baseline -= this.baselineAdjust;
            } else if (bl4) {
                this.baselineAdjust += Math.round((float)this.height * 0.35f);
                this.height += this.baselineAdjust;
            }
            super.layoutView();
        }
    }

    public int getCorrectedZoomFactor() throws WmiNoReadAccessException {
        int n = this.getZoomFactor();
        WmiModel wmiModel = this.getModel();
        this.attributes = (WmiFontAttributeSet)wmiModel.getAttributesForRead();
        boolean bl = this.attributes.isSuperscript();
        boolean bl2 = this.attributes.isSubscript();
        if (bl || bl2) {
            n = Math.round((float)n * 0.8f);
        }
        return n;
    }

    public WmiTextLayout getLayout() {
        return this.layout;
    }

    public Color getForegroundColor() {
        return this.attributes != null ? new Color(this.attributes.getForeground()) : null;
    }

    public void applyKerningAdjustment(boolean bl, boolean bl2) {
        if (this.layout != null && this.enableKernAdjust()) {
            this.layout.applyKerningAdjustment(bl, bl2);
            this.width = this.layout.getWidth() + this.getLeftPadding() + this.getRightPadding();
        }
    }

    public int computePreKernAdjustment() {
        return this.layout != null ? (int)this.layout.computePreKernAdjustment() : 0;
    }

    public int computePostKernAdjustment() {
        return this.layout != null ? (int)this.layout.computePostKernAdjustment() : 0;
    }

    public int computeSpaceAbove() {
        return this.layout != null ? this.layout.computeSpaceAbove() : this.getHeight();
    }

    public int computeSpaceBelow() {
        return this.layout != null ? this.layout.computeSpaceBelow() : this.getHeight();
    }

    protected void setLayout(WmiTextLayout wmiTextLayout, WmiFontAttributeSet wmiFontAttributeSet, int n) {
        this.layout = wmiTextLayout;
        this.width = wmiTextLayout.getWidth();
        this.baseline = wmiTextLayout.getBaseline();
        this.height = wmiTextLayout.getHeight();
        this.attributes = wmiFontAttributeSet;
        this.baselineAdjust = n;
    }

    public boolean extractNextBreakpoint(WmiParagraphView.WmiBreakInfo wmiBreakInfo, boolean bl) throws WmiNoReadAccessException {
        int n = wmiBreakInfo.nextStart;
        wmiBreakInfo.nextStart = -1;
        String string = wmiBreakInfo.activeText;
        if (wmiBreakInfo.view != this || n < 0) {
            wmiBreakInfo.view = this;
            string = null;
            n = 0;
        }
        if (string == null) {
            try {
                string = this.getText();
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            wmiBreakInfo.activeText = string;
        }
        int n2 = wmiBreakInfo.width;
        int n3 = 0;
        boolean bl2 = false;
        if (string != null && string.length() > 0 && this.layout != null) {
            Point point;
            char c;
            int n4;
            int n5 = string.length();
            int n6 = 0;
            char c2 = '\u0000';
            boolean bl3 = StringTools.isJapaneseText(string);
            n3 = this.layout.getCaretPosition(n, true);
            for (n4 = n; n4 < n5; ++n4) {
                boolean bl4 = false;
                c = '\u0000';
                try {
                    c = string.charAt(n4);
                }
                catch (Exception exception) {
                    WmiErrorLog.log(exception);
                }
                if (Character.isWhitespace(c) || c2 == '.' && !Character.isDigit(c) || c2 == '-' && !Character.isDigit(c) && c != '.' && c != '>' || c2 == '+' && !Character.isDigit(c) && c != '.' || c2 == '*' || c2 == '!' || c2 == '?' || c2 == ')' || c2 == ']' || c2 == '=' || c2 == ',' || c2 == ';' || c2 == '}' || c == '(' || c == '[' || c == '{' || c == '-' && Character.isDigit(c2) || Character.isWhitespace(c2)) {
                    bl4 = true;
                } else if (bl3) {
                    bl4 = this.isValidJapaneseBreakpoint(c, c2);
                }
                if (bl4) {
                    int n7;
                    n6 = n2 - n3 + this.layout.getCaretPosition(n4, true);
                    if (n6 > wmiBreakInfo.breakWidth) {
                        if (!bl2) break;
                        wmiBreakInfo.forcedBreak = true;
                        break;
                    }
                    if (c == '\n' || c == '\r') {
                        char c3;
                        int n8 = n6;
                        n7 = n4 + 1;
                        char c4 = c3 = c == '\n' ? (char)'\r' : '\n';
                        if (n4 < n5 - 1 && (c = string.charAt(n4 + 1)) == c3) {
                            ++n7;
                        }
                        bl2 = true;
                        wmiBreakInfo.update(this, n4, n7, n8, n8, true, false);
                        break;
                    }
                    if (!wmiBreakInfo.explicitBreaksOnly) {
                        int n9 = n4;
                        if (Character.isWhitespace(c)) {
                            ++n9;
                        }
                        n7 = n2 - n3 + this.layout.getCaretPosition(n9, true);
                        wmiBreakInfo.update(this, n4, n9, n6, n7, false, false);
                        bl2 = true;
                    }
                }
                c2 = c;
            }
            if (!wmiBreakInfo.explicitBreaksOnly && !bl2 && bl && (c = this.getOffset(point = new Point(n4 = wmiBreakInfo.breakWidth - (n2 - n3), 0))) > n) {
                n6 = n2 - n3 + this.layout.getCaretPosition(c, true);
                char c5 = c != this.getLength() ? c : (char)'\uffffffff';
                wmiBreakInfo.update(this, c, c5, n6, n6, true, true);
                bl2 = true;
            }
        }
        return bl2 || this.getWidth() - n3 == 0;
    }

    private boolean isValidJapaneseBreakpoint(char c, char c2) {
        boolean bl = false;
        if (c < '\u0080') {
            if (c2 >= '\u0080' && noEnds.get(c2) == null) {
                bl = true;
            }
        } else if (noStarts.get(c) == null && noEnds.get(c2) == null) {
            bl = true;
        }
        return bl;
    }

    public WmiView createViewFragment(int n, int n2) throws WmiNoReadAccessException {
        return new WmiTextFragmentView(this.getModel(), this.getDocumentView(), n, n2);
    }

    public WmiView createViewFragment(int n) throws WmiNoReadAccessException {
        return this.createViewFragment(n, this.getTraversableCount());
    }

    public String getText() throws WmiNoReadAccessException {
        String string = null;
        if (this.getModel() instanceof WmiTextModel) {
            WmiTextModel wmiTextModel = (WmiTextModel)this.getModel();
            string = wmiTextModel.getText();
        }
        return string;
    }

    public int getLength() throws WmiNoReadAccessException {
        WmiTextModel wmiTextModel = (WmiTextModel)this.getModel();
        return wmiTextModel.getLength();
    }

    public int getOffset(Point point) {
        int n = 0;
        if (this.layout != null) {
            n = this.layout.getIndex(point);
        }
        return n;
    }

    public int getHorizontalOffset(int n) {
        int n2 = 0;
        if (this.layout != null) {
            n2 = this.layout.getCaretPosition(n, true);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPositionMarker(int n) {
        WmiModel wmiModel = this.getModel();
        if (!WmiModelLock.readLock(wmiModel, true)) return;
        try {
            WmiMathDocumentView wmiMathDocumentView;
            if (n == -1) {
                n = this.getTraversableCount();
            }
            if ((wmiMathDocumentView = this.getDocumentView()) != null) {
                WmiCaret wmiCaret = wmiMathDocumentView.getCaret();
                boolean bl = false;
                if (wmiCaret == null || wmiCaret instanceof WmiMathCaret) {
                    wmiCaret = new WmiCaret(wmiMathDocumentView);
                    bl = true;
                }
                Object object = wmiMathDocumentView.getTreeLock();
                synchronized (object) {
                    int[] nArray = caretBounds;
                    synchronized (caretBounds) {
                        WmiScrollableContainerView wmiScrollableContainerView = WmiViewUtil.findEnclosingContainer(this);
                        this.getCaretBounds(wmiScrollableContainerView, n, caretBounds);
                        wmiCaret.updateCaretBounds(wmiScrollableContainerView, caretBounds[0], caretBounds[1], caretBounds[2], caretBounds[3]);
                        // ** MonitorExit[var7_8] (shouldn't be in output)
                    }
                }
                {
                    wmiCaret.updateView(this, n);
                    if (bl) {
                        wmiMathDocumentView.setPositionMarker(wmiCaret);
                    }
                    wmiCaret.show();
                    return;
                }
            }
            WmiErrorLog.log(new Exception("unable to find document view"));
            return;
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
            return;
        }
        finally {
            WmiModelLock.readUnlock(wmiModel);
        }
    }

    protected int[] getCaretBounds(WmiScrollableContainerView wmiScrollableContainerView, int n) throws WmiNoReadAccessException {
        return this.getCaretBounds(wmiScrollableContainerView, n, null);
    }

    private int[] getCaretBounds(WmiScrollableContainerView wmiScrollableContainerView, int n, int[] nArray) throws WmiNoReadAccessException {
        int[] nArray2 = nArray != null ? nArray : new int[4];
        int n2 = this.getLength();
        WmiTextModel wmiTextModel = (WmiTextModel)this.getModel();
        WmiFontAttributeSet wmiFontAttributeSet = (WmiFontAttributeSet)wmiTextModel.getAttributesForRead();
        Font font = WmiFontResolver.getFont(wmiFontAttributeSet, this.getZoomFactor(), this.getDocumentView().isPrintView());
        int n3 = 0;
        if (n2 > 0) {
            int n4 = n < n2 ? n : n2 - 1;
            n3 = this.getCaretPosition(n4, n < n2);
        }
        WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
        boolean bl = this.getDocumentView().isPrintView();
        int n5 = wmiFontMetrics.getFontProperty(3, bl);
        int n6 = wmiFontMetrics.getFontProperty(4, bl);
        int n7 = n5 + n6;
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        Point point = WmiViewUtil.getAbsoluteOffset(this);
        if (wmiScrollableContainerView != null && wmiScrollableContainerView != wmiMathDocumentView) {
            Point point2 = WmiViewUtil.getAbsoluteOffset(wmiScrollableContainerView);
            point.x -= point2.x;
            point.y -= point2.y;
        }
        if (wmiMathDocumentView != null) {
            int n8;
            int n9 = n8 = point.x + n3 + this.getLeftPadding();
            int n10 = point.y + this.baseline - n5;
            int n11 = n10 + n7;
            if (font.isItalic()) {
                n9 += (int)(0.194f * (float)this.getBaseline());
                n11 -= (int)(0.194f * (float)(this.getHeight() - this.getBaseline()));
            }
            if (this.baselineAdjust != 0) {
                n11 += this.baselineAdjust;
                if ((n10 += this.baselineAdjust) < point.y) {
                    n10 = point.y;
                }
                if (n11 > point.y + this.getHeight()) {
                    n11 = point.y + this.getHeight();
                }
            }
            nArray2[0] = n8;
            nArray2[1] = n10;
            nArray2[2] = n9;
            nArray2[3] = n11;
        } else {
            WmiErrorLog.log(new Exception("unable to find document view"));
        }
        return nArray2;
    }

    protected int getCaretPosition(int n, boolean bl) {
        return this.layout != null ? this.layout.getCaretPosition(n, bl) : 0;
    }

    public int[] getCharacterBounds(int n) throws WmiNoReadAccessException {
        WmiScrollableContainerView wmiScrollableContainerView = WmiViewUtil.findEnclosingContainer(this);
        int[] nArray = new int[4];
        int[] nArray2 = this.getCaretBounds(wmiScrollableContainerView, n);
        int[] nArray3 = this.getCaretBounds(wmiScrollableContainerView, n + 1);
        nArray[0] = nArray2[0];
        nArray[1] = nArray2[1];
        nArray[2] = nArray3[2] - nArray2[0];
        nArray[3] = nArray3[3] - nArray2[1];
        return nArray;
    }

    public WmiFontAttributeSet getFontAttributes() {
        return this.attributes;
    }

    public void updateView() {
        WmiModelObserver wmiModelObserver;
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        WmiModel wmiModel = this.getModel();
        WmiModelObserver wmiModelObserver2 = wmiModelObserver = wmiModel != null ? wmiModel.getObserver() : null;
        while (wmiModelObserver != null) {
            WmiView wmiView;
            WmiModelObserver wmiModelObserver3 = wmiModelObserver.getNextObserver();
            if (wmiModelObserver != this && wmiModelObserver instanceof WmiTextFragmentView && (wmiView = (WmiView)((Object)wmiModelObserver)).getDocumentView() == wmiMathDocumentView) {
                wmiView.invalidate(1);
                wmiView.release();
            }
            wmiModelObserver = wmiModelObserver3;
        }
        this.invalidate(1);
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        if (this.layout != null && this.attributes != null) {
            int n;
            int n2 = wmiRenderPath.getHorizontalOffset();
            int n3 = wmiRenderPath.getVerticalOffset();
            WmiSelection wmiSelection = wmiRenderPath.getSelection();
            WmiHighlightPainter wmiHighlightPainter = wmiSelection != null ? wmiSelection.getSelectionHighlighter() : null;
            Rectangle[] rectangleArray = null;
            if (wmiHighlightPainter != null) {
                n = this.layout != null ? this.layout.computePreKernAdjustment() : 0;
                int n4 = this.layout != null ? this.layout.computePostKernAdjustment() + n : 0;
                rectangleArray = wmiHighlightPainter.intersect(this.x + n2 - n + wmiRenderPath.getHorizontalShift(), this.y + n3 + this.baselineAdjust + wmiRenderPath.getVerticalShift(), this.width + n4, this.height);
            }
            if (this.attributes.isOpaque()) {
                graphics.setColor(new Color(this.attributes.getBackground()));
                graphics.fillRect(n2 + this.x, n3 + this.y + this.baselineAdjust, this.width, this.height);
                if (rectangleArray != null) {
                    graphics.setColor(this.getDocumentView().getColor(4));
                    for (n = 0; n < rectangleArray.length; ++n) {
                        graphics.fillRect(rectangleArray[n].x - wmiRenderPath.getHorizontalShift(), rectangleArray[n].y - wmiRenderPath.getVerticalShift(), rectangleArray[n].width, rectangleArray[n].height);
                    }
                }
            }
            Color color2 = new Color(this.attributes.getForeground());
            graphics.setColor(color2);
            this.drawText(graphics, wmiRenderPath, this.x + n2 + this.getLeftPadding(), this.y + n3);
            WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
            if (rectangleArray != null && wmiMathDocumentView != null) {
                graphics.setColor(wmiMathDocumentView.getColor(3));
                for (int i = 0; i < rectangleArray.length; ++i) {
                    Rectangle rectangle2 = graphics.getClipBounds();
                    graphics.clipRect(rectangleArray[i].x - wmiRenderPath.getHorizontalShift(), rectangleArray[i].y - wmiRenderPath.getVerticalShift(), rectangleArray[i].width, rectangleArray[i].height);
                    this.drawText(graphics, wmiRenderPath, this.x + n2 + this.getLeftPadding(), this.y + n3);
                    graphics.setClip(rectangle2);
                }
            }
        }
        graphics.setFont(font);
        graphics.setColor(color);
    }

    private void drawText(Graphics graphics, WmiRenderPath wmiRenderPath, int n, int n2) {
        boolean bl;
        if (this.layout != null) {
            if (wmiRenderPath.drawStringsWithGlyphVectors()) {
                this.layout.draw(graphics, n, n2 + this.baseline + this.baselineAdjust);
            } else {
                this.layout.drawAsString(graphics, n, n2 + this.baseline + this.baselineAdjust);
            }
        }
        boolean bl2 = bl = this.attributes.isUnderlined() || this.attributes.isComposed();
        if (bl |= this.attributes.isConverted()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            Color color = graphics2D.getColor();
            if (this.attributes.isComposed() || this.attributes.isConverted() && !this.attributes.isInputMethodSelected()) {
                graphics2D.setStroke(COMPOSED_STROKE);
                graphics.setColor(Color.DARK_GRAY);
            } else if (this.attributes.isConverted() && this.attributes.isInputMethodSelected()) {
                graphics2D.setStroke(CONVERTED_STROKE);
                graphics.setColor(Color.BLACK);
            }
            if (this.attributes.isUnderlined()) {
                graphics.drawLine(n + this.getUnderlineHorizontalOffset(), n2 + this.baseline + this.getUnderlineVerticalOffset(), n + this.getUnderlineHorizontalOffset() + this.width + this.getUnderlineHorizontalEndOffset(), n2 + this.baseline + this.getUnderlineVerticalOffset());
            } else {
                graphics.drawLine(n + this.getUnderlineHorizontalOffset() + 2, n2 + this.baseline + this.getUnderlineVerticalOffset(), n + this.getUnderlineHorizontalOffset() + this.width + this.getUnderlineHorizontalEndOffset() - 2, n2 + this.baseline + this.getUnderlineVerticalOffset());
            }
            graphics2D.setStroke(stroke);
            graphics2D.setColor(color);
        }
    }

    public int getUnderlineHorizontalOffset() {
        return 0;
    }

    public int getUnderlineHorizontalEndOffset() {
        return 0;
    }

    public int getUnderlineVerticalOffset() {
        return Math.round((float)(1 * this.getZoomFactor()) / 133.0f);
    }

    public Font getFont() {
        return this.layout != null ? this.layout.getFont() : null;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getTraversableCount() {
        int n = 0;
        if (this.layout != null) {
            n = this.layout.getTextLength();
        }
        return n;
    }

    public int getAdjustedBaseline() {
        return this.baseline + this.baselineAdjust;
    }

    public void insertChar(char c, int n) {
        this.insertString(Character.toString(c), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertString(String string, int n) {
        WmiTextModel wmiTextModel = (WmiTextModel)this.getModel();
        WmiMathDocumentModel wmiMathDocumentModel = wmiTextModel.getDocument();
        WmiModelLock.writeLock(wmiTextModel, true);
        try {
            WmiFontAttributeSet wmiFontAttributeSet;
            WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
            WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
            WmiTextModel wmiTextModel2 = null;
            int n2 = 0;
            if (wmiPositionMarker != null && wmiPositionMarker.getView() == this) {
                wmiTextModel2 = (WmiTextModel)this.getModel();
                n2 = wmiPositionMarker.getOffset();
                if (n2 < 0) {
                    n2 = 0;
                }
                n2 += this.getStartOffset();
            }
            WmiFontAttributeSet wmiFontAttributeSet2 = wmiMathDocumentModel.getActiveEditAttributes();
            WmiAttributeSet wmiAttributeSet = wmiTextModel.getAttributesForRead();
            WmiFontAttributeSet wmiFontAttributeSet3 = wmiFontAttributeSet = wmiAttributeSet instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)wmiAttributeSet : null;
            if (!wmiFontAttributeSet2.isCompatibleEditAttributeSet(wmiFontAttributeSet)) {
                wmiFontAttributeSet2 = (WmiFontAttributeSet)wmiFontAttributeSet2.copyAttributes();
                if (wmiTextModel.getLength() == 0) {
                    wmiTextModel.addAttributes(wmiFontAttributeSet2);
                } else {
                    if (n > 0 && n < wmiTextModel.getLength()) {
                        wmiTextModel.splitModel(n);
                    }
                    WmiCompositeModel wmiCompositeModel = wmiTextModel.getParent();
                    int n3 = n == 0 ? wmiCompositeModel.indexOf(wmiTextModel) : wmiCompositeModel.indexOf(wmiTextModel) + 1;
                    wmiTextModel = new WmiTextModel(wmiMathDocumentModel, "", wmiFontAttributeSet2);
                    wmiCompositeModel.addChild(wmiTextModel, n3);
                    wmiTextModel.setParent(wmiCompositeModel);
                    if (wmiTextModel2 != null) {
                        wmiTextModel2 = wmiTextModel;
                        n2 = 0;
                    }
                    n = 0;
                }
            }
            if (n > wmiTextModel.getLength()) {
                n = wmiTextModel.getLength();
            }
            if (n < 0) {
                n = 0;
            }
            wmiTextModel.insertText(string, n);
            if (wmiTextModel2 != null) {
                wmiMathDocumentView.setPendingPosition(new WmiModelPosition(wmiTextModel2, n2 + string.length()));
            }
            wmiMathDocumentModel.update(undoInsertText);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
            WmiErrorLog.log(wmiNoUpdateAccessException);
        }
        finally {
            WmiModelLock.writeUnlock(wmiTextModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int n, int n2) {
        WmiTextModel wmiTextModel = null;
        try {
            wmiTextModel = (WmiTextModel)this.getModel();
            WmiModelLock.writeLock(wmiTextModel, true);
            WmiMathDocumentModel wmiMathDocumentModel = wmiTextModel.getDocument();
            WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
            wmiTextModel.deleteText(n, n2);
            wmiMathDocumentView.setPendingPosition(new WmiModelPosition(wmiTextModel, n));
            wmiMathDocumentModel.update(undoDeleteText);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
            WmiErrorLog.log(wmiNoUpdateAccessException);
        }
        finally {
            WmiModelLock.writeUnlock(wmiTextModel);
        }
    }

    public int getStartOffset() {
        return 0;
    }

    public int getEndOffset() throws WmiNoReadAccessException {
        return this.getLength();
    }

    public int getLeftPadding() {
        return 0;
    }

    public int getRightPadding() {
        return 0;
    }

    public boolean enableKernAdjust() {
        return true;
    }

    public void addTraversableLinks() {
    }

    public WmiViewPath createViewPath(int n) {
        WmiViewPath wmiViewPath = new WmiViewPath(this);
        wmiViewPath.push(n);
        return wmiViewPath;
    }

    protected AccessibleContext createAccessibleContext() {
        return new WmiAccessibleContext();
    }

    protected int getEmptyTextWidth() throws WmiNoReadAccessException {
        return 0;
    }

    public int doExplicitLinebreak(WmiParagraphView wmiParagraphView) throws WmiNoReadAccessException {
        boolean bl = false;
        String string = this.getText();
        if (string != null) {
            int n = string.indexOf(10);
            int n2 = string.indexOf(13);
            int n3 = -1;
            int n4 = 1;
            if (n >= 0 && n2 >= 0) {
                int n5 = n3 = n < n2 ? n : n2;
                if (Math.abs(n2 - n) == 1) {
                    ++n4;
                }
            } else if (n >= 0 || n2 >= 0) {
                int n6 = n3 = n >= 0 ? n : n2;
            }
            if (n3 >= 0) {
                wmiParagraphView.split(this, n3, n4);
                bl = true;
            }
        }
        return bl ? 2 : 0;
    }

    public int doForcedLinebreak(WmiParagraphView wmiParagraphView, int n, int n2) throws WmiNoReadAccessException {
        boolean bl = false;
        int n3 = n2 - n;
        Point point = new Point(n3, 0);
        int n4 = this.getOffset(point);
        if (n4 > 0) {
            bl = true;
            wmiParagraphView.split(this, n4, 0);
        }
        return bl ? 2 : 0;
    }

    public int doImplicitLinebreak(WmiParagraphView wmiParagraphView, int n, int n2, int n3) throws WmiNoReadAccessException {
        boolean bl = false;
        WmiParagraphView.WmiBreakInfo wmiBreakInfo = new WmiParagraphView.WmiBreakInfo(false);
        wmiBreakInfo.breakWidth = n2 - n;
        this.extractNextBreakpoint(wmiBreakInfo, false);
        if (wmiBreakInfo.breakPoint > 0) {
            int n4 = 0;
            if (wmiBreakInfo.nextStart > wmiBreakInfo.breakPoint) {
                n4 = wmiBreakInfo.nextStart - wmiBreakInfo.breakPoint;
            }
            wmiParagraphView.split(this, wmiBreakInfo.breakPoint, n4);
            bl = true;
        }
        return bl ? 2 : 0;
    }

    static {
        int n;
        COMPOSED_DASH = new float[]{3.0f, 4.0f};
        COMPOSED_STROKE = new BasicStroke(2.0f, 2, 2, 1.0f, COMPOSED_DASH, 0.0f);
        CONVERTED_STROKE = new BasicStroke(3.0f);
        JAPANESE_NO_STARTS = new char[]{'\uff64', '\uff61', '\uff63', '\uff71', '\uff72', '\uff73', '\uff74', '\uff75', '\uff82', '\uff94', '\uff95', '\uff96', '\uff9c', '\uff76', '\uff79', '\uff70', '\uff9e', '\uff9f', '\uff1b', '\uff1a', '\uff0e', '\u3001', '\u3002', '\uff0c', '\uff1f', '\uff01', '\uff09', '\uff3d', '\u300d', '\uff5d', '\u3042', '\u3044', '\u3046', '\u3048', '\u304a', '\u3064', '\u3084', '\u3086', '\u3088', '\u308f', ',', '.', ':', ';', '?', '!', ')', ']', '}'};
        JAPANESE_NO_ENDS = new char[]{'\uff08', '\uff3b', '\u300c', '\u3012', '\uff04', '\uff20', '\uffe5', '\uff03', '\u2018', '\u201c', '\u3014', '\u3008', '\u300a', '\u300e', '\u3010', '\uffe0', '\uffe1', '\u00a7', '(', '[', '{', '\u00a2', '\\', '$', '@', '#'};
        noStarts = new WmiUnicodeMapper();
        noEnds = new WmiUnicodeMapper();
        undoInsertText = null;
        undoDeleteText = null;
        for (n = 0; n < JAPANESE_NO_STARTS.length; ++n) {
            noStarts.put(JAPANESE_NO_STARTS[n], Boolean.TRUE);
        }
        for (n = 0; n < JAPANESE_NO_ENDS.length; ++n) {
            noEnds.put(JAPANESE_NO_ENDS[n], Boolean.TRUE);
        }
        try {
            WmiResourcePackage wmiResourcePackage = WmiResourcePackage.getResourcePackage("com.maplesoft.mathdoc.view.resources.View");
            undoInsertText = wmiResourcePackage.getStringForKey("InsertText.undo");
            undoDeleteText = wmiResourcePackage.getStringForKey("DeleteText.undo");
        }
        catch (MissingResourceException missingResourceException) {
            WmiErrorLog.log(missingResourceException);
        }
        caretBounds = new int[4];
    }
}

