/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiDocumentScroller;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.view.WmiAbstractInlineWrapperView;
import com.maplesoft.mathdoc.view.WmiAbstractSelectionHighlighter;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiSwitchableCompositeView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewPathInterval;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class WmiSelectionHighlighter
extends WmiAbstractSelectionHighlighter {
    private static final int SELECTION_START_MODE = 0;
    private static final int SELECTION_END_MODE = 1;
    public static final int REPAINT_BORDER = 1;
    private Rectangle top;
    private Rectangle bottom;
    private Rectangle fill;
    private WmiMathDocumentView docView;
    private Rectangle dirtyRegion;

    public WmiSelectionHighlighter(WmiMathDocumentView wmiMathDocumentView, WmiViewPathInterval wmiViewPathInterval, WmiSelectionHighlighter wmiSelectionHighlighter) {
        WmiRowView wmiRowView;
        this.docView = wmiMathDocumentView;
        WmiViewPath wmiViewPath = wmiViewPathInterval.getSelectionStartPath();
        WmiViewPath wmiViewPath2 = wmiViewPathInterval.getSelectionEndPath();
        int[] nArray = new int[1];
        WmiCompositeView wmiCompositeView = this.findSelectionParent(wmiViewPath, wmiViewPath2, nArray);
        int n = nArray[0];
        int n2 = this.findHorizontalOffset(wmiCompositeView, wmiViewPath, n, 0);
        int n3 = this.findHorizontalOffset(wmiCompositeView, wmiViewPath2, n, 1);
        if (wmiCompositeView instanceof WmiSwitchableCompositeView && (wmiRowView = ((WmiSwitchableCompositeView)wmiCompositeView).getRootPhysicalView()) != null) {
            wmiCompositeView = wmiRowView;
        }
        if (wmiCompositeView instanceof WmiRowView || wmiCompositeView instanceof WmiMathDocumentView || wmiCompositeView instanceof WmiAbstractInlineWrapperView) {
            this.createMultiRowSelection(wmiCompositeView, wmiViewPath, wmiViewPath2, n, n2, n3);
        } else {
            this.createWithinRowSelection(wmiCompositeView, wmiViewPath, wmiViewPath2, n, n2, n3);
        }
        this.computeDirtyRegions(wmiSelectionHighlighter);
        this.repaintDirtyRegions();
    }

    private void createMultiRowSelection(WmiCompositeView wmiCompositeView, WmiViewPath wmiViewPath, WmiViewPath wmiViewPath2, int n, int n2, int n3) {
        WmiPositionedView wmiPositionedView = this.findRow(wmiCompositeView, wmiViewPath, n, 0);
        WmiPositionedView wmiPositionedView2 = this.findRow(wmiCompositeView, wmiViewPath2, n, 1);
        this.bottom = null;
        this.fill = null;
        this.top = null;
        if (wmiPositionedView != null && wmiPositionedView2 != null) {
            Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
            if (wmiPositionedView == wmiPositionedView2) {
                this.top = this.constructRect(wmiPositionedView, n2, n3);
            } else {
                Point point2 = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)((Object)wmiCompositeView));
                this.top = this.constructRect(wmiPositionedView, n2, point2.x + ((WmiPositionedView)((Object)wmiCompositeView)).getWidth());
                this.bottom = this.constructRect(wmiPositionedView2, point2.x, n3);
                if (this.bottom.y > this.top.y + this.top.height) {
                    this.fill = new Rectangle(point2.x, this.top.y + this.top.height, ((WmiPositionedView)((Object)wmiCompositeView)).getWidth(), this.bottom.y - (point.y + this.top.height));
                }
            }
        }
    }

    private void createWithinRowSelection(WmiCompositeView wmiCompositeView, WmiViewPath wmiViewPath, WmiViewPath wmiViewPath2, int n, int n2, int n3) {
        int n4;
        WmiView wmiView = wmiCompositeView;
        int n5 = n4 = wmiViewPath.depth() < wmiViewPath2.depth() ? wmiViewPath.depth() : wmiViewPath2.depth();
        while (n < n4 && wmiView instanceof WmiCompositeView) {
            int n6 = wmiViewPath.peek(n);
            if (wmiViewPath.peek(n) != wmiViewPath2.peek(n)) break;
            if (n6 < 0) {
                n6 = wmiView.getChildCount() - 1;
            }
            wmiView = wmiView.getChild(n6);
            ++n;
        }
        WmiPositionedView wmiPositionedView = (WmiPositionedView)wmiView;
        this.bottom = null;
        this.fill = null;
        this.top = null;
        this.top = this.constructRect(wmiPositionedView, n2, n3);
    }

    private Rectangle constructRect(WmiPositionedView wmiPositionedView, int n, int n2) {
        Rectangle rectangle = null;
        if (wmiPositionedView != null) {
            WmiTextLayout wmiTextLayout;
            Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
            boolean bl = false;
            if (wmiPositionedView instanceof WmiTextView && (wmiTextLayout = ((WmiTextView)wmiPositionedView).getLayout()) != null) {
                Font font = wmiTextLayout.getFont();
                FontRenderContext fontRenderContext = wmiTextLayout.getFontRenderContext();
                WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
                int n3 = ((WmiTextView)wmiPositionedView).getAdjustedBaseline() - wmiFontMetrics.getFontProperty(3, fontRenderContext);
                rectangle = new Rectangle(n, point.y + n3, n2 - n + 1, wmiTextLayout.getHeight());
                bl = true;
            }
            if (!bl) {
                rectangle = new Rectangle(n, point.y, n2 - n + 1, wmiPositionedView.getHeight());
            }
        }
        return rectangle;
    }

    public void paint(Graphics graphics) {
        Color color = graphics.getColor();
        Color color2 = this.docView.getColor(4);
        graphics.setColor(color2);
        if (this.top != null) {
            graphics.fillRect(this.top.x, this.top.y, this.top.width, this.top.height);
        }
        if (this.fill != null) {
            graphics.fillRect(this.fill.x, this.fill.y, this.fill.width, this.fill.height);
        }
        if (this.bottom != null) {
            graphics.fillRect(this.bottom.x, this.bottom.y, this.bottom.width, this.bottom.height);
        }
        graphics.setColor(color);
    }

    public void repaintDirtyRegions() {
        if (this.dirtyRegion != null) {
            this.docView.repaint(this.dirtyRegion.x - 1, this.dirtyRegion.y - 1, this.dirtyRegion.width + 2, this.dirtyRegion.height + 2);
        } else {
            this.docView.repaint();
        }
    }

    public void scrollVisible() {
        WmiDocumentScroller.scrollVisible(this.docView, this.getBounds());
    }

    public int getLeftBoundary(int n) {
        int n2 = -1;
        if (this.top != null && n >= this.top.y) {
            if (n < this.top.y + this.top.height) {
                n2 = this.top.x;
            } else if (this.fill != null && n < this.fill.y + this.fill.height) {
                n2 = this.fill.x;
            } else if (this.bottom != null && n < this.bottom.y + this.bottom.height) {
                n2 = this.bottom.x;
            }
        }
        return n2;
    }

    public int getRightBoundary(int n) {
        int n2 = -1;
        if (this.top != null && n >= this.top.y) {
            if (n < this.top.y + this.top.height) {
                n2 = this.top.x + this.top.width;
            } else if (this.fill != null && n < this.fill.y + this.fill.height) {
                n2 = this.fill.x + this.fill.width;
            } else if (this.bottom != null && n < this.bottom.y + this.bottom.height) {
                n2 = this.bottom.x + this.bottom.width;
            }
        }
        return n2;
    }

    public int getTopBoundary(int n) {
        int n2 = -1;
        if (this.top != null && this.top.x < n) {
            if (n < this.top.x + this.top.width) {
                n2 = this.top.y;
            }
        } else if (this.fill != null && this.fill.x < n) {
            if (n < this.fill.x + this.fill.width) {
                n2 = this.fill.y;
            }
        } else if (this.bottom != null && this.bottom.x < n && n < this.bottom.x + this.bottom.width) {
            n2 = this.bottom.y;
        }
        return n2;
    }

    public int getBottomBoundary(int n) {
        int n2 = -1;
        if (this.bottom != null && this.bottom.x < n) {
            if (n < this.bottom.x + this.bottom.width) {
                n2 = this.bottom.y + this.bottom.height;
            }
        } else if (this.fill != null && this.fill.x < n) {
            if (n < this.fill.x + this.fill.width) {
                n2 = this.fill.y + this.fill.height;
            }
        } else if (this.top != null && this.top.x < n && n < this.top.x + this.top.width) {
            n2 = this.top.y + this.top.height;
        }
        return n2;
    }

    private WmiCompositeView findSelectionParent(WmiViewPath wmiViewPath, WmiViewPath wmiViewPath2, int[] nArray) {
        int n;
        int n2;
        WmiView wmiView = null;
        int n3 = wmiViewPath != null ? wmiViewPath.depth() : 0;
        int n4 = wmiViewPath2 != null ? wmiViewPath2.depth() : 0;
        int n5 = n3 < n4 ? n3 : n4;
        wmiView = this.docView;
        for (n2 = 0; n2 < n5 && (n = wmiViewPath.peek(n2)) == wmiViewPath2.peek(n2); ++n2) {
            WmiView wmiView2;
            if (wmiView instanceof WmiSwitchableCompositeView && (wmiView2 = ((WmiSwitchableCompositeView)wmiView).getRootPhysicalView()) != null) {
                wmiView = wmiView2;
            }
            if (n < 0) {
                n = wmiView.getChildCount() - 1;
            }
            if (!((wmiView2 = wmiView.getChild(n)) instanceof WmiCompositeView)) break;
            wmiView = wmiView2;
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = n2;
        }
        return wmiView;
    }

    private WmiPositionedView findRow(WmiView wmiView, WmiViewPath wmiViewPath, int n, int n2) {
        WmiPositionedView wmiPositionedView = null;
        if (wmiViewPath != null) {
            WmiCompositeView wmiCompositeView;
            int n3 = wmiViewPath.depth();
            if (wmiView instanceof WmiSwitchableCompositeView && (wmiCompositeView = ((WmiSwitchableCompositeView)wmiView).getRootPhysicalView()) != null) {
                wmiView = wmiCompositeView;
            }
            if (wmiView instanceof WmiRowView || wmiView instanceof WmiMathDocumentView) {
                wmiCompositeView = (WmiCompositeView)wmiView;
                if (n < n3) {
                    int n4 = wmiViewPath.peek(n);
                    if (n4 < 0) {
                        n4 = wmiCompositeView.getChildCount() - 1;
                    }
                    wmiPositionedView = this.findRow(wmiCompositeView.getChild(n4), wmiViewPath, n + 1, n2);
                } else if (wmiCompositeView.getChildCount() > 0) {
                    wmiPositionedView = n2 == 0 ? this.findRow(wmiCompositeView.getChild(0), wmiViewPath, n + 1, n2) : this.findRow(wmiCompositeView.getChild(wmiCompositeView.getChildCount() - 1), wmiViewPath, n + 1, n2);
                }
            }
            if (wmiPositionedView == null) {
                wmiPositionedView = (WmiPositionedView)wmiView;
            }
        }
        return wmiPositionedView;
    }

    private int findHorizontalOffset(WmiCompositeView wmiCompositeView, WmiViewPath wmiViewPath, int n, int n2) {
        int n3 = 0;
        WmiView wmiView = null;
        int n4 = wmiViewPath.depth();
        int n5 = n;
        while (true) {
            int n6;
            WmiRowView wmiRowView;
            boolean bl = false;
            if (wmiCompositeView instanceof WmiScrollableContainerView) {
                boolean bl2 = bl = !((WmiScrollableContainerView)((Object)wmiCompositeView)).isDocumentView();
            }
            if (bl) {
                wmiView = null;
                Point point = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)((Object)wmiCompositeView));
                n3 = n2 == 0 ? point.x : point.x + ((WmiPositionedView)((Object)wmiCompositeView)).getWidth();
                break;
            }
            if (wmiCompositeView instanceof WmiSwitchableCompositeView && (wmiRowView = ((WmiSwitchableCompositeView)wmiCompositeView).getRootPhysicalView()) != null) {
                wmiCompositeView = wmiRowView;
            }
            if (n5 < n4) {
                n6 = wmiViewPath.peek(n5);
                int n7 = wmiCompositeView.getChildCount();
                if (n6 < 0 || n6 >= n7 && n7 > 0) {
                    wmiView = null;
                    Point point = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)((Object)wmiCompositeView));
                    n3 = point.x + ((WmiPositionedView)((Object)wmiCompositeView)).getWidth();
                    break;
                }
                if (n6 >= n7) break;
            } else {
                wmiView = null;
                Point point = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)((Object)wmiCompositeView));
                n3 = n2 == 0 ? point.x : point.x + ((WmiPositionedView)((Object)wmiCompositeView)).getWidth();
                break;
            }
            wmiView = wmiCompositeView.getChild(n6);
            if (!(wmiView instanceof WmiCompositeView)) break;
            wmiCompositeView = (WmiCompositeView)wmiView;
            ++n5;
        }
        if (wmiView instanceof WmiPositionedView) {
            Point point = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)wmiView);
            n3 = point.x;
            if (wmiView instanceof WmiTextView) {
                if (++n5 < n4) {
                    int n8 = wmiViewPath.peek(n5);
                    n3 = n8 < 0 ? (n3 += ((WmiPositionedView)wmiView).getWidth()) : (n3 += ((WmiTextView)wmiView).getHorizontalOffset(n8));
                } else if (n2 == 1) {
                    n3 += ((WmiPositionedView)wmiView).getWidth();
                }
            } else if (wmiView != null && n2 == 1) {
                n3 += ((WmiPositionedView)wmiView).getWidth();
            }
        }
        return n3;
    }

    public void computeDirtyRegions(WmiHighlightPainter wmiHighlightPainter) {
        this.dirtyRegion = this.computeBounds();
        if (this.dirtyRegion == null && wmiHighlightPainter != null) {
            this.dirtyRegion = wmiHighlightPainter.getBounds();
        } else if (wmiHighlightPainter != null) {
            Rectangle rectangle = wmiHighlightPainter.getBounds();
            if (rectangle == null) {
                return;
            }
            if (rectangle.x != this.dirtyRegion.x || rectangle.width != this.dirtyRegion.width || !(wmiHighlightPainter instanceof WmiSelectionHighlighter)) {
                this.dirtyRegion = SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.dirtyRegion);
            } else if (rectangle.y == this.dirtyRegion.y && rectangle.height == this.dirtyRegion.height) {
                WmiSelectionHighlighter wmiSelectionHighlighter = (WmiSelectionHighlighter)wmiHighlightPainter;
                this.dirtyRegion = this.top.x != wmiSelectionHighlighter.top.x || this.top.width != wmiSelectionHighlighter.top.width ? SwingUtilities.computeUnion(this.top.x, this.top.y, this.top.width, this.top.height, wmiSelectionHighlighter.top) : (this.bottom != null && wmiSelectionHighlighter.bottom != null ? SwingUtilities.computeUnion(this.bottom.x, this.bottom.y, this.bottom.width, this.bottom.height, wmiSelectionHighlighter.bottom) : null);
            } else {
                WmiSelectionHighlighter wmiSelectionHighlighter = (WmiSelectionHighlighter)wmiHighlightPainter;
                if (this.dirtyRegion.y != rectangle.y) {
                    if (this.dirtyRegion.y + this.dirtyRegion.height == rectangle.y + rectangle.height) {
                        int n = this.dirtyRegion.y;
                        int n2 = rectangle.y;
                        int n3 = Math.min(n, n2);
                        int n4 = Math.max(n += this.top.height, n2 += wmiSelectionHighlighter.top.height);
                        int n5 = Math.min(this.dirtyRegion.x, rectangle.x);
                        int n6 = Math.max(this.dirtyRegion.x + this.dirtyRegion.width, rectangle.x + rectangle.width);
                        this.dirtyRegion = new Rectangle(n5, n3, n6 - n5 + 1, n4 - n3 + 1);
                    } else {
                        this.dirtyRegion = SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.dirtyRegion);
                    }
                } else {
                    int n = this.dirtyRegion.y + this.dirtyRegion.height;
                    int n7 = rectangle.y + rectangle.height;
                    int n8 = Math.max(n, n7);
                    if (this.bottom != null) {
                        n -= this.bottom.height;
                    }
                    if (wmiSelectionHighlighter.bottom != null) {
                        n7 -= wmiSelectionHighlighter.bottom.height;
                    }
                    int n9 = Math.min(n, n7);
                    int n10 = Math.min(this.dirtyRegion.x, rectangle.x);
                    int n11 = Math.max(this.dirtyRegion.x + this.dirtyRegion.width, rectangle.x + rectangle.width);
                    this.dirtyRegion = new Rectangle(n10, n9, n11 - n10 + 1, n8 - n9 + 1);
                }
            }
        }
    }

    private Rectangle computeBounds() {
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = this.top != null ? new Rectangle(this.top.x, this.top.y, this.top.width, this.top.height) : null;
        if (rectangle != null) {
            if (this.fill != null) {
                rectangle = SwingUtilities.computeUnion(this.fill.x, this.fill.y, this.fill.width, this.fill.height, rectangle);
            }
            if (this.bottom != null) {
                rectangle = SwingUtilities.computeUnion(this.bottom.x, this.bottom.y, this.bottom.width, this.bottom.height, rectangle);
            }
        }
        return rectangle;
    }

    public Rectangle[] intersect(int n, int n2, int n3, int n4) {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        Rectangle rectangle = this.intersection(n, n2, n3, n4, this.top);
        if (rectangle != null) {
            arrayList.add(rectangle);
        }
        if ((rectangle = this.intersection(n, n2, n3, n4, this.fill)) != null) {
            arrayList.add(rectangle);
        }
        if ((rectangle = this.intersection(n, n2, n3, n4, this.bottom)) != null) {
            arrayList.add(rectangle);
        }
        Rectangle[] rectangleArray = null;
        if (arrayList.size() > 0) {
            rectangleArray = new Rectangle[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                rectangleArray[i] = (Rectangle)arrayList.get(i);
            }
        }
        return rectangleArray;
    }

    private Rectangle intersection(int n, int n2, int n3, int n4, Rectangle rectangle) {
        Rectangle rectangle2 = null;
        if (rectangle != null) {
            rectangle2 = new Rectangle(n, n2, n3, n4);
            SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
            if (rectangle2.width == 0) {
                rectangle2 = null;
            }
        }
        return rectangle2;
    }

    public Rectangle computeLeftMarginBounds() {
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = this.bottom != null ? new Rectangle(this.bottom.x, this.bottom.y, this.bottom.width, this.bottom.height) : null;
        if (this.fill != null) {
            rectangle = SwingUtilities.computeUnion(this.fill.x, this.fill.y, this.fill.width, this.fill.height, rectangle);
        }
        if (this.top != null && rectangle != null && this.top.x == rectangle.x) {
            rectangle = SwingUtilities.computeUnion(this.top.x, this.top.y, this.top.width, this.top.height, rectangle);
        }
        return rectangle;
    }

    public Rectangle getBounds() {
        return this.computeBounds();
    }

    public Color getSelectionForeground() {
        return this.docView.getColor(3);
    }

    public Point getPointAtEnd() {
        Point point = null;
        if (this.bottom != null) {
            Rectangle rectangle = this.bottom.getBounds();
            point = new Point(rectangle.x + rectangle.width, rectangle.y);
        } else if (this.top != null) {
            Rectangle rectangle = this.top.getBounds();
            point = new Point(rectangle.x + rectangle.width, rectangle.y);
        }
        return point;
    }
}

