/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiMathDocumentMouseListener;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiContainerView;
import com.maplesoft.mathdoc.view.WmiEightPointResizer;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiResizeDecorator;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;

public abstract class WmiResizableContainerView
extends WmiArrayCompositeView
implements WmiContainerView {
    public static final int RESIZE_NO_CHANGE = -2;
    protected static WmiResizableContainerView resizingHold = null;
    protected static BufferedImage resizeImage = null;
    protected WmiResizeDecorator marker = null;
    protected boolean resizableByUser = true;

    protected WmiResizableContainerView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        this(wmiModel, wmiMathDocumentView, null);
    }

    protected WmiResizableContainerView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView, WmiCompositeView wmiCompositeView) {
        super(wmiModel, wmiMathDocumentView, wmiCompositeView);
    }

    protected void createResizeImage() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        resizeImage = graphicsConfiguration.createCompatibleImage(this.width, this.height);
        Graphics2D graphics2D = resizeImage.createGraphics();
        this.drawContents(graphics2D, this.width, this.height);
    }

    protected Point getAbsoluteCoordinates() {
        return WmiViewUtil.getAbsoluteOffset(this);
    }

    protected Rectangle getAbsoluteRegion() {
        Rectangle rectangle = this.getBounds();
        rectangle.setLocation(this.getAbsoluteCoordinates());
        return rectangle;
    }

    protected void highlight(Graphics graphics, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(10, 0.5f));
        Color color2 = graphics2D.getColor();
        if (color != null) {
            graphics2D.setColor(color);
        }
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setColor(color2);
        if (composite != null) {
            graphics2D.setComposite(composite);
        }
    }

    public boolean shouldConstrainPrintSize() {
        return false;
    }

    public float getConstrainedSizeRatio() {
        return Math.min(1.0f, (float)this.getWidthConstraint(false) / (float)this.getWidth());
    }

    public String debugPrint(int n) throws WmiNoReadAccessException {
        return System.getProperty("line.separator") + super.debugPrint(n);
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid() && resizingHold != this) {
            WmiUndoManager wmiUndoManager;
            this.calculateRestrictedSize();
            super.layoutView();
            WmiModel wmiModel = this.getModel();
            WmiMathDocumentModel wmiMathDocumentModel = wmiModel != null ? wmiModel.getDocument() : null;
            WmiUndoManager wmiUndoManager2 = wmiUndoManager = wmiMathDocumentModel != null ? wmiMathDocumentModel.getUndoManager() : null;
            if (wmiUndoManager != null && !wmiUndoManager.isUndoingOrRedoing()) {
                this.resizeCanvasIfNecessary(this.getCanvasBounds());
                if (this.requiresCanvasResizeCommit()) {
                    SwingUtilities.invokeLater(new CanvasUpdater());
                }
            }
        }
    }

    protected void calculateRestrictedSize() throws WmiNoReadAccessException {
        this.height = this.getContentsVisibleHeight();
        this.width = this.getContentsVisibleWidth();
        this.baseline = this.height / 2;
        boolean bl = this.getDocumentView() == null ? false : this.getDocumentView().isPrintView();
        if (this.applySizeConstraint(bl || this.resizableByUser)) {
            this.resizeUpdate();
        }
        if (this.marker != null) {
            this.marker.updateView(this);
        }
    }

    protected void resizeUpdate() {
    }

    protected boolean applySizeConstraint(boolean bl) throws WmiNoReadAccessException {
        boolean bl2 = false;
        int n = this.width;
        int n2 = this.getWidthConstraint(true);
        if (n2 > 0 && n2 < this.width) {
            this.width = n2;
            if (bl) {
                double d = (double)n2 / (double)n;
                this.height = (int)((double)this.height * d);
            }
            bl2 = true;
        }
        return bl2;
    }

    protected boolean shouldDrawChildren() {
        return true;
    }

    protected boolean shouldDrawSelectionHighlight() {
        return true;
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        int n = wmiRenderPath.getHorizontalOffset() + this.x;
        int n2 = wmiRenderPath.getVerticalOffset() + this.y;
        graphics.translate(n, n2);
        wmiRenderPath.applyShift(n, n2);
        if (resizingHold == this && resizeImage != null) {
            graphics.drawImage(resizeImage, 0, 0, this.width, this.height, 0, 0, resizeImage.getWidth(), resizeImage.getHeight(), Color.WHITE, null);
        } else {
            this.drawContents(graphics, this.width, this.height);
        }
        Color color = null;
        if (this.shouldDrawSelectionHighlight() && wmiRenderPath.isSelected(n, this.width)) {
            WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
            color = wmiMathDocumentView.getColor(4);
        } else if (resizingHold == this) {
            color = Color.WHITE;
        }
        if (color != null) {
            this.highlight(graphics, color);
        }
        graphics.translate(-n, -n2);
        wmiRenderPath.applyShift(-n, -n2);
        if (this.shouldDrawChildren()) {
            super.draw(graphics, wmiRenderPath, rectangle);
        }
    }

    public void release() {
        super.release();
        resizeImage = null;
        if (this.marker != null) {
            this.marker.hide();
            this.marker = null;
        }
    }

    public void onMouseClicked(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMouseDragged(MouseEvent mouseEvent) {
        if (resizingHold == this && this.marker != null) {
            WmiMathDocumentModel wmiMathDocumentModel;
            Dimension dimension = this.marker.onMouseDragged(mouseEvent);
            this.width = (int)dimension.getWidth();
            this.height = (int)dimension.getHeight();
            WmiModel wmiModel = this.getModel();
            if (wmiModel != null && (wmiMathDocumentModel = wmiModel.getDocument()) != null && WmiModelLock.readLock(wmiMathDocumentModel, true)) {
                try {
                    WmiMathDocumentView wmiMathDocumentView;
                    this.applySizeConstraint(false);
                    this.marker.updateView(this);
                    WmiCompositeView wmiCompositeView = this.getParentView();
                    if (wmiCompositeView != null) {
                        wmiCompositeView.invalidate(1);
                    }
                    if ((wmiMathDocumentView = this.getDocumentView()) != null) {
                        wmiMathDocumentView.layoutView();
                        wmiMathDocumentView.repaint();
                        WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
                    }
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                finally {
                    WmiModelLock.readUnlock(wmiMathDocumentModel);
                }
            }
            mouseEvent.consume();
        }
    }

    public void onMouseExited(MouseEvent mouseEvent) {
        this.setCursor(null);
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        Cursor cursor = null;
        if (this.marker != null && this.marker.isVisible()) {
            cursor = this.marker.onMouseMoved(mouseEvent);
        }
        if (cursor != null) {
            this.setCursor(cursor);
            mouseEvent.consume();
        }
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        resizingHold = null;
        resizeImage = null;
        if (this.marker != null && this.marker.isVisible() && (mouseEvent.getModifiers() & 0x10) != 0 && this.marker.onMousePressed(mouseEvent)) {
            WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
            WmiMathDocumentMouseListener wmiMathDocumentMouseListener = wmiMathDocumentView.getMouseListener();
            wmiMathDocumentMouseListener.setMouseDragView(this);
            resizingHold = this;
            this.createResizeImage();
            mouseEvent.consume();
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if (resizingHold == this) {
            if (this.marker != null) {
                this.marker.onMouseReleased(mouseEvent);
            }
            resizingHold = null;
            resizeImage = null;
            this.resizeModel(this.width, this.height, true);
            mouseEvent.consume();
        }
    }

    protected Rectangle getCanvasBounds() {
        return this.getBounds();
    }

    protected void resizeCanvasIfNecessary(Rectangle rectangle) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            WmiView wmiView = this.getChild(i);
        }
    }

    protected boolean requiresCanvasResizeCommit() {
        return false;
    }

    protected void commitCanvasResize() throws WmiNoWriteAccessException, WmiNoUpdateAccessException {
    }

    public void setFocus(boolean bl) {
    }

    public void setPositionMarker(int n) {
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        if (wmiMathDocumentView != null) {
            if (this.marker == null || !this.marker.equals(wmiMathDocumentView.getPositionMarker())) {
                WmiResizeDecorator wmiResizeDecorator = this.createResizeDecorator(wmiMathDocumentView);
                if (wmiResizeDecorator != null) {
                    wmiMathDocumentView.setPositionMarker(wmiResizeDecorator);
                    wmiResizeDecorator.updateView(this);
                    wmiResizeDecorator.show();
                    this.marker = wmiResizeDecorator;
                    wmiMathDocumentView.setFocusedView(this);
                }
            } else if (this.marker != null) {
                this.marker.updateView(this);
            }
            wmiMathDocumentView.repaint();
        }
    }

    public void setMarker(WmiResizeDecorator wmiResizeDecorator) {
        this.marker = wmiResizeDecorator;
    }

    protected abstract WmiResizeDecorator createResizeDecorator(WmiMathDocumentView var1);

    protected abstract void drawContents(Graphics var1, int var2, int var3);

    protected abstract int getContentsVisibleHeight() throws WmiNoReadAccessException;

    protected abstract int getContentsVisibleWidth() throws WmiNoReadAccessException;

    protected int getContentsFullWidth() throws WmiNoReadAccessException {
        return this.getContentsVisibleWidth();
    }

    protected int getContentsFullHeight() throws WmiNoReadAccessException {
        return this.getContentsVisibleHeight();
    }

    public abstract void resizeModel(int var1, int var2, boolean var3);

    public void setUserResizable(boolean bl) {
        this.resizableByUser = bl;
    }

    public WmiPositionedView getChildView(Point point) {
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        MouseEvent mouseEvent = new MouseEvent(wmiMathDocumentView, 0, 0L, 0, point.x, point.y, 1, false);
        mouseEvent.setSource(this);
        WmiPositionedView wmiPositionedView = this.marker != null && WmiEightPointResizer.isEventInResizeRegion(mouseEvent) ? null : super.getChildView(point);
        return wmiPositionedView;
    }

    private class CanvasUpdater
    implements Runnable {
        private CanvasUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WmiModel wmiModel = WmiResizableContainerView.this.getModel();
            if (wmiModel == null) {
                return;
            }
            WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
            if (wmiMathDocumentModel == null) {
                return;
            }
            WmiUndoManager wmiUndoManager = wmiMathDocumentModel.getUndoManager();
            wmiUndoManager.makeLastEditCoalescable(true);
            if (WmiModelLock.writeLock(wmiMathDocumentModel, true)) {
                try {
                    WmiResizableContainerView.this.commitCanvasResize();
                }
                catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                    WmiErrorLog.log(wmiNoWriteAccessException);
                }
                catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                    WmiErrorLog.log(wmiNoUpdateAccessException);
                }
                finally {
                    WmiModelLock.writeUnlock(wmiMathDocumentModel);
                }
                wmiUndoManager.makeLastEditCoalescable(true);
                wmiUndoManager.coalesceLastEdits();
                wmiUndoManager.makeLastEditCoalescable(false);
            }
        }
    }
}

