/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.components.WmiContextManager;
import com.maplesoft.mathdoc.controller.WmiClipboardManager;
import com.maplesoft.mathdoc.controller.WmiDocumentType;
import com.maplesoft.mathdoc.controller.WmiIndexedViewFactory;
import com.maplesoft.mathdoc.controller.WmiInputMethodRequestHandler;
import com.maplesoft.mathdoc.controller.WmiMathDocumentKeyListener;
import com.maplesoft.mathdoc.controller.WmiMathDocumentMouseListener;
import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiInputLock;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPathInterval;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.view.WmiAdaptiveLayoutView;
import com.maplesoft.mathdoc.view.WmiAggregateSelection;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiDefaultPositionUpdateHandler;
import com.maplesoft.mathdoc.view.WmiEightPointResizer;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiLayoutDecorator;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionInView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionUpdateHandler;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionChangeListener;
import com.maplesoft.mathdoc.view.WmiSelectionHighlighter;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class WmiMathDocumentView
extends JComponent
implements WmiCompositeView,
WmiPositionedView,
WmiScrollableContainerView,
InputMethodListener,
FocusListener,
Scrollable,
Autoscroll {
    protected static final int DEFAULT_INDENT = 5;
    public static final int BACKGROUND_COLOR_INDEX = 0;
    public static final int FOREGROUND_COLOR_INDEX = 1;
    public static final int CARET_COLOR_INDEX = 2;
    public static final int SELECTION_FOREGROUND_COLOR_INDEX = 3;
    public static final int SELECTION_BACKGROUND_COLOR_INDEX = 4;
    public static final int COLOR_INDEX_TABLE_SIZE = 5;
    public static final String RESOURCE_PREFIX = "TextPane";
    public static final int DEFAULT_BREAK_WIDTH = 400;
    protected static final int DEFAULT_WIDTH = 500;
    protected static final int DEFAULT_HEIGHT = 400;
    public static final Insets SCROLL_INSETS = new Insets(8, 8, 8, 8);
    public static final int SCROLL_INCREMENT = 15;
    public static final WmiDocumentType DOCUMENT_TYPE_DEFAULT = new WmiDocumentType();
    public static final String COMPONENT_VIEW_PROPERTY = "__WmiView__";
    public static final String COMPONENT_OFFSET_PROPERTY = "__WmiViewOffset__";
    public static final int LAYOUT_DELAY_TIMEOUT = 10;
    public static final Point CONTAINER_OFFSET = new Point(0, 0);
    protected WmiRowView rootView;
    private WmiMathDocumentModel model;
    private WmiViewFactory factory;
    protected int breakWidth = 400;
    protected int zoom = 133;
    protected int pendingBreakWidth = 400;
    private WmiPositionMarker marker;
    protected WmiMathDocumentMouseListener documentMouseListener = null;
    protected WmiMathDocumentKeyListener documentKeyListener = null;
    protected WmiView focusView = null;
    private WmiSelection currentSelection = null;
    private Color[] colorTable = null;
    protected WmiInputMethodRequestHandler inputHandler = null;
    private boolean isScrolling = false;
    private boolean pendingSelectionReset = false;
    private WmiModelPath pendingModelPath = null;
    private WmiPositionUpdateHandler pendingPositionHandler = null;
    private ArrayList positionHandlers = null;
    private Dimension docSize = null;
    private WmiLayoutDecorator layoutDecorator = null;
    private List highlightPainters = null;
    private int lastHorizontalPosition = 0;
    protected WmiContextManager contextManager = null;
    protected WmiClipboardManager clipboardManager = null;
    protected boolean isLayoutEnabled = true;
    protected boolean isRepaintEnabled = true;
    protected boolean isPainting = false;
    protected boolean isInLayout = false;
    protected Point pendingScrollPosition = null;
    protected ArrayList selectionChangeListeners = new ArrayList();
    private BufferedImage renderImage = null;
    private static WmiMathDocumentView activeDocumentView = null;
    private WmiScrollableContainerView activeContainerView = null;
    private Object activeContainerAccessLock = new Object();
    private boolean skipAutoexecWarning = false;

    public WmiMathDocumentView() {
        this(null, null);
    }

    public WmiMathDocumentView(WmiMathDocumentModel wmiMathDocumentModel, WmiViewFactory wmiViewFactory) {
        this.model = wmiMathDocumentModel != null ? wmiMathDocumentModel : new WmiMathDocumentModel();
        this.factory = wmiViewFactory != null ? wmiViewFactory : new WmiIndexedViewFactory();
        this.model.addModelListener(this.factory);
        this.rootView = this.createRootView(this.model, this.getDebugName());
        this.rootView.setParentView(this);
        this.factory.setRootView(this);
        this.marker = new WmiCaret(this);
        this.positionHandlers = new ArrayList();
        this.highlightPainters = new LinkedList();
        this.getClipboardManager();
        this.setFocusTraversalKeys(0, new TreeSet());
        this.setFocusTraversalKeys(1, new TreeSet());
        this.initializeColorTable();
        this.setLayout(null);
        this.setOpaque(true);
        this.registerTestKeys();
    }

    public void setContextManager(WmiContextManager wmiContextManager) {
        this.contextManager = wmiContextManager;
    }

    public WmiContextManager getContextManager() {
        return this.contextManager;
    }

    public void enableLayout(boolean bl) {
        this.isLayoutEnabled = bl;
    }

    public void enableRepaint(boolean bl) {
        this.isRepaintEnabled = true;
    }

    public WmiDocumentType getDocumentType() {
        return DOCUMENT_TYPE_DEFAULT;
    }

    public boolean isDocumentView() {
        return true;
    }

    public void appendView(WmiView wmiView) {
        if (this.rootView != null) {
            this.rootView.appendView(wmiView);
        }
    }

    public WmiView getChild(int n) {
        WmiView wmiView = null;
        if (this.rootView != null) {
            wmiView = this.rootView.getChild(n);
        }
        return wmiView;
    }

    public int getChildCount() {
        return this.rootView != null ? this.rootView.getChildCount() : 0;
    }

    public void replaceChild(WmiView wmiView, int n) {
    }

    public void removeChild(int n) {
    }

    public int indexOf(WmiView wmiView) {
        return this.rootView != null ? this.rootView.indexOf(wmiView) : -1;
    }

    public WmiModel getModel() {
        return this.model;
    }

    public WmiInputLock getInputLock() {
        return this.model.getInputLock();
    }

    public void updateView() throws WmiNoReadAccessException {
        if (this.rootView != null) {
            int n = this.getZoom();
            if (!this.isPrintView()) {
                float f = WmiFontResolver.DPI_SCALE_FACTOR;
                n = Math.round(f * (float)n);
            }
            if (n != this.zoom) {
                this.zoom = n;
                this.invalidateAll(this.rootView);
            }
            this.rootView.verifyReadLock();
            this.rootView.updateView();
        }
    }

    protected int getZoom() throws WmiNoReadAccessException {
        return ((WmiMathDocumentModel)this.getModel()).getZoomFactor();
    }

    public void markValid(int n) {
        if (this.rootView != null) {
            this.rootView.markValid(n);
        }
    }

    public void markInvalid(int n) {
        if (this.rootView != null) {
            this.rootView.markInvalid(n);
        }
    }

    public void release() {
        this.removeMouseListener(this.documentMouseListener);
        this.removeMouseMotionListener(this.documentMouseListener);
        this.removeKeyListener(this.documentKeyListener);
        this.removeInputMethodListener(this.inputHandler);
        if (this.model instanceof WmiMathDocumentModel) {
            this.model.removeModelListener(this.factory);
        }
        this.documentMouseListener = null;
        this.documentKeyListener = null;
        this.inputHandler = null;
        FocusListener[] focusListenerArray = this.getFocusListeners();
        for (int i = 0; i < focusListenerArray.length; ++i) {
            this.removeFocusListener(focusListenerArray[i]);
        }
        this.setPositionMarker(null);
        this.setSelection(null);
        this.rootView.release();
        this.rootView.setParentView(null);
        this.rootView = null;
        if (this.factory != null) {
            this.factory.releaseFactory();
            this.factory = null;
        }
        this.removeLayoutDecorator();
        this.resetKeyboardActions();
        if (this.clipboardManager != null) {
            this.clipboardManager.release();
            this.clipboardManager = null;
        }
        this.removeAll();
        if (this.positionHandlers != null) {
            this.positionHandlers.clear();
        }
        this.model = null;
        this.pendingModelPath = null;
        this.pendingPositionHandler = null;
        this.renderImage = null;
    }

    public boolean isLayoutValid() {
        return this.rootView.isLayoutValid();
    }

    public boolean isContentValid() {
        return this.rootView.isContentValid();
    }

    public void invalidate(int n) {
        if (this.rootView != null) {
            this.rootView.invalidate(n);
        }
    }

    public void invalidate() {
    }

    public void invalidateAll(WmiView wmiView) throws WmiNoReadAccessException {
        if (wmiView != null) {
            wmiView.invalidate(1);
            if (wmiView instanceof WmiCompositeView) {
                WmiCompositeView wmiCompositeView = (WmiCompositeView)wmiView;
                for (int i = 0; i < wmiCompositeView.getChildCount(); ++i) {
                    this.invalidateAll(wmiCompositeView.getChild(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBreakWidth() {
        this.calculatePendingBreakWidth();
        if (this.pendingBreakWidth != this.breakWidth) {
            boolean bl = false;
            try {
                bl = WmiModelLock.readLock(this.model, false);
                if (bl) {
                    this.breakWidth = this.pendingBreakWidth;
                    this.revalidateLayout();
                    this.layoutView();
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                if (bl) {
                    WmiModelLock.readUnlock(this.model);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutView() {
        if (this.rootView == null || !this.isLayoutEnabled) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        this.isInLayout = true;
        try {
            if (!WmiModelLock.ownsWriteLock(this.getModel())) {
                bl2 = WmiModelLock.readLock(this.getModel(), true);
            }
            this.calculatePendingBreakWidth();
            if (this.pendingBreakWidth != this.breakWidth) {
                bl = true;
                this.breakWidth = this.pendingBreakWidth;
                this.revalidateLayout();
            }
            if (!SwingUtilities.isEventDispatchThread()) {
                while (this.isPainting) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            Object object = this.getTreeLock();
            synchronized (object) {
                JViewport jViewport;
                Container container = this.getParent();
                JViewport jViewport2 = jViewport = container instanceof JViewport ? (JViewport)container : null;
                if (jViewport != null) {
                    jViewport.setScrollMode(0);
                }
                int n = this.rootView.getWidth();
                int n2 = this.rootView.getHeight();
                this.rootView.layoutView();
                if (this.rootView.getHeight() < n2) {
                    bl = true;
                    this.repaint(0, this.rootView.getHeight() - 1, Math.max(n, this.rootView.getWidth() + 1), n2 - this.rootView.getHeight() + 2);
                }
                if (this.rootView.getWidth() != n) {
                    bl = true;
                    if (this.currentSelection != null) {
                        this.currentSelection.resync();
                    }
                    this.repaint();
                }
                if (bl && this.marker != null) {
                    this.marker.resync();
                }
                int n3 = this.getRootViewLeftIndent();
                int n4 = Math.max(this.rootView.width, this.breakWidth) + 2 * n3;
                Dimension dimension = new Dimension(n4, this.rootView.height);
                this.rootView.x = n3;
                Rectangle rectangle = this.getVisibleRegion();
                if (rectangle != null) {
                    dimension.height = Math.max(dimension.height, rectangle.height);
                    dimension.width = Math.max(dimension.width, rectangle.width);
                }
                if (this.docSize == null || this.docSize.height != dimension.height || this.docSize.width != dimension.width) {
                    this.docSize = dimension;
                    this.setSize(dimension);
                    if (this.docSize.width != dimension.width) {
                        this.repaint();
                    } else if (dimension.height > this.docSize.height) {
                        this.repaint(0, this.docSize.height - 1, dimension.width + 1, dimension.height - this.docSize.height + 2);
                    }
                }
                this.rootView.paintDirty();
                this.layoutComponents();
                if (jViewport != null && this.pendingScrollPosition != null) {
                    SwingUtilities.invokeLater(new DelayedScroll((JViewport)container, this.pendingScrollPosition));
                    this.pendingScrollPosition = null;
                }
                if (this.layoutDecorator != null && this.layoutDecorator.isVisible()) {
                    this.layoutDecorator.layoutView();
                    this.layoutDecorator.repaint();
                }
                this.isInLayout = false;
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        finally {
            if (bl2) {
                WmiModelLock.readUnlock(this.getModel());
            }
        }
    }

    protected void layoutComponents() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Object object;
            Component component = this.getComponent(i);
            if (!(component instanceof JComponent) || !((object = ((JComponent)component).getClientProperty(COMPONENT_VIEW_PROPERTY)) instanceof WmiPositionedView)) continue;
            WmiPositionedView wmiPositionedView = (WmiPositionedView)object;
            Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
            Point point2 = (Point)((JComponent)component).getClientProperty(COMPONENT_OFFSET_PROPERTY);
            if (point2 != null) {
                point.x += point2.x;
                point.y += point2.y;
            }
            component.setLocation(point);
        }
    }

    protected int getRootViewLeftIndent() {
        return 5;
    }

    public void paintDirty() {
        if (this.rootView != null) {
            this.rootView.paintDirty();
        }
    }

    public void checkRepaint() {
        if (this.rootView != null) {
            this.rootView.checkRepaint();
        }
    }

    public void resetPaintFlags() {
        if (this.rootView != null) {
            this.rootView.resetPaintFlags();
        }
    }

    public void forceRepaint() {
        if (this.rootView != null) {
            this.rootView.forceRepaint();
        }
    }

    public boolean getCheckRepaint() {
        return this.rootView != null ? this.rootView.getCheckRepaint() : false;
    }

    public boolean getForceRepaint() {
        return this.rootView != null ? this.rootView.getForceRepaint() : false;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public String debugPrint(int n) throws WmiNoReadAccessException {
        return this.rootView != null ? this.rootView.debugPrint(n) : "";
    }

    public String getDebugName() {
        return "Document";
    }

    public WmiCompositeView getParentView() {
        return null;
    }

    public void setParentView(WmiCompositeView wmiCompositeView) {
        throw new UnsupportedOperationException();
    }

    public void setInputInhibit(boolean bl) {
        if (this.documentMouseListener != null) {
            this.documentMouseListener.setDispatchInhibit(bl);
        }
    }

    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getVisibleRegion();
        return rectangle != null ? new Insets(rectangle.y + WmiMathDocumentView.SCROLL_INSETS.top, rectangle.x + WmiMathDocumentView.SCROLL_INSETS.left, rectangle.y + rectangle.height - WmiMathDocumentView.SCROLL_INSETS.bottom, rectangle.x + rectangle.width - WmiMathDocumentView.SCROLL_INSETS.right) : null;
    }

    public void autoscroll(Point point) {
        Rectangle rectangle = this.getVisibleRegion();
        int n = 0;
        if (rectangle != null) {
            if (point.y < rectangle.y + WmiMathDocumentView.SCROLL_INSETS.top) {
                n = -15;
            } else if (point.y > rectangle.y + rectangle.height - WmiMathDocumentView.SCROLL_INSETS.bottom) {
                n = 15;
            }
            if (n != 0) {
                int n2;
                rectangle.y += n;
                if (rectangle.y < 0) {
                    rectangle.y = 0;
                }
                int n3 = n2 = this.rootView != null ? this.rootView.getHeight() : this.getHeight();
                if ((n2 -= rectangle.height) < 0) {
                    n2 = 0;
                }
                if (rectangle.y > n2) {
                    rectangle.y = n2;
                }
                this.setScrollPosition(rectangle.x, rectangle.y);
            }
        }
    }

    public WmiClipboardManager getClipboardManager() {
        if (this.clipboardManager == null) {
            this.clipboardManager = new WmiClipboardManager(this);
        }
        return this.clipboardManager;
    }

    public void setPositionMarker(int n) {
        if (this.rootView != null) {
            this.rootView.setPositionMarker(n);
        }
    }

    public int getBaseline() {
        int n = 0;
        if (this.rootView != null) {
            n = this.rootView.getBaseline();
        }
        return n;
    }

    public void setBaseline(int n) {
        if (this.rootView != null) {
            this.rootView.setBaseline(n);
        }
    }

    public void setHorizontalOffset(int n) {
        if (this.rootView != null) {
            this.rootView.setHorizontalOffset(n);
        }
    }

    public void setVerticalOffset(int n) {
        if (this.rootView != null) {
            this.rootView.setVerticalOffset(n);
        }
    }

    public int getHorizontalOffset() {
        int n = 0;
        if (this.rootView != null) {
            n = this.rootView.getHorizontalOffset();
        }
        return n;
    }

    public int getVerticalOffset() {
        int n = 0;
        if (this.rootView != null) {
            n = this.rootView.getVerticalOffset();
        }
        return n;
    }

    public WmiPositionedView getChildView(Point point) {
        WmiPositionedView wmiPositionedView = null;
        if (this.rootView != null) {
            wmiPositionedView = this.rootView.getChildView(point);
        }
        return wmiPositionedView;
    }

    public boolean getIntersectingChildViews(Shape shape, WmiAggregateSelection wmiAggregateSelection, int n) {
        return false;
    }

    public WmiPositionedView getViewForNavigation(int n, Point point) {
        return this.getNearestChildView(point);
    }

    public WmiPositionedView getNearestChildView(Point point) {
        WmiPositionedView wmiPositionedView = null;
        if (this.rootView != null) {
            wmiPositionedView = this.rootView.getNearestChildView(point);
        }
        return wmiPositionedView;
    }

    public void setHeight(int n) {
        if (this.rootView != null) {
            this.rootView.setHeight(n);
        }
        if (this.layoutDecorator != null) {
            this.layoutDecorator.setHeight(n);
        }
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        if (this.layoutDecorator != null) {
            this.layoutDecorator.setHeight(n2);
        }
    }

    public void setWidth(int n) {
        if (this.rootView != null) {
            this.rootView.setWidth(n);
        }
    }

    public boolean isBelowDocument(int n) {
        if (this.rootView != null) {
            return n > this.rootView.getHeight();
        }
        return false;
    }

    public WmiMathDocumentView getDocumentView() {
        return this;
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        boolean bl;
        Graphics2D graphics2D = null;
        Graphics graphics2 = graphics;
        boolean bl2 = bl = this.getSelection() == null;
        if (bl && (this.renderImage == null || this.renderImage.getWidth() < rectangle.width || this.renderImage.getHeight() < rectangle.height)) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            this.renderImage = graphicsConfiguration.createCompatibleImage(rectangle.width, rectangle.height);
        }
        if (this.renderImage != null && bl) {
            graphics2D = this.renderImage.createGraphics();
            ((Graphics)graphics2D).translate(-rectangle.x, -rectangle.y);
            graphics2 = graphics2D;
        }
        if (this.rootView != null && rectangle != null) {
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = rectangle.width;
            int n4 = rectangle.height;
            if (RuntimePlatform.isMac()) {
                wmiRenderPath.drawStringsWithGlyphVectors(false);
            }
            Color color = graphics.getColor();
            Rectangle rectangle2 = graphics.getClipBounds();
            if (this.isOpaque()) {
                graphics2.setColor(this.getColor(0));
                if (rectangle2 != null) {
                    n = Math.max(rectangle.x, rectangle2.x);
                    n2 = Math.max(rectangle.y, rectangle2.y);
                    n3 = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width) - n;
                    n4 = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height) - n2;
                }
                if (n3 > 0 && n4 > 0) {
                    graphics2.fillRect(n, n2, n3, n4);
                }
            }
            WmiSelection wmiSelection = this.getSelection();
            WmiHighlightPainter wmiHighlightPainter = null;
            boolean bl3 = false;
            if (wmiSelection != null && (wmiHighlightPainter = wmiSelection.getSelectionHighlighter()) != null) {
                boolean bl4 = this.activeContainer() == this;
                boolean bl5 = bl4 ? false : this.selectionIncludesContainer(this.activeContainer());
                boolean bl6 = bl3 = bl4 || bl5;
            }
            if (bl3 && wmiHighlightPainter.getDrawingLayer() == 0) {
                this.paintSelectionHighlightInContext(graphics2);
            }
            graphics2.setColor(color);
            if (this.isInLayout) {
                if (rectangle2 != null) {
                    this.repaint(rectangle2);
                } else {
                    this.repaint();
                }
            } else {
                if (rectangle2 != null) {
                    graphics2.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                this.rootView.draw(graphics2, wmiRenderPath, rectangle);
            }
            if (bl3 && wmiHighlightPainter.getDrawingLayer() == 1) {
                this.paintSelectionHighlightInContext(graphics2);
            }
            graphics2.setClip(null);
            if (this.highlightPainters != null) {
                Iterator iterator = this.highlightPainters.iterator();
                while (iterator.hasNext()) {
                    WmiHighlightPainter wmiHighlightPainter2 = (WmiHighlightPainter)iterator.next();
                    wmiHighlightPainter2.paint(graphics2);
                }
            }
            graphics2.setClip(rectangle2);
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics.drawImage(this.renderImage, n, n2, n + n3, n2 + n4, n - rectangle.x, n2 - rectangle.y, n - rectangle.x + n3, n2 - rectangle.y + n4, Color.WHITE, null);
            }
        }
    }

    public WmiCompositeModel getDeleteBoundary(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        return null;
    }

    public void doLayout() {
    }

    public void notifyMousePressed(MouseEvent mouseEvent) {
    }

    public Point getContainerOffset() {
        return CONTAINER_OFFSET;
    }

    public boolean mergeFragmentsOnUpdate() {
        return false;
    }

    public void addHighlightPainter(WmiHighlightPainter wmiHighlightPainter) {
        if (!this.highlightPainters.contains(wmiHighlightPainter)) {
            this.highlightPainters.add(wmiHighlightPainter);
        }
    }

    public void removeHighlightPainter(WmiHighlightPainter wmiHighlightPainter) {
        if (this.highlightPainters != null) {
            this.highlightPainters.remove(wmiHighlightPainter);
        }
    }

    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
    }

    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.marker != null) {
            this.marker.show();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.marker != null) {
            JRootPane jRootPane;
            JRootPane jRootPane2;
            Component component;
            boolean bl = true;
            if (!(this.marker instanceof WmiCaret) && (component = focusEvent.getOppositeComponent()) instanceof JComponent && (jRootPane2 = this.getRootPane()) == (jRootPane = ((JComponent)component).getRootPane())) {
                bl = false;
            }
            if (bl) {
                this.marker.hide();
            }
            if (this.marker instanceof WmiEightPointResizer) {
                this.getMouseListener().setDragViewToReceiveMove(false);
            }
        }
    }

    public WmiParagraphModel getCurrentParagraphModel() throws WmiNoReadAccessException {
        WmiPositionedView wmiPositionedView;
        WmiParagraphModel wmiParagraphModel = null;
        if (this.marker != null && (wmiPositionedView = this.marker.getView()) != null) {
            WmiModel wmiModel = wmiPositionedView.getModel();
            if (!(wmiModel instanceof WmiParagraphModel)) {
                wmiModel = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.PARAGRAPH);
            }
            if (wmiModel instanceof WmiParagraphModel) {
                wmiParagraphModel = (WmiParagraphModel)wmiModel;
            }
        }
        return wmiParagraphModel;
    }

    public void resetSelectionOnUpdate() throws WmiNoReadAccessException {
        this.pendingSelectionReset = true;
        this.pendingModelPath = null;
        if (this.currentSelection != null) {
            WmiModel[] wmiModelArray = new WmiModel[2];
            int[] nArray = new int[2];
            this.currentSelection.getModelInterval(wmiModelArray, nArray);
            WmiModel wmiModel = wmiModelArray[0];
            if (wmiModel != null) {
                this.pendingModelPath = new WmiModelPath(wmiModel);
                this.pendingModelPath.push(nArray[0]);
                this.pendingPositionHandler = null;
            }
        }
    }

    public void setPendingPositionUpdateHandler(WmiPositionUpdateHandler wmiPositionUpdateHandler) {
        this.pendingPositionHandler = wmiPositionUpdateHandler;
    }

    public void setPendingPosition(WmiModelPosition wmiModelPosition) {
        WmiDefaultPositionUpdateHandler wmiDefaultPositionUpdateHandler = new WmiDefaultPositionUpdateHandler(this, wmiModelPosition);
        this.setPendingPositionUpdateHandler(wmiDefaultPositionUpdateHandler);
    }

    public void setPendingPosition(WmiModel wmiModel, int n) {
        this.setPendingPosition(new WmiModelPosition(wmiModel, n));
    }

    public void addPositionUpdateHandler(WmiPositionUpdateHandler wmiPositionUpdateHandler) {
        if (!this.positionHandlers.contains(wmiPositionUpdateHandler)) {
            this.positionHandlers.add(wmiPositionUpdateHandler);
        }
    }

    public void removePositionUpdateHandler(WmiPositionUpdateHandler wmiPositionUpdateHandler) {
        this.positionHandlers.remove(wmiPositionUpdateHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchPositionUpdate() {
        for (int i = this.positionHandlers.size() - 1; i >= 0; --i) {
            WmiPositionUpdateHandler wmiPositionUpdateHandler = (WmiPositionUpdateHandler)this.positionHandlers.get(i);
            WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)this.getModel();
            boolean bl = WmiModelLock.ownsWriteLock(wmiMathDocumentModel);
            if (!bl && !WmiModelLock.readLock(wmiMathDocumentModel, true)) continue;
            try {
                wmiPositionUpdateHandler.updatePosition();
                continue;
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
                continue;
            }
            finally {
                if (!bl) {
                    WmiModelLock.readUnlock(wmiMathDocumentModel);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNotify() {
        boolean bl = false;
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)this.getModel();
        if (!WmiModelLock.ownsWriteLock(wmiMathDocumentModel)) {
            bl = WmiModelLock.readLock(wmiMathDocumentModel, true);
        }
        try {
            if (this.pendingPositionHandler != null) {
                this.pendingPositionHandler.updatePosition();
            } else if (this.pendingSelectionReset) {
                if (this.pendingModelPath != null) {
                    this.pendingModelPath = this.adjustModelPath(this.pendingModelPath);
                    this.updatePosition(this.pendingModelPath, 0);
                }
                this.setSelection(null);
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        finally {
            if (bl) {
                WmiModelLock.readUnlock(wmiMathDocumentModel);
            }
        }
        this.pendingSelectionReset = false;
        this.pendingModelPath = null;
        this.pendingPositionHandler = null;
    }

    public void notifyPopupRequest(WmiView wmiView, MouseEvent mouseEvent) {
        if (wmiView instanceof WmiPositionedView && !this.isInHighlight(mouseEvent, (WmiPositionedView)wmiView) && (this.getSelection() != null || this.marker == null || this.marker.getView() != wmiView)) {
            WmiMathDocumentMouseListener.snapToNearestView(mouseEvent, wmiView);
            WmiMathDocumentMouseListener.updateSelection(mouseEvent);
        }
    }

    protected void calculatePendingBreakWidth() {
        Container container = this.getParent();
        if (container instanceof JViewport) {
            Rectangle rectangle = ((JViewport)container).getViewRect();
            this.pendingBreakWidth = rectangle.width - 10;
        }
        if (this.pendingBreakWidth <= 0) {
            this.pendingBreakWidth = 400;
        }
    }

    protected WmiRowView createRootView(WmiModel wmiModel, String string) {
        return new WmiRowView(wmiModel, this, string);
    }

    private void registerTestKeys() {
        this.registerKeyboardAction(new DebugPrintAction(this, false, true), "Debug-Print-Light-Views", KeyStroke.getKeyStroke(112, 9, false), 2);
        this.registerKeyboardAction(new DebugPrintAction(this, true, true), "Debug-Print-Verbose-Views", KeyStroke.getKeyStroke(113, 9, false), 2);
        this.registerKeyboardAction(new DebugPrintAction(this, false, false), "Debug-Print-Light", KeyStroke.getKeyStroke(112, 8, false), 2);
        this.registerKeyboardAction(new DebugPrintAction(this, true, false), "Debug-Print-Verbose", KeyStroke.getKeyStroke(113, 8, false), 2);
    }

    protected void createListeners() {
        this.documentMouseListener = new WmiMathDocumentMouseListener(this);
        this.addMouseListener(this.documentMouseListener);
        this.addMouseMotionListener(this.documentMouseListener);
        this.addMouseWheelListener(this.documentMouseListener);
        this.addFocusListener(this);
        this.documentKeyListener = new WmiMathDocumentKeyListener(this);
        this.addKeyListener(this.documentKeyListener);
        if (RuntimePlatform.isWindows() || RuntimePlatform.isMac()) {
            this.inputHandler = new WmiInputMethodRequestHandler(this);
        }
        this.addInputMethodListener(this.inputHandler);
    }

    public void setFocusedView(WmiView wmiView) {
        this.focusView = wmiView;
        if (wmiView != null) {
            boolean bl;
            boolean bl2 = bl = !this.hasFocus();
            if (wmiView instanceof WmiPositionedView) {
                WmiPositionedView wmiPositionedView = (WmiPositionedView)wmiView;
                Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
                point.x += wmiPositionedView.getWidth() / 2;
                point.y += wmiPositionedView.getHeight() / 2;
                Component component = this.getComponentAt(point);
                if (component != null && component != this) {
                    bl = false;
                }
            }
            if (bl && WmiMathDocumentView.getActiveDocumentView() == this) {
                this.requestFocus();
            }
        }
        if (this.documentKeyListener != null) {
            this.documentKeyListener.setFocus(wmiView);
        }
    }

    public WmiView getFocusedView() {
        return this.focusView;
    }

    public void notifyMarkerPositionChanged() {
        if (this.contextManager != null) {
            this.contextManager.positionChangeNotification(this);
        }
        this.dispatchPositionUpdate();
    }

    public Point getLastMousePoint() {
        return this.documentMouseListener.getLastMousePoint();
    }

    public WmiView getDragSourceView() {
        return this.documentMouseListener.getDragSourceView();
    }

    public WmiView getDropTargetView() {
        return this.documentMouseListener.getDropTargetView();
    }

    public void notifyDragAndDropComplete(WmiModel wmiModel, Point point) {
        this.documentMouseListener.notifyDragAndDropComplete(wmiModel, point);
    }

    public void notifyViewLostFocus(WmiView wmiView) {
    }

    public WmiMathDocumentMouseListener getMouseListener() {
        return this.documentMouseListener;
    }

    public WmiMathDocumentKeyListener getKeyListener() {
        return this.documentKeyListener;
    }

    public WmiViewFactory getViewFactory() {
        return this.factory;
    }

    public WmiCaret getCaret() {
        return this.marker instanceof WmiCaret ? (WmiCaret)this.marker : null;
    }

    public WmiPositionMarker getPositionMarker() {
        return this.marker;
    }

    public boolean isMarkerInSubcontainer() {
        WmiPositionedView wmiPositionedView;
        boolean bl = false;
        if (this.marker != null && (wmiPositionedView = this.marker.getView()) != null) {
            bl = WmiViewUtil.isInSubcontainer(wmiPositionedView);
        }
        return bl;
    }

    public void setPositionMarker(WmiPositionMarker wmiPositionMarker) {
        if (this.marker != null) {
            this.marker.hide();
        }
        this.marker = wmiPositionMarker;
        if (this.marker != null) {
            this.marker.show();
        }
        this.notifyMarkerPositionChanged();
    }

    protected WmiModelPath adjustModelPath(WmiModelPath wmiModelPath) throws WmiNoReadAccessException {
        WmiModelPath wmiModelPath2 = wmiModelPath;
        WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)this.getModel();
        int n = wmiModelPath.depth();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            block7: {
                Object object;
                int n3 = wmiModelPath.peek(i);
                if (n3 < wmiCompositeModel.getChildCount()) {
                    nArray[i] = n3;
                    WmiModel wmiModel = wmiCompositeModel.getChild(n3);
                    if (!(wmiModel instanceof WmiCompositeModel)) break;
                    wmiCompositeModel = (WmiCompositeModel)wmiModel;
                    continue;
                }
                n2 = i;
                if (wmiCompositeModel.getChildCount() == 0) {
                    wmiCompositeModel = wmiCompositeModel.getParent();
                    --n2;
                }
                while (true) {
                    if (n2 + 1 >= n) {
                        object = new int[2 * n];
                        System.arraycopy(nArray, 0, object, 0, n);
                        nArray = object;
                        n *= 2;
                    }
                    if ((n3 = wmiCompositeModel.getChildCount()) <= 0) break block7;
                    nArray[n2++] = n3 - 1;
                    object = wmiCompositeModel.getChild(n3 - 1);
                    if (!(object instanceof WmiCompositeModel)) break;
                    wmiCompositeModel = (WmiCompositeModel)object;
                }
                if (object instanceof WmiTextModel) {
                    nArray[n2++] = ((WmiTextModel)object).getLength();
                }
            }
            wmiModelPath2 = new WmiModelPath();
            for (int j = 0; j < n2; ++j) {
                wmiModelPath2.push(nArray[j]);
            }
            break;
        }
        return wmiModelPath2;
    }

    public void updatePosition(WmiModelPath wmiModelPath, int n) throws WmiNoReadAccessException {
        this.updatePosition(wmiModelPath.getModelPosition((WmiMathDocumentModel)this.getModel()), n);
    }

    public void updatePosition(WmiModelPosition wmiModelPosition, int n) throws WmiNoReadAccessException {
        boolean bl = false;
        if (wmiModelPosition != null) {
            Object object;
            WmiModel wmiModel = wmiModelPosition.getModel();
            int n2 = wmiModelPosition.getOffset();
            if (wmiModel instanceof WmiMathSpaceModel && WmiViewUtil.modelToView(this, wmiModel, 0) == null) {
                int n3;
                object = wmiModel.getParent();
                int n4 = n3 = object != null ? object.indexOf(wmiModel) : -1;
                if (n3 >= 0) {
                    wmiModelPosition = new WmiModelPosition((WmiModel)object, n3 + 1);
                    this.updatePosition(wmiModelPosition, n);
                    return;
                }
            }
            if (wmiModel instanceof WmiCompositeModel) {
                WmiModel wmiModel2;
                object = WmiViewUtil.modelToView(this, wmiModel, 0);
                if (object == null && wmiModel instanceof WmiMathFencedModel) {
                    WmiMathFencedModel wmiMathFencedModel = (WmiMathFencedModel)wmiModel;
                    if (n2 == 0) {
                        wmiModel2 = wmiMathFencedModel.getModelForLeft();
                        if (wmiModel2 != null) {
                            wmiModel = wmiModel2;
                            n2 = 0;
                            object = WmiViewUtil.modelToView(this, wmiModel, 0);
                        }
                    } else if (n2 == -1 && (wmiModel2 = wmiMathFencedModel.getModelForRight()) != null) {
                        wmiModel = wmiModel2;
                        n2 = -1;
                        object = WmiViewUtil.modelToView(this, wmiModel, 0);
                    }
                }
                if (WmiViewUtil.isTraversableView((WmiView)object)) {
                    ((WmiPositionedView)object).setPositionMarker(n2);
                    bl = true;
                } else {
                    while (wmiModel instanceof WmiCompositeModel) {
                        WmiCompositeModel wmiCompositeModel;
                        WmiModelTag wmiModelTag = wmiModel.getTag();
                        if (wmiModel instanceof WmiMathModel && wmiModelTag != WmiModelTag.MATH && wmiModelTag != WmiModelTag.MATH_ROW && wmiModelTag != WmiModelTag.MATH_TABLE_CELL && wmiModelTag != WmiModelTag.MATH_TABLE_ROW && wmiModelTag != WmiModelTag.MATH_TABLE_LABELED_ROW) break;
                        wmiModel2 = (WmiCompositeModel)wmiModel;
                        int n5 = wmiModel2.getChildCount();
                        if (n5 > 0 && n2 < n5) {
                            if (n2 >= 0) {
                                wmiModel = wmiModel2.getChild(n2);
                                n2 = 0;
                                continue;
                            }
                            wmiModel = wmiModel2.getChild(n5 - 1);
                            n2 = -1;
                            continue;
                        }
                        WmiModel wmiModel3 = null;
                        while (wmiModel3 == null && wmiModel2 != null && (wmiCompositeModel = wmiModel2.getParent()) != null) {
                            int n6 = wmiCompositeModel.indexOf(wmiModel2);
                            if (n6 < wmiCompositeModel.getChildCount() - 1) {
                                wmiModel3 = wmiCompositeModel.getChild(n6 + 1);
                                continue;
                            }
                            wmiModel2 = wmiCompositeModel;
                        }
                        wmiModel = wmiModel3;
                        n2 = 0;
                    }
                }
            }
            if (wmiModel instanceof WmiMathModel && !bl) {
                object = this.getCaret();
                if (!(object instanceof WmiMathCaret)) {
                    object = new WmiMathCaret(this);
                    this.setPositionMarker((WmiPositionMarker)object);
                }
                ((WmiCaret)object).updateMarkerPosition(wmiModel, n2);
                bl = true;
            } else if (wmiModel instanceof WmiTextModel && !bl) {
                object = this.getCaret();
                if (object == null || object instanceof WmiMathCaret) {
                    object = new WmiCaret(this);
                    this.setPositionMarker((WmiPositionMarker)object);
                }
                ((WmiCaret)object).updateMarkerPosition(wmiModel, n2);
                bl = true;
            } else if (wmiModel != null && !bl && (object = WmiViewUtil.modelToView(this, wmiModel, 0)) instanceof WmiPositionedView) {
                ((WmiPositionedView)object).setPositionMarker(n2);
                bl = true;
            }
        }
        if (!bl) {
            this.setPositionMarker(null);
        }
        if (this.marker != null) {
            if (n == 1) {
                this.marker.scrollVisible();
            } else if (n == 2) {
                this.marker.scrollToTop();
            }
        }
    }

    public WmiSelection getSelection() {
        return this.currentSelection;
    }

    public void setSelection(WmiSelection wmiSelection) {
        WmiHighlightPainter wmiHighlightPainter = null;
        WmiHighlightPainter wmiHighlightPainter2 = null;
        if (this.currentSelection != null) {
            wmiHighlightPainter = this.currentSelection.getSelectionHighlighter();
        }
        if (wmiSelection != null) {
            wmiHighlightPainter2 = wmiSelection.getSelectionHighlighter();
        }
        if (wmiHighlightPainter2 == null && wmiHighlightPainter instanceof WmiSelectionHighlighter) {
            ((WmiSelectionHighlighter)wmiHighlightPainter).computeDirtyRegions(null);
            ((WmiSelectionHighlighter)wmiHighlightPainter).repaintDirtyRegions();
        } else if (wmiHighlightPainter2 instanceof WmiSelectionHighlighter) {
            ((WmiSelectionHighlighter)wmiHighlightPainter2).computeDirtyRegions(wmiHighlightPainter);
        }
        this.currentSelection = wmiSelection;
        this.fireSelectionChangeNotification(this.currentSelection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSelectionChangeNotification(WmiSelection wmiSelection) {
        ArrayList arrayList = this.selectionChangeListeners;
        synchronized (arrayList) {
            Iterator iterator = this.selectionChangeListeners.iterator();
            while (iterator.hasNext()) {
                WmiSelectionChangeListener wmiSelectionChangeListener = (WmiSelectionChangeListener)iterator.next();
                wmiSelectionChangeListener.notifySelectionChange(wmiSelection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionChangeListener(WmiSelectionChangeListener wmiSelectionChangeListener) {
        ArrayList arrayList = this.selectionChangeListeners;
        synchronized (arrayList) {
            if (!this.selectionChangeListeners.contains(wmiSelectionChangeListener)) {
                this.selectionChangeListeners.add(wmiSelectionChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionChangeListener(WmiSelectionChangeListener wmiSelectionChangeListener) {
        ArrayList arrayList = this.selectionChangeListeners;
        synchronized (arrayList) {
            if (this.selectionChangeListeners.contains(wmiSelectionChangeListener)) {
                this.selectionChangeListeners.remove(wmiSelectionChangeListener);
            }
        }
    }

    protected void removeLayoutDecorator() {
        if (this.layoutDecorator != null) {
            this.layoutDecorator.release();
        }
        this.layoutDecorator = null;
    }

    public WmiLayoutDecorator getLayoutDecorator() {
        return this.layoutDecorator;
    }

    public void setLayoutDecorator(WmiLayoutDecorator wmiLayoutDecorator) {
        if (wmiLayoutDecorator == this.layoutDecorator) {
            return;
        }
        this.removeLayoutDecorator();
        this.layoutDecorator = wmiLayoutDecorator;
        this.invalidate(1);
        final WmiMathDocumentView wmiMathDocumentView = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                wmiMathDocumentView.layoutView();
            }
        });
    }

    public int getZoomFactor() {
        return this.zoom;
    }

    public void setTemporaryZoomFactor(int n) {
        this.zoom = n;
    }

    public WmiView copyView() {
        return null;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Serializable serializable;
        Rectangle rectangle;
        int n;
        if (this.isInLayout) {
            if (this.renderImage != null) {
                int n2 = this.renderImage.getWidth();
                n = this.renderImage.getHeight();
                rectangle = this.getVisibleRegion();
                graphics.translate(rectangle.x, rectangle.y);
                graphics.drawImage(this.renderImage, 0, 0, n2, n, 0, 0, n2, n, Color.WHITE, null);
                graphics.translate(-rectangle.x, -rectangle.y);
            }
            if ((serializable = graphics.getClipBounds()) != null) {
                this.repaint((Rectangle)serializable);
            } else {
                this.repaint();
            }
        }
        if (this.isRepaintEnabled) {
            this.isPainting = true;
            try {
                serializable = this.getParent();
                n = serializable instanceof JViewport && ((JViewport)serializable).getScrollMode() != 1 && !this.isInLayout ? 1 : 0;
                rectangle = this.getVisibleRegion();
                Graphics2D graphics2D = (Graphics2D)graphics;
                Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                FontRenderContext fontRenderContext = WmiFontMetrics.getScreenContext();
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, fontRenderContext.isAntiAliased() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                this.draw(graphics, new WmiRenderPath(this), rectangle);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
                if (this.getComponentCount() > 0) {
                    this.paintChildren(graphics);
                }
                if (serializable instanceof JViewport) {
                    if (this.pendingScrollPosition != null) {
                        SwingUtilities.invokeLater(new DelayedScroll((JViewport)serializable, this.pendingScrollPosition));
                        this.pendingScrollPosition = null;
                    }
                    if (n != 0) {
                        ((JViewport)serializable).setScrollMode(1);
                    }
                }
                this.paintMarkerInContext(graphics);
                this.pendingScrollPosition = null;
            }
            finally {
                this.isPainting = false;
            }
        }
    }

    public void paintMarkerInContext(Graphics graphics) {
        boolean bl;
        WmiSelection wmiSelection = this.getSelection();
        boolean bl2 = bl = this.clipboardManager != null ? this.clipboardManager.isEnabled() : false;
        if (!(this.marker == null || !bl && wmiSelection != null && wmiSelection.hideCaret() && this.marker instanceof WmiCaret)) {
            this.marker.paint(graphics);
        }
    }

    public void paintSelectionHighlightInContext(Graphics graphics) {
        WmiHighlightPainter wmiHighlightPainter;
        WmiSelection wmiSelection = this.getSelection();
        if (wmiSelection != null && (wmiHighlightPainter = wmiSelection.getSelectionHighlighter()) != null) {
            wmiHighlightPainter.paint(graphics);
        }
    }

    public boolean selectionIncludesContainer(WmiView wmiView) {
        boolean bl = false;
        if (this.currentSelection != null && wmiView != null) {
            bl = this.currentSelection.contains(wmiView) == 2;
        }
        return bl;
    }

    public int getBreakWidth() {
        return this.breakWidth;
    }

    public Rectangle getVisibleRegion() {
        Rectangle rectangle = null;
        Container container = this.getParent();
        rectangle = container instanceof JViewport ? ((JViewport)container).getViewRect() : this.getBounds();
        return rectangle;
    }

    public void setVisibleRegion(int n, int n2) {
        Container container;
        Point point = new Point(n, n2);
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        if ((container = this.getParent()) instanceof JViewport) {
            if (this.isInLayout || this.isPainting) {
                this.pendingScrollPosition = point;
            } else {
                ((JViewport)container).setViewPosition(point);
            }
        }
    }

    public void setScrollPosition(int n, int n2, boolean bl) {
        if (this.isScrolling()) {
            return;
        }
        Container container = this.getParent();
        if (container instanceof JViewport) {
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (this.isInLayout || this.isPainting) {
                this.pendingScrollPosition = new Point(n, n2);
            } else {
                JViewport jViewport = (JViewport)container;
                if (bl) {
                    Thread thread = new Thread(new Scroller(jViewport, n, n2));
                    thread.setName("live scroller");
                    thread.setPriority(10);
                    thread.start();
                } else {
                    jViewport.setViewPosition(new Point(n, n2));
                }
            }
        }
    }

    public void setScrollPosition(int n, int n2) {
        this.setScrollPosition(n, n2, false);
    }

    public void setScrollPositionToView(WmiPositionedView wmiPositionedView) {
        Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
        this.setScrollPosition(0, point.y, true);
    }

    public synchronized boolean isScrolling() {
        return this.isScrolling;
    }

    public boolean isPrintView() {
        return false;
    }

    public Cursor getDefaultCursor() {
        return Cursor.getPredefinedCursor(2);
    }

    protected void revalidateLayout() throws WmiNoReadAccessException {
        this.invalidate(this.rootView, WmiModelTag.PARAGRAPH);
        this.invalidateAdaptiveViews(this.rootView);
    }

    public void invalidate(WmiView wmiView, WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        WmiModelTag wmiModelTag2;
        WmiModel wmiModel = wmiView != null ? wmiView.getModel() : null;
        WmiModelTag wmiModelTag3 = wmiModelTag2 = wmiModel != null ? wmiModel.getTag() : null;
        if (wmiModelTag2 != null && wmiModelTag2.equals(wmiModelTag)) {
            wmiView.invalidate(1);
        } else if (wmiView instanceof WmiCompositeView) {
            WmiCompositeView wmiCompositeView = (WmiCompositeView)wmiView;
            int n = wmiCompositeView.getChildCount();
            for (int i = 0; i < n; ++i) {
                WmiView wmiView2 = wmiCompositeView.getChild(i);
                this.invalidate(wmiView2, wmiModelTag);
            }
        }
    }

    protected void invalidateAdaptiveViews(WmiView wmiView) {
        if (wmiView instanceof WmiAdaptiveLayoutView) {
            wmiView.invalidate(1);
        }
        if (wmiView instanceof WmiCompositeView) {
            WmiCompositeView wmiCompositeView = (WmiCompositeView)wmiView;
            int n = wmiCompositeView.getChildCount();
            for (int i = 0; i < n; ++i) {
                WmiView wmiView2 = wmiCompositeView.getChild(i);
                this.invalidateAdaptiveViews(wmiView2);
            }
        }
    }

    public void invalidate(WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        this.invalidate(this.rootView, wmiModelTag);
    }

    public boolean isRequestFocusEnabled() {
        return true;
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    public InputMethodRequests getInputMethodRequests() {
        return this.inputHandler;
    }

    public Color getColor(int n) {
        Color color = null;
        if (n >= 0 && n < 5) {
            color = this.colorTable[n];
        }
        return color;
    }

    public void setColor(Color color, int n) {
        if (n >= 0 && n < 5) {
            this.colorTable[n] = color;
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.setColor(color, 0);
    }

    public Color getBackground() {
        return this.getColor(0);
    }

    public void updateUI() {
        this.initializeColorTable();
    }

    private void initializeColorTable() {
        String string = RESOURCE_PREFIX;
        this.colorTable = new Color[5];
        this.colorTable[0] = UIManager.getColor(string + ".background");
        this.colorTable[1] = UIManager.getColor(string + ".foreground");
        this.colorTable[2] = UIManager.getColor(string + ".caretForeground");
        this.colorTable[4] = UIManager.getColor(string + ".selectionBackground");
        this.colorTable[3] = UIManager.getColor(string + ".selectionForeground");
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 0;
        if (n == 0) {
            n3 = (int)rectangle.getWidth();
        } else if (n == 1) {
            n3 = (int)rectangle.getHeight();
        }
        return n3;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 15;
    }

    public static WmiMathDocumentView getActiveDocumentView() {
        return activeDocumentView;
    }

    public static void setActiveDocumentView(WmiMathDocumentView wmiMathDocumentView) {
        activeDocumentView = wmiMathDocumentView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WmiScrollableContainerView activeContainer() {
        WmiScrollableContainerView wmiScrollableContainerView = null;
        Object object = this.activeContainerAccessLock;
        synchronized (object) {
            wmiScrollableContainerView = this.activeContainerView;
        }
        return wmiScrollableContainerView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveContainer(WmiScrollableContainerView wmiScrollableContainerView) {
        Object object = this.activeContainerAccessLock;
        synchronized (object) {
            this.activeContainerView = wmiScrollableContainerView;
        }
    }

    public WmiPositionedView getNextView(int n) {
        return null;
    }

    public void setNextView(WmiPositionedView wmiPositionedView, int n) {
        if (this.rootView != null) {
            this.rootView.setNextView(wmiPositionedView, n);
        }
    }

    public void addNavigationLinks() {
        if (this.rootView != null) {
            this.rootView.addNavigationLinks();
        }
    }

    public boolean isNavagableView() {
        return true;
    }

    public boolean isInHighlight(MouseEvent mouseEvent) {
        boolean bl = false;
        WmiHighlightPainter wmiHighlightPainter = this.currentSelection != null ? this.currentSelection.getSelectionHighlighter() : null;
        WmiPositionInView wmiPositionInView = WmiViewUtil.getPositionInView(mouseEvent);
        Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionInView.getView());
        point.translate(wmiPositionInView.getPosition().x, wmiPositionInView.getPosition().y);
        if (wmiHighlightPainter != null) {
            bl = wmiHighlightPainter.isInsideHighlight(point);
        }
        return bl;
    }

    public boolean isInHighlight(WmiPositionedView wmiPositionedView) {
        boolean bl = false;
        WmiHighlightPainter wmiHighlightPainter = this.currentSelection != null ? this.currentSelection.getSelectionHighlighter() : null;
        Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
        if (wmiHighlightPainter != null && wmiHighlightPainter.isInsideHighlight(point)) {
            bl = true;
        }
        return bl;
    }

    public boolean isInHighlight(MouseEvent mouseEvent, WmiPositionedView wmiPositionedView) {
        boolean bl = false;
        WmiSelection wmiSelection = this.getSelection();
        try {
            bl = this.isInHighlight(mouseEvent);
        }
        catch (NullPointerException nullPointerException) {
            bl = this.isInHighlight(wmiPositionedView);
        }
        return bl;
    }

    public int getLastHorizontalPosition() {
        return this.lastHorizontalPosition;
    }

    public void saveLastHorizontalPosition() {
        WmiPositionMarker wmiPositionMarker = this.getPositionMarker();
        if (wmiPositionMarker != null) {
            this.lastHorizontalPosition = wmiPositionMarker instanceof WmiMathCaret ? ((WmiMathCaret)wmiPositionMarker).getUprightPosition() : wmiPositionMarker.getBounds().x;
        }
    }

    public void insertView(WmiView wmiView, int n) {
    }

    public WmiView splitView(int n, int n2) {
        return null;
    }

    public int doExplicitLinebreak(WmiParagraphView wmiParagraphView) {
        return 0;
    }

    public int doImplicitLinebreak(WmiParagraphView wmiParagraphView, int n, int n2, int n3) {
        return 0;
    }

    public int doForcedLinebreak(WmiParagraphView wmiParagraphView, int n, int n2) {
        return 0;
    }

    public boolean hasGoodBreakpoint(int n, int n2, int n3) throws WmiNoReadAccessException {
        return false;
    }

    public int getWidthConstraint(boolean bl) {
        return bl ? -1 : this.getBreakWidth();
    }

    public int getHeightConstraint() {
        return -1;
    }

    public boolean getSkipAutoexecWarning() {
        return this.skipAutoexecWarning;
    }

    public void setSkipAutoexecWarning(boolean bl) {
        this.skipAutoexecWarning = bl;
    }

    private class DelayedScroll
    implements Runnable {
        JViewport port;
        Point pt;

        private DelayedScroll(JViewport jViewport, Point point) {
            this.port = jViewport;
            this.pt = point;
        }

        public void run() {
            if (WmiMathDocumentView.this.isPainting || WmiMathDocumentView.this.isInLayout) {
                SwingUtilities.invokeLater(this);
            } else {
                WmiMathDocumentView.this.repaint();
                this.port.setViewPosition(this.pt);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WmiMathDocumentView.this.repaint();
                    }
                });
            }
        }
    }

    private static class DebugPrintAction
    implements ActionListener {
        private boolean isVerbose = false;
        private boolean views = false;
        private WmiMathDocumentView view;

        private DebugPrintAction(WmiMathDocumentView wmiMathDocumentView, boolean bl, boolean bl2) {
            this.view = wmiMathDocumentView;
            this.isVerbose = bl;
            this.views = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)this.view.getModel();
            if (WmiModelLock.readLock(wmiMathDocumentModel, true)) {
                try {
                    WmiModelPathInterval wmiModelPathInterval = null;
                    WmiSelection wmiSelection = this.view.getSelection();
                    if (wmiSelection != null) {
                        WmiViewPath wmiViewPath = wmiSelection.getSelectionStartPath();
                        WmiViewPath wmiViewPath2 = wmiSelection.getSelectionEndPath();
                        WmiModelPath wmiModelPath = new WmiModelPath(wmiViewPath.createModelPosition(this.view));
                        WmiModelPath wmiModelPath2 = new WmiModelPath(wmiViewPath2.createModelPosition(this.view));
                        wmiModelPathInterval = new WmiModelPathInterval(wmiModelPath, wmiModelPath2);
                    }
                    if (this.isVerbose) {
                        wmiMathDocumentModel.debugPrintVerbose(wmiModelPathInterval);
                    } else {
                        wmiMathDocumentModel.debugPrintLight(wmiModelPathInterval);
                    }
                    if (this.views) {
                        System.out.println(this.view.debugPrint(0));
                    }
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                }
                finally {
                    WmiModelLock.readUnlock(wmiMathDocumentModel);
                }
            }
        }
    }

    private class Scroller
    implements Runnable {
        public static final int DEFAULT_SCROLL_TIME = 300;
        public static final int DEFAULT_SCROLL_STEPS = 20;
        private static final int MINIMUM_SCROLL_WAIT_TIME = 20;
        private int scrollTime = -1;
        private int scrollSteps = -1;
        private long scrollStartTime = -1L;
        private JViewport viewport = null;
        private int scrollEndX = -1;
        private int scrollEndY = -1;

        private Scroller(JViewport jViewport, int n, int n2, int n3, int n4) {
            this.viewport = jViewport;
            this.scrollTime = n;
            this.scrollSteps = n2;
            this.scrollEndX = n3;
            this.scrollEndY = n4;
        }

        private Scroller(JViewport jViewport, int n, int n2) {
            this(jViewport, 300, 20, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.scrollStartTime = System.currentTimeMillis();
            Point point = this.viewport.getViewPosition();
            int n = Math.max(20, this.scrollTime / this.scrollSteps);
            int n2 = (this.scrollEndX - point.x) / this.scrollSteps;
            int n3 = (this.scrollEndY - point.y) / this.scrollSteps;
            try {
                WmiMathDocumentView wmiMathDocumentView = WmiMathDocumentView.this;
                synchronized (wmiMathDocumentView) {
                    WmiMathDocumentView.this.isScrolling = true;
                }
                for (int i = 1; i <= this.scrollSteps; ++i) {
                    int n4;
                    int n5;
                    int n6 = (int)(System.currentTimeMillis() - this.scrollStartTime) * this.scrollSteps;
                    n6 /= this.scrollTime;
                    if (++n6 > i) {
                        i = n6;
                    }
                    boolean bl = false;
                    boolean bl2 = false;
                    int n7 = n5 = n2 < 0 ? Math.max(this.scrollEndX, point.x + (i + 1) * n2) : Math.min(this.scrollEndX, point.x + (i + 1) * n2);
                    if (n5 + this.viewport.getWidth() > WmiMathDocumentView.this.getWidth()) {
                        n5 = WmiMathDocumentView.this.getWidth() - this.viewport.getWidth();
                        bl = true;
                    }
                    if (n5 < 0) {
                        n5 = 0;
                        bl = true;
                    }
                    int n8 = n4 = n3 < 0 ? Math.max(this.scrollEndY, point.y + (i + 1) * n3) : Math.min(this.scrollEndY, point.y + (i + 1) * n3);
                    if (n4 + this.viewport.getHeight() > WmiMathDocumentView.this.getHeight()) {
                        n4 = WmiMathDocumentView.this.getHeight() - this.viewport.getHeight();
                        bl2 = true;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                        bl2 = true;
                    }
                    SwingUtilities.invokeLater(new DelayedScroll(this.viewport, new Point(n5, n4)));
                    if (n5 == this.scrollEndX || bl) {
                        if (n4 == this.scrollEndY) break;
                        if (bl2) {
                            break;
                        }
                    }
                    WmiMathDocumentView wmiMathDocumentView2 = WmiMathDocumentView.this;
                    synchronized (wmiMathDocumentView2) {
                        WmiMathDocumentView.this.wait(n);
                        continue;
                    }
                }
            }
            catch (Exception exception) {
                WmiErrorLog.log(exception);
            }
            finally {
                WmiMathDocumentView wmiMathDocumentView = WmiMathDocumentView.this;
                synchronized (wmiMathDocumentView) {
                    WmiMathDocumentView.this.isScrolling = false;
                }
            }
        }
    }
}

