/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.util;

public class WmiMutex {
    public static final long FOREVER = Long.MAX_VALUE;
    private Thread owner = null;
    private int lockCount = 0;

    public synchronized boolean acquire(long l) throws InterruptedException {
        boolean bl = false;
        if (l == 0L) {
            bl = this.acquireWithoutBlocking();
        } else if (l == Long.MAX_VALUE) {
            while (!this.acquireWithoutBlocking()) {
                this.wait(Long.MAX_VALUE);
            }
            bl = true;
        } else {
            long l2;
            long l3 = System.currentTimeMillis() + l;
            while (!(bl = this.acquireWithoutBlocking()) && (l2 = l3 - System.currentTimeMillis()) > 0L) {
                this.wait(l2);
            }
        }
        return bl;
    }

    public void acquire() throws InterruptedException {
        this.acquire(Long.MAX_VALUE);
    }

    private boolean acquireWithoutBlocking() {
        Thread thread = Thread.currentThread();
        if (this.owner == null) {
            this.owner = thread;
            this.lockCount = 1;
        } else if (this.owner == thread) {
            ++this.lockCount;
        }
        return this.owner == thread;
    }

    public synchronized void release() {
        if (this.owner != Thread.currentThread()) {
            throw new OwnershipException();
        }
        if (--this.lockCount <= 0) {
            this.owner = null;
            this.notify();
        }
    }

    public static class OwnershipException
    extends RuntimeException {
        public OwnershipException() {
            super("Attempt by non-owner thread to release a mutex.");
        }

        public OwnershipException(String string) {
            super(string);
        }
    }
}

