/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.util;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import java.util.Arrays;

public abstract class WmiAncestorPath
implements Cloneable,
Comparable {
    protected static final int DEFAULT_CAPACITY = 10;
    protected static final float GROWTH_FACTOR = 1.5f;
    public static final int SELECT_NONE = 0;
    public static final int SELECT_PARTIAL = 1;
    public static final int SELECT_FULL = 2;
    protected int[] path;
    protected int length = 0;

    protected WmiAncestorPath() {
        this.ensureCapacity(10);
    }

    protected WmiAncestorPath(WmiAncestorPath wmiAncestorPath) {
        this.length = wmiAncestorPath.length;
        this.path = new int[this.length];
        System.arraycopy(wmiAncestorPath.path, 0, this.path, 0, this.length);
    }

    private void ensureCapacity(int n) {
        if (this.path == null) {
            this.path = new int[n];
        } else if (this.path.length < n) {
            int n2 = (int)(1.5f * (float)this.path.length);
            if (n2 < n) {
                n2 = n;
            }
            int[] nArray = new int[n2];
            System.arraycopy(this.path, 0, nArray, 0, this.path.length);
            this.path = nArray;
        }
    }

    public int depth() {
        return this.length;
    }

    public boolean greaterThan(WmiAncestorPath wmiAncestorPath) {
        int n = this.compareTo(wmiAncestorPath);
        if (n == 0 && this.length > wmiAncestorPath.depth()) {
            n = 1;
        }
        return n > 0;
    }

    public void next() {
        if (this.length > 0) {
            int n = this.length - 1;
            this.path[n] = this.path[n] + 1;
        }
    }

    public void prev() {
        if (this.length > 0) {
            int n = this.length - 1;
            this.path[n] = this.path[n] - 1;
        }
    }

    public int peek(int n) {
        int n2 = -1;
        if (n >= 0 && n < this.length) {
            n2 = this.path[n];
        }
        return n2;
    }

    public void poke(int n, int n2) {
        if (n >= 0 && n < this.length && n2 >= 0) {
            this.path[n] = n2;
        }
    }

    public int pop() {
        int n = this.top();
        --this.length;
        return n;
    }

    public int top() {
        return this.peek(this.length - 1);
    }

    public void push(int n) {
        this.ensureCapacity(this.length + 1);
        this.path[this.length++] = n;
    }

    public int compareTo(Object object) {
        WmiAncestorPath wmiAncestorPath = (WmiAncestorPath)object;
        int n = Math.min(this.length, wmiAncestorPath.length);
        int n2 = 0;
        for (int i = 0; i < n && n2 == 0; ++i) {
            n2 = wmiAncestorPath.peek(i) < 0 ? (this.peek(i) < 0 ? 0 : -1) : (this.peek(i) < 0 ? 1 : this.peek(i) - wmiAncestorPath.peek(i));
        }
        return n2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof WmiAncestorPath) {
            WmiAncestorPath wmiAncestorPath = (WmiAncestorPath)object;
            bl = this.depth() == wmiAncestorPath.depth() && this.compareTo(object) == 0;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("path:[");
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append(this.path[i]);
            if (i >= this.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static WmiAncestorPath commonPath(WmiAncestorPath wmiAncestorPath, WmiAncestorPath wmiAncestorPath2) {
        WmiAncestorPath wmiAncestorPath3 = null;
        try {
            wmiAncestorPath3 = (WmiAncestorPath)wmiAncestorPath.clone();
            wmiAncestorPath3.length = 0;
            Arrays.fill(wmiAncestorPath3.path, 0);
            if (wmiAncestorPath != null && wmiAncestorPath2 != null) {
                WmiAncestorPath wmiAncestorPath4 = (WmiAncestorPath)wmiAncestorPath.clone();
                WmiAncestorPath wmiAncestorPath5 = (WmiAncestorPath)wmiAncestorPath2.clone();
                while (wmiAncestorPath4.depth() > wmiAncestorPath5.depth()) {
                    wmiAncestorPath4.pop();
                }
                while (wmiAncestorPath5.depth() > wmiAncestorPath4.depth()) {
                    wmiAncestorPath5.pop();
                }
                for (int i = 0; i < wmiAncestorPath4.depth() && wmiAncestorPath4.peek(i) == wmiAncestorPath5.peek(i); ++i) {
                    wmiAncestorPath3.push(wmiAncestorPath4.peek(i));
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            WmiErrorLog.log(cloneNotSupportedException);
        }
        return wmiAncestorPath3;
    }
}

