/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class WmiRoundButtonUIFactory {
    public static ButtonUI createUI() {
        return new RoundButtonUI();
    }

    private WmiRoundButtonUIFactory() {
    }

    private static class RoundButtonUI
    extends BasicButtonUI {
        private RoundButtonUI() {
        }

        public void installUI(JComponent jComponent) {
            super.installUI(jComponent);
            Dimension dimension = this.getPreferredSize(jComponent);
            jComponent.setSize(dimension);
            jComponent.setMaximumSize(dimension);
            jComponent.setMinimumSize(dimension);
            jComponent.setPreferredSize(dimension);
            jComponent.setOpaque(false);
            ((AbstractButton)jComponent).setRolloverEnabled(true);
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            int n = this.getDefaultTextIconGap(abstractButton);
            SizeCalculation sizeCalculation = this.calculateSizes(jComponent);
            Color color = jComponent.getBackground();
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isPressed()) {
                color = color.darker();
            } else if (buttonModel.isRollover()) {
                color = color.brighter();
            } else if (!buttonModel.isEnabled()) {
                color = Color.LIGHT_GRAY;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(new GradientPaint(0.0f, -5.0f, Color.WHITE, 0.0f, sizeCalculation.circleSize, color));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fillOval(sizeCalculation.circleXOffset, 0, sizeCalculation.circleSize, sizeCalculation.circleSize);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, Color.DARK_GRAY, sizeCalculation.circleSize, sizeCalculation.circleSize, Color.WHITE));
            graphics2D.drawOval(sizeCalculation.circleXOffset, 0, sizeCalculation.circleSize, sizeCalculation.circleSize);
            Icon icon = abstractButton.getIcon();
            if (icon != null) {
                icon.paintIcon(jComponent, graphics2D, sizeCalculation.circleXOffset + n, n);
            }
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(abstractButton.getText(), sizeCalculation.labelXOffset, sizeCalculation.circleSize + sizeCalculation.labelHeight + n);
        }

        public Dimension getPreferredSize(JComponent jComponent) {
            SizeCalculation sizeCalculation = this.calculateSizes(jComponent);
            return new Dimension(Math.max(sizeCalculation.circleSize, sizeCalculation.labelWidth), sizeCalculation.circleSize + sizeCalculation.labelHeight + this.getDefaultTextIconGap((AbstractButton)jComponent));
        }

        private SizeCalculation calculateSizes(JComponent jComponent) {
            SizeCalculation sizeCalculation = new SizeCalculation();
            String string = ((AbstractButton)jComponent).getText();
            FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
            sizeCalculation.labelWidth = fontMetrics.stringWidth(string);
            sizeCalculation.labelHeight = fontMetrics.getHeight() + fontMetrics.getDescent();
            int n = 32;
            Icon icon = ((AbstractButton)jComponent).getIcon();
            if (icon != null) {
                n = Math.max(icon.getIconWidth(), icon.getIconHeight()) + this.getDefaultTextIconGap((AbstractButton)jComponent);
            }
            sizeCalculation.circleSize = n;
            sizeCalculation.circleXOffset = Math.max(0, (sizeCalculation.labelWidth - sizeCalculation.circleSize) / 2);
            sizeCalculation.labelXOffset = Math.max(0, (sizeCalculation.circleSize - sizeCalculation.labelWidth) / 2);
            return sizeCalculation;
        }

        private static class SizeCalculation {
            public int labelWidth;
            public int labelHeight;
            public int circleSize;
            public int circleXOffset;
            public int labelXOffset;

            private SizeCalculation() {
            }
        }
    }
}

