/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class WmiRolloverHighlightButtonUI
extends BasicButtonUI {
    protected static final int PAINT_BACKGROUND = 1;
    protected static final int PAINT_BORDER = 2;

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ((AbstractButton)jComponent).setRolloverEnabled(true);
    }

    protected Color getPaintingColor(int n, AbstractButton abstractButton) {
        Color color = null;
        ButtonModel buttonModel = abstractButton.getModel();
        if (n == 1) {
            if (buttonModel.isPressed()) {
                color = abstractButton.getBackground().darker();
            } else if (buttonModel.isSelected()) {
                color = Color.WHITE;
            } else if (buttonModel.isRollover()) {
                color = abstractButton.getBackground().brighter();
            }
        } else if (n == 2) {
            if (buttonModel.isPressed()) {
                color = Color.GRAY;
            } else if (buttonModel.isSelected()) {
                color = Color.BLUE;
            } else if (buttonModel.isRollover()) {
                color = Color.LIGHT_GRAY;
            }
        }
        return color;
    }

    protected void paintBackground(Graphics graphics, AbstractButton abstractButton) {
        Color color = this.getPaintingColor(1, abstractButton);
        if (abstractButton.isOpaque()) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
        }
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRoundRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight(), 2, 2);
        }
    }

    protected void paintBorder(Graphics graphics, AbstractButton abstractButton) {
        Color color = this.getPaintingColor(2, abstractButton);
        if (color != null) {
            graphics.setColor(color);
            graphics.drawRoundRect(0, 0, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1, 4, 4);
        }
    }

    protected void paintContents(Graphics graphics, AbstractButton abstractButton) {
        String string;
        Icon icon = null;
        if (!abstractButton.isEnabled()) {
            icon = abstractButton.getDisabledIcon();
        }
        if (icon == null) {
            icon = abstractButton.getIcon();
        }
        if (icon != null) {
            if (abstractButton.getModel().isPressed()) {
                icon.paintIcon(abstractButton, graphics, 3, 2);
            } else {
                icon.paintIcon(abstractButton, graphics, 2, 2);
            }
        }
        if ((string = abstractButton.getText()) != null) {
            Rectangle rectangle = WmiComponentUtil.centerTextInButton(abstractButton);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (abstractButton.isEnabled() || abstractButton.isSelected()) {
                graphics.setColor(abstractButton.getForeground());
            } else {
                graphics.setColor(Color.GRAY);
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, -1, rectangle.x + this.getTextShiftOffset(), rectangle.y + fontMetrics.getAscent() + this.getTextShiftOffset());
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        this.paintBackground(graphics, abstractButton);
        this.paintBorder(graphics, abstractButton);
        this.paintContents(graphics, abstractButton);
    }
}

