/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.WmiTwoArgumentMathModel;
import com.maplesoft.mathdoc.model.math.WmiUnderModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiLimitBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int FUNCTION_INDEX = 0;
    private static final int EQN_INDEX = 1;
    private static final int DIRECTION_INDEX = 2;
    private static final int LHS_INDEX = 0;
    private static final int RHS_INDEX = 1;
    private static final int LIMIT_SIZE = 2;
    private static final int LIMIT_WITH_DIRECTION_SIZE = 3;
    private static final String DIRECTION_RIGHT = "right";
    private static final String DIRECTION_LEFT = "left";
    private static final String DIRECTION_REAL = "real";
    private static final String DIRECTION_COMPLEX = "complex";
    private static final String LIMIT_RIGHT_OPERATOR = "+";
    private static final String LIMIT_LEFT_OPERATOR = "&uminus0;";
    private static final String LIMIT_REAL_OPERATOR = ", real";
    private static final String LIMIT_COMPLEX_OPERATOR = ", complex";
    private static final String LIMIT_ARROW_OPERATOR = "\u2192";
    public static final String LIMIT_OPERATOR = "lim";
    private static final WmiMathSemantics LIMIT_SEMANTICS = new WmiLimitSemantics();
    public static final boolean INERT = true;
    public static final boolean NONINERT = false;
    private boolean isInert;

    public WmiLimitBuilder() {
        this(false);
    }

    public WmiLimitBuilder(boolean bl) {
        this.isInert = bl;
    }

    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel wmiMathDocumentModel, String string, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiMathModel wmiMathModel = null;
        Dag dag2 = dag.getChild(1);
        Dag dag3 = dag2.getChild(0);
        Dag dag4 = dag2.getChild(1);
        if (dag4.getType() <= 19) {
            WmiTwoArgumentMathModel wmiTwoArgumentMathModel;
            WmiMathModel[] wmiMathModelArray;
            Object object;
            WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag3, wmiMathContext);
            WmiMathModel wmiMathModel3 = WmiMathFactory.createMath(wmiMathDocumentModel, dag4, wmiMathContext);
            WmiMathTokenModel wmiMathTokenModel = null;
            boolean bl = false;
            if (dag.getLength() == 3 && (object = dag.getChild(2).getData()) != null) {
                if (((String)object).equalsIgnoreCase(DIRECTION_RIGHT)) {
                    wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, LIMIT_RIGHT_OPERATOR, wmiMathContext);
                    bl = true;
                } else if (((String)object).equalsIgnoreCase(DIRECTION_LEFT)) {
                    wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, LIMIT_LEFT_OPERATOR, wmiMathContext);
                    bl = true;
                } else if (((String)object).equalsIgnoreCase(DIRECTION_REAL)) {
                    wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, LIMIT_REAL_OPERATOR, wmiMathContext);
                } else if (((String)object).equalsIgnoreCase(DIRECTION_COMPLEX)) {
                    wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, LIMIT_COMPLEX_OPERATOR, wmiMathContext);
                }
            }
            object = new WmiInlineMathModel(wmiMathDocumentModel);
            ((WmiAbstractArrayCompositeModel)object).appendChild(wmiMathModel2);
            ((WmiAbstractArrayCompositeModel)object).appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, LIMIT_ARROW_OPERATOR, wmiMathContext));
            if (wmiMathTokenModel == null) {
                ((WmiAbstractArrayCompositeModel)object).appendChild(wmiMathModel3);
            } else if (bl) {
                wmiMathModelArray = new WmiMathModel[]{wmiMathModel3, wmiMathTokenModel};
                wmiTwoArgumentMathModel = new WmiSuperscriptModel(wmiMathDocumentModel, wmiMathModelArray, wmiMathContext);
                wmiMathModel3.setParent(wmiTwoArgumentMathModel);
                wmiMathTokenModel.setParent(wmiTwoArgumentMathModel);
                ((WmiAbstractArrayCompositeModel)object).appendChild(wmiTwoArgumentMathModel);
            } else {
                ((WmiAbstractArrayCompositeModel)object).appendChild(wmiMathModel3);
                ((WmiAbstractArrayCompositeModel)object).appendChild(wmiMathTokenModel);
            }
            wmiMathModelArray = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, LIMIT_OPERATOR, wmiMathContext);
            if (this.isInert) {
                this.inertize((WmiMathOperatorModel)wmiMathModelArray);
            }
            wmiTwoArgumentMathModel = new WmiUnderModel(wmiMathDocumentModel, (WmiModel)wmiMathModelArray, (WmiModel)object, wmiMathContext);
            wmiTwoArgumentMathModel.addAttribute(WmiUnderModel.WmiUnderAttributeSet.ACCENT_KEY, Boolean.FALSE);
            WmiMathModel wmiMathModel4 = WmiMathFactory.createMath(wmiMathDocumentModel, dag.getChild(0), wmiMathContext);
            if (WmiPrecedenceRules.areBracketsRequired(dag.getChild(0), 4, 1)) {
                wmiMathModel4 = WmiMathFactory.addBrackets(wmiMathModel4, wmiMathContext);
            }
            WmiModel[] wmiModelArray = new WmiMathModel[3];
            wmiModelArray[0] = wmiTwoArgumentMathModel;
            wmiModelArray[1] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[1].addAttribute("width", "0.4em");
            wmiModelArray[2] = wmiMathModel4;
            wmiMathModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
        }
        if (wmiMathModel != null) {
            wmiMathModel.setSemantics(LIMIT_SEMANTICS);
        }
        return wmiMathModel;
    }

    public boolean shouldBeUsed(Dag dag, WmiMathContext wmiMathContext) {
        boolean bl = super.shouldBeUsed(dag, wmiMathContext);
        Dag dag2 = dag.getChild(1);
        int n = dag2.getLength();
        return bl && dag2 != null && n >= 2 && n <= 3 && dag2.getChild(1).getType() == 20;
    }

    private static class WmiLimitSemantics
    implements WmiMathSemantics {
        private static final int UNDER_MODEL_INDEX = 0;
        private static final int FUNCTION_MODEL_INDEX = 2;
        private static final int INLINE_MODEL_INDEX_IN_UNDER_MODEL = 1;
        private static final int VARIABLE_MODEL_INDEX_IN_INLINE_MODEL = 0;
        private static final int POINT_MODEL_INDEX_IN_INLINE_MODEL = 2;
        private static final int OPTION_MODEL_INDEX_IN_INLINE_MODEL = 3;

        private WmiLimitSemantics() {
        }

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            Dag dag = null;
            if (wmiMathModel != null && wmiMathModel.isComposite()) {
                WmiModel wmiModel;
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
                WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(2);
                WmiModel wmiModel2 = wmiCompositeModel.getChild(0);
                if (wmiModel2 != null && wmiModel2.isComposite() && wmiMathModel2 != null && (wmiModel = ((WmiCompositeModel)wmiModel2).getChild(1)) != null && wmiModel.isComposite()) {
                    WmiCompositeModel wmiCompositeModel2 = (WmiCompositeModel)wmiModel;
                    Dag dag2 = wmiMathModel2.toDag();
                    Dag[] dagArray = new Dag[2];
                    WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel2.getChild(0);
                    WmiMathModel wmiMathModel4 = (WmiMathModel)wmiCompositeModel2.getChild(2);
                    if (wmiMathModel3 != null && wmiMathModel4 != null) {
                        WmiMathOperatorModel wmiMathOperatorModel;
                        dagArray[0] = wmiMathModel3.toDag();
                        dagArray[1] = wmiMathModel4.toDag();
                        Dag dag3 = Dag.createDag(20, dagArray, null, false);
                        if (wmiCompositeModel2.getChild(3) != null && (wmiMathOperatorModel = (WmiMathOperatorModel)wmiCompositeModel2.getChild(3)) instanceof WmiTextModel) {
                            String string = ((WmiTextModel)wmiMathOperatorModel).getText();
                            Dag dag4 = null;
                            if (WmiLimitBuilder.LIMIT_REAL_OPERATOR.equals(string)) {
                                dag4 = Dag.createDag(8, null, WmiLimitBuilder.DIRECTION_REAL, false);
                            }
                            if (WmiLimitBuilder.LIMIT_COMPLEX_OPERATOR.equals(string)) {
                                dag4 = Dag.createDag(8, null, WmiLimitBuilder.DIRECTION_COMPLEX, false);
                            }
                            if (WmiLimitBuilder.LIMIT_RIGHT_OPERATOR.equals(string)) {
                                dag4 = Dag.createDag(8, null, WmiLimitBuilder.DIRECTION_RIGHT, false);
                            }
                            if (WmiLimitBuilder.LIMIT_LEFT_OPERATOR.equals(string)) {
                                dag4 = Dag.createDag(8, null, WmiLimitBuilder.DIRECTION_LEFT, false);
                            }
                            if (dag4 != null) {
                                dag = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.LIMIT_FUNC_NAME, dag2, dag3, dag4);
                            }
                        }
                        if (dag == null) {
                            dag = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.LIMIT_FUNC_NAME, dag2, dag3);
                        }
                    }
                }
            }
            dag = WmiSemanticDagUtil.handleNullDag(dag, wmiMathModel);
            return dag;
        }
    }
}

