/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;
import java.util.ArrayList;

public class WmiInfixNotationBuilder
extends WmiAbstractSpecialFunctionBuilder {
    public static final String INTERSECT_FUNCTION_NAME = "intersect";
    public static final String IN_FUNCTION_NAME = "in";
    public static final String MINUS_FUNCTION_NAME = "minus";
    public static final String UNION_FUNCTION_NAME = "union";
    public static final String SUBSET_FUNCTION_NAME = "subset";
    public static final String EXPR_SEQ_OPERATOR = "$";
    public static final String COMPOSITION_OPERATOR = "@";
    public static final String DOT_PRODUCT_OPERATOR = ".";
    public static final String MOD_OPERATOR = "mod";
    public static final String ELEMENT_OF_OPERATOR = "\u2208";
    public static final String INTERSECT_OPERATOR = "\u2229";
    public static final String UNION_OPERATOR = "\u222a";
    public static final String SUBSET_OPERATOR = "\u2286";
    public static final String SET_MINUS_OPERATOR = "\u2216";
    public static final String PLUS_MINUS_NAME = "&+-";
    public static final String PLUS_MINUS_SEMANTICS = "&plusmn;";
    public static final String PLUS_MINUS_OPERATOR = "\u00b1";
    private int minArgumentSize;
    private int maxArgumentSize;
    private int precedence;
    private String opString;
    private boolean addMSpacePadding;
    private int precedenceRule;

    public WmiInfixNotationBuilder(String string, int n, int n2, boolean bl) {
        this(string, 2, n, n2, bl);
    }

    public WmiInfixNotationBuilder(String string, int n, int n2, int n3, boolean bl) {
        this.minArgumentSize = n2;
        this.maxArgumentSize = n3;
        this.precedence = n;
        this.addMSpacePadding = bl;
        this.opString = string;
        this.precedenceRule = 0;
    }

    public WmiInfixNotationBuilder(String string, int n, int n2, int n3, boolean bl, int n4) {
        this(string, n, n2, n3, bl);
        this.precedenceRule = n4;
    }

    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel wmiMathDocumentModel, String string, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        int n = dag.getLength();
        boolean bl = this.addMSpacePadding;
        int n2 = bl ? (n - 1) * 4 + 1 : n * 2 - 1;
        WmiModel[] wmiModelArray = new WmiMathModel[n2];
        Dag dag2 = dag.getChild(0);
        wmiModelArray[0] = this.createAndBracketChild(wmiMathDocumentModel, dag2, wmiMathContext);
        int n3 = 1;
        for (int i = 1; i < n; ++i) {
            Dag dag3 = dag.getChild(i);
            if (bl) {
                wmiModelArray[n3] = new WmiMathSpaceModel(wmiMathDocumentModel);
                wmiModelArray[n3++].addAttribute("width", "0.5em");
            }
            wmiModelArray[n3++] = wmiMathContext.useProcRules() ? WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, string, wmiMathContext) : WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, this.opString, wmiMathContext);
            if (bl) {
                wmiModelArray[n3] = new WmiMathSpaceModel(wmiMathDocumentModel);
                wmiModelArray[n3++].addAttribute("width", "0.5em");
            }
            wmiModelArray[n3++] = this.createAndBracketChild(wmiMathDocumentModel, dag3, wmiMathContext);
        }
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
        wmiInlineMathModel.setSemantics(new WmiInfixNotationSemantics(string));
        return wmiInlineMathModel;
    }

    private WmiMathModel createAndBracketChild(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
        if (WmiPrecedenceRules.areBracketsRequired(dag, this.precedence, this.precedenceRule)) {
            wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, wmiMathContext);
        }
        return wmiMathModel;
    }

    public boolean shouldBeUsed(Dag dag, WmiMathContext wmiMathContext) {
        boolean bl = dag.getLength() > 1 && dag.getChild(1) != null;
        Dag dag2 = dag.getChild(1);
        int n = dag2.getLength();
        return bl && n >= this.minArgumentSize && n <= this.maxArgumentSize;
    }

    private class WmiInfixNotationSemantics
    implements WmiMathSemantics {
        private final String functionName;

        public WmiInfixNotationSemantics(String string) {
            this.functionName = string;
        }

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            Dag dag = null;
            if (wmiMathModel != null && wmiMathModel.isComposite()) {
                Dag[] dagArray;
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
                ArrayList<Dag> arrayList = new ArrayList<Dag>();
                for (int i = 0; i < wmiCompositeModel.getChildCount(); ++i) {
                    dagArray = (Dag[])wmiCompositeModel.getChild(i);
                    if (dagArray == null || dagArray instanceof WmiTextModel && WmiInfixNotationBuilder.this.opString.equals(((WmiTextModel)dagArray).getText())) continue;
                    arrayList.add(dagArray.toDag());
                }
                if (arrayList.size() <= WmiInfixNotationBuilder.this.maxArgumentSize && arrayList.size() >= WmiInfixNotationBuilder.this.minArgumentSize) {
                    Dag dag2 = WmiSemanticDagUtil.createName(this.functionName);
                    dagArray = arrayList.toArray(new Dag[0]);
                    dag = WmiSemanticDagUtil.createFunction(dag2, dagArray);
                }
            }
            dag = WmiSemanticDagUtil.handleNullDag(dag, wmiMathModel);
            return dag;
        }
    }
}

