/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiAbstractElisionBuilder;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import java.util.ArrayList;

public class WmiSumBuilder
extends WmiAbstractElisionBuilder
implements WmiMathSemantics {
    public static final String SINGLE_ELIDED_TERM_MARKER = "term";
    public static final String ELIDED_TERM_MARKER = "terms";
    public static final String PLUS_OPERATOR = "+";
    public static final String MINUS_OPERATOR = "&minus;";
    public static final String PROC_MINUS_OPERATOR = " \u2212 ";
    public static final String UNARY_MINUS_OPERATOR = "&uminus0;";
    public static final String PROC_UNARY_MINUS_OPERATOR = "\u2212";
    private static final String LINEBREAK_CONTEXT_NAME = "sum";
    private static final WmiMathSemantics PLUS_SEMANTICS = new PlusSemantics();
    private static final WmiMathSemantics MINUS_SEMANTICS = new MinusSemantics();
    private static final String PLUS_MINUS_OPERATOR_NAME = "&+-";
    private static final String PLUS_MINUS_OPERATOR_SEMANTICS = "&plusmn;";
    private static final String PLUS_MINUS_OPERATOR_CHAR = "\u00b1";

    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int n;
        WmiMathModel wmiMathModel = null;
        int n2 = n = dag.getLength();
        boolean bl = this.isElisionRequired(n2 / 2);
        int n3 = 0;
        if (bl) {
            n3 = n2 / 2 - this.leftSample - this.rightSample;
            n2 -= n3;
        }
        WmiModel[] wmiModelArray = new WmiMathModel[n2];
        int n4 = 0;
        boolean bl2 = false;
        if (n2 == 2) {
            Dag dag2 = dag.getChild(0);
            Dag dag3 = dag.getChild(1);
            wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
            if (dag3.equals(DagConstants.MINUS_ONE)) {
                boolean bl3 = false;
                if (WmiPrecedenceRules.areBracketsRequired(dag2, 6, 1)) {
                    wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, wmiMathContext);
                    bl3 = true;
                }
                wmiModelArray[0] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, wmiMathContext.useProcRules() ? PROC_UNARY_MINUS_OPERATOR : UNARY_MINUS_OPERATOR, wmiMathContext);
                wmiModelArray[1] = wmiMathModel;
                try {
                    wmiMathModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
                    wmiMathModel.setSemantics(this);
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                    WmiErrorLog.log(wmiInvalidModelInitializationException);
                }
            }
        } else {
            for (int i = 0; i < n; i += 2) {
                Object object;
                Dag dag4 = dag.getChild(i);
                Dag dag5 = dag.getChild(i + 1);
                WmiMathTokenModel wmiMathTokenModel = null;
                if (bl && i == this.leftSample * 2) {
                    wmiModelArray[n4++] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, PLUS_OPERATOR, wmiMathContext);
                    wmiModelArray[n4++] = this.getElisionMarker(wmiMathDocumentModel, n3, wmiMathContext);
                    i = n - this.rightSample * 2;
                    if (i == n) break;
                }
                if (i == 0) {
                    if (dag5.equals(DagConstants.MINUS_ONE)) {
                        wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, wmiMathContext.useProcRules() ? PROC_UNARY_MINUS_OPERATOR : UNARY_MINUS_OPERATOR, wmiMathContext);
                        wmiMathTokenModel.setSemantics(MINUS_SEMANTICS);
                    }
                } else if (dag5.equals(DagConstants.ONE)) {
                    wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, PLUS_OPERATOR, wmiMathContext);
                    wmiMathTokenModel.setSemantics(PLUS_SEMANTICS);
                } else {
                    wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, wmiMathContext.useProcRules() ? PROC_MINUS_OPERATOR : MINUS_OPERATOR, wmiMathContext);
                    wmiMathTokenModel.setSemantics(MINUS_SEMANTICS);
                }
                if (dag4.getType() == 18) {
                    Dag dag6;
                    Dag dag7 = dag4.getLength() > 1 ? dag4.getChild(0) : null;
                    Object object2 = object = dag7 != null ? dag7.getData() : null;
                    if (object != null && ((String)object).equals(PLUS_MINUS_OPERATOR_NAME) && (dag6 = dag4.getChild(1)) != null && dag6.getType() == 29 && dag6.getLength() == 1) {
                        dag4 = dag6.getChild(0);
                        wmiMathTokenModel = new WmiMathOperatorModel(wmiMathDocumentModel, PLUS_MINUS_OPERATOR_CHAR, PLUS_MINUS_OPERATOR_SEMANTICS, wmiMathContext);
                        bl2 = true;
                    }
                }
                int n5 = DagUtil.isNegative(dag5) ? 1 : 0;
                object = WmiMathFactory.createMath(wmiMathDocumentModel, dag4, wmiMathContext);
                boolean bl4 = false;
                if (WmiPrecedenceRules.areBracketsRequired(dag4, 6, n5)) {
                    object = WmiMathFactory.addBrackets((WmiMathModel)object, wmiMathContext);
                    bl4 = true;
                }
                if (dag4.getType() == 16 && !bl4 && object instanceof WmiCompositeModel && ((WmiCompositeModel)object).getChild(0) instanceof WmiMathOperatorModel) {
                    wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, MINUS_OPERATOR, wmiMathContext);
                    wmiMathTokenModel.setSemantics(MINUS_SEMANTICS);
                    try {
                        ((WmiCompositeModel)object).removeChild(0);
                    }
                    catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                        WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                    }
                }
                if (wmiMathTokenModel != null) {
                    wmiModelArray[n4++] = wmiMathTokenModel;
                }
                wmiModelArray[n4++] = object;
            }
            if (n4 < n2) {
                WmiMathModel[] wmiMathModelArray = new WmiMathModel[n4];
                System.arraycopy(wmiModelArray, 0, wmiMathModelArray, 0, n4);
                wmiModelArray = wmiMathModelArray;
            }
            try {
                wmiMathModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
                if (!bl2) {
                    wmiMathModel.setSemantics(this);
                }
            }
            catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                WmiErrorLog.log(wmiInvalidModelInitializationException);
            }
        }
        if (wmiMathContext.shouldSubExpressionLabel(wmiMathModel, dag)) {
            wmiMathModel = wmiMathContext.createSubexpressionLabel(wmiMathModel, dag);
        }
        return wmiMathModel;
    }

    public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
        int n = wmiCompositeModel.getChildCount();
        Dag dag = null;
        if (n > 0) {
            Dag[] dagArray;
            int n2 = 0;
            WmiMathModel wmiMathModel2 = null;
            WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel.getChild(0);
            if (wmiMathModel3 instanceof WmiMathOperatorModel) {
                wmiMathModel2 = wmiMathModel3;
                n2 = 1;
            }
            ArrayList<Dag> arrayList = new ArrayList<Dag>();
            int n3 = 0;
            for (int i = n2; i < n; i += 2) {
                dagArray = (Dag[])wmiCompositeModel.getChild(i);
                if (WmiModelUtil.isEmptyIdentifierModel((WmiModel)dagArray)) {
                    --i;
                    continue;
                }
                arrayList.add(n3, dagArray.toDag());
                arrayList.add(n3 + 1, wmiMathModel2 != null ? wmiMathModel2.toDag() : DagConstants.ONE);
                if (arrayList.get(n3 + 1) == null) {
                    arrayList.add(n3 + 1, DagConstants.ONE);
                }
                if (i < n - 1) {
                    wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(i + 1);
                }
                n3 += 2;
            }
            dagArray = arrayList.toArray(new Dag[0]);
            WmiSemanticDagUtil.fillNullDags(dagArray);
            dag = Dag.createDag(16, dagArray, null, false);
        }
        return dag;
    }

    protected String getElisionThresholdProperty() {
        return "elisiontermsthreshold";
    }

    protected String getElisionAfterProperty() {
        return "elisiontermsafter";
    }

    protected String getElisionBeforeProperty() {
        return "elisiontermsbefore";
    }

    protected int getDefaultElideThreshold() {
        return 1000;
    }

    public String getSingleElisionMarkerText() {
        return SINGLE_ELIDED_TERM_MARKER;
    }

    public String getElisionMarkerText() {
        return ELIDED_TERM_MARKER;
    }

    public static boolean isUnaryMinus(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
        WmiMathOperatorModel wmiMathOperatorModel;
        String string;
        boolean bl = false;
        if (wmiMathModel instanceof WmiMathOperatorModel && (string = (wmiMathOperatorModel = (WmiMathOperatorModel)wmiMathModel).getText()) != null && string.equals(UNARY_MINUS_OPERATOR)) {
            bl = true;
        }
        return bl;
    }

    private static class MinusSemantics
    implements WmiMathSemantics {
        public Dag toDag(WmiMathModel wmiMathModel) {
            return DagConstants.MINUS_ONE;
        }
    }

    private static class PlusSemantics
    implements WmiMathSemantics {
        private PlusSemantics() {
        }

        public Dag toDag(WmiMathModel wmiMathModel) {
            return DagConstants.ONE;
        }
    }
}

