/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathModel;

public class WmiSemanticDagUtil {
    public static final Dag ABS_FUNC_NAME = Dag.createDag(8, null, "abs", false);
    public static final Dag COMPOSITION_FUNC_NAME = Dag.createDag(8, null, "@@", false);
    public static final Dag CONJUGATE_FUNC_NAME = Dag.createDag(8, null, "conjugate", false);
    public static final Dag DIFF_FUNC_NAME = Dag.createDag(8, null, "diff", false);
    public static final Dag DOLLAR_SIGN_FUNC_NAME = Dag.createDag(8, null, "$", false);
    public static final Dag EVAL_FUNC_NAME = Dag.createDag(8, null, "eval", false);
    public static final Dag EXP_FUNC_NAME = Dag.createDag(8, null, "exp", false);
    public static final Dag FACTORIAL_FUNC_NAME = Dag.createDag(8, null, "factorial", false);
    public static final Dag PRODUCT_FUNC_NAME = Dag.createDag(8, null, "product", false);
    public static final Dag SUM_FUNC_NAME = Dag.createDag(8, null, "sum", false);
    public static final Dag INTEGRAL_FUNC_NAME = Dag.createDag(8, null, "int", false);
    public static final Dag LIMIT_FUNC_NAME = Dag.createDag(8, null, "limit", false);
    public static final Dag PIECEWISE_FUNC_NAME = Dag.createDag(8, null, "PIECEWISE", false);
    public static final Dag MATRIX_FUNC_NAME = Dag.createDag(8, null, "MATRIX", false);
    public static final Dag VECTOR_FUNC_NAME = Dag.createDag(8, null, "VECTOR", false);
    public static final Dag RTABLE_FUNC_NAME = Dag.createDag(8, null, "RTABLE", false);
    public static final Dag UNIT_FUNC_NAME = Dag.createDag(8, null, "Unit", false);
    public static final Dag CURL_FUNC_NAME = Dag.createDag(8, null, "Curl", false);
    public static final Dag GRADIENT_FUNC_NAME = Dag.createDag(8, null, "Gradient", false);
    public static final Dag DIVERGENCE_FUNC_NAME = Dag.createDag(8, null, "Divergence", false);
    public static final Dag SERIES_FUNC_NAME = Dag.createDag(8, null, "_SERIES", false);
    public static final Dag QUESION_MARK_DAG = Dag.createDag(8, null, "?", false);

    private static Dag assembleFunction(Dag dag, Dag dag2) {
        Dag[] dagArray = new Dag[]{dag, dag2};
        return Dag.createDag(18, dagArray, null, false);
    }

    public static Dag createFunction(Dag dag, Dag[] dagArray) {
        WmiSemanticDagUtil.fillNullDags(dagArray);
        Dag dag2 = Dag.createDag(29, dagArray, null, false);
        return WmiSemanticDagUtil.assembleFunction(dag, dag2);
    }

    public static Dag createFunction(Dag dag, Dag dag2) {
        return WmiSemanticDagUtil.createFunction(dag, new Dag[]{dag2});
    }

    public static Dag createFunction(Dag dag, Dag dag2, Dag dag3) {
        return WmiSemanticDagUtil.createFunction(dag, new Dag[]{dag2, dag3});
    }

    public static Dag createFunction(Dag dag, Dag dag2, Dag dag3, Dag dag4) {
        return WmiSemanticDagUtil.createFunction(dag, new Dag[]{dag2, dag3, dag4});
    }

    public static Dag createFunction(Dag dag, Dag dag2, Dag dag3, Dag dag4, Dag dag5) {
        return WmiSemanticDagUtil.createFunction(dag, new Dag[]{dag2, dag3, dag4, dag5});
    }

    public static Dag createList(Dag[] dagArray) {
        WmiSemanticDagUtil.fillNullDags(dagArray);
        return Dag.createDag(30, dagArray, null, false);
    }

    public static Dag createName(String string) {
        return Dag.createDag(8, null, string, false);
    }

    public static Dag createIntpos(String string) {
        return Dag.createDag(2, null, string.trim(), false);
    }

    public static Dag createEquation(Dag dag, Dag dag2) {
        Dag[] dagArray = new Dag[]{dag, dag2};
        WmiSemanticDagUtil.fillNullDags(dagArray);
        return Dag.createDag(20, dagArray, null, false);
    }

    public static Dag handleNullDag(Dag dag, WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
        if (dag == null) {
            dag = WmiImpliedSemantics.getDag(wmiMathModel, false);
        }
        return dag;
    }

    public static WmiModel getModelSafely(WmiModel wmiModel, int n) throws WmiNoReadAccessException {
        WmiModel wmiModel2 = null;
        if (wmiModel != null && wmiModel.isComposite()) {
            wmiModel2 = ((WmiCompositeModel)wmiModel).getChild(n);
        }
        return wmiModel2;
    }

    public static void fillNullDags(Dag[] dagArray) {
        if (dagArray != null) {
            for (int i = 0; i < dagArray.length; ++i) {
                if (dagArray[i] != null) continue;
                dagArray[i] = QUESION_MARK_DAG;
            }
        }
    }
}

