/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.ModdefDagFactory;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;

public class WmiProcBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final String PROC_OPERATOR = "proc";
    public static final String MODULE_OPERATOR = "module";
    public static final String PROC_TERMINATION_OPERATOR = "end proc";
    public static final String MODULE_TERMINATION_OPERATOR = "end module";
    public static final String PROC_SHORT_TERMINATION_OPERATOR = "end";
    public static final String SEMICOLON_STATEMENT_SEPARATOR_OPERATOR = ";";
    public static final String STATEMENT_SEQUENCE_BLANK_TERMINATION_OP = "";
    private static final int MAX_PROC_SIZE = 10;
    private static final int PARAMETER_INDEX = 0;
    private static final int LOCAL_INDEX = 1;
    private static final int OPTION_INDEX = 2;
    private static final int REMEMBER_TABLE_INDEX = 3;
    private static final int EXPORT_INDEX = 3;
    private static final int STATEMENT_INDEX = 4;
    private static final int DESCRIPTION_INDEX = 5;
    private static final int GLOBAL_INDEX = 6;
    private static final int LEXICAL_INDEX = 7;
    private static final int MODULE_NAME_INDEX = 8;
    private static final int DEFAULT_VERBOSEPROC_LEVEL = 1;
    public static final String ELIDED_PROC_ELIPSIS = "...";
    public static final String LOCAL_KEYWORD = "local";
    public static final String EXPORT_KEYWORD = "export";
    public static final String DESCRIPTION_KEYWORD = "description";
    public static final String GLOBAL_KEYWORD = "global";
    public static final String OPTION_KEYWORD = "option";
    public static final String ARROW_OPERATOR = "\u2192";
    private static final String OPERATOR_OPTION_NAME = "operator";
    private static final String ARROW_OPTION_NAME = "arrow";
    private static final String COPYRIGHT_OPTION_START = "Copyright";
    private static final int BASE_NORMAL_PROC_SIZE = 6;
    public static final WmiMathSpaceModel.WmiMathSpaceAttributeSet PROC_INC_LINEBREAK_ATTR = new WmiMathSpaceModel.WmiMathSpaceAttributeSet();
    public static final WmiMathSpaceModel.WmiMathSpaceAttributeSet PROC_DEC_LINEBREAK_ATTR = new WmiMathSpaceModel.WmiMathSpaceAttributeSet();
    public static final WmiMathSpaceModel.WmiMathSpaceAttributeSet PROC_INDENT_LINEBREAK_ATTR = new WmiMathSpaceModel.WmiMathSpaceAttributeSet();
    private static final String POST_PROC_SPACE = "0.3em";

    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (dag.getType() == 40 && dag.getLength() > 2) {
            return this.createModel(dag.getChild(1), wmiMathDocumentModel, wmiMathContext);
        }
        WmiModel[] wmiModelArray = new WmiMathModel[10];
        WmiMathModel wmiMathModel = null;
        int n = WmiProcBuilder.getVerboseProcProperty(wmiMathDocumentModel);
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        Dag dag2 = dag.getChild(2);
        if (dag2 != null && dag2.getLength() > 0) {
            bl = this.isProcVisible(wmiMathDocumentModel, dag2, wmiMathContext);
            bl2 = this.isProcOption(dag2, OPERATOR_OPTION_NAME);
            bl3 = this.isProcOption(dag2, ARROW_OPTION_NAME);
            wmiMathModel = this.buildProcKeyword(dag2, wmiMathDocumentModel, wmiMathContext, OPTION_KEYWORD);
        } else {
            bl = n >= 1;
        }
        wmiModelArray = bl3 && bl2 ? this.buildArrowProcChildren(dag, wmiMathDocumentModel, wmiMathContext) : this.buildNormalProcChildren(dag, wmiMathDocumentModel, wmiMathContext, wmiMathModel, bl, n, bl2);
        try {
            wmiInlineMathModel.replaceChildren(wmiModelArray, 0, 0);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        wmiMathContext.decrementProcCounter();
        if (dag.getType() == 34) {
            ProcDagFactory.removeStacks(dag);
        } else {
            ProcDagFactory.removeStacks();
        }
        wmiInlineMathModel.setSemantics(this);
        return wmiInlineMathModel;
    }

    private boolean isProcOption(Dag dag, String string) {
        boolean bl = false;
        if (dag != null && dag.getLength() > 0) {
            int n = dag.getLength();
            for (int i = 0; i < n; ++i) {
                Dag dag2 = dag.getChild(i);
                String string2 = dag2.getData();
                if (null == string2 || !string2.equals(string)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private WmiMathModel[] buildArrowProcChildren(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Object object;
        if (dag.getType() == 34) {
            ProcDagFactory.addToStacks(dag);
        } else if (dag.getType() == 39) {
            ProcDagFactory.addToStacks(dag.getChild(0), dag.getChild(1), dag.getChild(7), dag.getChild(3));
        }
        wmiMathContext.incrementProcCounter();
        wmiMathContext.setOperatorProc(true);
        Dag dag2 = dag.getChild(0);
        WmiMathModel[] wmiMathModelArray = new WmiMathModel[3];
        if (dag2 != null && dag2.getLength() == 1) {
            object = dag2.getChild(0);
            wmiMathModelArray[0] = WmiMathFactory.createMath(wmiMathDocumentModel, (Dag)object, wmiMathContext);
        } else {
            object = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
            wmiMathModelArray[0] = WmiMathFactory.addBrackets((WmiMathModel)object, wmiMathContext);
        }
        wmiMathModelArray[1] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, ARROW_OPERATOR, wmiMathContext);
        object = dag.getChild(4);
        wmiMathModelArray[2] = this.buildStatementSeq((Dag)object, wmiMathDocumentModel, wmiMathContext, true);
        wmiMathContext.setOperatorProc(false);
        return wmiMathModelArray;
    }

    private boolean isProcVisible(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext) {
        int n;
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = WmiProcBuilder.getVerboseProcProperty(wmiMathDocumentModel);
        boolean bl4 = bl = n2 > 0;
        if (dag != null && dag.getLength() > 0) {
            n = dag.getLength();
            for (int i = 0; i < n; ++i) {
                Dag dag2 = dag.getChild(i);
                String string = dag2.getData();
                if (null == string) continue;
                if (string.equals(OPERATOR_OPTION_NAME)) {
                    bl2 = wmiMathContext.getProcCount() == 0;
                    continue;
                }
                if (!string.startsWith(COPYRIGHT_OPTION_START)) continue;
                bl3 = true;
            }
        }
        n = bl && (!bl3 || n2 != 1) ? 1 : 0;
        return n != 0;
    }

    private WmiMathModel[] buildNormalProcChildren(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiMathModel wmiMathModel, boolean bl, int n, boolean bl2) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Object object;
        int n2 = dag.getLength();
        Dag dag2 = dag.getLength() > 8 ? dag.getChild(8) : null;
        Dag dag3 = dag.getChild(1);
        Dag dag4 = dag.getChild(3);
        Dag dag5 = dag.getChild(6);
        Dag dag6 = dag.getChild(5);
        Dag dag7 = dag.getChild(4);
        Dag dag8 = dag.getChild(3);
        Dag dag9 = null;
        if (n2 > 8) {
            dag9 = dag.getChild(n2 - 1);
        }
        boolean bl3 = dag.getType() == 39 ? ModdefDagFactory.calculateLength(dag2) > 0 : false;
        boolean bl4 = dag3.getLength() > 0;
        boolean bl5 = dag4.getLength() > 0 && dag.getType() == 39;
        boolean bl6 = dag5.getLength() > 0;
        boolean bl7 = dag6.getLength() > 0;
        boolean bl8 = dag8.getLength() > 0 && dag.getType() == 34;
        boolean bl9 = dag.getType() == 34 && ProcDagFactory.hasReturnType(dag);
        int n3 = 6;
        n3 += bl3 ? 2 : 0;
        if (bl) {
            n3 += bl4 ? 1 : 0;
            n3 += bl6 ? 1 : 0;
            n3 += bl8 && n > 2 ? 1 : 0;
            n3 += wmiMathModel != null ? 1 : 0;
        }
        n3 += bl7 ? 1 : 0;
        n3 += bl5 ? 1 : 0;
        WmiMathModel[] wmiMathModelArray = new WmiMathModel[n3 += bl9 ? 1 : 0];
        int n4 = 0;
        String string = dag.getType() == 34 ? PROC_OPERATOR : MODULE_OPERATOR;
        wmiMathModelArray[n4++] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, string, wmiMathContext);
        if (bl3) {
            wmiMathModelArray[n4] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiMathModelArray[n4++].addAttribute("width", "0.5em");
            object = dag.getChild(8);
            wmiMathModelArray[n4++] = WmiMathFactory.createMath(wmiMathDocumentModel, (Dag)object, wmiMathContext);
        }
        if (dag.getType() == 34) {
            ProcDagFactory.addToStacks(dag);
        } else if (dag.getType() == 39) {
            ProcDagFactory.addToStacks(dag.getChild(0), dag.getChild(1), dag.getChild(7), dag.getChild(3));
        }
        wmiMathContext.incrementProcCounter();
        wmiMathModelArray[n4++] = dag.getType() == 34 ? ((object = DagUtil.formatProcParams(dag)) != null ? this.buildParameters((Dag)object, wmiMathDocumentModel, wmiMathContext) : this.buildParameters(dag.getChild(0), wmiMathDocumentModel, wmiMathContext)) : this.buildParameters(DagConstants.EMPTY, wmiMathDocumentModel, wmiMathContext);
        if (bl9) {
            object = new WmiInlineMathModel(wmiMathDocumentModel);
            ((WmiAbstractArrayCompositeModel)object).appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "::", wmiMathContext));
            ((WmiAbstractArrayCompositeModel)object).appendChild(WmiMathFactory.createMathModel(wmiMathDocumentModel, dag9, wmiMathContext));
            ((WmiAbstractArrayCompositeModel)object).appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, SEMICOLON_STATEMENT_SEPARATOR_OPERATOR, wmiMathContext));
            wmiMathModelArray[n4++] = object;
        }
        WmiMathModel wmiMathModel2 = wmiMathModelArray[n4++] = wmiMathContext.getProcCount() == 1 ? WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, PROC_INDENT_LINEBREAK_ATTR) : WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, PROC_INC_LINEBREAK_ATTR);
        if (bl) {
            if (wmiMathModel != null) {
                wmiMathModelArray[n4++] = wmiMathModel;
            }
            if (bl4) {
                if (dag3.getType() == 30) {
                    dag3.setType(29);
                }
                wmiMathModelArray[n4++] = this.buildProcKeyword(dag3, wmiMathDocumentModel, wmiMathContext, LOCAL_KEYWORD);
            }
        }
        if (bl5) {
            wmiMathModelArray[n4++] = this.buildProcKeyword(dag4, wmiMathDocumentModel, wmiMathContext, EXPORT_KEYWORD);
        }
        if (bl && bl6) {
            wmiMathModelArray[n4++] = this.buildProcKeyword(dag5, wmiMathDocumentModel, wmiMathContext, GLOBAL_KEYWORD);
        }
        if (bl7) {
            wmiMathModelArray[n4++] = this.buildProcKeyword(dag6, wmiMathDocumentModel, wmiMathContext, DESCRIPTION_KEYWORD);
        }
        if (bl2) {
            wmiMathContext.setOperatorProc(true);
        }
        wmiMathModelArray[n4++] = this.buildStatementSeq(dag7, wmiMathDocumentModel, wmiMathContext, bl);
        wmiMathModelArray[n4++] = WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, PROC_DEC_LINEBREAK_ATTR);
        object = dag.getType() == 34 ? PROC_TERMINATION_OPERATOR : MODULE_TERMINATION_OPERATOR;
        wmiMathModelArray[n4++] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, (String)(WmiProcBuilder.getLongDelimProperty(wmiMathDocumentModel) ? object : PROC_SHORT_TERMINATION_OPERATOR), wmiMathContext);
        if (bl2) {
            wmiMathContext.setOperatorProc(false);
        }
        if (bl && n > 2 && bl8) {
            wmiMathModelArray[n4++] = WmiMathFactory.createMath(wmiMathDocumentModel, dag8, wmiMathContext);
        }
        return wmiMathModelArray;
    }

    WmiMathModel buildProcKeyword(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        WmiModel[] wmiModelArray = new WmiMathModel[5];
        wmiModelArray[0] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, string, wmiMathContext);
        wmiModelArray[1] = new WmiMathSpaceModel(wmiMathDocumentModel);
        wmiModelArray[1].addAttribute("width", "0.5em");
        wmiModelArray[2] = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
        wmiModelArray[3] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, SEMICOLON_STATEMENT_SEPARATOR_OPERATOR, wmiMathContext);
        wmiModelArray[4] = WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, PROC_INDENT_LINEBREAK_ATTR);
        try {
            wmiInlineMathModel.replaceChildren(wmiModelArray, 0, 0);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        return wmiInlineMathModel;
    }

    static int getVerboseProcProperty(WmiMathDocumentModel wmiMathDocumentModel) {
        int n = 0;
        if (wmiMathDocumentModel instanceof DagRenderContext) {
            n = ((DagRenderContext)((Object)wmiMathDocumentModel)).getInterfaceProperty("verboseproc", 1);
        }
        return n;
    }

    static boolean getLongDelimProperty(WmiMathDocumentModel wmiMathDocumentModel) {
        boolean bl = false;
        if (wmiMathDocumentModel instanceof DagRenderContext) {
            bl = ((DagRenderContext)((Object)wmiMathDocumentModel)).getInterfaceProperty("longdelim", true);
        }
        return bl;
    }

    WmiMathModel buildParameters(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
        wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel2, wmiMathContext);
        return wmiMathModel;
    }

    WmiMathModel buildStatementSeq(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, ELIDED_PROC_ELIPSIS, wmiMathContext);
        if (bl) {
            wmiMathModel = WmiProcBuilder.createStatementSequenceRow(dag, wmiMathDocumentModel, wmiMathContext);
        }
        return wmiMathModel;
    }

    public static WmiMathModel createStatementSequenceRow(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
    }

    public static WmiMathModel createStatementSequenceRow(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = null;
        wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
        if (dag.getLength() <= 0 || dag.getType() != 46) {
            wmiMathModel = WmiProcBuilder.addStatementSeparator(wmiMathModel, wmiMathContext, STATEMENT_SEQUENCE_BLANK_TERMINATION_OP, bl);
        }
        return wmiMathModel;
    }

    public static WmiMathModel createLinebreakIndicator(WmiMathDocumentModel wmiMathDocumentModel, WmiMathSpaceModel.WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet) {
        WmiMathSpaceModel wmiMathSpaceModel = new WmiMathSpaceModel(wmiMathDocumentModel, STATEMENT_SEQUENCE_BLANK_TERMINATION_OP, (WmiAttributeSet)wmiMathSpaceAttributeSet);
        try {
            wmiMathSpaceModel.addAttribute("width", "0.5em");
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        return wmiMathSpaceModel;
    }

    public static WmiMathModel addStatementSeparator(WmiMathModel wmiMathModel, WmiMathContext wmiMathContext, boolean bl) throws WmiNoWriteAccessException {
        return WmiProcBuilder.addStatementSeparator(wmiMathModel, wmiMathContext, SEMICOLON_STATEMENT_SEPARATOR_OPERATOR, bl);
    }

    public static WmiMathModel addStatementSeparator(WmiMathModel wmiMathModel, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException {
        return WmiProcBuilder.addStatementSeparator(wmiMathModel, wmiMathContext, SEMICOLON_STATEMENT_SEPARATOR_OPERATOR, true);
    }

    public static WmiMathModel addStatementSeparator(WmiMathModel wmiMathModel, WmiMathContext wmiMathContext, String string) throws WmiNoWriteAccessException {
        return WmiProcBuilder.addStatementSeparator(wmiMathModel, wmiMathContext, string, true);
    }

    public static WmiMathModel addStatementSeparator(WmiMathModel wmiMathModel, WmiMathContext wmiMathContext, String string, boolean bl) throws WmiNoWriteAccessException {
        WmiMathModel wmiMathModel2 = null;
        if (!bl && string.equals(STATEMENT_SEQUENCE_BLANK_TERMINATION_OP)) {
            wmiMathModel2 = wmiMathModel;
        } else {
            WmiMathDocumentModel wmiMathDocumentModel = wmiMathModel.getDocument();
            wmiMathModel2 = new WmiInlineMathModel(wmiMathDocumentModel);
            int n = bl ? 3 : 2;
            WmiModel[] wmiModelArray = new WmiMathModel[n];
            wmiModelArray[0] = wmiMathModel;
            wmiModelArray[1] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, string, wmiMathContext);
            if (bl) {
                wmiModelArray[2] = WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, PROC_INDENT_LINEBREAK_ATTR);
            }
            try {
                ((WmiInlineMathModel)wmiMathModel2).replaceChildren(wmiModelArray, 0, 0);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
        }
        return wmiMathModel2;
    }

    public Dag toDag(WmiMathModel wmiMathModel) {
        return null;
    }

    static {
        PROC_INC_LINEBREAK_ATTR.addAttribute("linebreak", "increaseindentnewline");
        PROC_INC_LINEBREAK_ATTR.addAttribute("width", POST_PROC_SPACE);
        PROC_DEC_LINEBREAK_ATTR.addAttribute("linebreak", "decreaseindentnewline");
        PROC_INDENT_LINEBREAK_ATTR.addAttribute("linebreak", "firstprocnewline");
        PROC_INDENT_LINEBREAK_ATTR.addAttribute("width", POST_PROC_SPACE);
    }

    public static class WmiStatementSequenceBuilder
    implements WmiMathModelBuilder,
    WmiMathSemantics {
        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
            int n = dag.getLength();
            int n2 = n - 1;
            WmiModel[] wmiModelArray = new WmiMathModel[n];
            for (int i = 0; i < n2; ++i) {
                wmiModelArray[i] = WmiProcBuilder.addStatementSeparator(WmiMathFactory.createMath(wmiMathDocumentModel, dag.getChild(i), wmiMathContext), wmiMathContext);
            }
            wmiModelArray[n2] = WmiProcBuilder.addStatementSeparator(WmiMathFactory.createMath(wmiMathDocumentModel, dag.getChild(n2), wmiMathContext), wmiMathContext, WmiProcBuilder.STATEMENT_SEQUENCE_BLANK_TERMINATION_OP, false);
            try {
                wmiInlineMathModel.replaceChildren(wmiModelArray, 0, 0);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
            wmiInlineMathModel.setSemantics(this);
            return wmiInlineMathModel;
        }

        public Dag toDag(WmiMathModel wmiMathModel) {
            return null;
        }
    }
}

