/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiRootModel;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSpecialFunctionBuilder;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;

public class WmiPowerBuilder
implements WmiMathModelBuilder,
WmiSpecialFunctionBuilder,
WmiMathSemantics {
    public static final String SQUARE_ROOT_FUNCTION_NAME = "sqrt";
    public static final String NTH_ROOT_FUNCTION_NAME = "surd";
    private static final int INLINE_FRAC_THRESHOLD = 2;
    private static final int BASE_DAG_INDEX = 0;
    private static final int EXPONENT_DAG_INDEX = 1;
    private static final int NUMERATOR_DAG_INDEX = 0;
    private static final int DENOMINATOR_DAG_INDEX = 1;
    private static final int INLINE_POWER_SIZE = 3;
    public static final String CARET_EXPONENT_OPERATOR = "^";
    private static final WmiMathSemantics ROOT_SEMANTICS = new WmiRootSemantics();
    private static final String LINEBREAK_CONTEXT_NAME = "power";

    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = null;
        Dag dag2 = dag.getChild(0);
        Dag dag3 = dag.getChild(1);
        WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
        wmiMathModel = wmiMathContext.useProcRules() ? this.createInlinePowerModel(wmiMathDocumentModel, wmiMathModel2, dag, dag2, dag3, wmiMathContext) : (DagUtil.isOneHalf(dag3) ? this.createSquareRootModel(wmiMathDocumentModel, wmiMathModel2, wmiMathContext) : (dag2.getType() == 10 ? this.createSubSupPower(wmiMathDocumentModel, dag, dag2, dag3, wmiMathContext) : this.createPowerModel(wmiMathDocumentModel, wmiMathModel2, dag, dag2, dag3, wmiMathContext)));
        if (wmiMathContext.shouldSubExpressionLabel(wmiMathModel, dag)) {
            wmiMathModel = wmiMathContext.createSubexpressionLabel(wmiMathModel, dag);
        }
        return wmiMathModel;
    }

    private WmiMathModel createInlinePowerModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathModel wmiMathModel, Dag dag, Dag dag2, Dag dag3, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        WmiModel[] wmiModelArray = new WmiMathModel[3];
        WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag3, wmiMathContext);
        if (WmiPrecedenceRules.areBracketsRequired(dag2, dag, 1)) {
            wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, wmiMathContext);
        }
        if (WmiPrecedenceRules.areBracketsRequired(dag3, dag, 1)) {
            wmiMathModel2 = WmiMathFactory.addBrackets(wmiMathModel2, wmiMathContext);
        }
        wmiModelArray[0] = wmiMathModel;
        wmiModelArray[1] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, CARET_EXPONENT_OPERATOR, wmiMathContext);
        wmiModelArray[2] = wmiMathModel2;
        try {
            wmiInlineMathModel.replaceChildren(wmiModelArray, 0, 0);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        return wmiInlineMathModel;
    }

    protected WmiMathModel createSubSupPower(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, Dag dag2, Dag dag3, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = this.createExponent(wmiMathDocumentModel, dag3, wmiMathContext);
        WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag2.getChild(0), wmiMathContext);
        WmiMathModel wmiMathModel3 = WmiMathFactory.createMath(wmiMathDocumentModel, dag2.getChild(1), wmiMathContext);
        if (WmiPrecedenceRules.areBracketsRequired(dag3, dag, 1)) {
            wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, wmiMathContext);
        }
        WmiSubSupModel wmiSubSupModel = new WmiSubSupModel(wmiMathDocumentModel, wmiMathModel2, wmiMathModel3, wmiMathModel, wmiMathContext);
        wmiSubSupModel.setSemantics(this);
        return wmiSubSupModel;
    }

    private WmiMathModel createExponent(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = null;
        if (dag.getType() == 3) {
            Dag dag2 = dag.getChild(0);
            Dag dag3 = dag.getChild(1);
            if (dag2.getData().length() <= 2 && dag3.getData().length() <= 2) {
                wmiMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
                ((WmiCompositeModel)((Object)wmiMathModel)).appendChild(WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext));
                ((WmiCompositeModel)((Object)wmiMathModel)).appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "/", wmiMathContext));
                ((WmiCompositeModel)((Object)wmiMathModel)).appendChild(WmiMathFactory.createMath(wmiMathDocumentModel, dag3, wmiMathContext));
                wmiMathModel.setSemantics(WmiNumericModel.INLINE_RATIONAL_SEMANTICS);
            }
        }
        if (wmiMathModel == null) {
            wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
        }
        return wmiMathModel;
    }

    protected WmiMathModel createPowerModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathModel wmiMathModel, Dag dag, Dag dag2, Dag dag3, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel2 = this.createExponent(wmiMathDocumentModel, dag3, wmiMathContext);
        if (wmiMathModel instanceof WmiRootModel || WmiPrecedenceRules.areBracketsRequired(dag2, dag, 1)) {
            wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, wmiMathContext);
        }
        WmiSuperscriptModel wmiSuperscriptModel = new WmiSuperscriptModel(wmiMathDocumentModel, wmiMathModel, wmiMathModel2, wmiMathContext);
        wmiSuperscriptModel.setSemantics(this);
        return wmiSuperscriptModel;
    }

    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel wmiMathDocumentModel, String string, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = null;
        WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag.getChild(0), wmiMathContext);
        if (string.equals(SQUARE_ROOT_FUNCTION_NAME)) {
            wmiMathModel = this.createSquareRootModel(wmiMathDocumentModel, wmiMathModel2, wmiMathContext);
        } else {
            WmiMathModel wmiMathModel3 = WmiMathFactory.createMath(wmiMathDocumentModel, dag.getChild(1), wmiMathContext);
            wmiMathModel = new WmiRootModel(wmiMathDocumentModel, wmiMathModel2, wmiMathModel3, wmiMathContext);
            wmiMathModel.setSemantics(ROOT_SEMANTICS);
        }
        return wmiMathModel;
    }

    public boolean shouldBeUsed(Dag dag, WmiMathContext wmiMathContext) {
        int n;
        Dag dag2;
        boolean bl;
        boolean bl2 = bl = !wmiMathContext.useProcRules();
        if (bl && !(dag2 = dag.getChild(n = 0)).getData().equals(SQUARE_ROOT_FUNCTION_NAME)) {
            Dag dag3;
            int n2 = 1;
            int n3 = 1;
            Dag dag4 = dag.getChild(n2);
            bl = dag4 != null && dag4.getLength() > 1 ? (dag3 = dag4.getChild(n3)) != null && (dag3.getType() == 2 || dag3.getType() == 8) && dag3.getData().length() == 1 : false;
        }
        return bl;
    }

    protected WmiMathModel createSquareRootModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathModel wmiMathModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiRootModel.WmiSquareRootModel wmiSquareRootModel = new WmiRootModel.WmiSquareRootModel(wmiMathDocumentModel, (WmiModel)wmiMathModel, wmiMathContext);
        wmiSquareRootModel.setSemantics(ROOT_SEMANTICS);
        return wmiSquareRootModel;
    }

    public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
        int n;
        Dag dag = null;
        WmiCompositeModel wmiCompositeModel = wmiMathModel instanceof WmiCompositeModel ? (WmiCompositeModel)((Object)wmiMathModel) : null;
        int n2 = n = wmiCompositeModel != null ? wmiCompositeModel.getChildCount() : 0;
        if (n == 2 && wmiCompositeModel.getTag() == WmiModelTag.MATH_SUPERSCRIPT) {
            WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(0);
            WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel.getChild(1);
            Dag[] dagArray = new Dag[]{wmiMathModel2.toDag(), wmiMathModel3.toDag()};
            dag = Dag.createDag(13, dagArray, null, false);
        } else if (n == 3 && wmiCompositeModel.getTag() == WmiModelTag.MATH_SUB_SUP) {
            WmiMathModel wmiMathModel4 = (WmiMathModel)wmiCompositeModel.getChild(0);
            WmiMathModel wmiMathModel5 = (WmiMathModel)wmiCompositeModel.getChild(1);
            WmiMathModel wmiMathModel6 = (WmiMathModel)wmiCompositeModel.getChild(2);
            Dag[] dagArray = new Dag[]{wmiMathModel4.toDag(), wmiMathModel5.toDag()};
            WmiSemanticDagUtil.fillNullDags(dagArray);
            Dag dag2 = Dag.createDag(10, dagArray, null, false);
            dagArray = new Dag[]{dag2, wmiMathModel6.toDag()};
            WmiSemanticDagUtil.fillNullDags(dagArray);
            dag = Dag.createDag(13, dagArray, null, false);
        }
        return dag;
    }

    public static class WmiRootSemantics
    implements WmiMathSemantics {
        private static final String LINEBREAK_CONTEXT_NAME = "root";

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            Dag dag = null;
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
            WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(0);
            Dag[] dagArray = new Dag[2];
            dagArray[0] = wmiMathModel2.toDag();
            int n = wmiCompositeModel.getChildCount();
            if (n == 1) {
                dagArray[1] = DagConstants.ONE_HALF;
                WmiSemanticDagUtil.fillNullDags(dagArray);
                dag = Dag.createDag(13, dagArray, null, false);
            } else if (n > 1) {
                WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel.getChild(1);
                dagArray[1] = wmiMathModel3.toDag();
                WmiSemanticDagUtil.fillNullDags(dagArray);
                Dag dag2 = Dag.createDag(29, dagArray, null, false);
                dagArray = new Dag[]{Dag.createDag(8, null, WmiPowerBuilder.NTH_ROOT_FUNCTION_NAME, false), dag2};
                dag = Dag.createDag(18, dagArray, null, false);
            }
            return dag;
        }
    }
}

