/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import java.math.BigDecimal;

public class WmiNumericFormatter {
    private static final int MAX_EXPANDED_DIGITS = 100000;
    private String dot = ".";
    private String displaydot;
    private String defaultdisplaydot;
    private String comma = ",";
    private String displaycomma;
    private String defaultdisplaycomma;
    private float[][] colors = new float[][]{{0.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 1.0f}};

    public WmiNumericFormatter() {
        this(".", ",");
    }

    public WmiNumericFormatter(String string, String string2) {
        this.defaultdisplaydot = string;
        this.defaultdisplaycomma = string2;
        this.displaydot = this.defaultdisplaydot;
        this.displaycomma = this.defaultdisplaycomma;
    }

    public WmiFormattedNumeric format(Dag dag, String string) {
        int n;
        int n2;
        int n3;
        this.displaydot = this.defaultdisplaydot;
        this.displaycomma = this.defaultdisplaycomma;
        WmiFormattedNumeric wmiFormattedNumeric = this.splitNumeric(dag);
        if ((string = this.getFormatter(dag, string, wmiFormattedNumeric)).length() == 0) {
            return null;
        }
        while (string.length() > 0 && string.charAt(0) == '[' && (n3 = string.indexOf("]")) != -1) {
            this.processSpecial(wmiFormattedNumeric, string.substring(1, n3));
            string = string.substring(n3 + 1);
        }
        string = this.expandFormattingString(string);
        if (wmiFormattedNumeric.isRational()) {
            n3 = WmiNumericFormatter.indexOf(string, this.dot);
            n2 = 0;
            if (n3 != -1) {
                n2 = this.countDecimals(string, n3 + 1);
            }
            wmiFormattedNumeric = wmiFormattedNumeric.approximateRational(n2);
        }
        if ((n3 = this.scale(string)) != 0) {
            wmiFormattedNumeric.setExponent(wmiFormattedNumeric.getIntegerExponent() + n3);
        }
        n2 = WmiNumericFormatter.indexOf(string, this.dot);
        int n4 = n2 + 1;
        boolean bl = true;
        if (n2 == -1) {
            bl = false;
            n4 = n2 = string.length();
        }
        wmiFormattedNumeric.setForceDot(bl);
        int n5 = WmiNumericFormatter.indexOf(string, "E+");
        if (n5 == -1) {
            n5 = WmiNumericFormatter.indexOf(string, "E-");
        }
        if (n5 == -1) {
            n5 = WmiNumericFormatter.indexOf(string, "e+");
        }
        if (n5 == -1) {
            n5 = WmiNumericFormatter.indexOf(string, "e-");
        }
        if (n5 == -1) {
            wmiFormattedNumeric.normalize(0);
        } else {
            if (n2 > n5) {
                n2 = n5;
            }
            n4 = n5;
            n = this.countLeftDigits(string, n2 - 1);
            if (n == 0 && !bl) {
                n = 1;
            }
            wmiFormattedNumeric.normalizeMultiples(n);
        }
        if (!bl) {
            wmiFormattedNumeric.roundToDecimals(0);
            this.formatRight(string, wmiFormattedNumeric, n4);
        } else {
            n = this.countDecimals(string, n2 + 1);
            wmiFormattedNumeric.roundToDecimals(n);
            this.formatRight(string, wmiFormattedNumeric, n2 + 1);
        }
        this.formatLeft(string, wmiFormattedNumeric, n2 - 1);
        return wmiFormattedNumeric;
    }

    private String expandFormattingString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.charAt(0));
        int n = 1;
        while (n < string.length()) {
            int n2 = string.indexOf("{", n);
            if (n2 == -1) {
                stringBuffer.append(string.substring(n));
                break;
            }
            stringBuffer.append(string.substring(n, n2));
            int n3 = string.indexOf("}", n2 + 1);
            if (n3 == -1) break;
            char c = string.charAt(n2 - 1);
            String string2 = string.substring(n2 + 1, n3);
            try {
                int n4 = Integer.valueOf(string2) - 1;
                if (n4 <= 0 || n4 > 100000) break;
                for (int i = 0; i < n4; ++i) {
                    stringBuffer.append(c);
                }
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
            n = n3 + 1;
        }
        return stringBuffer.toString();
    }

    private int countLeftDigits(String string, int n) {
        boolean bl = false;
        int n2 = 0;
        while (n >= 0) {
            char c = string.charAt(n);
            if (c == '\"') {
                bl = !bl;
                --n;
                continue;
            }
            if (!(bl || c != '#' && c != '0' && c != '?')) {
                ++n2;
            }
            --n;
        }
        return n2;
    }

    private int countDecimals(String string, int n) {
        boolean bl = false;
        int n2 = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\"') {
                bl = !bl;
                ++n;
                continue;
            }
            if (!bl) {
                if (c == 'E' && n < string.length() - 2) {
                    char c2 = string.charAt(n + 1);
                    char c3 = string.charAt(n + 2);
                    if (!(c2 != '+' && c2 != '-' || c3 != '#' && c3 != '0' && c3 != '?')) {
                        int n3 = WmiNumericFormatter.indexOf(string, "E", n + 2);
                        if (n3 == -1) break;
                        n = n3 + 1;
                        continue;
                    }
                }
                if (c == '#' || c == '0' || c == '?') {
                    ++n2;
                }
            }
            ++n;
        }
        return n2;
    }

    private void formatRight(String string, WmiFormattedNumeric wmiFormattedNumeric, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = wmiFormattedNumeric.getPostMantissa();
        int n2 = 0;
        boolean bl = false;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\"') {
                bl = !bl;
                ++n;
                continue;
            }
            if (!bl) {
                if (c == '#' || c == '0' || c == '?') {
                    if (n2 < string2.length()) {
                        stringBuffer.append(string2.charAt(n2));
                        ++n2;
                    } else if (c == '0') {
                        stringBuffer.append("0");
                    } else if (c == '?') {
                        stringBuffer.append(" ");
                    }
                } else if (c != this.comma.charAt(0)) {
                    int n3;
                    if (c == '_') {
                        stringBuffer.append(" ");
                        ++n;
                    } else if (c == '[') {
                        n3 = string.indexOf(93, n);
                        if (n3 != -1) {
                            this.processSpecial(wmiFormattedNumeric, string.substring(n + 1, n3));
                            n = n3;
                        }
                    } else if (c == 'E') {
                        if (n < string.length() - 2) {
                            n3 = string.charAt(n + 1);
                            char c2 = string.charAt(n + 2);
                            if (!(n3 != 43 && n3 != 45 || c2 != '#' && c2 != '0' && c2 != '?')) {
                                n = this.formatExponent(string, wmiFormattedNumeric, n + 1);
                                continue;
                            }
                        }
                        stringBuffer.append(c);
                    } else {
                        stringBuffer.append(c);
                    }
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        wmiFormattedNumeric.setPostMantissa(stringBuffer.toString());
    }

    private int formatExponent(String string, WmiFormattedNumeric wmiFormattedNumeric, int n) {
        wmiFormattedNumeric.forceExponentSign(string.charAt(n++) == '+');
        int n2 = WmiNumericFormatter.indexOf(string, "E", n);
        if (n2 == -1) {
            n2 = string.length();
        }
        this.formatExponent(string.substring(n, n2), wmiFormattedNumeric);
        return n2;
    }

    private void formatExponent(String string, WmiFormattedNumeric wmiFormattedNumeric) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "" + wmiFormattedNumeric.getIntegerExponent();
        this.formatLeft(string, stringBuffer, string2, string.length() - 1, wmiFormattedNumeric);
        wmiFormattedNumeric.setExponentString(stringBuffer.reverse().toString());
    }

    private void processSpecial(WmiFormattedNumeric wmiFormattedNumeric, String string) {
        if ((string = string.toLowerCase()).equals("red")) {
            wmiFormattedNumeric.setRGBColor(this.colors[2]);
        } else if (string.equals("black")) {
            wmiFormattedNumeric.setRGBColor(this.colors[0]);
        } else if (string.equals("blue")) {
            wmiFormattedNumeric.setRGBColor(this.colors[4]);
        } else if (string.equals("cyan")) {
            wmiFormattedNumeric.setRGBColor(this.colors[7]);
        } else if (string.equals("green")) {
            wmiFormattedNumeric.setRGBColor(this.colors[3]);
        } else if (string.equals("magenta")) {
            wmiFormattedNumeric.setRGBColor(this.colors[6]);
        } else if (string.equals("white")) {
            wmiFormattedNumeric.setRGBColor(this.colors[1]);
        } else if (string.equals("yellow")) {
            wmiFormattedNumeric.setRGBColor(this.colors[5]);
        } else if (string.startsWith("color")) {
            int n = 0;
            try {
                Integer.valueOf(string.substring(5)).intValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (n > 7 || n < 0) {
                n = 0;
            }
            wmiFormattedNumeric.setRGBColor(this.colors[n]);
        } else if (string.startsWith("sep")) {
            if (string.length() > 3) {
                this.displaydot = "" + string.charAt(3);
            }
            if (string.length() > 4) {
                this.displaycomma = "" + string.charAt(4);
            }
        } else if (!(string.startsWith("=") || string.startsWith(">") || string.startsWith("<"))) {
            throw new Error("number format not supported: " + string);
        }
    }

    private int scale(String string) {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '\"') {
                bl = !bl;
                ++n2;
                continue;
            }
            if (!bl) {
                if (c == this.comma.charAt(0)) {
                    if (n2 == string.length() - 1) {
                        n -= 3;
                    } else {
                        char c2 = string.charAt(n2 + 1);
                        if (c2 != '#' && c2 != '0' && c2 != '?') {
                            n -= 3;
                        }
                    }
                } else if (c == '%') {
                    n += 2;
                }
            }
            ++n2;
        }
        return n;
    }

    private boolean hasSeparatingComma(String string, int n) {
        boolean bl = false;
        while (n >= 0) {
            char c = string.charAt(n);
            if (c == '\"') {
                bl = !bl;
                --n;
                continue;
            }
            if (!bl && c == this.comma.charAt(0) && n < string.length() - 1) {
                char c2 = string.charAt(n + 1);
                if (c2 == '#' || c2 == '0' || c2 == '?') {
                    return true;
                }
                --n;
                continue;
            }
            --n;
        }
        return false;
    }

    private boolean hasMoreFormatDigits(String string, int n) {
        --n;
        while (n >= 0) {
            char c = string.charAt(n);
            if (c == '#' || c == '0' || c == '?') {
                return true;
            }
            --n;
        }
        return false;
    }

    private boolean hasMoreZeroFormatDigits(String string, int n) {
        --n;
        while (n >= 0) {
            char c = string.charAt(n);
            if (c == '0') {
                return true;
            }
            --n;
        }
        return false;
    }

    private void formatLeft(String string, WmiFormattedNumeric wmiFormattedNumeric, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = wmiFormattedNumeric.getPreMantissa();
        this.formatLeft(string, stringBuffer, string2, n, wmiFormattedNumeric);
        wmiFormattedNumeric.setPreMantissa(stringBuffer.reverse().toString());
    }

    private void formatLeft(String string, StringBuffer stringBuffer, String string2, int n, WmiFormattedNumeric wmiFormattedNumeric) {
        String string3 = string2;
        int n2 = string3.length() - 1;
        boolean bl = this.hasSeparatingComma(string, n);
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n >= 0) {
            if (n > 0 && string.charAt(n - 1) == '_') {
                if (bl3 && !this.hasMoreFormatDigits(string, n)) {
                    while (n2 >= 0) {
                        stringBuffer.append(string3.charAt(n2));
                        if (bl && n2 > 0 && ++n3 == 3) {
                            stringBuffer.append(this.displaycomma);
                            n3 = 0;
                        }
                        --n2;
                    }
                }
                stringBuffer.append(" ");
                n -= 2;
                continue;
            }
            char c = string.charAt(n);
            if (c == '\"') {
                bl2 = !bl2;
                --n;
                continue;
            }
            if (!bl2) {
                if (c == '#' || c == '0' || c == '?') {
                    bl3 = true;
                    if (n2 >= 0) {
                        stringBuffer.append(string3.charAt(n2));
                        if (bl && (n2 > 0 || this.hasMoreZeroFormatDigits(string, n)) && ++n3 == 3) {
                            stringBuffer.append(this.displaycomma);
                            n3 = 0;
                        }
                        --n2;
                    } else if (c == '0') {
                        stringBuffer.append("0");
                        if (bl && this.hasMoreFormatDigits(string, n) && ++n3 == 3) {
                            stringBuffer.append(this.displaycomma);
                            n3 = 0;
                        }
                    } else if (c == '?') {
                        stringBuffer.append(" ");
                        if (++n3 == 3) {
                            n3 = 0;
                        }
                    }
                } else if (c != this.comma.charAt(0)) {
                    if (c == ']') {
                        int n4;
                        for (n4 = n - 1; n4 >= 0 && string.charAt(n4) != '['; --n4) {
                        }
                        if (n4 != -1) {
                            this.processSpecial(wmiFormattedNumeric, string.substring(n4 + 1, n));
                            n = n4;
                        }
                    } else {
                        if (bl3 && !this.hasMoreFormatDigits(string, n)) {
                            while (n2 >= 0) {
                                stringBuffer.append(string3.charAt(n2));
                                if (bl && n2 > 0 && ++n3 == 3) {
                                    stringBuffer.append(this.displaycomma);
                                    n3 = 0;
                                }
                                --n2;
                            }
                        }
                        stringBuffer.append(c);
                    }
                }
            } else {
                if (bl3 && !this.hasMoreFormatDigits(string, n)) {
                    while (n2 >= 0) {
                        stringBuffer.append(string3.charAt(n2));
                        if (bl && n2 > 0 && ++n3 == 3) {
                            stringBuffer.append(this.displaycomma);
                            n3 = 0;
                        }
                        --n2;
                    }
                }
                stringBuffer.append(c);
            }
            --n;
        }
        if (bl3) {
            while (n2 >= 0) {
                stringBuffer.append(string3.charAt(n2));
                if (bl && n2 > 0 && ++n3 == 3) {
                    stringBuffer.append(this.displaycomma);
                    n3 = 0;
                }
                --n2;
            }
        }
    }

    public WmiFormattedNumeric splitNumeric(Dag dag) {
        if (DagUtil.isFloatZero(dag) || DagUtil.isZero(dag)) {
            WmiFormattedNumeric wmiFormattedNumeric = new WmiFormattedNumeric("0", 0);
            wmiFormattedNumeric.setZero(true);
            return wmiFormattedNumeric;
        }
        if (DagUtil.isFloat(dag)) {
            Dag dag2 = dag.getChild(0);
            if (DagUtil.isFloatInfinity(dag)) {
                WmiFormattedNumeric wmiFormattedNumeric = new WmiFormattedNumeric(true, false);
                if (DagUtil.isNegative(dag)) {
                    wmiFormattedNumeric.setSign(-1);
                }
                return wmiFormattedNumeric;
            }
            if (DagUtil.isNameNamed(dag.getChild(1), "undefined")) {
                return new WmiFormattedNumeric(false, true);
            }
            String string = dag2.getData();
            if (string.equals("0")) {
                WmiFormattedNumeric wmiFormattedNumeric = new WmiFormattedNumeric("0", 0);
                wmiFormattedNumeric.setZero(true);
                return wmiFormattedNumeric;
            }
            if (DagUtil.isNegInt(dag2)) {
                string = "-" + string;
            }
            int n = DagUtil.parseInt(dag.getChild(1));
            return new WmiFormattedNumeric(string, n);
        }
        if (DagUtil.isPosInt(dag)) {
            return new WmiFormattedNumeric(dag.getData(), 0);
        }
        if (DagUtil.isNegInt(dag)) {
            return new WmiFormattedNumeric("-" + dag.getData(), 0);
        }
        if (DagUtil.isSum(dag)) {
            if (DagUtil.isNameNamed(dag.getChild(0), "infinity")) {
                WmiFormattedNumeric wmiFormattedNumeric = new WmiFormattedNumeric(true, false);
                if (DagUtil.isNegative(dag.getChild(1))) {
                    wmiFormattedNumeric.setSign(-1);
                }
                return wmiFormattedNumeric;
            }
            return new WmiFormattedNumeric(DagBuilder.lPrint(dag), 0);
        }
        if (DagUtil.isNameNamed(dag, "infinity")) {
            return new WmiFormattedNumeric(true, false);
        }
        if (DagUtil.isNameNamed(dag, "undefined")) {
            return new WmiFormattedNumeric(false, true);
        }
        if (DagUtil.isRational(dag)) {
            return new WmiFormattedNumeric(dag);
        }
        throw new Error("unexpected DAG: " + dag);
    }

    public String getFormatter(Dag dag, String string) {
        return this.getFormatter(dag, string, null);
    }

    private String getFormatter(Dag dag, String string, WmiFormattedNumeric wmiFormattedNumeric) {
        if (this.hasConditional(string)) {
            return this.getConditionalFormatter(dag, string);
        }
        string = DagUtil.isZero(dag) || DagUtil.isFloatZero(dag) ? this.getZeroFormatter(string) : (DagUtil.isNegative(dag) ? this.getNegativeFormatter(string, wmiFormattedNumeric) : this.getPositiveFormatter(string));
        return string;
    }

    private boolean hasConditional(String string) {
        int n = WmiNumericFormatter.indexOf(string, "[");
        while (n != -1) {
            char c;
            if (n < string.length() - 1 && ((c = string.charAt(n + 1)) == '=' || c == '<' || c == '>')) {
                return true;
            }
            n = WmiNumericFormatter.indexOf(string, "[", n + 1);
        }
        return false;
    }

    private String getConditionalFormatter(Dag dag, String string) {
        int[] nArray;
        int n = 0;
        while ((nArray = this.getNextFormatter(string, n)) != null) {
            String string2 = string.substring(nArray[0], nArray[1]);
            n = nArray[1] + 1;
            String[] stringArray = this.getCondition(string2);
            if (stringArray != null && !this.meetsCondition(dag, stringArray)) continue;
            return string2;
        }
        return "";
    }

    private int[] getNextFormatter(String string, int n) {
        if (n >= string.length()) {
            return null;
        }
        int n2 = WmiNumericFormatter.indexOf(string, ";", n);
        if (n2 == -1) {
            n2 = string.length();
        }
        return new int[]{n, n2};
    }

    private String[] getCondition(String string) {
        int n = WmiNumericFormatter.indexOf(string, "[");
        if (n == -1) {
            return null;
        }
        int n2 = WmiNumericFormatter.indexOf(string, "]", n);
        if (n2 == -1) {
            return null;
        }
        String string2 = string.substring(n + 1, n2);
        if (string2.length() < 2) {
            return null;
        }
        char c = string2.charAt(0);
        if (c != '=' && c != '<' && c != '>') {
            return null;
        }
        String string3 = "" + (char)c;
        String string4 = null;
        char c2 = string2.charAt(1);
        if (c2 == '=' || c2 == '>') {
            string3 = string3 + (char)c2;
            string4 = string2.substring(2);
        } else {
            string4 = string2.substring(1);
        }
        return new String[]{string3, string4.trim()};
    }

    private boolean meetsCondition(Dag dag, String[] stringArray) {
        double d = Double.valueOf(stringArray[1]);
        return this.meetsCondition(dag, stringArray[0], d);
    }

    private boolean meetsCondition(Dag dag, String string, double d) {
        int n = this.compare(dag, d);
        if (string.equals("=")) {
            return n == 0;
        }
        if (string.equals(">")) {
            return n == 1;
        }
        if (string.equals("<")) {
            return n == -1;
        }
        if (string.equals(">=")) {
            return n == 0 || n == 1;
        }
        if (string.equals("<=")) {
            return n == 0 || n == -1;
        }
        if (string.equals("<>")) {
            return n != 0;
        }
        return false;
    }

    private int compare(Dag dag, double d) {
        String string = DagBuilder.lPrint(dag);
        if (string.equals("undefined")) {
            return 2;
        }
        if (string.equals("infinity")) {
            return 1;
        }
        if (string.equals("-infinity")) {
            return -1;
        }
        BigDecimal bigDecimal = new BigDecimal(string);
        return bigDecimal.compareTo(new BigDecimal(d));
    }

    private String getZeroFormatter(String string) {
        int n = WmiNumericFormatter.indexOf(string, ";");
        if (n == -1) {
            return string;
        }
        int n2 = WmiNumericFormatter.indexOf(string, ";", n + 1);
        if (n2 == -1) {
            return string.substring(0, n);
        }
        return string.substring(n2 + 1);
    }

    private String getNegativeFormatter(String string, WmiFormattedNumeric wmiFormattedNumeric) {
        int n = WmiNumericFormatter.indexOf(string, ";");
        if (n == -1) {
            return string;
        }
        int n2 = WmiNumericFormatter.indexOf(string, ";", n + 1);
        if (n2 == n + 1) {
            return this.getPositiveFormatter(string);
        }
        if (wmiFormattedNumeric != null) {
            wmiFormattedNumeric.setSign(1);
        }
        if (n2 == -1) {
            return string.substring(n + 1);
        }
        return string.substring(n + 1, n2);
    }

    private String getPositiveFormatter(String string) {
        int n = WmiNumericFormatter.indexOf(string, ";");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private static int indexOf(String string, String string2) {
        return WmiNumericFormatter.indexOf(string, string2, 0);
    }

    private static int indexOf(String string, String string2, int n) {
        boolean bl = false;
        char c = string2.charAt(0);
        int n2 = string2.length();
        for (int i = n; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == '\"') {
                bl = !bl;
                continue;
            }
            if (bl || c2 != c) continue;
            if (n2 == 1) {
                return i;
            }
            if (i + n2 > string.length() || !string.substring(i, i + n2).equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public class WmiFormattedNumeric {
        private String premantissa;
        private String postmantissa;
        private int exponent;
        private String xstring;
        private boolean forcedot;
        private boolean isnegative;
        private boolean iszero;
        private float[] color;
        private boolean forcexsign;
        private boolean isinfinity = false;
        private boolean isundefined = false;
        private Dag rational;
        private boolean signforced;

        public WmiFormattedNumeric(boolean bl, boolean bl2) {
            if (bl2) {
                this.isundefined = true;
            } else if (bl) {
                this.isinfinity = true;
            }
            this.premantissa = "";
            this.exponent = 0;
        }

        public void setZero(boolean bl) {
            this.iszero = bl;
        }

        public WmiFormattedNumeric(String string, int n) {
            int n2;
            this.premantissa = string;
            if (!WmiNumericFormatter.this.displaydot.equals(WmiNumericFormatter.this.dot) && (n2 = string.indexOf(WmiNumericFormatter.this.dot)) != -1) {
                this.premantissa = string.substring(0, n2 - 1) + WmiNumericFormatter.this.displaydot + string.substring(n2 + 1);
            }
            this.exponent = n;
            this.isnegative = false;
            if (this.premantissa != null && this.premantissa.length() > 0 && this.premantissa.charAt(0) == '-') {
                this.isnegative = true;
                this.premantissa = this.premantissa.substring(1);
            }
            if (this.premantissa.equals("0")) {
                this.premantissa = "";
            }
        }

        public WmiFormattedNumeric(Dag dag) {
            this.rational = dag;
        }

        public boolean isRational() {
            return this.rational != null;
        }

        public WmiFormattedNumeric approximateRational(int n) {
            BigDecimal bigDecimal = new BigDecimal(DagBuilder.lPrint(this.rational.getChild(0)));
            BigDecimal bigDecimal2 = new BigDecimal(DagBuilder.lPrint(this.rational.getChild(1)));
            BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, n += bigDecimal2.unscaledValue().bitLength() / 3, 6);
            WmiFormattedNumeric wmiFormattedNumeric = new WmiFormattedNumeric(bigDecimal3.unscaledValue().toString(), -bigDecimal3.scale());
            if (this.signforced) {
                wmiFormattedNumeric.isnegative = this.isnegative;
            }
            wmiFormattedNumeric.color = this.color;
            return wmiFormattedNumeric;
        }

        public void setExponentString(String string) {
            this.xstring = string;
        }

        public void forceExponentSign(boolean bl) {
            this.forcexsign = bl;
        }

        public void setRGBColor(float[] fArray) {
            this.color = fArray;
        }

        public float[] getRGBColor() {
            return this.color;
        }

        public String getPostMantissa() {
            return this.postmantissa;
        }

        public void setPostMantissa(String string) {
            this.postmantissa = string;
        }

        public String getPreMantissa() {
            return this.premantissa;
        }

        public void setPreMantissa(String string) {
            this.premantissa = string;
        }

        public int getSign() {
            if (this.iszero) {
                return 0;
            }
            if (this.isnegative) {
                return -1;
            }
            return 1;
        }

        public void setSign(int n) {
            this.signforced = true;
            this.isnegative = n == -1;
        }

        public void setForceDot(boolean bl) {
            this.forcedot = bl;
        }

        public int getIntegerExponent() {
            if (this.iszero) {
                return 0;
            }
            return this.exponent;
        }

        public void setExponent(int n) {
            this.exponent = n;
        }

        public String getMantissa() {
            String string = this.premantissa;
            if (this.postmantissa != null && this.postmantissa.length() > 0) {
                string = string + WmiNumericFormatter.this.displaydot + this.postmantissa;
            }
            return string;
        }

        public String getExponent() {
            if (this.xstring != null && this.iszero) {
                this.xstring = "0";
            }
            if (this.forcexsign && this.xstring.charAt(0) != '-') {
                return "+" + this.xstring;
            }
            return this.xstring;
        }

        public void trim() {
            int n;
            String string = this.postmantissa;
            for (n = string.length() - 1; n >= 0 && string.charAt(n) == '0'; --n) {
            }
            this.postmantissa = this.postmantissa.substring(0, n + 1);
        }

        public void roundToDecimals(int n) {
            int n2;
            if (this.postmantissa == null || this.postmantissa.length() <= n) {
                return;
            }
            boolean bl = false;
            int n3 = n;
            while ((n2 = this.postmantissa.charAt(n) - 48) >= 5) {
                int n4;
                if (n2 > 5) {
                    bl = true;
                    break;
                }
                if (++n < this.postmantissa.length()) continue;
                if (n3 > 0) {
                    n = n3 - 1;
                    int n5 = this.postmantissa.charAt(n) - 48;
                    if (n5 / 2 * 2 == n5) break;
                    bl = true;
                    break;
                }
                if (this.premantissa == null || this.premantissa.length() == 0 || (n4 = this.premantissa.charAt(n = this.premantissa.length() - 1) - 48) / 2 * 2 == n4) break;
                bl = true;
                break;
            }
            this.postmantissa = this.postmantissa.substring(0, n3);
            if (bl) {
                if (n3 > 0) {
                    n2 = this.postmantissa.length();
                    this.postmantissa = this.increment(this.postmantissa);
                    if (this.postmantissa.length() > n2) {
                        this.postmantissa = this.postmantissa.substring(1);
                        this.premantissa = this.increment(this.premantissa);
                    }
                } else {
                    this.premantissa = this.increment(this.premantissa);
                }
            }
            this.trim();
        }

        private String increment(String string) {
            if (string == null || string.length() == 0) {
                return "1";
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            for (int i = string.length() - 1; i >= 0; --i) {
                int n2 = string.charAt(i) - 48;
                if ((n2 += n) == 10) {
                    stringBuffer.append("0");
                    n = 1;
                    continue;
                }
                stringBuffer.append((char)(48 + n2));
                n = 0;
            }
            if (n == 1) {
                stringBuffer.append("1");
            }
            stringBuffer.reverse();
            return stringBuffer.toString();
        }

        public String getDigits() {
            String string = this.premantissa;
            if (this.postmantissa != null && this.postmantissa.length() > 0) {
                string = string + WmiNumericFormatter.this.displaydot + this.postmantissa;
            } else if (this.forcedot) {
                string = string + WmiNumericFormatter.this.displaydot;
            }
            return string;
        }

        public void setMantissa(String string) {
            int n = string.indexOf(WmiNumericFormatter.this.displaydot);
            if (n == -1) {
                this.premantissa = string;
                this.postmantissa = null;
            } else {
                this.premantissa = string.substring(0, n);
                this.postmantissa = string.substring(n + 1);
            }
        }

        public void normalize(int n) {
            int n2;
            String string;
            StringBuffer stringBuffer;
            int n3;
            String string2;
            if (n == this.exponent) {
                if (this.premantissa == null || this.premantissa.equals("0")) {
                    this.premantissa = "";
                }
                if (this.postmantissa == null) {
                    this.postmantissa = "";
                }
                return;
            }
            int n4 = this.exponent - n;
            if (n4 < 0) {
                string2 = this.premantissa;
                if (string2.equals("0")) {
                    string2 = "";
                }
                if ((n3 = (n4 = -n4) - string2.length()) < 0) {
                    n3 = 0;
                }
                stringBuffer = new StringBuffer(n3);
                for (int i = 0; i < n3; ++i) {
                    stringBuffer.append("0");
                }
                string2 = stringBuffer.toString() + string2;
                string = string2.substring(string2.length() - n4, string2.length());
                this.postmantissa = this.postmantissa != null ? string + this.postmantissa : string;
                this.premantissa = string2.substring(0, string2.length() - n4);
                if (this.premantissa.equals("0")) {
                    this.premantissa = "";
                }
                if (this.postmantissa == null) {
                    this.postmantissa = "";
                }
            } else {
                if (this.postmantissa == null) {
                    this.postmantissa = "";
                }
                if ((n3 = n4 - (string2 = this.postmantissa).length()) < 0) {
                    n3 = 0;
                }
                stringBuffer = new StringBuffer(n3);
                for (int i = 0; i < n3; ++i) {
                    stringBuffer.append("0");
                }
                string2 = string2 + stringBuffer.toString();
                string = string2.substring(0, n4);
                this.premantissa = this.premantissa != null ? this.premantissa + string : string;
                this.postmantissa = string2.substring(n4);
            }
            this.exponent = n;
            for (n2 = this.postmantissa.length(); n2 > 0 && this.postmantissa.charAt(n2 - 1) == '0'; --n2) {
            }
            this.postmantissa = this.postmantissa.substring(0, n2);
        }

        private int rem(int n, int n2) {
            if (n >= 0) {
                return n % n2;
            }
            int n3 = -n % n2;
            if ((n3 = n2 - n3) >= n2) {
                n3 -= n2;
            }
            return n3;
        }

        public void normalizeMultiples(int n) {
            if (this.iszero) {
                this.normalize(0);
                return;
            }
            int n2 = this.leftDigits() - 1;
            if (n == 0) {
                this.normalize(n2 + 1);
            } else {
                int n3 = this.rem(n2, n);
                this.normalize(n2 - n3);
            }
        }

        public int leftDigits() {
            String string = this.premantissa;
            if (string.equals("0")) {
                string = "";
            }
            int n = string.length() + this.exponent;
            return n;
        }

        public String toString() {
            if (this.isinfinity) {
                if (this.getSign() < 0) {
                    return "-infinity";
                }
                return "infinity";
            }
            if (this.isundefined) {
                return "undefined";
            }
            String string = this.getDigits();
            String string2 = "" + this.exponent;
            if (this.xstring != null) {
                string = string + "E";
                if (this.forcexsign && this.xstring.length() > 0 && this.xstring.charAt(0) != '-' && this.xstring.charAt(0) != '+') {
                    string = string + "+";
                }
                string = string + this.xstring;
            } else {
                if (this.exponent < 0) {
                    string2 = "(" + string2 + ")";
                }
                if (this.exponent != 0) {
                    string = string + "*10^" + string2;
                }
            }
            if (this.isnegative) {
                string = "-" + string;
            }
            return string;
        }
    }
}

