/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiMathDocumentHierarchyValidator;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAssignedSemantics;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import java.io.IOException;
import java.util.HashMap;

public class WmiMathWrapperModel
extends WmiAbstractArrayCompositeMathModel
implements WmiMathModel,
WmiFontAttributeSource {
    private static final int MATH_CHILD_INDEX = 0;
    public static final int DISPLAY_DAG_CHILD_INDEX = 0;
    public static final int SEMANTIC_DAG_CHILD_INDEX = 1;
    public static final int DISPLAY_DAG_PART = 0;
    public static final int SEMANTIC_DAG_PART = 1;
    public static final String TYPESET_PACKAGE = "Typesetting";
    private static final int FUNCTION_NAME_INDEX = 0;
    private static final String MODULE_NAME_ATTR = "modulename";
    private static final String EMPTY_DOTM_CLASSIC = "%#%?G";
    protected static HashMap styleMapper = new HashMap();
    private WmiMathSemantics semantics = null;
    private String dotm = null;
    private String displayDotM = null;
    private boolean replacingLabel = false;

    public WmiMathWrapperModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
    }

    public static boolean identifyTypesettingOutputDag(Dag dag) {
        boolean bl = false;
        if (dag.getType() == 29 && dag.getLength() == 2) {
            Dag dag2 = dag.getChild(0);
            bl = WmiMathWrapperModel.isTypesettingDag(dag2) || DagUtil.isGarbage(dag2);
        }
        return bl;
    }

    public static boolean isTypesettingDag(Dag dag) {
        boolean bl = false;
        if (dag != null) {
            Dag dag2 = dag;
            if (dag.getType() == 29 && dag.getLength() == 1) {
                dag2 = dag.getChild(0);
            }
            if (dag2.getType() == 18) {
                Dag dag3 = dag2.getChild(0);
                Dag dag4 = DagUtil.searchForAttribute(dag3, MODULE_NAME_ATTR);
                bl = dag4 != null && dag4.getData().equals(TYPESET_PACKAGE);
            }
        }
        return bl;
    }

    public static Dag[] getTypesettingDagComponents(Dag dag) {
        Dag[] dagArray = new Dag[]{dag, dag};
        if (WmiMathWrapperModel.identifyTypesettingOutputDag(dag)) {
            Dag dag2 = dag.getChild(0);
            Dag dag3 = dag.getChild(1);
            if (dag2.getType() == 18) {
                dagArray[0] = dag2;
                if (DagUtil.isOneElementList(dag3)) {
                    dagArray[1] = dag3.getChild(0);
                } else {
                    dagArray[1] = dag3;
                    if (dag3 != null && dag3.getType() == 30) {
                        dag3.setType(29);
                    }
                }
            } else if (DagUtil.isGarbage(dag2)) {
                dagArray[0] = dag3;
                dagArray[1] = dag3;
                if (DagUtil.isOneElementList(dag3)) {
                    dagArray[1] = dag3.getChild(0);
                    dagArray[0] = dagArray[1];
                }
            }
        }
        return dagArray;
    }

    public WmiMathWrapperModel createInputMath() throws WmiNoReadAccessException {
        WmiMathWrapperModel wmiMathWrapperModel = null;
        try {
            wmiMathWrapperModel = (WmiMathWrapperModel)this.clone();
            WmiAttributeSet wmiAttributeSet = wmiMathWrapperModel.getAttributes();
            wmiAttributeSet.addAttribute("font_style_name", "2D Math");
            wmiMathWrapperModel.attributes = wmiAttributeSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            WmiErrorLog.log(cloneNotSupportedException);
        }
        return wmiMathWrapperModel;
    }

    private void recreateChildren(Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.recreateChildren(dag, dag, wmiMathContext);
    }

    private void recreateChildren(Dag dag, Dag dag2, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel;
        Dag dag3;
        try {
            this.removeChildren(0, this.getChildCount());
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        Dag dag4 = dag3 = DagUtil.isGarbage(dag) || DagUtil.isMVerbatim(dag) ? dag2 : dag;
        if (!dag3.isNormalized()) {
            dag3 = DagBuilder.normalize(dag3);
        }
        if ((wmiMathModel = WmiMathFactory.createMathModel(this.getDocument(), dag3, wmiMathContext)) == null && dag != dag2) {
            wmiMathModel = WmiMathFactory.createMathModel(this.getDocument(), dag2, wmiMathContext);
        }
        if (wmiMathModel != null) {
            this.appendChild(wmiMathModel);
            if (wmiMathModel.getSemantics() != null) {
                if (!WmiMathWrapperModel.isTypesettingDag(dag2)) {
                    WmiAssignedSemantics wmiAssignedSemantics = new WmiAssignedSemantics(dag2, 0, dag2 != dag);
                    wmiMathModel.setSemantics(wmiAssignedSemantics);
                }
            } else {
                WmiAssignedSemantics wmiAssignedSemantics = new WmiAssignedSemantics(dag2, 0, dag2 != dag);
                wmiMathModel.setSemantics(wmiAssignedSemantics);
            }
        }
    }

    public void createMathChildren(String string) throws IOException, WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathContext wmiMathContext = new WmiMathContext((WmiFontAttributeSet)this.getAttributes());
        this.createMathChildren(string, wmiMathContext);
    }

    public void createMathChildren(String string, WmiMathContext wmiMathContext) throws IOException, WmiNoReadAccessException, WmiNoWriteAccessException {
        Dag dag = DagBuilder.createDag(string.getBytes());
        dag = DagBuilder.normalize(dag);
        Dag dag2 = this.displayDotM != null ? DagBuilder.createDag(this.displayDotM.getBytes()) : null;
        Dag dag3 = null;
        Dag dag4 = null;
        Dag dag5 = null;
        if (dag2 != null) {
            dag5 = dag;
            dag3 = dag4 = dag2;
        } else {
            dag5 = null;
            dag4 = null;
            dag3 = dag;
        }
        if (dag4 == null && WmiMathWrapperModel.identifyTypesettingOutputDag(dag3)) {
            dag4 = dag3.getChild(0);
            dag5 = dag3.getChild(1);
            if (DagUtil.isOneElementList(dag5)) {
                dag5 = dag5.getChild(0);
            }
        }
        if (dag5 != null && dag4 != null) {
            this.recreateChildren(dag4, dag5, wmiMathContext);
        } else {
            this.recreateChildren(dag3, dag3, wmiMathContext);
        }
        if (wmiMathContext.hasRecoverableErrorOccured()) {
            throw wmiMathContext.getRecoverableError();
        }
    }

    public void createMathChildren(Dag dag, WmiFontAttributeSet wmiFontAttributeSet) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.createMathChildren(dag, new WmiMathContext(wmiFontAttributeSet));
    }

    public void createMathChildren(Dag dag, Dag dag2, WmiFontAttributeSet wmiFontAttributeSet) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.createMathChildren(dag, dag2, new WmiMathContext(wmiFontAttributeSet));
    }

    public void createMathChildren(Dag dag, Dag dag2, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.recreateChildren(dag, dag2, wmiMathContext);
    }

    public void createMathChildren(Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.createMathChildren(dag, dag, wmiMathContext);
    }

    public Dag getNonSemanticDag() throws WmiNoReadAccessException {
        return this.toDag(false);
    }

    public Dag getDag() throws WmiNoReadAccessException {
        return this.toDag();
    }

    public void storeDotm(String string) {
        this.dotm = string;
    }

    public String getDotM() throws WmiNoReadAccessException {
        Dag dag;
        String string = this.dotm;
        if (string == null && this.getChild(0) instanceof WmiMathModel && (dag = ((WmiMathModel)this.getChild(0)).toDag()) != null) {
            string = DagBuilder.createDotm(dag);
        }
        return string;
    }

    public String getDotMClassic() throws WmiNoReadAccessException {
        String string = null;
        boolean bl = false;
        if (this.isEmptyMath()) {
            string = EMPTY_DOTM_CLASSIC;
        } else {
            Dag dag = WmiImpliedSemantics.getDag(this, false, true);
            if (WmiMathWrapperModel.isTypesettingDag(dag) && this.getChild(0) instanceof WmiMathModel) {
                dag = ((WmiMathModel)this.getChild(0)).toDag();
            }
            if (dag != null) {
                dag = DagUtil.getDisplayDataFromPrintslash(dag);
            }
            if (dag != null && DagUtil.isList(dag) && dag.getLength() == 2 && WmiMathWrapperModel.isTypesettingDag(dag.getChild(0))) {
                dag = dag.getChild(1);
                bl = true;
            }
            if (dag != null) {
                string = DagBuilder.createDotm(dag);
            }
        }
        if (!bl && this.dotm != null) {
            string = this.dotm;
        }
        return string;
    }

    public String getSaveDotM() throws WmiNoReadAccessException {
        String string = null;
        Dag dag = this.getSaveDag();
        if (dag != null) {
            string = DagBuilder.createDotm(dag);
        }
        return string;
    }

    public Dag getSaveDag() throws WmiNoReadAccessException {
        Dag dag = null;
        if (this.getChild(0) instanceof WmiMathModel) {
            Dag dag2;
            WmiMathModel wmiMathModel = (WmiMathModel)this.getChild(0);
            dag = dag2 = WmiImpliedSemantics.getDag(wmiMathModel, false, true);
            Dag dag3 = null;
            WmiMathSemantics wmiMathSemantics = wmiMathModel.getSemantics();
            if (wmiMathSemantics instanceof WmiAssignedSemantics) {
                dag3 = wmiMathSemantics.toDag(wmiMathModel);
            } else if (this.getSemantics() instanceof WmiAssignedSemantics) {
                dag3 = this.getSemantics().toDag(this);
            } else if (wmiMathSemantics != null && !(wmiMathSemantics instanceof WmiImpliedSemantics)) {
                dag3 = wmiMathSemantics.toDag(wmiMathModel);
            } else if (this.getSemantics() != null && !(this.getSemantics() instanceof WmiImpliedSemantics)) {
                dag3 = this.getSemantics().toDag(this);
            }
            if (dag3 != null) {
                dag = dag3;
            } else {
                String string;
                dag = dag2;
                WmiModelTag wmiModelTag = wmiMathModel.getTag();
                if (wmiModelTag == WmiModelTag.MATH_ROW && ((WmiCompositeModel)((Object)wmiMathModel)).getChildCount() == 1) {
                    wmiMathModel = (WmiMathModel)((WmiCompositeModel)((Object)wmiMathModel)).getChild(0);
                    wmiModelTag = wmiMathModel.getTag();
                }
                if (wmiModelTag == WmiModelTag.MATH_IDENTIFIER && (string = ((WmiTextModel)((Object)wmiMathModel)).getText()).length() == 0) {
                    dag = Dag.createDag(8, null, "", false);
                }
            }
        } else {
            dag = this.toDag();
        }
        return dag;
    }

    public Dag getSaveDisplayDag() throws WmiNoReadAccessException {
        Dag dag = null;
        if (this.getChild(0) instanceof WmiMathModel) {
            WmiMathModel wmiMathModel = (WmiMathModel)this.getChild(0);
            dag = WmiImpliedSemantics.getDag(wmiMathModel, false, true);
        }
        return dag;
    }

    public String getSaveDisplayDotM() throws WmiNoReadAccessException {
        Dag dag;
        String string;
        String string2 = string = this.getDocument().isMutableModel(this) ? null : this.displayDotM;
        if (string == null && (dag = this.getSaveDisplayDag()) != null) {
            string = DagBuilder.createDotm(dag);
        }
        return string;
    }

    public void setDisplayDotM(String string) {
        this.displayDotM = string;
    }

    public String getAutoSimplifiedInput() throws WmiNoReadAccessException {
        String string = null;
        Dag dag = this.toDag();
        boolean bl = false;
        if (dag != null) {
            Dag dag2;
            int n;
            int n2;
            if ((dag = DagUtil.getSemanticDataFromPrintslash(dag)) != null && dag.getType() == 46 && (n2 = dag.getLength()) % 2 == 0) {
                bl = true;
                for (n = 1; n < n2; n += 2) {
                    dag2 = dag.getChild(n);
                    if (DagUtil.isOne(dag2) || DagUtil.isMinusOne(dag2)) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                StringBuffer stringBuffer = new StringBuffer();
                for (n = 0; n < this.length; n += 2) {
                    stringBuffer.append(DagBuilder.lPrint(dag.getChild(n)));
                    dag2 = dag.getChild(n + 1);
                    if (DagUtil.isOne(dag2)) {
                        stringBuffer.append(";");
                        continue;
                    }
                    stringBuffer.append(":");
                }
                string = stringBuffer.toString();
            } else {
                string = DagBuilder.lPrint(dag);
            }
        }
        return string;
    }

    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object object;
        String string = null;
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        if (wmiAttributeSet != null && (object = wmiAttributeSet.getAttribute("font_style_name")) != null) {
            string = object.toString();
        }
        return string;
    }

    public void updateFontStyle(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
        wmiFontAttributeSet.setNamedFontStyle(string, this.getDocument());
        this.addAttributes(wmiFontAttributeSet);
    }

    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    public void setSemantics(WmiMathSemantics wmiMathSemantics) {
        if (wmiMathSemantics == null || wmiMathSemantics instanceof WmiImpliedSemantics || wmiMathSemantics instanceof WmiAssignedSemantics) {
            this.semantics = wmiMathSemantics;
        }
    }

    public Dag toDag() throws WmiNoReadAccessException {
        return this.toDag(true);
    }

    public Dag toDag(boolean bl) throws WmiNoReadAccessException {
        Dag dag = null;
        if (this.semantics instanceof WmiAssignedSemantics && bl) {
            dag = this.semantics.toDag(this);
        } else {
            WmiMathSemantics wmiMathSemantics;
            Object object;
            boolean bl2 = false;
            if (this.getChild(0) instanceof WmiMathModel) {
                object = (WmiMathModel)this.getChild(0);
                wmiMathSemantics = object.getSemantics();
                if (wmiMathSemantics instanceof WmiAssignedSemantics) {
                    dag = wmiMathSemantics.toDag((WmiMathModel)object);
                } else {
                    dag = ((WmiMathModel)this.getChild(0)).toDag();
                    bl2 = true;
                }
            }
            Object object2 = object = bl2 ? this.dotm : this.getDotM();
            if (dag == null) {
                if (object != null) {
                    try {
                        dag = DagBuilder.createDag(((String)object).getBytes());
                    }
                    catch (IOException iOException) {
                        WmiErrorLog.log(iOException);
                    }
                } else {
                    wmiMathSemantics = new WmiImpliedSemantics();
                    dag = wmiMathSemantics.toDag(this);
                }
            }
        }
        return dag;
    }

    public boolean useScriptSize(WmiModel wmiModel) {
        return false;
    }

    public void setReplacingLabel(boolean bl) {
        this.replacingLabel = bl;
    }

    public boolean isReplacingLabel() {
        return this.replacingLabel;
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiFontAttributeSet();
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH;
    }

    public boolean isVisible() throws WmiNoReadAccessException {
        boolean bl = true;
        WmiMathDocumentModel wmiMathDocumentModel = this.getDocument();
        if (wmiMathDocumentModel != null) {
            bl = !wmiMathDocumentModel.isHidden(this);
        }
        return bl;
    }

    public static final WmiMathWrapperModel insert2DMath(WmiModel wmiModel, int n, WmiMathDocumentModel wmiMathDocumentModel) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiAttributeSet wmiAttributeSet = wmiModel.getAttributes();
        return WmiMathWrapperModel.insert2DMath(wmiModel, n, wmiMathDocumentModel, wmiAttributeSet);
    }

    public static final WmiMathWrapperModel insert2DMath(WmiModel wmiModel, int n, WmiMathDocumentModel wmiMathDocumentModel, WmiAttributeSet wmiAttributeSet) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = WmiMathWrapperModel.mapStyleFromAttributes(wmiMathDocumentModel, wmiAttributeSet);
        WmiMathModel wmiMathModel = WmiMathWrapperModel.createDefaultEmptyStructure(wmiMathDocumentModel, wmiFontAttributeSet);
        return WmiMathWrapperModel.insert2DMath(wmiModel, n, wmiMathDocumentModel, wmiMathModel, wmiFontAttributeSet);
    }

    public static final WmiMathWrapperModel insert2DMath(WmiModel wmiModel, int n, WmiMathDocumentModel wmiMathDocumentModel, WmiMathModel wmiMathModel, WmiAttributeSet wmiAttributeSet) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel wmiModel2;
        WmiMathWrapperModel wmiMathWrapperModel = new WmiMathWrapperModel(wmiMathDocumentModel);
        if (wmiAttributeSet != null) {
            wmiMathWrapperModel.addAttributes(wmiAttributeSet);
        }
        wmiMathWrapperModel.appendChild(wmiMathModel);
        WmiFontAttributeSet wmiFontAttributeSet = WmiMathWrapperModel.createAttributesForNewTextRuns(wmiModel, wmiMathDocumentModel);
        WmiMathDocumentHierarchyValidator wmiMathDocumentHierarchyValidator = wmiMathDocumentModel.getModelHierarchyValidator();
        WmiModel wmiModel3 = wmiModel2 = wmiModel instanceof WmiCompositeModel ? wmiModel : wmiModel.getParent();
        while (wmiModel2 != null && !wmiMathDocumentHierarchyValidator.isValid(wmiModel2.getTag(), wmiMathWrapperModel.getTag())) {
            wmiModel = wmiModel2;
            wmiModel2 = wmiModel2.getParent();
        }
        WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfClass(wmiModel, WmiCompositeModel.class);
        if (wmiModel instanceof WmiTextModel) {
            WmiTextModel wmiTextModel = (WmiTextModel)wmiModel;
            WmiMathWrapperModel.insertIntoText(wmiTextModel, n, wmiCompositeModel, wmiMathDocumentModel, wmiMathWrapperModel, wmiFontAttributeSet);
        } else {
            if (wmiCompositeModel == null && wmiModel instanceof WmiCompositeModel) {
                wmiCompositeModel = (WmiCompositeModel)wmiModel;
            }
            if (wmiCompositeModel != null) {
                WmiCompositeModel wmiCompositeModel2 = wmiCompositeModel;
                int n2 = wmiModel == wmiCompositeModel ? 0 : wmiCompositeModel2.indexOf(wmiModel);
                wmiCompositeModel2.addChild(wmiMathWrapperModel, n2);
            }
        }
        return wmiMathWrapperModel;
    }

    private static final void insertIntoText(WmiTextModel wmiTextModel, int n, WmiModel wmiModel, WmiMathDocumentModel wmiMathDocumentModel, WmiMathWrapperModel wmiMathWrapperModel, WmiFontAttributeSet wmiFontAttributeSet) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        int n2 = wmiTextModel.getLength();
        WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
        int n3 = wmiCompositeModel.indexOf(wmiTextModel);
        if (n2 > 0) {
            if (n2 > 1 && n > 0 && n < n2) {
                WmiTextModel wmiTextModel2 = wmiTextModel.splitModel(n);
                if (wmiTextModel2 != wmiTextModel) {
                    n3 = wmiCompositeModel.indexOf(wmiTextModel2);
                }
            } else if (n == n2) {
                ++n3;
            }
            if (n == 0 && n2 > 0) {
                wmiCompositeModel.addChild(new WmiTextModel(wmiMathDocumentModel, "", wmiFontAttributeSet), n3);
                ++n3;
            }
            wmiCompositeModel.addChild(wmiMathWrapperModel, n3);
        } else {
            wmiCompositeModel.replaceChild(wmiMathWrapperModel, n3);
        }
    }

    private static final WmiFontAttributeSet createAttributesForNewTextRuns(WmiModel wmiModel, WmiMathDocumentModel wmiMathDocumentModel) throws WmiNoReadAccessException {
        WmiAttributeSet wmiAttributeSet = wmiModel.getAttributes();
        WmiFontAttributeSet wmiFontAttributeSet = null;
        if (wmiAttributeSet instanceof WmiFontAttributeSet) {
            wmiFontAttributeSet = (WmiFontAttributeSet)wmiAttributeSet;
        } else {
            String string = (String)wmiAttributeSet.getAttribute("font_style_name");
            if (string != null) {
                wmiFontAttributeSet = wmiMathDocumentModel.getFontStyle(string);
            }
        }
        return wmiFontAttributeSet;
    }

    public static WmiMathModel createPlaceHolder(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) {
        WmiIdentifierModel wmiIdentifierModel = new WmiIdentifierModel(wmiMathDocumentModel, "", "", wmiMathContext, false);
        return wmiIdentifierModel;
    }

    public static WmiMathModel createPlaceHolder(WmiMathDocumentModel wmiMathDocumentModel, WmiAttributeSet wmiAttributeSet) {
        return WmiMathWrapperModel.createPlaceHolder(wmiMathDocumentModel, WmiMathWrapperModel.createContext(wmiAttributeSet));
    }

    public static WmiMathContext createContext(WmiAttributeSet wmiAttributeSet) {
        WmiMathContext wmiMathContext = null;
        if (wmiAttributeSet instanceof WmiFontAttributeSet) {
            wmiMathContext = new WmiMathContext((WmiFontAttributeSet)wmiAttributeSet);
        } else {
            WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
            wmiFontAttributeSet.addAttributes(wmiAttributeSet);
            wmiMathContext = new WmiMathContext(wmiFontAttributeSet);
        }
        return wmiMathContext;
    }

    public static final WmiMathModel createDefaultEmptyStructure(WmiMathDocumentModel wmiMathDocumentModel, WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        WmiMathContext wmiMathContext = WmiMathWrapperModel.createContext(wmiAttributeSet);
        WmiMathModel wmiMathModel = WmiMathWrapperModel.createPlaceHolder(wmiMathDocumentModel, wmiMathContext);
        wmiInlineMathModel.appendChild(wmiMathModel);
        return wmiInlineMathModel;
    }

    public static final WmiMathWrapperModel createEmptyMathWrapper(WmiMathDocumentModel wmiMathDocumentModel, WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        WmiMathWrapperModel wmiMathWrapperModel = new WmiMathWrapperModel(wmiMathDocumentModel);
        wmiMathWrapperModel.setAttributes(wmiAttributeSet);
        wmiMathWrapperModel.appendChild(WmiMathWrapperModel.createDefaultEmptyStructure(wmiMathDocumentModel, wmiAttributeSet));
        return wmiMathWrapperModel;
    }

    public boolean isEmptyMath() throws WmiNoReadAccessException {
        boolean bl = false;
        WmiModel wmiModel = this;
        while (wmiModel instanceof WmiCompositeModel && !(wmiModel instanceof WmiMathFencedModel) && ((WmiCompositeModel)wmiModel).getChildCount() < 2) {
            WmiCompositeModel wmiCompositeModel = wmiModel;
            if (wmiCompositeModel.getChildCount() == 1) {
                wmiModel = wmiCompositeModel.getChild(0);
                if (!(wmiModel instanceof WmiTextModel)) continue;
                bl = ((WmiTextModel)wmiModel).getLength() == 0;
                break;
            }
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isPlaceHolder() throws WmiNoReadAccessException {
        boolean bl = false;
        WmiModel wmiModel = this;
        while (wmiModel instanceof WmiCompositeModel && ((WmiCompositeModel)wmiModel).getChildCount() == 1) {
            WmiCompositeModel wmiCompositeModel = wmiModel;
            if (!((wmiModel = wmiCompositeModel.getChild(0)) instanceof WmiIdentifierModel)) continue;
            bl = ((WmiIdentifierModel)wmiModel).getTokenContents().length() == 0;
        }
        return bl;
    }

    public static final void addStyleMapping(String string, String string2) {
        styleMapper.put(string, string2);
    }

    public static final WmiFontAttributeSet mapStyleFromAttributes(WmiMathDocumentModel wmiMathDocumentModel, WmiAttributeSet wmiAttributeSet) throws WmiNoReadAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = wmiAttributeSet instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)wmiAttributeSet : null;
        String string = (String)wmiAttributeSet.getAttribute("font_style_name");
        if ((string = WmiMathWrapperModel.mapStyleName(string)) != null) {
            wmiFontAttributeSet = wmiMathDocumentModel.getFontStyle(string);
        }
        return wmiFontAttributeSet;
    }

    public static final String mapStyleName(String string) {
        String string2 = (String)styleMapper.get(string);
        string2 = string2 == null ? string : string2;
        return string2;
    }

    public int kerningPoints() throws WmiNoReadAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = WmiMathWrapperModel.mapStyleFromAttributes(this.getDocument(), this.getAttributes());
        int n = 0;
        if (wmiFontAttributeSet != null) {
            double d = (double)wmiFontAttributeSet.getSize() * 0.3;
            n = (int)d;
        }
        return n;
    }

    public void discardSemantics() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.removeSemantics(this);
    }

    private void removeSemantics(WmiMathModel wmiMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.removeSemantics(wmiMathModel, false);
    }

    public void removeSemantics(WmiMathModel wmiMathModel, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Object object;
        boolean bl2 = true;
        boolean bl3 = false;
        if (wmiMathModel.getTag() == WmiModelTag.MATH_ACTION) {
            object = wmiMathModel.getAttributesForRead();
            bl3 = object.getAttribute("rtableid") != null;
            Object object2 = object.getAttribute("actiontype");
            if (bl3 && !(bl3 = "browsertable".equals(object2))) {
                object = wmiMathModel.getAttributes();
                object.addAttribute("rtableid", null);
                wmiMathModel.setAttributes((WmiAttributeSet)object);
            }
        }
        if (bl && !bl3) {
            wmiMathModel.setSemantics(null);
        } else {
            object = wmiMathModel.getSemantics();
            if (bl3) {
                bl2 = false;
            } else if (object instanceof WmiAssignedSemantics) {
                ((WmiAssignedSemantics)object).markStale();
            } else {
                wmiMathModel.setSemantics(null);
            }
        }
        if (bl2 && wmiMathModel instanceof WmiCompositeModel) {
            object = (WmiCompositeModel)((Object)wmiMathModel);
            int n = object.getChildCount();
            for (int i = 0; i < n; ++i) {
                WmiModel wmiModel = object.getChild(i);
                if (!(wmiModel instanceof WmiMathModel)) continue;
                this.removeSemantics((WmiMathModel)wmiModel, bl);
            }
        }
    }

    public boolean isCrossBoundarySubselectable() {
        return false;
    }
}

