/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.util.MathMLEntityMap;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class WmiMathOperatorDictionary {
    private static final int FORM = 0;
    private static final int FENCE = 1;
    private static final int SEPARATOR = 2;
    private static final int LSPACE = 3;
    private static final int RSPACE = 4;
    private static final int STRETCHY = 5;
    private static final int SYMMETRIC = 6;
    private static final int MAXSIZE = 7;
    private static final int MINSIZE = 8;
    private static final int LARGEOP = 9;
    private static final int MOVABLELIMITS = 10;
    private static final int ACCENT = 11;
    private static final int ATTRIBUTE_COUNT = 12;
    private static final String[] ATTRIBUTES = new String[]{"form", "fence", "separator", "lspace", "rspace", "stretchy", "symmetric", "maxsize", "minsize", "largeop", "movablelimits", "accent"};
    public static final int FORM_PREFIX = 0;
    public static final int FORM_INFIX = 1;
    public static final int FORM_POSTFIX = 2;
    private static final String[] FORMS = new String[]{"prefix", "infix", "postfix"};
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int SPACE_ZERO = 0;
    private static final int SPACE_VERYVERYTHIN = 1;
    private static final int SPACE_VERYTHIN = 2;
    private static final int SPACE_THIN = 3;
    private static final int SPACE_MEDIUM = 4;
    private static final int SPACE_THICK = 5;
    private static final int SPACE_VERYTHICK = 6;
    private static final String[] SPACES = new String[]{"0em", "veryverythinmathspace", "verythinmathspace", "thinmathspace", "mediummathspace", "thickmathspace", "verythickmathspace"};
    private static final String RESOURCES = "com/maplesoft/mathdoc/model/math/resources/operator_dictionary";
    private static Map infix = null;
    private static Map prefix = null;
    private static Map postfix = null;

    private static Map createNameToIndexMap() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("form", new Integer(0));
        hashMap.put("fence", new Integer(1));
        hashMap.put("separator", new Integer(2));
        hashMap.put("lspace", new Integer(3));
        hashMap.put("rspace", new Integer(4));
        hashMap.put("stretchy", new Integer(5));
        hashMap.put("symmetric", new Integer(6));
        hashMap.put("maxsize", new Integer(7));
        hashMap.put("minsize", new Integer(8));
        hashMap.put("largeop", new Integer(9));
        hashMap.put("movablelimits", new Integer(10));
        hashMap.put("accent", new Integer(11));
        hashMap.put("infix", new Integer(1));
        hashMap.put("prefix", new Integer(0));
        hashMap.put("postfix", new Integer(2));
        hashMap.put("0em", new Integer(0));
        hashMap.put("veryverythinmathspace", new Integer(1));
        hashMap.put("verythinmathspace", new Integer(2));
        hashMap.put("thinmathspace", new Integer(3));
        hashMap.put("mediummathspace", new Integer(4));
        hashMap.put("thickmathspace", new Integer(5));
        hashMap.put("verythickmathspace", new Integer(6));
        return hashMap;
    }

    private static void buildOperatorDictionary(Map map) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(RESOURCES);
        infix = new HashMap();
        prefix = new HashMap();
        postfix = new HashMap();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = resourceBundle.getString(string);
            String[] stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                char c;
                String string3 = stringArray[i].trim();
                DictionaryEntry dictionaryEntry = WmiMathOperatorDictionary.parseAttributes(string3, map);
                Map map2 = null;
                switch (dictionaryEntry.getAttribute(0)) {
                    case 0: {
                        map2 = prefix;
                        break;
                    }
                    case 2: {
                        map2 = postfix;
                        break;
                    }
                    default: {
                        map2 = infix;
                    }
                }
                if (string != null && string.length() > 0 && ((c = string.charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && !string.equals("lim") && !string.equals("max") && !string.equals("min")) {
                    string = '&' + string + ';';
                }
                map2.put(string, dictionaryEntry);
            }
        }
    }

    private static DictionaryEntry parseAttributes(String string, Map map) {
        int[] nArray = new int[12];
        boolean[] blArray = new boolean[12];
        Arrays.fill(nArray, 0);
        Arrays.fill(blArray, false);
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String[] stringArray2 = stringArray[i].split("=");
            Integer n2 = (Integer)map.get(stringArray2[0]);
            if (n2 == null) continue;
            int n3 = n2;
            nArray[n3] = n = WmiMathOperatorDictionary.translateToDictionaryValue(n3, stringArray2[1], map);
            blArray[n3] = true;
        }
        return new DictionaryEntry(nArray, blArray);
    }

    private WmiMathOperatorDictionary() {
    }

    public static boolean installAttributes(WmiMathOperatorModel wmiMathOperatorModel) throws WmiNoWriteAccessException {
        return WmiMathOperatorDictionary.installAttributes(wmiMathOperatorModel, null);
    }

    public static boolean installAttributes(WmiMathOperatorModel wmiMathOperatorModel, WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        boolean bl = WmiMathOperatorDictionary.installAttributes(wmiMathOperatorModel, 1, wmiAttributeSet);
        if (!bl) {
            bl = WmiMathOperatorDictionary.installAttributes(wmiMathOperatorModel, 0, wmiAttributeSet);
        }
        if (!bl) {
            bl = WmiMathOperatorDictionary.installAttributes(wmiMathOperatorModel, 2, wmiAttributeSet);
        }
        return bl;
    }

    public static boolean installAttributes(WmiMathOperatorModel wmiMathOperatorModel, int n) throws WmiNoWriteAccessException {
        return WmiMathOperatorDictionary.installAttributes(wmiMathOperatorModel, n, null);
    }

    public static boolean installAttributes(WmiMathOperatorModel wmiMathOperatorModel, int n, WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        boolean bl = false;
        try {
            String string = wmiMathOperatorModel.getTokenContents();
            String string2 = wmiMathOperatorModel.getSemanticLabel();
            Map map = null;
            switch (n) {
                case 0: {
                    map = prefix;
                    break;
                }
                case 2: {
                    map = postfix;
                    break;
                }
                default: {
                    map = infix;
                }
            }
            DictionaryEntry dictionaryEntry = (DictionaryEntry)map.get(string2);
            if (dictionaryEntry == null) {
                dictionaryEntry = (DictionaryEntry)map.get(string);
            }
            if (dictionaryEntry == null && string.length() == 1 && string2 == null) {
                String string3 = "&" + MathMLEntityMap.getMathMLName(string.charAt(0)) + ";";
                dictionaryEntry = (DictionaryEntry)map.get(string3);
            }
            if (dictionaryEntry == null || string2 != null && string2.equals("&ApplyFunction;")) {
                dictionaryEntry = (DictionaryEntry)map.get(string2);
            }
            if (dictionaryEntry != null) {
                boolean bl2 = false;
                if (wmiAttributeSet == null) {
                    wmiAttributeSet = wmiMathOperatorModel.getAttributes();
                    bl2 = true;
                }
                WmiMathOperatorDictionary.copyAttributes(dictionaryEntry, wmiAttributeSet);
                if (bl2) {
                    wmiMathOperatorModel.setAttributes(wmiAttributeSet);
                }
                bl = true;
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            bl = false;
            wmiNoReadAccessException.printStackTrace();
        }
        return bl;
    }

    public static boolean isNameForOperator(String string) {
        if (!string.startsWith("&")) {
            string = "&" + string + ";";
        }
        return infix.containsKey(string) || prefix.containsKey(string) || postfix.containsKey(string);
    }

    private static void copyAttributes(DictionaryEntry dictionaryEntry, WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        for (int i = 0; i < 12; ++i) {
            if (!dictionaryEntry.isSet(i)) continue;
            int n = dictionaryEntry.getAttribute(i);
            Object object = WmiMathOperatorDictionary.translateToAttributeSetValue(i, n);
            wmiAttributeSet.addAttribute(ATTRIBUTES[i], object);
        }
    }

    private static final int translateToDictionaryValue(int n, String string, Map map) {
        int n2 = 0;
        switch (n) {
            case 0: 
            case 3: 
            case 4: {
                n2 = (Integer)map.get(string);
                break;
            }
            case 7: 
            case 8: {
                n2 = Integer.parseInt(string);
                break;
            }
            default: {
                n2 = Boolean.valueOf(string) != false ? 1 : 0;
            }
        }
        return n2;
    }

    private static final Object translateToAttributeSetValue(int n, int n2) {
        Object object = null;
        switch (n) {
            case 0: {
                object = FORMS[n2];
                break;
            }
            case 3: 
            case 4: {
                object = SPACES[n2];
                break;
            }
            case 7: 
            case 8: {
                object = Integer.toString(n2) + " pt";
                break;
            }
            default: {
                object = n2 != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return object;
    }

    static {
        Map map = WmiMathOperatorDictionary.createNameToIndexMap();
        WmiMathOperatorDictionary.buildOperatorDictionary(map);
    }

    private static class DictionaryEntry {
        private static final int[] SHIFTS = new int[]{14, 13, 12, 9, 6, 5, 4, 24, 16, 3, 2, 1};
        private static final int[] MASKS = new int[]{3, 1, 1, 7, 7, 1, 1, 255, 255, 1, 1, 1};
        private int set = 0;
        private int info = 0;

        public DictionaryEntry(int[] nArray, boolean[] blArray) {
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                this.setAttribute(i, nArray[i]);
                this.set |= 1 << i;
            }
        }

        private void setAttribute(int n, int n2) {
            this.info |= n2 << SHIFTS[n];
        }

        public boolean isSet(int n) {
            return (this.set & 1 << n) != 0;
        }

        public int getAttribute(int n) {
            return this.info >> SHIFTS[n] & MASKS[n];
        }
    }
}

