/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiIntAttributeKey;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.WmiValidForTypeMK;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import java.util.Arrays;
import java.util.HashMap;

public class WmiMathGlyphModel
extends WmiAbstractMathTokenModel
implements WmiMathTokenModel,
WmiFontAttributeSource,
WmiValidForTypeMK {
    private WmiMathSemantics semantics = null;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    private WmiAbstractMathTokenModel glyphParent = null;

    public WmiMathGlyphModel(WmiMathDocumentModel wmiMathDocumentModel) throws WmiNoWriteAccessException {
        super(wmiMathDocumentModel, " ");
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathGlyphModel(WmiMathDocumentModel wmiMathDocumentModel, String string, WmiAttributeSet wmiAttributeSet) {
        super(wmiMathDocumentModel, string);
        try {
            this.setAttributes(wmiAttributeSet);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public int getLength() throws WmiNoReadAccessException {
        WmiMathGlyphAttributeSet wmiMathGlyphAttributeSet = (WmiMathGlyphAttributeSet)this.getAttributesForRead();
        if (wmiMathGlyphAttributeSet.getFontFamily().equals("")) {
            return wmiMathGlyphAttributeSet.getAlt().length();
        }
        return 1;
    }

    public boolean isComposite() {
        return false;
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH_GLYPH;
    }

    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathGlyphAttributeSet();
    }

    public String getTokenContents() throws WmiNoReadAccessException {
        return null;
    }

    public void setGlyphParent(WmiAbstractMathTokenModel wmiAbstractMathTokenModel) throws WmiNoWriteAccessException {
        this.glyphParent = wmiAbstractMathTokenModel;
    }

    public WmiAbstractMathTokenModel getGlyphParent() {
        return this.glyphParent;
    }

    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    public void setSemantics(WmiMathSemantics wmiMathSemantics) {
        this.semantics = wmiMathSemantics;
    }

    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics == null ? null : this.semantics.toDag(this);
    }

    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object object;
        String string = null;
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        if (wmiAttributeSet != null && (object = wmiAttributeSet.getAttribute("font_style_name")) != null) {
            string = object.toString();
        }
        return string;
    }

    public void updateFontStyle(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
        wmiFontAttributeSet.setNamedFontStyle(string, this.getDocument());
        this.addAttributes(wmiFontAttributeSet);
    }

    public boolean useScriptSize(WmiModel wmiModel) {
        return false;
    }

    public boolean forceSave(Object object, Object object2) {
        return false;
    }

    public Dag getTypeMk() {
        return null;
    }

    public boolean suppliesOwnTypeMK() {
        return false;
    }

    public static class WmiMathGlyphAttributeSet
    extends WmiMathAttributeSet {
        private static HashMap keyMap = null;
        public static final String ALT = "alt";
        public static final String INDEX = "index";
        public static final String[] ATTRIBUTES = new String[]{"alt", "index"};
        public static final WmiAttributeKey[] GLYPH_KEYS = new WmiAttributeKey[]{new AltKey(), new IndexKey(), new FontFamilyKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.EXTENDED_KEYS, GLYPH_KEYS);
        private String alt = null;
        private Integer index = new Integer(-1);

        public WmiMathGlyphAttributeSet() {
        }

        public WmiMathGlyphAttributeSet(WmiMathGlyphAttributeSet wmiMathGlyphAttributeSet) {
            super(wmiMathGlyphAttributeSet);
            this.alt = wmiMathGlyphAttributeSet.alt;
            this.index = wmiMathGlyphAttributeSet.index;
        }

        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS;
        }

        protected HashMap getKeyMap() {
            return keyMap;
        }

        protected void setKeyMap(HashMap hashMap) {
            keyMap = hashMap;
        }

        public WmiAttributeSet copyAttributes() {
            return new WmiMathGlyphAttributeSet(this);
        }

        public String getAlt() {
            return this.alt;
        }

        public String getFontFamily() {
            return (String)this.getAttribute("fontfamily");
        }

        public int getIndex() {
            return this.index != null ? this.index : -1;
        }

        public void addAttribute(Object object, Object object2) {
            if (ALT.equals(object)) {
                this.alt = object2.toString();
            } else if (INDEX.equals(object)) {
                this.index = Integer.decode(object2.toString());
            } else {
                super.addAttribute(object, object2);
            }
        }

        public void addAttributes(WmiAttributeSet wmiAttributeSet) {
            super.addAttributes(wmiAttributeSet);
            if (wmiAttributeSet instanceof WmiMathGlyphAttributeSet) {
                WmiMathGlyphAttributeSet wmiMathGlyphAttributeSet = (WmiMathGlyphAttributeSet)wmiAttributeSet;
                this.alt = wmiMathGlyphAttributeSet.alt;
                this.index = wmiMathGlyphAttributeSet.index;
            }
        }

        public static class FontFamilyKey
        extends WmiMathAttributeSet.FontFamilyKey {
            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiFontAttributeSet)wmiAttributeSet).getFamily();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                Object[] objectArray = WmiFontResolver.getAvailableFontFamilyNames();
                if (Arrays.binarySearch(objectArray, string) >= 0) {
                    ((WmiFontAttributeSet)wmiAttributeSet).setFamily(string);
                } else {
                    ((WmiFontAttributeSet)wmiAttributeSet).setFamily("");
                }
            }
        }

        public static class AltKey
        extends WmiStringAttributeKey {
            public AltKey() {
                super(WmiMathGlyphAttributeSet.ALT, "");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathGlyphAttributeSet)wmiAttributeSet).alt;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathGlyphAttributeSet)wmiAttributeSet).alt = string;
            }
        }

        public static class IndexKey
        extends WmiIntAttributeKey {
            public IndexKey() {
                super(WmiMathGlyphAttributeSet.INDEX, -1);
            }

            public int getIntValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathGlyphAttributeSet)wmiAttributeSet).index != null ? ((WmiMathGlyphAttributeSet)wmiAttributeSet).index.intValue() : this.getDefaultValue();
            }

            public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
                ((WmiMathGlyphAttributeSet)wmiAttributeSet).index = new Integer(n);
            }
        }
    }
}

