/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import java.util.HashMap;

public class WmiMathEncloseModel
extends WmiInlineMathModel {
    private WmiMathSemantics semantics = null;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();

    public WmiMathEncloseModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathEncloseModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray, WmiAttributeSet wmiAttributeSet) throws WmiInvalidModelInitializationException {
        super(wmiMathDocumentModel, wmiModelArray);
        try {
            this.setAttributes(wmiAttributeSet);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH_ENCLOSE;
    }

    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathEncloseAttributeSet();
    }

    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    public void setSemantics(WmiMathSemantics wmiMathSemantics) {
        this.semantics = wmiMathSemantics;
    }

    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics == null ? null : this.semantics.toDag(this);
    }

    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object object;
        String string = null;
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        if (wmiAttributeSet != null && (object = wmiAttributeSet.getAttribute("font_style_name")) != null) {
            string = object.toString();
        }
        return string;
    }

    public void updateFontStyle(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
        wmiFontAttributeSet.setNamedFontStyle(string, this.getDocument());
        this.addAttributes(wmiFontAttributeSet);
    }

    public boolean useScriptSize(WmiModel wmiModel) {
        return false;
    }

    public boolean forceSave(Object object, Object object2) {
        return false;
    }

    public Dag getTypeMk() {
        return null;
    }

    public boolean suppliesOwnTypeMK() {
        return false;
    }

    public static class WmiMathEncloseAttributeSet
    extends WmiMathAttributeSet {
        public static final String LONGDIV = "longdiv";
        public static final String ACTUARIAL = "actuarial";
        public static final String RADICAL = "radical";
        public static final String BOX = "box";
        public static final String ROUNDEDBOX = "roundedbox";
        public static final String CIRCLE = "circle";
        public static final String LEFT = "left";
        public static final String RIGHT = "right";
        public static final String TOP = "top";
        public static final String BOTTOM = "bottom";
        public static final String UPDIAGONALSTRIKE = "updiagonalstrike";
        public static final String DOWNDIAGONALSTRIKE = "downdiagonalstrike";
        public static final String VERTICALSTRIKE = "verticalstrike";
        public static final String HORIZONTALSTRIKE = "horizontalstrike";
        private static HashMap keyMap = null;
        public static final String NOTATION = "notation";
        public static final String[] ATTRIBUTES = new String[]{"notation"};
        public static final WmiAttributeKey[] ENCLOSE_KEYS = new WmiAttributeKey[]{new NotationKey()};
        private String notation = "longdiv";
        private boolean isRadical = false;

        public WmiMathEncloseAttributeSet() {
        }

        public WmiMathEncloseAttributeSet(WmiMathEncloseAttributeSet wmiMathEncloseAttributeSet) {
            this.notation = wmiMathEncloseAttributeSet.notation;
        }

        public WmiAttributeKey[] getKeys() {
            return ENCLOSE_KEYS;
        }

        protected HashMap getKeyMap() {
            return keyMap;
        }

        protected void setKeyMap(HashMap hashMap) {
            keyMap = hashMap;
        }

        public WmiAttributeSet copyAttributes() {
            return new WmiMathEncloseAttributeSet(this);
        }

        public String getNotation() {
            return this.notation;
        }

        public boolean isRadical() {
            return this.isRadical;
        }

        public void addAttribute(Object object, Object object2) {
            if (NOTATION.equals(object)) {
                this.notation = object2.toString();
            }
        }

        public void addAttributes(WmiAttributeSet wmiAttributeSet) {
            super.addAttributes(wmiAttributeSet);
            if (wmiAttributeSet instanceof WmiMathEncloseAttributeSet) {
                WmiMathEncloseAttributeSet wmiMathEncloseAttributeSet = (WmiMathEncloseAttributeSet)wmiAttributeSet;
                this.notation = wmiMathEncloseAttributeSet.notation;
            }
        }

        public static class NotationKey
        extends WmiStringAttributeKey {
            public NotationKey() {
                super(WmiMathEncloseAttributeSet.NOTATION, "");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathEncloseAttributeSet)wmiAttributeSet).notation;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathEncloseAttributeSet)wmiAttributeSet).notation = string;
                if (string.indexOf(WmiMathEncloseAttributeSet.RADICAL) >= 0) {
                    ((WmiMathEncloseAttributeSet)wmiAttributeSet).isRadical = true;
                }
            }
        }
    }
}

