/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;

public class WmiKeyWordBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final String SAVE_KEYWORD = "save";
    public static final String READ_KEYWORD = "read";
    public static final String STOP_KEYWORD = "stop";
    public static final String BREAK_KEYWORD = "break";
    public static final String NEXT_KEYWORD = "next";
    public static final String RETURN_KEYWORD = "return";
    public static final String ERROR_KEYWORD = "error";
    private String keyword;

    public WmiKeyWordBuilder(String string) {
        this.keyword = string;
    }

    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = null;
        int n = dag.getLength();
        int n2 = n > 0 ? 2 + n : 1;
        WmiModel[] wmiModelArray = new WmiMathModel[n2];
        wmiModelArray[0] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, this.getKeyword(), wmiMathContext);
        if (n2 > 1) {
            wmiModelArray[1] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[1].addAttribute("width", "0.5em");
        }
        for (int i = 0; i < n; ++i) {
            wmiModelArray[i + 2] = WmiMathFactory.createMath(wmiMathDocumentModel, dag.getChild(i), wmiMathContext);
        }
        try {
            wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        return wmiInlineMathModel;
    }

    public Dag toDag(WmiMathModel wmiMathModel) {
        return null;
    }

    public String getKeyword() {
        return this.keyword;
    }
}

