/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiProcBuilder;

public class WmiIfStatementBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final String IF_KEYWORD = "if";
    public static final String THEN_KEYWORD = "then";
    public static final String ELSE_KEYWORD = "else";
    public static final String ELSE_IF_KEYWORD = "elif";
    public static final String END_IF_KEYWORD = "end if";
    public static final String END_IF_SHORT_KEYWORD = "fi";
    public static final int IF_SIZE = 8;
    private static final int ELSE_SIZE = 4;
    private static final int FIRST_CONDITION_INDEX = 0;
    private static final int FIRST_STATEMENT_INDEX = 1;
    private static final int FIRST_ELSE_INDEX = 2;
    private static final WmiIfLineSemantics LINE_SEMANTICS = new WmiIfLineSemantics();

    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = null;
        int n = dag.getLength();
        boolean bl = (n & 1) == 1;
        WmiModel[] wmiModelArray = new WmiMathModel[n / 2 + n % 2 + 1];
        int n2 = 0;
        wmiModelArray[n2++] = this.createIfCondition(dag.getChild(0), dag.getChild(1), wmiMathDocumentModel, wmiMathContext, IF_KEYWORD);
        for (int i = 2; i < n - 1; i += 2) {
            wmiModelArray[n2++] = this.createIfCondition(dag.getChild(i), dag.getChild(i + 1), wmiMathDocumentModel, wmiMathContext, ELSE_IF_KEYWORD);
        }
        if (bl) {
            wmiModelArray[n2++] = this.createElseStatement(dag.getChild(n - 1), wmiMathDocumentModel, wmiMathContext);
        }
        wmiModelArray[n2] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, WmiProcBuilder.getLongDelimProperty(wmiMathDocumentModel) ? END_IF_KEYWORD : END_IF_SHORT_KEYWORD, wmiMathContext);
        try {
            wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
            wmiInlineMathModel.setSemantics(this);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        return wmiInlineMathModel;
    }

    public WmiMathModel createIfCondition(Dag dag, Dag dag2, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = null;
        WmiModel[] wmiModelArray = new WmiMathModel[8];
        wmiModelArray[0] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, string, wmiMathContext);
        wmiModelArray[1] = new WmiMathSpaceModel(wmiMathDocumentModel);
        wmiModelArray[1].addAttribute("width", "0.5em");
        wmiModelArray[2] = WmiProcBuilder.createStatementSequenceRow(dag, wmiMathDocumentModel, wmiMathContext);
        wmiModelArray[3] = new WmiMathSpaceModel(wmiMathDocumentModel);
        wmiModelArray[3].addAttribute("width", "0.5em");
        wmiModelArray[4] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, THEN_KEYWORD, wmiMathContext);
        wmiModelArray[5] = WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, WmiProcBuilder.PROC_INC_LINEBREAK_ATTR);
        wmiModelArray[6] = WmiProcBuilder.createStatementSequenceRow(dag2, wmiMathDocumentModel, wmiMathContext);
        wmiModelArray[7] = WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, WmiProcBuilder.PROC_DEC_LINEBREAK_ATTR);
        try {
            wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
            wmiInlineMathModel.setSemantics(LINE_SEMANTICS);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        return wmiInlineMathModel;
    }

    public WmiMathModel createElseStatement(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = null;
        WmiModel[] wmiModelArray = new WmiMathModel[]{WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, ELSE_KEYWORD, wmiMathContext), WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, WmiProcBuilder.PROC_INC_LINEBREAK_ATTR), WmiProcBuilder.createStatementSequenceRow(dag, wmiMathDocumentModel, wmiMathContext), WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, WmiProcBuilder.PROC_DEC_LINEBREAK_ATTR)};
        try {
            wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
            wmiInlineMathModel.setSemantics(LINE_SEMANTICS);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        return wmiInlineMathModel;
    }

    public Dag toDag(WmiMathModel wmiMathModel) {
        return null;
    }

    public static class WmiIfLineSemantics
    implements WmiMathSemantics {
        public Dag toDag(WmiMathModel wmiMathModel) {
            return null;
        }
    }
}

