/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;

public class WmiHashTableBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    private static final String ROW_LEAD_CHARACTERS = "#(";
    private static final String ROW_MIDDLE_CHARACTERS = ") = ";
    private static final String LINEBREAK_CONTEXT_NAME = "hashtable";

    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = null;
        int n = dag.getLength();
        WmiModel[] wmiModelArray = new WmiMathModel[n / 2];
        int n2 = 0;
        for (int i = 0; i < n - 1; i += 2) {
            Dag dag2 = dag.getChild(i);
            Dag dag3 = dag.getChild(i + 1);
            wmiModelArray[n2++] = this.buildHashRow(dag2, dag3, wmiMathDocumentModel, wmiMathContext);
        }
        try {
            wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
            wmiInlineMathModel.setSemantics(this);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        return wmiInlineMathModel;
    }

    private WmiMathModel buildHashRow(Dag dag, Dag dag2, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        WmiModel[] wmiModelArray = new WmiMathModel[1];
        StringBuffer stringBuffer = new StringBuffer(ROW_LEAD_CHARACTERS);
        stringBuffer.append(DagBuilder.lPrint(dag));
        stringBuffer.append(ROW_MIDDLE_CHARACTERS);
        stringBuffer.append(DagBuilder.lPrint(dag2));
        wmiModelArray[0] = WmiMathFactory.createMathTextToken(wmiMathDocumentModel, stringBuffer.toString(), wmiMathContext);
        try {
            wmiInlineMathModel.replaceChildren(wmiModelArray, 0, 0);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        return wmiInlineMathModel;
    }

    public Dag toDag(WmiMathModel wmiMathModel) {
        return null;
    }
}

