/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.BracketMatcher;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.util.MathMLEntityMap;
import com.maplesoft.util.WmiMathEntityNameMapper;
import com.maplesoft.util.WmiUnicodeMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class MathTokenizer {
    private static HashSet kmap;
    private static OperatorMap omap;
    private static HashMap replaceMap;
    private static HashSet linebreakSet;

    private static int extractNumeric(String string, int n, int n2) {
        char c;
        int n3 = n;
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = -1;
        int n7 = string.length();
        if (n2 >= 0 && n2 < n7) {
            n7 = n2;
        }
        while (n3 < n7) {
            c = string.charAt(n3);
            if (n5 == n3 - 1 && n5 >= 0 && (c == '+' || c == '-' || c == '\u2212')) {
                ++n3;
                continue;
            }
            if (Character.isDigit(c)) {
                ++n3;
                if (n5 < 0) {
                    bl = true;
                } else {
                    bl2 = true;
                }
                n6 = n3;
                continue;
            }
            if (c == '.' && n4 < 0) {
                n4 = n3++;
                n6 = n3;
                continue;
            }
            if (n5 < 0 && (c == 'e' || c == 'E')) {
                if (!bl) break;
                n5 = n3++;
                continue;
            }
            if (n4 != n3 - 1 || c != '.') break;
            --n3;
            break;
        }
        if (n5 > 0 && !bl2) {
            n3 = n6;
        }
        if (n3 - n == 1 && !Character.isDigit(string.charAt(n))) {
            n3 = n;
        }
        if (n3 == n && n < n7 && (c = string.charAt(n)) >= '\u00bc' && c <= '\u00be') {
            ++n3;
        }
        return n3 - n;
    }

    private static int extractString(String string, int n, int n2) {
        int n3 = n;
        int n4 = string.length();
        if (n2 >= 0 && n2 < n4) {
            n4 = n2;
        }
        if (string.charAt(n3) == '\"') {
            while (++n3 < n4) {
                char c = string.charAt(n3);
                if (c == '\\' && n3 + 1 < string.length()) {
                    ++n3;
                }
                if (c != '\"') continue;
                ++n3;
                break;
            }
        }
        return n3 - n;
    }

    private static int extractVerbatim(String string, int n, int n2) {
        int n3;
        block2: {
            char c;
            n3 = n;
            int n4 = string.length();
            if (n2 >= 0 && n2 < n4) {
                n4 = n2;
            }
            if ((c = string.charAt(n3)) != '?' && c != '#') break block2;
            while (++n3 < n4 && (c = string.charAt(n3)) != '\n') {
            }
        }
        return n3 - n;
    }

    private static int extractIdentifier(String string, int n, int n2) {
        int n3 = n;
        int n4 = string.length();
        if (n2 >= 0 && n2 < n4) {
            n4 = n2;
        }
        block0: while (n3 < n4) {
            char c = string.charAt(n3);
            if (n3 == n) {
                if (Character.isDigit(c) || c >= '\u00bc' && c <= '\u00be') break;
                if (c == '\"' || c == '`') {
                    while (++n3 < string.length()) {
                        if (c == '\\') {
                            if (n3 + 1 >= string.length()) continue;
                            ++n3;
                            continue;
                        }
                        if (string.charAt(n3) != c) continue;
                        ++n3;
                        break block0;
                    }
                    break;
                }
            }
            if (MathTokenizer.omap.contains(c) || Character.isWhitespace(c)) break;
            ++n3;
        }
        return n3 - n;
    }

    private static int extractNewline(String string, int n, int n2) {
        int n3 = n;
        int n4 = string.length();
        if (n2 >= 0 && n2 < n4) {
            n4 = n2;
        }
        if (n3 < n4) {
            char c = string.charAt(n3);
            if (c == '\n') {
                if (++n3 < n4 && string.charAt(n3) == '\r') {
                    ++n3;
                }
            } else if (c == '\r' && ++n3 < n4 && string.charAt(n3) == '\n') {
                ++n3;
            }
        }
        return n3 - n;
    }

    private static int extractOperator(String string, int n, int n2) {
        char c;
        char c2;
        int n3 = n;
        int n4 = string.length();
        if (n2 >= 0 && n2 < n4) {
            n4 = n2;
        }
        if (n3 < n4 && MathTokenizer.omap.contains(c2 = string.charAt(n3)) && ++n3 < string.length() && MathTokenizer.omap.contains(c2, c = string.charAt(n3))) {
            ++n3;
        }
        if (n3 == n) {
            String string2;
            while (n3 < string.length() && (c2 = string.charAt(n3)) >= 'a' && c2 <= 'z') {
                ++n3;
            }
            if (n3 > n && !kmap.contains(string2 = string.substring(n, n3))) {
                n3 = n;
            }
        }
        return n3 - n;
    }

    public static void registerIdentifierCharacter(char c) {
        MathTokenizer.omap.remove(c);
    }

    public static WmiMathWrapperModel tokenize(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return MathTokenizer.tokenize(wmiMathDocumentModel, wmiMathContext, string, null, null, null, false);
    }

    public static WmiMathWrapperModel tokenize(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, String string, String string2, PlaceholderFiller placeholderFiller) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return MathTokenizer.tokenize(wmiMathDocumentModel, wmiMathContext, string, null, string2, placeholderFiller, false);
    }

    public static WmiMathWrapperModel tokenize(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, String string, int[] nArray, String string2, PlaceholderFiller placeholderFiller, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean bl2 = bl;
        int n = nArray != null ? nArray[0] : 0;
        int n2 = 0;
        int n3 = -1;
        WmiMathWrapperModel wmiMathWrapperModel = new WmiMathWrapperModel(wmiMathDocumentModel);
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        wmiMathWrapperModel.appendChild(wmiInlineMathModel);
        WmiFontAttributeSet wmiFontAttributeSet = wmiMathContext.getStyle();
        wmiMathWrapperModel.addAttributes(wmiFontAttributeSet);
        wmiInlineMathModel.addAttributes(wmiFontAttributeSet);
        while (n2 < string.length()) {
            if (string2 != null && placeholderFiller != null) {
                n3 = string.indexOf(string2, n2);
            }
            if (n3 == n2) {
                placeholderFiller.appendPlaceholder(wmiInlineMathModel);
                n2 += string2.length();
                continue;
            }
            WmiAbstractMathTokenModel wmiAbstractMathTokenModel = null;
            String string3 = null;
            int n4 = MathTokenizer.extractNumeric(string, n2, n3);
            int n5 = MathTokenizer.extractOperator(string, n2, n3);
            int n6 = MathTokenizer.extractString(string, n2, n3);
            int n7 = MathTokenizer.extractVerbatim(string, n2, n3);
            int n8 = MathTokenizer.extractIdentifier(string, n2, n3);
            int n9 = MathTokenizer.extractNewline(string, n2, n3);
            int n10 = 0;
            int n11 = 0;
            boolean bl3 = false;
            if (n7 != 0) {
                int n12 = n2 + 1;
                if (string.startsWith("???")) {
                    n12 += 2;
                } else if (string.startsWith("??")) {
                    ++n12;
                }
                string3 = string.substring(n2, n12);
                wmiAbstractMathTokenModel = new WmiMathOperatorModel(wmiMathDocumentModel, string3, string3, wmiMathContext);
                wmiInlineMathModel.appendChild(wmiAbstractMathTokenModel);
                string3 = string.substring(n12, n2 + n7);
                wmiAbstractMathTokenModel = new WmiIdentifierModel(wmiMathDocumentModel, string3, string3, wmiMathContext, false);
                n11 = 1 + ((WmiTextModel)wmiAbstractMathTokenModel).getLength();
                n10 = n7;
                bl2 = true;
            } else if (n9 != 0) {
                WmiMathAttributeSet wmiMathAttributeSet = wmiMathContext.createAttributes(3);
                WmiMathSpaceModel.WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet = new WmiMathSpaceModel.WmiMathSpaceAttributeSet();
                wmiMathSpaceAttributeSet.addAttributes(wmiMathAttributeSet);
                wmiAbstractMathTokenModel = new WmiMathSpaceModel(wmiMathDocumentModel, "", (WmiAttributeSet)wmiMathSpaceAttributeSet);
                n11 = 1;
                wmiAbstractMathTokenModel.addAttribute("linebreak", "newline");
                wmiInlineMathModel.appendChild(wmiAbstractMathTokenModel);
                wmiAbstractMathTokenModel = new WmiMathSpaceModel(wmiMathDocumentModel, "", (WmiAttributeSet)wmiMathSpaceAttributeSet);
                n10 = n9;
            } else if (n6 != 0) {
                string3 = string.substring(n2, n2 + n6);
                if (n6 > 1 && string3.charAt(string3.length() - 1) == '\"') {
                    string3 = string3.substring(1);
                    string3 = string3.substring(0, string3.length() - 1);
                    wmiAbstractMathTokenModel = new WmiMathStringModel(wmiMathDocumentModel, string3, wmiMathContext);
                } else {
                    wmiAbstractMathTokenModel = new WmiMathOperatorModel(wmiMathDocumentModel, string3, string3, wmiMathContext);
                }
                bl3 = true;
                n11 = ((WmiTextModel)wmiAbstractMathTokenModel).getLength();
                n10 = n6;
                bl2 = false;
            } else if (n4 > n5) {
                if (n4 >= n8) {
                    if (n4 > 0) {
                        string3 = string.substring(n2, n2 + n4);
                        wmiAbstractMathTokenModel = new WmiNumericModel(wmiMathDocumentModel, string3, string3, wmiMathContext);
                        n11 = ((WmiTextModel)wmiAbstractMathTokenModel).getLength();
                    }
                    n10 = n4;
                    bl2 = false;
                } else {
                    string3 = string.substring(n2, n2 + n8);
                    wmiAbstractMathTokenModel = new WmiIdentifierModel(wmiMathDocumentModel, string3, string3, wmiMathContext, MathTokenizer.isMathSymbol(string3));
                    n11 = ((WmiTextModel)wmiAbstractMathTokenModel).getLength();
                    n10 = n8;
                    bl2 = false;
                }
            } else if (n5 >= n8) {
                if (n5 > 0) {
                    String string4;
                    string3 = string.substring(n2, n2 + n5);
                    if (wmiMathContext.isSyntaxMappingEnabled() && (string4 = (String)replaceMap.get(string3)) != null) {
                        string3 = string4;
                    }
                    if (string3.equals("\u2212")) {
                        string3 = bl2 ? "&uminus0;" : "&minus;";
                    }
                    wmiAbstractMathTokenModel = new WmiMathOperatorModel(wmiMathDocumentModel, string3, string3, wmiMathContext);
                    n11 = ((WmiTextModel)wmiAbstractMathTokenModel).getLength();
                    bl2 = true;
                }
                n10 = n5;
            } else {
                string3 = string.substring(n2, n2 + n8);
                wmiAbstractMathTokenModel = new WmiIdentifierModel(wmiMathDocumentModel, string3, string3, wmiMathContext, MathTokenizer.isMathSymbol(string3));
                n10 = n8;
                n11 = ((WmiTextModel)wmiAbstractMathTokenModel).getLength();
                bl2 = false;
            }
            if (n11 != n10 && n2 < n) {
                n = MathTokenizer.getCorrectedOffset(string3, n2, n, bl3);
            }
            if (n10 == 0) {
                n10 = 1;
            }
            if (wmiAbstractMathTokenModel != null) {
                if (MathTokenizer.requiresImplicitMultiplication(wmiInlineMathModel, wmiAbstractMathTokenModel)) {
                    WmiMathOperatorModel wmiMathOperatorModel = new WmiMathOperatorModel(wmiMathDocumentModel, " ", " ", wmiMathContext);
                    wmiInlineMathModel.appendChild(wmiMathOperatorModel);
                    if (n > n2) {
                        ++n;
                    }
                }
                wmiInlineMathModel.appendChild(wmiAbstractMathTokenModel);
            }
            n2 += n10;
        }
        if (nArray != null) {
            nArray[0] = n;
        }
        return wmiMathWrapperModel;
    }

    private static boolean requiresImplicitMultiplication(WmiInlineMathModel wmiInlineMathModel, WmiModel wmiModel) throws WmiNoReadAccessException {
        int n;
        boolean bl = false;
        WmiModelTag wmiModelTag = wmiModel.getTag();
        if (wmiModelTag == WmiModelTag.MATH_IDENTIFIER && (n = wmiInlineMathModel.getChildCount()) > 0) {
            String string;
            WmiModelTag wmiModelTag2;
            WmiModel wmiModel2 = wmiInlineMathModel.getChild(n - 1);
            WmiModelTag wmiModelTag3 = wmiModelTag2 = wmiModel2 != null ? wmiModel2.getTag() : null;
            if (wmiModelTag2 == WmiModelTag.MATH_NUMERIC && !(string = ((WmiIdentifierModel)wmiModel).getAllText()).equalsIgnoreCase("e")) {
                bl = true;
            }
        }
        return bl;
    }

    private static int getCorrectedOffset(String string, int n, int n2, boolean bl) {
        int n3;
        int n4 = n2;
        int n5 = n3 = bl ? 2 : 1;
        if (string != null) {
            int n6 = string.length();
            for (int i = 0; i < n6 && n + i < n4 - n3; ++i) {
                char c = string.charAt(i);
                if (c != '&') continue;
                int n7 = i;
                int n8 = -1;
                while (++i < n6) {
                    if (string.charAt(i) != ';') continue;
                    n8 = i;
                    break;
                }
                if (n8 <= n7) continue;
                String string2 = string.substring(n7 + 1, n8);
                char c2 = WmiMathEntityNameMapper.getUnicodeCharacter(string2);
                if (c2 == '\u0000') {
                    n4 -= 2;
                    continue;
                }
                n4 -= string2.length() + 1;
            }
        }
        return n4;
    }

    public static boolean isMathSymbol(String string) {
        boolean bl = false;
        if (string.length() == 1) {
            char c = string.charAt(0);
            bl = MathTokenizer.isMathSymbol(c);
        }
        return bl;
    }

    public static boolean isMathSymbol(char c) {
        boolean bl = false;
        if (c >= '\u0370' && c <= '\u04ff') {
            bl = true;
        } else if (c >= '\u0080' && c <= '\u00bf') {
            bl = true;
        } else if (c >= '\u2000' && c <= '\u206f') {
            bl = true;
        } else if (c >= '\u2100' && c <= '\u218f') {
            bl = true;
        } else if (c >= '\u2190' && c <= '\u22ff') {
            bl = true;
        } else if (c >= '\u2600' && c <= '\u26ff') {
            bl = true;
        } else if (c < '\u27c0' || c > '\u27eb') {
            if (c >= '\u2a00' && c <= '\u2aff') {
                bl = true;
            } else if (c >= '\u300a' && c <= '\u300b') {
                bl = true;
            } else if (c >= '\ue000' && c <= '\uf8ff') {
                bl = true;
            }
        }
        return bl;
    }

    public static WmiModelPosition retokenize(WmiTextModel wmiTextModel, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        return MathTokenizer.retokenize(wmiTextModel, n, true);
    }

    public static WmiModelPosition retokenize(WmiTextModel wmiTextModel, int n, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModelPosition wmiModelPosition = null;
        WmiMathWrapperModel wmiMathWrapperModel = (WmiMathWrapperModel)WmiModelUtil.findAncestorOfTag((WmiModel)wmiTextModel, WmiModelTag.MATH);
        if (wmiMathWrapperModel == null || MathTokenizer.isSpecialCharacterModel(wmiTextModel)) {
            return new WmiModelPosition(wmiTextModel, n);
        }
        if (wmiTextModel.getTag() == WmiModelTag.MATH_TEXT && wmiTextModel.getLength() > 0) {
            return new WmiModelPosition(wmiTextModel, n);
        }
        ArrayList arrayList = MathTokenizer.detachScripts(wmiTextModel);
        if (bl) {
            MathTokenizer.expandNestedRows(wmiTextModel);
        }
        WmiCompositeModel wmiCompositeModel = wmiTextModel.getParent();
        MathTokenizer.pruneEmptyModels(wmiCompositeModel, wmiTextModel);
        RetokenizeContext retokenizeContext = new RetokenizeContext();
        retokenizeContext.offset = n;
        MathTokenizer.getAttributes(wmiTextModel, wmiMathWrapperModel, retokenizeContext);
        String string = MathTokenizer.getContent(wmiCompositeModel, wmiTextModel, retokenizeContext);
        retokenizeContext.wrapper = wmiMathWrapperModel;
        MathTokenizer.doReplacement(wmiTextModel, wmiCompositeModel, string, retokenizeContext);
        if (retokenizeContext.posModel != null) {
            wmiModelPosition = new WmiModelPosition(retokenizeContext.posModel, retokenizeContext.posOffset);
            retokenizeContext.wrapper = (WmiMathWrapperModel)WmiModelUtil.findAncestorOfTag(retokenizeContext.posModel, WmiModelTag.MATH);
            wmiModelPosition = BracketMatcher.matchBrackets(retokenizeContext.wrapper, arrayList, wmiModelPosition);
            MathTokenizer.reattachScripts(arrayList);
        }
        return wmiModelPosition;
    }

    private static void doReplacement(WmiTextModel wmiTextModel, WmiCompositeModel wmiCompositeModel, String string, RetokenizeContext retokenizeContext) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
        WmiMathContext wmiMathContext = WmiMathWrapperModel.createContext(wmiTextModel.getAttributesForRead());
        wmiMathContext.enableSyntaxMapping(false);
        int[] nArray = new int[]{retokenizeContext.adjustedOffset};
        retokenizeContext.wrapper = MathTokenizer.tokenize(wmiTextModel.getDocument(), wmiMathContext, string.toString(), nArray, null, null, retokenizeContext.startIndex == 0);
        retokenizeContext.adjustedOffset = nArray[0];
        WmiCompositeModel wmiCompositeModel2 = retokenizeContext.wrapper;
        int n = wmiCompositeModel2.getChildCount();
        if (n == 1 && retokenizeContext.wrapper.getChild(0) instanceof WmiCompositeModel) {
            wmiCompositeModel2 = (WmiCompositeModel)retokenizeContext.wrapper.getChild(0);
            n = wmiCompositeModel2.getChildCount();
        }
        if (n == 0) {
            WmiMathDocumentModel wmiMathDocumentModel = wmiCompositeModel2.getDocument();
            WmiIdentifierModel wmiIdentifierModel = new WmiIdentifierModel(wmiMathDocumentModel, "", "", wmiMathContext, false);
            wmiCompositeModel2.appendChild(wmiIdentifierModel);
            n = 1;
        }
        int n2 = 0;
        int n3 = 0;
        WmiModel[] wmiModelArray = new WmiModel[n];
        for (int i = 0; i < n; ++i) {
            int n4;
            Object object;
            Object object2;
            WmiModel wmiModel;
            wmiModelArray[i] = wmiModel = wmiCompositeModel2.getChild(i);
            int n5 = 1;
            if (!(wmiModel instanceof WmiMathSpaceModel) && wmiModel instanceof WmiTextModel) {
                object2 = (WmiTextModel)wmiModel;
                object = ((WmiTextModel)object2).getText();
                if (!((String)object).equals("\u2212") && wmiModel.getTag() == WmiModelTag.MATH_OPERATOR) {
                    String string2;
                    char c;
                    Object object3;
                    n4 = ((String)object).length();
                    boolean bl = false;
                    if (n2 < retokenizeContext.semantics.size() && (Integer)(object3 = (Integer)retokenizeContext.semantics.get(n2)) == n3) {
                        String string3 = (String)retokenizeContext.semantics.get(n2 + 1);
                        if (string3.equals(object)) {
                            object = (String)retokenizeContext.semantics.get(n2 + 2);
                            bl = true;
                        }
                        n2 += 3;
                        ((WmiTextModel)object2).replaceText((String)object, 0, n4);
                        ((WmiMathOperatorModel)object2).configureStrings((String)object, wmiMathContext);
                    }
                    if ((object3 = (String)replaceMap.get(object)) != null) {
                        ((WmiTextModel)object2).replaceText((String)object3, 0, ((String)object).length());
                        retokenizeContext.adjustedOffset += ((String)object3).length() - n4;
                        object = object3;
                    }
                    if (!bl && ((String)object).length() == 1 && (c = ((String)object).charAt(0)) > '\u007f' && (string2 = MathMLEntityMap.getMathMLName(((String)object).charAt(0))) != null) {
                        ((WmiTextModel)object2).replaceText("&" + string2 + ";", 0, ((String)object).length());
                    }
                }
                n5 = ((WmiTextModel)object2).getLength();
            }
            n3 += n5;
            if (retokenizeContext.attributeMask != 0 && (object2 = wmiModel.getAttributes()) instanceof WmiFontAttributeSet) {
                object = (WmiFontAttributeSet)object2;
                n4 = ((WmiFontAttributeSet)object).getExtendedStyle();
                n4 = n4 & ~retokenizeContext.attributeMask | retokenizeContext.setAttributes;
                ((WmiFontAttributeSet)object).setExtendedStyle(n4);
                wmiModel.setAttributes((WmiAttributeSet)object);
            }
            if (n5 < retokenizeContext.adjustedOffset) {
                retokenizeContext.adjustedOffset -= n5;
                continue;
            }
            if (retokenizeContext.adjustedOffset < 0 || retokenizeContext.posModel != null) continue;
            retokenizeContext.posModel = wmiModel;
            retokenizeContext.posOffset = retokenizeContext.adjustedOffset;
            if (!MathTokenizer.isLinebreakingMSpace(wmiModel)) continue;
            retokenizeContext.posOffset = 0;
        }
        wmiCompositeModel.replaceChildren(wmiModelArray, retokenizeContext.startIndex, retokenizeContext.endIndex - retokenizeContext.startIndex + 1);
        WmiInsertGenericMathCommand.refreshSemantics(wmiCompositeModel);
        MathTokenizer.removeEmptyModels(wmiCompositeModel, retokenizeContext.posModel);
    }

    private static void getAttributes(WmiTextModel wmiTextModel, WmiMathWrapperModel wmiMathWrapperModel, RetokenizeContext retokenizeContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiAttributeSet wmiAttributeSet = wmiTextModel.getAttributesForRead();
        if (wmiAttributeSet instanceof WmiMathAttributeSet) {
            WmiMathAttributeSet wmiMathAttributeSet = (WmiMathAttributeSet)wmiAttributeSet;
            retokenizeContext.extStyle = wmiMathAttributeSet.getExtendedStyle();
            int n = MathTokenizer.getPrototype(wmiTextModel, retokenizeContext.extStyle);
            if ((retokenizeContext.extStyle & 0x800) != 0 && wmiTextModel.getLength() == 0) {
                WmiFontAttributeSet wmiFontAttributeSet = (WmiFontAttributeSet)wmiMathWrapperModel.getAttributesForRead();
                wmiTextModel.addAttributes(wmiFontAttributeSet);
                n = retokenizeContext.extStyle = wmiFontAttributeSet.getExtendedStyle();
            }
            int n2 = 39;
            retokenizeContext.attributeMask = (retokenizeContext.extStyle ^ n) & n2;
            retokenizeContext.setAttributes = retokenizeContext.extStyle & n2;
        }
    }

    private static String getContent(WmiCompositeModel wmiCompositeModel, WmiTextModel wmiTextModel, RetokenizeContext retokenizeContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Object object;
        retokenizeContext.startIndex = retokenizeContext.targetIndex = wmiCompositeModel.indexOf(wmiTextModel);
        retokenizeContext.endIndex = retokenizeContext.targetIndex;
        retokenizeContext.size = wmiCompositeModel.getChildCount();
        if (retokenizeContext.offset == -1) {
            retokenizeContext.offset = wmiTextModel.getLength();
        }
        if (wmiCompositeModel.getTag() == WmiModelTag.MATH_ROW) {
            object = new AttributeCompareContext(wmiCompositeModel, retokenizeContext.targetIndex, retokenizeContext.offset);
            ((AttributeCompareContext)object).significantAttributes = retokenizeContext.attributeMask;
            while (retokenizeContext.startIndex > 0 && MathTokenizer.compatibleAttributes((AttributeCompareContext)object, retokenizeContext.startIndex - 1)) {
                --retokenizeContext.startIndex;
            }
            while (retokenizeContext.endIndex < retokenizeContext.size - 1 && MathTokenizer.compatibleAttributes((AttributeCompareContext)object, retokenizeContext.endIndex + 1)) {
                ++retokenizeContext.endIndex;
            }
            retokenizeContext.attributeMask = ((AttributeCompareContext)object).significantAttributes;
            retokenizeContext.setAttributes &= retokenizeContext.attributeMask;
        }
        object = new StringBuffer();
        for (int i = retokenizeContext.startIndex; i <= retokenizeContext.endIndex; ++i) {
            String string;
            WmiModel wmiModel = wmiCompositeModel.getChild(i);
            if (wmiModel instanceof WmiMathSpaceModel) {
                if (MathTokenizer.isLinebreakingMSpace(wmiModel)) {
                    ((StringBuffer)object).append("\n");
                } else {
                    ((StringBuffer)object).append(" ");
                }
                if (i >= retokenizeContext.targetIndex) continue;
                ++retokenizeContext.adjustedOffset;
                continue;
            }
            if (!(wmiModel instanceof WmiTextModel)) continue;
            String string2 = ((WmiTextModel)wmiModel).getText();
            ((StringBuffer)object).append(string2);
            if (wmiModel instanceof WmiMathOperatorModel && (string = ((WmiMathOperatorModel)wmiModel).getSemanticLabel()) != null && MathTokenizer.isValidLabel(string, string2)) {
                retokenizeContext.semantics.add(new Integer(retokenizeContext.adjustedOffset));
                retokenizeContext.semantics.add(string2);
                retokenizeContext.semantics.add(string);
            }
            if (i < retokenizeContext.targetIndex) {
                retokenizeContext.adjustedOffset += string2.length();
                continue;
            }
            if (i != retokenizeContext.targetIndex) continue;
            retokenizeContext.adjustedOffset += retokenizeContext.offset;
        }
        return ((StringBuffer)object).toString();
    }

    private static void removeEmptyModels(WmiCompositeModel wmiCompositeModel, WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        if (wmiCompositeModel.getTag() == WmiModelTag.MATH_ROW) {
            int n = wmiCompositeModel.getChildCount();
            for (int i = n - 1; i >= 0; --i) {
                WmiModel wmiModel2 = wmiCompositeModel.getChild(i);
                if (n <= 1 || wmiModel2.getTag() != WmiModelTag.MATH_IDENTIFIER || ((WmiTextModel)wmiModel2).getLength() != 0 || wmiModel == wmiModel2) continue;
                wmiCompositeModel.removeChild(i);
                --n;
            }
        }
    }

    private static boolean isValidLabel(String string, String string2) {
        boolean bl = false;
        if (string != null && string2 != null && string.length() > 1) {
            char c = string.charAt(0);
            char c2 = string.charAt(string.length() - 1);
            bl = string2.length() == 1 && c == '&' && c2 == ';';
        }
        return bl;
    }

    public static void retokenize(List list) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        for (int i = 0; i < list.size(); ++i) {
            WmiModelPosition wmiModelPosition = (WmiModelPosition)list.get(i);
            WmiModel wmiModel = wmiModelPosition.getModel();
            WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
            if (wmiCompositeModel.indexOf(wmiModel) == -1) continue;
            MathTokenizer.retokenize(wmiModelPosition);
        }
    }

    public static WmiModelPosition retokenize(WmiPositionMarker wmiPositionMarker) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int n;
        WmiModelPosition wmiModelPosition = null;
        WmiPositionedView wmiPositionedView = wmiPositionMarker != null ? wmiPositionMarker.getView() : null;
        WmiModel wmiModel = wmiPositionedView != null ? wmiPositionedView.getModel() : null;
        int n2 = n = wmiPositionMarker != null ? wmiPositionMarker.getOffset() : 0;
        if (wmiPositionedView instanceof WmiTextView) {
            n += ((WmiTextView)wmiPositionedView).getStartOffset();
        }
        if (wmiModel instanceof WmiTextModel) {
            wmiModelPosition = MathTokenizer.retokenize((WmiTextModel)wmiModel, n);
        } else if (wmiModel instanceof WmiCompositeModel) {
            WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
            int n3 = wmiCompositeModel != null ? wmiCompositeModel.indexOf(wmiModel) : -1;
            WmiModel wmiModel2 = null;
            n = 0;
            if (n3 > 0 && n == 0) {
                wmiModel2 = wmiCompositeModel.getChild(n3 - 1);
                n = -1;
            } else if (n3 < wmiCompositeModel.getChildCount() - 1 && n != 0) {
                wmiModel2 = wmiCompositeModel.getChild(n3 + 1);
                n = 0;
            }
            if (wmiModel2 instanceof WmiTextModel) {
                wmiModelPosition = MathTokenizer.retokenize((WmiTextModel)wmiModel2, n);
            }
        }
        return wmiModelPosition;
    }

    public static WmiModelPosition retokenize(WmiModelPosition wmiModelPosition) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModelPosition wmiModelPosition2 = null;
        WmiModel wmiModel = wmiModelPosition.getModel();
        int n = wmiModelPosition.getOffset();
        if (wmiModel instanceof WmiTextModel) {
            wmiModelPosition2 = MathTokenizer.retokenize((WmiTextModel)wmiModel, n);
        } else if (wmiModel instanceof WmiCompositeModel) {
            WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
            int n2 = wmiCompositeModel != null ? wmiCompositeModel.indexOf(wmiModel) : -1;
            WmiModel wmiModel2 = null;
            n = 0;
            if (n2 > 0 && n == 0) {
                wmiModel2 = wmiCompositeModel.getChild(n2 - 1);
                n = -1;
            } else if (n2 < wmiCompositeModel.getChildCount() - 1 && n != 0) {
                wmiModel2 = wmiCompositeModel.getChild(n2 + 1);
                n = 0;
            }
            if (wmiModel2 instanceof WmiTextModel) {
                wmiModelPosition2 = MathTokenizer.retokenize((WmiTextModel)wmiModel2, n);
            }
        }
        return wmiModelPosition2;
    }

    private static void expandNestedRows(WmiTextModel wmiTextModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCompositeModel wmiCompositeModel = wmiTextModel.getParent();
        if (wmiCompositeModel != null && wmiCompositeModel.getTag() == WmiModelTag.MATH_ROW) {
            MathTokenizer.expandChildRows(wmiCompositeModel);
            WmiCompositeModel wmiCompositeModel2 = wmiCompositeModel.getParent();
            if (wmiCompositeModel2 != null && wmiCompositeModel2.getTag() == WmiModelTag.MATH_ROW) {
                MathTokenizer.expandChildRows(wmiCompositeModel2);
                if (wmiCompositeModel2.indexOf(wmiCompositeModel) < 0) {
                    wmiCompositeModel = wmiCompositeModel2;
                }
            }
        }
    }

    private static void pruneEmptyModels(WmiCompositeModel wmiCompositeModel, WmiTextModel wmiTextModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModelTag wmiModelTag;
        WmiModelTag wmiModelTag2 = wmiModelTag = wmiCompositeModel != null ? wmiCompositeModel.getTag() : null;
        if (wmiModelTag == WmiModelTag.MATH_ROW) {
            int n = wmiCompositeModel.getChildCount();
            for (int i = n - 1; i >= 0; --i) {
                if (!WmiModelUtil.isEmptyModel(wmiCompositeModel.getChild(i), wmiTextModel)) continue;
                try {
                    wmiCompositeModel.removeChild(i);
                    continue;
                }
                catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                    WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                }
            }
        }
    }

    private static void expandChildRows(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int n = wmiCompositeModel.getChildCount();
        for (int i = n - 1; i >= 0; --i) {
            WmiInlineMathModel wmiInlineMathModel;
            WmiAttributeSet wmiAttributeSet;
            WmiModel wmiModel = wmiCompositeModel.getChild(i);
            if (wmiModel == null || wmiModel.getTag() != WmiModelTag.MATH_ROW || (wmiAttributeSet = (wmiInlineMathModel = (WmiInlineMathModel)wmiModel).getAttributesForRead()).getAttribute("Typesetting:-msemantics") != null) continue;
            int n2 = wmiInlineMathModel.getChildCount();
            WmiModel[] wmiModelArray = new WmiModel[n2];
            for (int j = 0; j < n2; ++j) {
                wmiModelArray[j] = wmiInlineMathModel.getChild(j);
            }
            try {
                wmiCompositeModel.replaceChildren(wmiModelArray, i, 1);
                continue;
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
        }
    }

    private static ArrayList detachScripts(WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        ArrayList arrayList = new ArrayList();
        MathTokenizer.detachScripts(wmiModel, arrayList);
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        if (wmiCompositeModel != null && wmiCompositeModel.getTag() == WmiModelTag.MATH_ROW) {
            int n = wmiCompositeModel.indexOf(wmiModel);
            int n2 = wmiCompositeModel.getChildCount();
            while (arrayList.size() == 0 && ++n < n2) {
                MathTokenizer.detachScripts(wmiCompositeModel.getChild(n), arrayList);
            }
        }
        return arrayList;
    }

    private static void detachScripts(WmiModel wmiModel, ArrayList arrayList) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCompositeModel wmiCompositeModel = null;
        if (MathTokenizer.isScript(wmiModel)) {
            wmiCompositeModel = (WmiCompositeModel)wmiModel;
            MathTokenizer.doScriptDetachment(wmiCompositeModel);
        } else {
            WmiCompositeModel wmiCompositeModel2 = wmiModel.getParent();
            while (MathTokenizer.sharesCommonBaseline(wmiModel, wmiCompositeModel2)) {
                if (MathTokenizer.isScript(wmiCompositeModel2)) {
                    MathTokenizer.doScriptDetachment(wmiCompositeModel2);
                    wmiCompositeModel = wmiCompositeModel2;
                    break;
                }
                wmiModel = wmiCompositeModel2;
                wmiCompositeModel2 = wmiModel.getParent();
            }
        }
        if (wmiCompositeModel != null) {
            arrayList.add(wmiCompositeModel);
        }
    }

    private static boolean sharesCommonBaseline(WmiModel wmiModel, WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        WmiModelTag wmiModelTag;
        boolean bl = false;
        WmiModelTag wmiModelTag2 = wmiModelTag = wmiCompositeModel != null ? wmiCompositeModel.getTag() : null;
        if (wmiModelTag == WmiModelTag.MATH_ROW || wmiModelTag == WmiModelTag.MATH_FENCED) {
            bl = true;
        } else if (wmiModelTag == WmiModelTag.MATH_SUBSCRIPT || wmiModelTag == WmiModelTag.MATH_SUPERSCRIPT || wmiModelTag == WmiModelTag.MATH_SUB_SUP) {
            WmiModel wmiModel2 = wmiCompositeModel.getChild(0);
            bl = wmiModel2 == wmiModel;
        }
        return bl;
    }

    public static void doScriptDetachment(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel wmiModel;
        int n;
        WmiMathDocumentModel wmiMathDocumentModel = wmiCompositeModel.getDocument();
        WmiCompositeModel wmiCompositeModel2 = wmiCompositeModel.getParent();
        if (!wmiCompositeModel2.getTag().equals(WmiModelTag.MATH_ROW)) {
            n = wmiCompositeModel2.indexOf(wmiCompositeModel);
            wmiModel = new WmiInlineMathModel(wmiMathDocumentModel);
            ((WmiAbstractArrayCompositeModel)wmiModel).appendChild(wmiCompositeModel);
            try {
                wmiCompositeModel2.replaceChild(wmiModel, n);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
            wmiCompositeModel2 = wmiModel;
        }
        if ((n = wmiCompositeModel2.indexOf(wmiCompositeModel)) >= 0) {
            wmiModel = wmiCompositeModel.getChild(0);
            WmiIdentifierModel wmiIdentifierModel = new WmiIdentifierModel(wmiCompositeModel.getDocument(), "", "", (WmiFontAttributeSet)wmiCompositeModel.getAttributes(), false);
            try {
                wmiCompositeModel.replaceChild(wmiIdentifierModel, 0);
                if (!(wmiModel.getTag() != WmiModelTag.MATH_ROW || wmiModel.getAttributesForRead().getAttribute("Typesetting:-msemantics") != null && wmiModel.getAttributesForRead().getAttribute("Typesetting:-msemantics").equals("donotprune"))) {
                    WmiCompositeModel wmiCompositeModel3 = (WmiCompositeModel)wmiModel;
                    int n2 = wmiCompositeModel3.getChildCount();
                    WmiModel[] wmiModelArray = new WmiModel[n2];
                    for (int i = 0; i < n2; ++i) {
                        wmiModelArray[i] = wmiCompositeModel3.getChild(i);
                    }
                    wmiCompositeModel2.addChildren(wmiModelArray, n);
                } else {
                    wmiCompositeModel2.addChild(wmiModel, n);
                }
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
        }
    }

    private static boolean isScript(WmiModel wmiModel) {
        WmiModelTag wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
        return wmiModelTag == WmiModelTag.MATH_SUBSCRIPT || wmiModelTag == WmiModelTag.MATH_SUPERSCRIPT || wmiModelTag == WmiModelTag.MATH_SUB_SUP;
    }

    private static void reattachScripts(ArrayList arrayList) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)arrayList.get(i);
            MathTokenizer.reattachScripts(wmiCompositeModel);
        }
    }

    private static void reattachScripts(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCompositeModel wmiCompositeModel2 = wmiCompositeModel.getParent();
        int n = wmiCompositeModel2.indexOf(wmiCompositeModel);
        if (n > 0) {
            WmiModel wmiModel = wmiCompositeModel2.getChild(n - 1);
            WmiCompositeModel wmiCompositeModel3 = wmiModel.getParent();
            while (!(wmiModel == null || wmiModel.getTag() != WmiModelTag.MATH_ROW || wmiModel.getAttributesForRead().getAttribute("Typesetting:-msemantics") != null && wmiModel.getAttributesForRead().getAttribute("Typesetting:-msemantics").equals("donotprune"))) {
                wmiCompositeModel3 = (WmiCompositeModel)wmiModel;
                wmiModel = wmiCompositeModel3.getChild(wmiCompositeModel3.getChildCount() - 1);
            }
            if (wmiModel != null) {
                try {
                    wmiCompositeModel3.removeChild(wmiModel);
                    wmiCompositeModel.replaceChild(wmiModel, 0);
                }
                catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                    WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                }
            }
        }
    }

    private static boolean isSpecialCharacterModel(WmiTextModel wmiTextModel) throws WmiNoReadAccessException {
        String string;
        WmiModelTag wmiModelTag;
        WmiModelTag wmiModelTag2 = wmiModelTag = wmiTextModel != null ? wmiTextModel.getTag() : null;
        if (wmiModelTag == WmiModelTag.MATH_OPERATOR && (string = wmiTextModel.getText()) != null && (string.equals("d") || string.equals("e"))) {
            return true;
        }
        return wmiModelTag == WmiModelTag.MATH_NUMERIC && (string = wmiTextModel.getText()) != null && (string.equals("i") || string.equals("j") || string.equals("I"));
    }

    private static boolean compatibleAttributes(AttributeCompareContext attributeCompareContext, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String string;
        WmiModelTag wmiModelTag;
        WmiModel wmiModel = attributeCompareContext.parent.getChild(n);
        WmiTextModel wmiTextModel = attributeCompareContext.reference;
        WmiModelTag wmiModelTag2 = wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
        if (wmiModelTag == WmiModelTag.MATH_IDENTIFIER || wmiModelTag == WmiModelTag.MATH_OPERATOR || wmiModelTag == WmiModelTag.MATH_NUMERIC || wmiModelTag == WmiModelTag.MATH_STRING || wmiModelTag == WmiModelTag.MATH_TEXT) {
            WmiAttributeSet wmiAttributeSet = wmiModel.getAttributesForRead();
            WmiAttributeSet wmiAttributeSet2 = wmiTextModel.getAttributesForRead();
            if (wmiAttributeSet instanceof WmiMathAttributeSet) {
                if (wmiAttributeSet.getAttribute("Typesetting:-msemantics") != null) {
                    return false;
                }
                if (MathTokenizer.isSpecialCharacterModel((WmiTextModel)wmiModel)) {
                    return false;
                }
                if (wmiAttributeSet2 == null) {
                    wmiTextModel.setAttributes(wmiAttributeSet);
                    return true;
                }
                if (wmiAttributeSet2 instanceof WmiMathAttributeSet) {
                    WmiMathAttributeSet wmiMathAttributeSet = (WmiMathAttributeSet)wmiAttributeSet2;
                    WmiMathAttributeSet wmiMathAttributeSet2 = (WmiMathAttributeSet)wmiAttributeSet;
                    int n2 = wmiMathAttributeSet2.getExtendedStyle();
                    int n3 = MathTokenizer.getPrototype(wmiModel, n2);
                    int n4 = wmiMathAttributeSet.getExtendedStyle();
                    int n5 = n2 ^ n3;
                    int n6 = ~(attributeCompareContext.significantAttributes | n5);
                    if (!wmiMathAttributeSet.getFamily().equals(wmiMathAttributeSet2.getFamily())) {
                        return false;
                    }
                    if (wmiMathAttributeSet.getSize() != wmiMathAttributeSet2.getSize()) {
                        return false;
                    }
                    int n7 = ~(0x740 | n6);
                    if (((n4 ^ n2) & n7) != 0) {
                        return false;
                    }
                    if (wmiMathAttributeSet.getForeground() != wmiMathAttributeSet2.getForeground()) {
                        return false;
                    }
                    if (wmiMathAttributeSet.isOpaque() && wmiMathAttributeSet.getBackground() != wmiMathAttributeSet2.getBackground()) {
                        return false;
                    }
                    attributeCompareContext.significantAttributes |= n5;
                    return true;
                }
            }
        } else if (wmiModel instanceof WmiTextModel && !MathTokenizer.isLinebreakingMSpace(wmiModel) && ((string = ((WmiTextModel)wmiModel).getText()) == null || string.length() == 0)) {
            return true;
        }
        return false;
    }

    public static int getPrototype(WmiModel wmiModel, int n) throws WmiNoReadAccessException {
        return WmiAbstractMathTokenModel.getPrototype(wmiModel, n);
    }

    public static boolean isOperator(char c) {
        return MathTokenizer.omap.contains(c);
    }

    public static boolean isLinebreakingMSpace(WmiModel wmiModel) throws WmiNoReadAccessException {
        boolean bl = false;
        if (wmiModel.getTag() == WmiModelTag.MATH_SPACE) {
            WmiMathSpaceModel.WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet = (WmiMathSpaceModel.WmiMathSpaceAttributeSet)wmiModel.getAttributesForRead();
            String string = wmiMathSpaceAttributeSet.getLinebreak();
            if (linebreakSet == null) {
                linebreakSet = new HashSet();
                linebreakSet.add("newline");
                linebreakSet.add("decreaseindentnewline");
                linebreakSet.add("increaseindentnewline");
                linebreakSet.add("indentingnewline");
                linebreakSet.add("firstprocnewline");
            }
            bl = linebreakSet.contains(string);
        }
        return bl;
    }

    public static boolean containsOperator(String string) {
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c = string.charAt(i);
            if (c == '&' && (n2 = string.indexOf(59, i)) >= 0) {
                String string2 = string.substring(i + 1, n2);
                c = WmiMathEntityNameMapper.getUnicodeCharacter(string2);
                i = n2;
            }
            if (!MathTokenizer.omap.contains(c)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static {
        int n;
        kmap = new HashSet();
        omap = new OperatorMap();
        replaceMap = new HashMap();
        linebreakSet = null;
        MathTokenizer.omap.add('-');
        MathTokenizer.omap.add('+');
        MathTokenizer.omap.add('/');
        MathTokenizer.omap.add('*');
        MathTokenizer.omap.add('=');
        MathTokenizer.omap.add(':');
        MathTokenizer.omap.add(';');
        MathTokenizer.omap.add('#');
        MathTokenizer.omap.add('<');
        MathTokenizer.omap.add('>');
        MathTokenizer.omap.add('@');
        MathTokenizer.omap.add('&');
        MathTokenizer.omap.add('^');
        MathTokenizer.omap.add('[');
        MathTokenizer.omap.add(']');
        MathTokenizer.omap.add('(');
        MathTokenizer.omap.add(')');
        MathTokenizer.omap.add('{');
        MathTokenizer.omap.add('}');
        MathTokenizer.omap.add('|');
        MathTokenizer.omap.add('.');
        MathTokenizer.omap.add(',');
        MathTokenizer.omap.add('!');
        MathTokenizer.omap.add('$');
        MathTokenizer.omap.add('?');
        MathTokenizer.omap.add(' ');
        MathTokenizer.omap.add('\'');
        MathTokenizer.omap.add('\\');
        MathTokenizer.omap.add('\u00b1');
        MathTokenizer.omap.add('\u00b7', '*');
        MathTokenizer.omap.add('\u00f7', '/');
        for (n = 8192; n < 8303; ++n) {
            MathTokenizer.omap.add((char)n);
        }
        for (n = 8592; n < 8959; ++n) {
            MathTokenizer.omap.add((char)n);
        }
        MathTokenizer.omap.add('\u231c');
        MathTokenizer.omap.add('\u231d');
        MathTokenizer.omap.add('\u231e');
        MathTokenizer.omap.add('\u231f');
        MathTokenizer.omap.add('\u25a1');
        MathTokenizer.omap.add('\u25ad');
        MathTokenizer.omap.add('\u25b1');
        MathTokenizer.omap.add('\u25b3');
        MathTokenizer.omap.add('\u25bd');
        MathTokenizer.omap.add('\u25ca');
        MathTokenizer.omap.add('\u25cb');
        MathTokenizer.omap.add('\u2993');
        MathTokenizer.omap.add('\u25c1');
        MathTokenizer.omap.add('\u25b7');
        MathTokenizer.omap.add('\u00af');
        MathTokenizer.omap.add('\ufe37');
        MathTokenizer.omap.add('\ufe38');
        MathTokenizer.omap.add('\u2927');
        MathTokenizer.omap.add('\u2928');
        MathTokenizer.omap.add('\u2929');
        MathTokenizer.omap.add('\u292a');
        MathTokenizer.omap.add('\u296e');
        MathTokenizer.omap.add('\u296f');
        MathTokenizer.omap.add('\u2905');
        MathTokenizer.omap.add('\u2936');
        MathTokenizer.omap.add('\u2937');
        MathTokenizer.omap.add('\u2923');
        MathTokenizer.omap.add('\u2924');
        MathTokenizer.omap.add('\u2926');
        MathTokenizer.omap.add('\u2925');
        MathTokenizer.omap.add('\u00ac');
        MathTokenizer.omap.add('\u2145');
        MathTokenizer.omap.add('\u29b5');
        MathTokenizer.omap.add('\u29b6');
        MathTokenizer.omap.add('\u299c');
        MathTokenizer.omap.add('\u00b4');
        MathTokenizer.omap.add('\u00b8');
        MathTokenizer.omap.add('`');
        MathTokenizer.omap.add('\u02c6');
        MathTokenizer.omap.add('\u00a8');
        MathTokenizer.omap.add('\u00a1');
        MathTokenizer.omap.add('\u00bf');
        MathTokenizer.omap.add('\u00ab');
        MathTokenizer.omap.add('\u00bb');
        MathTokenizer.omap.add('\u00af');
        MathTokenizer.omap.add('\u00b6');
        MathTokenizer.omap.add('\u00a7');
        MathTokenizer.omap.add('\u00a8');
        MathTokenizer.omap.add('\u00b0');
        MathTokenizer.omap.add('\u2713');
        MathTokenizer.omap.add('\u00a9');
        MathTokenizer.omap.add('\u00ae');
        MathTokenizer.omap.add('\u00a3');
        MathTokenizer.omap.add('\u00a4');
        MathTokenizer.omap.add('\u00a5');
        for (n = 10176; n < 10219; ++n) {
            MathTokenizer.omap.add((char)n);
        }
        for (n = 10752; n < 11007; ++n) {
            MathTokenizer.omap.add((char)n);
        }
        for (n = 57857; n < 57871; ++n) {
            MathTokenizer.omap.add((char)n);
        }
        MathTokenizer.omap.add('\u00d7');
        MathTokenizer.omap.add('\u21d2');
        MathTokenizer.omap.add('\u2329');
        MathTokenizer.omap.add('\u232a');
        MathTokenizer.omap.add('\u2308');
        MathTokenizer.omap.add('\u2309');
        MathTokenizer.omap.add('\u230a');
        MathTokenizer.omap.add('\u230b');
        MathTokenizer.omap.add('\u2192');
        MathTokenizer.omap.add('\u21cf');
        MathTokenizer.omap.add('\u300a');
        MathTokenizer.omap.add('\u300b');
        MathTokenizer.omap.add('\u301a');
        MathTokenizer.omap.add('\u301b');
        MathTokenizer.omap.add('|', '|');
        MathTokenizer.omap.add('.', '.');
        MathTokenizer.omap.add(':', '-');
        MathTokenizer.omap.add(':', '=');
        MathTokenizer.omap.add(':', ':');
        MathTokenizer.omap.add('<', '=');
        MathTokenizer.omap.add('>', '=');
        MathTokenizer.omap.add('!', '=');
        MathTokenizer.omap.add('!', '<');
        MathTokenizer.omap.add('!', '>');
        MathTokenizer.omap.add('<', '>');
        MathTokenizer.omap.add('>', '<');
        MathTokenizer.omap.add('-', '>');
        MathTokenizer.omap.add('=', '>');
        MathTokenizer.omap.add('\u2212', '>');
        MathTokenizer.omap.add('\u2260', '>');
        MathTokenizer.omap.add('\u226e', '=');
        MathTokenizer.omap.add('\u226f', '=');
        MathTokenizer.omap.add('\u2225');
        MathTokenizer.omap.add('@', '@');
        MathTokenizer.omap.add('&', '*');
        MathTokenizer.omap.add('&', '-');
        MathTokenizer.omap.add('&', '+');
        MathTokenizer.omap.add('&', '/');
        MathTokenizer.omap.add('\\', '^');
        MathTokenizer.omap.add('\\', '*');
        MathTokenizer.omap.add('\\', '\u22c5');
        MathTokenizer.omap.add('\\', '/');
        MathTokenizer.omap.add('\\', '\\');
        kmap.add("and");
        kmap.add("assuming");
        kmap.add("break");
        kmap.add("by");
        kmap.add("catch");
        kmap.add("description");
        kmap.add("do");
        kmap.add("done");
        kmap.add("elif");
        kmap.add("else");
        kmap.add("end");
        kmap.add("error");
        kmap.add("export");
        kmap.add("fi");
        kmap.add("finally");
        kmap.add("for");
        kmap.add("from");
        kmap.add("global");
        kmap.add("if");
        kmap.add("iff");
        kmap.add("implies");
        kmap.add("in");
        kmap.add("intersect");
        kmap.add("local");
        kmap.add("minus");
        kmap.add("mod");
        kmap.add("module");
        kmap.add("nand");
        kmap.add("next");
        kmap.add("nor");
        kmap.add("not");
        kmap.add("od");
        kmap.add("option");
        kmap.add("options");
        kmap.add("or");
        kmap.add("proc");
        kmap.add("quit");
        kmap.add("read");
        kmap.add("return");
        kmap.add("save");
        kmap.add("stop");
        kmap.add("subset");
        kmap.add("then");
        kmap.add("to");
        kmap.add("try");
        kmap.add("union");
        kmap.add("use");
        kmap.add("while");
        kmap.add("xor");
        replaceMap.put(":-", ":-");
        replaceMap.put("\\^", "^");
        replaceMap.put("\\_", "_");
        replaceMap.put("\\*", "*");
        replaceMap.put("\\\u22c5", "*");
        replaceMap.put("\\/", "/");
        replaceMap.put(":=", "\u2254");
        replaceMap.put("::", "\u2237");
        replaceMap.put("<=", "\u2264");
        replaceMap.put(">=", "\u2265");
        replaceMap.put("!=", "\u2260");
        replaceMap.put("!<", "\u226e");
        replaceMap.put("!>", "\u226f");
        replaceMap.put("->", "\u2192");
        replaceMap.put("\u2212>", "\u2192");
        replaceMap.put("\u226e=", "\u2270");
        replaceMap.put("\u226f=", "\u2271");
        replaceMap.put("=>", "\u21d2");
        replaceMap.put("\u2260>", "\u21cf");
        replaceMap.put("<>", "\u2260");
        replaceMap.put("..", "..");
        replaceMap.put("-", "\u2212");
        replaceMap.put("||", "\u2225");
    }

    private static class RetokenizeContext {
        public int startIndex = 0;
        public int endIndex = 0;
        public int adjustedOffset = 0;
        public int attributeMask = 0;
        public int setAttributes = 0;
        public int extStyle = 0;
        public int targetIndex = 0;
        public int size = 0;
        public int offset = 0;
        public ArrayList semantics = new ArrayList();
        public WmiMathWrapperModel wrapper = null;
        public WmiModel posModel = null;
        public int posOffset = 0;

        private RetokenizeContext() {
        }
    }

    public static abstract class PlaceholderFiller {
        public void appendPlaceholder(WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiModel wmiModel = this.createPlaceholder(wmiInlineMathModel.getDocument());
            if (wmiModel != null) {
                wmiInlineMathModel.appendChild(wmiModel);
            }
        }

        public abstract WmiModel createPlaceholder(WmiMathDocumentModel var1) throws WmiNoReadAccessException, WmiNoWriteAccessException;
    }

    private static class OperatorMap {
        private static final Object DEFAULT_OPERATOR_MARKER = Boolean.TRUE;
        private WmiUnicodeMapper operatorMapper = new WmiUnicodeMapper();

        private OperatorMap() {
        }

        private void add(char c) {
            if (this.operatorMapper.get(c) == null) {
                this.operatorMapper.put(c, DEFAULT_OPERATOR_MARKER);
            }
        }

        private void remove(char c) {
            this.operatorMapper.put(c, null);
        }

        private void add(char c, char c2) {
            Object object = this.operatorMapper.get(c);
            if (object == null || object == DEFAULT_OPERATOR_MARKER) {
                object = new WmiUnicodeMapper();
                this.operatorMapper.put(c, object);
            }
            ((WmiUnicodeMapper)object).put(c2, DEFAULT_OPERATOR_MARKER);
        }

        private boolean contains(char c) {
            return this.operatorMapper.get(c) != null;
        }

        private boolean contains(char c, char c2) {
            boolean bl = false;
            Object object = this.operatorMapper.get(c);
            if (object instanceof WmiUnicodeMapper) {
                bl = ((WmiUnicodeMapper)object).get(c2) != null;
            }
            return bl;
        }
    }

    private static class AttributeCompareContext {
        private WmiTextModel reference;
        private int referenceIndex;
        private WmiCompositeModel parent;
        private int significantAttributes = 0;

        private AttributeCompareContext(WmiCompositeModel wmiCompositeModel, int n, int n2) throws WmiNoReadAccessException {
            this.parent = wmiCompositeModel;
            this.referenceIndex = n;
            this.reference = (WmiTextModel)wmiCompositeModel.getChild(this.referenceIndex);
        }
    }
}

