/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTableModel;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;

public class WmiTableColumnModel
extends WmiAbstractModel {
    public static final String COLUMN_WEIGHT = "weight";
    public static final Integer DEFAULT_COLUMN_WEIGHT = new Integer(100);
    public static final String SEPARATOR = "separator";
    public static final Boolean DEFAULT_SEPARATOR = Boolean.TRUE;

    public WmiTableColumnModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
        try {
            this.addAttribute(COLUMN_WEIGHT, DEFAULT_COLUMN_WEIGHT);
            this.addAttribute(SEPARATOR, DEFAULT_SEPARATOR);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
    }

    public WmiModelTag getTag() {
        return WmiModelTag.TABLE_COLUMN;
    }

    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    public int getColumnWeight() throws WmiNoReadAccessException {
        int n = DEFAULT_COLUMN_WEIGHT;
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        Object object = wmiAttributeSet.getAttribute(COLUMN_WEIGHT);
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object != null) {
            String string = object.toString();
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = DEFAULT_COLUMN_WEIGHT;
            }
        }
        return n;
    }

    public void addAttribute(Object object, Object object2) throws WmiNoWriteAccessException {
        try {
            WmiTableModel wmiTableModel = (WmiTableModel)WmiModelUtil.findAncestorOfTag((WmiModel)this, WmiModelTag.TABLE);
            if (wmiTableModel != null) {
                this.getDocument().markDirty(wmiTableModel);
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        super.addAttribute(object, object2);
    }

    public WmiUndoableEdit createUndoableEdit() {
        return new WmiTableColumnUndoableEdit(this);
    }

    protected static class WmiTableColumnUndoableEdit
    extends WmiAbstractModel.WmiAbstractModelEdit {
        protected WmiTableColumnUndoableEdit(WmiAbstractModel wmiAbstractModel) {
            super(wmiAbstractModel);
        }

        public void notifyTable() {
            WmiModel wmiModel = this.getModel();
            WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
            try {
                WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.TABLE);
                if (wmiCompositeModel != null && wmiMathDocumentModel != null) {
                    wmiMathDocumentModel.notifyModelListeners(wmiCompositeModel, 0);
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }

        public void undo() throws WmiNoUpdateAccessException {
            super.undo();
            this.notifyTable();
        }

        public void redo() throws WmiNoUpdateAccessException {
            super.redo();
            this.notifyTable();
        }
    }
}

