/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiGenericAttributeSet;

public class WmiTableCellAttributeSet
extends WmiGenericAttributeSet {
    public static final String ROWSPAN = "rowspan";
    public static final String COLUMNSPAN = "columnspan";
    public static final Integer DEFAULT_ROWSPAN = new Integer(1);
    public static final Integer DEFAULT_COLUMNSPAN = new Integer(1);

    public WmiTableCellAttributeSet() {
        this.addAttribute(ROWSPAN, DEFAULT_ROWSPAN);
        this.addAttribute(COLUMNSPAN, DEFAULT_COLUMNSPAN);
    }

    public int getRowSpan() {
        return this.getIntAttribute(ROWSPAN);
    }

    public void setRowSpan(int n) {
        this.addAttribute(ROWSPAN, new Integer(n));
    }

    public int getColumnSpan() {
        return this.getIntAttribute(COLUMNSPAN);
    }

    public int getIntAttribute(String string) {
        int n = 1;
        Object object = this.getAttribute(string);
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object != null) {
            String string2 = object.toString();
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                WmiErrorLog.log(numberFormatException);
            }
        }
        return n;
    }

    public WmiAttributeSet copyAttributes() {
        WmiTableCellAttributeSet wmiTableCellAttributeSet = new WmiTableCellAttributeSet();
        wmiTableCellAttributeSet.addAttribute(ROWSPAN, this.getAttribute(ROWSPAN));
        wmiTableCellAttributeSet.addAttribute(COLUMNSPAN, this.getAttribute(COLUMNSPAN));
        return wmiTableCellAttributeSet;
    }
}

