/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.graphics.AbstractInheritedAttributeKey;

public abstract class WmiStringAttributeKey
extends AbstractInheritedAttributeKey
implements WmiAttributeKey {
    private String name;
    private String defaultValue;

    public WmiStringAttributeKey(String string, String string2) {
        this.name = string;
        this.defaultValue = string2;
    }

    public WmiStringAttributeKey(String string, String string2, int n) {
        super(n);
        this.name = string;
        this.defaultValue = string2;
    }

    public boolean getBooleanValue(WmiAttributeSet wmiAttributeSet) {
        String string = this.getStringValue(wmiAttributeSet);
        return string != null ? string.compareToIgnoreCase("true") == 0 : false;
    }

    public int getIntValue(WmiAttributeSet wmiAttributeSet) {
        String string = this.getStringValue(wmiAttributeSet);
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            WmiErrorLog.log(numberFormatException);
        }
        return n;
    }

    public float getFloatValue(WmiAttributeSet wmiAttributeSet) {
        String string = this.getStringValue(wmiAttributeSet);
        float f = 0.0f;
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            WmiErrorLog.log(numberFormatException);
        }
        return f;
    }

    public abstract String getStringValue(WmiAttributeSet var1);

    public Object getValue(WmiAttributeSet wmiAttributeSet) {
        return this.getStringValue(wmiAttributeSet);
    }

    public void setBooleanValue(WmiAttributeSet wmiAttributeSet, boolean bl) {
        this.setStringValue(wmiAttributeSet, bl ? "true" : "false");
    }

    public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
        this.setStringValue(wmiAttributeSet, Integer.toString(n));
    }

    public void setFloatValue(WmiAttributeSet wmiAttributeSet, float f) {
        this.setStringValue(wmiAttributeSet, Float.toString(f));
    }

    public abstract void setStringValue(WmiAttributeSet var1, String var2);

    public void setValue(WmiAttributeSet wmiAttributeSet, Object object) {
        if (object == null) {
            this.setStringValue(wmiAttributeSet, null);
        } else {
            this.setStringValue(wmiAttributeSet, object.toString());
        }
    }

    public String getAttributeName() {
        return this.name;
    }

    public int getAttributeType() {
        return 3;
    }

    public String toString() {
        return this.getAttributeName();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

