/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiGenericCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.util.SearchAlgorithms;
import com.maplesoft.util.WmiSearchException;
import com.maplesoft.util.WmiSearchVisitor;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class WmiModelUtil {
    private static ModelUtilChildOperation defaultChildOp = new ModelUtilChildOperation();
    private static ModelUtilTraversalOrderedChildOperation traversalChildOp = new ModelUtilTraversalOrderedChildOperation();
    private static ModelUtilParentOperation parentOp = new ModelUtilParentOperation();
    private static WmiExportFormatter formatter = null;
    private static WmiImportParser parser = null;

    public static void copyStyleMap(WmiMathDocumentModel wmiMathDocumentModel, int n, HashMap hashMap) throws WmiNoReadAccessException {
        Iterator iterator = wmiMathDocumentModel.getStyleNames(n);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            hashMap.put(e, wmiMathDocumentModel.getStyle(n, e.toString()));
        }
    }

    public static WmiModelPath createPathToModel(WmiModelPosition wmiModelPosition, WmiModelTag[] wmiModelTagArray, boolean bl) throws WmiNoReadAccessException {
        return new WmiModelPath(WmiModelUtil.expandModelPosition(wmiModelPosition, wmiModelTagArray, bl));
    }

    public static WmiModelPosition expandModelPosition(WmiModelPosition wmiModelPosition, WmiModelTag[] wmiModelTagArray, boolean bl) throws WmiNoReadAccessException {
        WmiModel wmiModel = wmiModelPosition.getModel();
        WmiModelTag wmiModelTag = wmiModel.getTag();
        WmiModel wmiModel2 = null;
        for (int i = 0; i < wmiModelTagArray.length && wmiModel2 == null; ++i) {
            if (wmiModelTag != wmiModelTagArray[i]) continue;
            wmiModel2 = wmiModel;
        }
        if (wmiModel2 == null) {
            wmiModel2 = WmiModelUtil.findAncestorOfTag(wmiModel, wmiModelTagArray);
        }
        if (wmiModel2 != null) {
            wmiModelPosition = new WmiModelPosition(wmiModel2, bl ? 0 : -1);
        }
        return wmiModelPosition;
    }

    public static int ancestorIndexOf(WmiCompositeModel wmiCompositeModel, WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel2;
        if (wmiCompositeModel == wmiModel) {
            return 0;
        }
        WmiModel wmiModel2 = wmiModel;
        for (wmiCompositeModel2 = wmiModel2.getParent(); wmiCompositeModel2 != wmiCompositeModel && wmiCompositeModel2 != null; wmiCompositeModel2 = wmiCompositeModel2.getParent()) {
            wmiModel2 = wmiModel2.getParent();
        }
        return wmiCompositeModel2.indexOf(wmiModel2);
    }

    public static WmiModelPath mapBeginningOfCompositeModel(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        WmiModelPath wmiModelPath = new WmiModelPath(wmiCompositeModel);
        WmiCompositeModel wmiCompositeModel2 = wmiCompositeModel;
        while (wmiCompositeModel2 != null && wmiCompositeModel2.getChildCount() > 0) {
            wmiModelPath.push(0);
            WmiModel wmiModel = wmiCompositeModel2.getChild(0);
            if (wmiModel instanceof WmiCompositeModel) {
                wmiCompositeModel2 = (WmiCompositeModel)wmiModel;
                continue;
            }
            wmiCompositeModel2 = null;
            wmiModelPath.push(0);
        }
        return wmiModelPath;
    }

    public static WmiModelPath mapEndOfCompositeModel(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        WmiModelPath wmiModelPath = new WmiModelPath(wmiCompositeModel);
        WmiCompositeModel wmiCompositeModel2 = wmiCompositeModel;
        while (wmiCompositeModel2 != null && wmiCompositeModel2.getChildCount() > 0) {
            int n = wmiCompositeModel2.getChildCount() - 1;
            wmiModelPath.push(n);
            WmiModel wmiModel = wmiCompositeModel2.getChild(n);
            if (wmiModel instanceof WmiCompositeModel) {
                wmiCompositeModel2 = (WmiCompositeModel)wmiModel;
                continue;
            }
            wmiCompositeModel2 = null;
            wmiModelPath.push(-1);
        }
        return wmiModelPath;
    }

    public static int splitModel(WmiModel wmiModel, int n) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        int n2 = -1;
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        int n3 = wmiCompositeModel.indexOf(wmiModel);
        if (n3 >= 0) {
            if (wmiModel instanceof WmiTextModel) {
                WmiTextModel wmiTextModel = (WmiTextModel)wmiModel;
                if (n > 0) {
                    ++n3;
                    if (n < wmiTextModel.getLength()) {
                        wmiTextModel.splitModel(n);
                    }
                }
                n2 = n3;
            } else {
                if (n > 0) {
                    ++n3;
                    if (wmiModel instanceof WmiCompositeModel && n < ((WmiCompositeModel)wmiModel).getChildCount()) {
                        ((WmiCompositeModel)wmiModel).splitModel(n);
                    }
                }
                n2 = n3;
            }
        }
        return n2;
    }

    public static WmiModelTag getTagForString(String string) {
        WmiModelTag wmiModelTag = null;
        for (int i = 0; i < WmiModelTag.ALL_MATHDOC_TAGS.length; ++i) {
            if (!WmiModelTag.ALL_MATHDOC_TAGS[i].getName().equals(string)) continue;
            wmiModelTag = WmiModelTag.ALL_MATHDOC_TAGS[i];
        }
        return wmiModelTag;
    }

    public static boolean isLeftmostPosition(WmiModelPosition wmiModelPosition) throws WmiNoReadAccessException {
        boolean bl = false;
        WmiModel wmiModel = null;
        int n = -1;
        if (wmiModelPosition != null) {
            wmiModel = wmiModelPosition.getModel();
            n = wmiModelPosition.getOffset();
        }
        if (wmiModel != null && n == 0) {
            bl = true;
            if (wmiModel instanceof WmiMathModel) {
                WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
                while (wmiCompositeModel instanceof WmiMathModel) {
                    if (wmiCompositeModel.getChildInTraversalOrder(0) != wmiModel) {
                        bl = false;
                        break;
                    }
                    wmiModel = wmiCompositeModel;
                    wmiCompositeModel = wmiCompositeModel.getParent();
                }
            }
        }
        return bl;
    }

    public static WmiCompositeModel findAncestorOfClass(WmiModel wmiModel, Class clazz) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel;
        for (wmiCompositeModel = wmiModel.getParent(); wmiCompositeModel != null && !clazz.isInstance(wmiCompositeModel); wmiCompositeModel = wmiCompositeModel.getParent()) {
        }
        return wmiCompositeModel;
    }

    public static WmiCompositeModel findAncestorOfTag(WmiModel wmiModel, WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel;
        WmiCompositeModel wmiCompositeModel2 = wmiCompositeModel = wmiModel != null ? wmiModel.getParent() : null;
        while (wmiCompositeModel != null && wmiCompositeModel.getTag() != wmiModelTag) {
            wmiCompositeModel = wmiCompositeModel.getParent();
        }
        return wmiCompositeModel;
    }

    public static WmiCompositeModel findAncestorOfTag(WmiModel wmiModel, WmiModelTag[] wmiModelTagArray) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel = null;
        for (int i = 0; i < wmiModelTagArray.length && wmiCompositeModel == null; ++i) {
            wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModel, wmiModelTagArray[i]);
        }
        return wmiCompositeModel;
    }

    public static WmiCompositeModel findAncestorOfTags(WmiModel wmiModel, WmiModelTag[] wmiModelTagArray) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel;
        WmiCompositeModel wmiCompositeModel2 = null;
        if (wmiModel != null && (wmiCompositeModel = wmiModel.getParent()) != null) {
            WmiModelTag wmiModelTag = wmiCompositeModel.getTag();
            for (int i = 0; i < wmiModelTagArray.length && wmiCompositeModel2 == null; ++i) {
                if (wmiModelTag != wmiModelTagArray[i]) continue;
                wmiCompositeModel2 = wmiCompositeModel;
            }
            if (wmiCompositeModel2 == null) {
                wmiCompositeModel2 = WmiModelUtil.findAncestorOfTags(wmiCompositeModel, wmiModelTagArray);
            }
        }
        return wmiCompositeModel2;
    }

    public static WmiModel findAncestorWithAttribute(WmiModel wmiModel, Object object, Object object2) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch modelUtilAttributeMatch = new ModelUtilAttributeMatch(wmiModel, object, object2);
        return WmiModelUtil.parentSearch(wmiModel, modelUtilAttributeMatch);
    }

    public static WmiModel findAncestorWithAttribute(WmiModel wmiModel, Object object) throws WmiNoReadAccessException {
        ModelUtilAttributeFind modelUtilAttributeFind = new ModelUtilAttributeFind(wmiModel, object);
        return WmiModelUtil.parentSearch(wmiModel, modelUtilAttributeFind);
    }

    public static boolean isModelAncestorOfModel(WmiModel wmiModel, WmiModel wmiModel2) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel = null;
        if (wmiModel != wmiModel2) {
            wmiCompositeModel = WmiModelUtil.parentSearch(wmiModel2, new ModelUtilEqualityMatch(wmiModel));
        }
        return wmiCompositeModel != null;
    }

    public static boolean isEmptyIdentifierModel(WmiModel wmiModel) throws WmiNoReadAccessException {
        int n;
        boolean bl = false;
        if (wmiModel instanceof WmiIdentifierModel && (n = ((WmiIdentifierModel)wmiModel).getLength()) == 0) {
            bl = true;
        }
        return bl;
    }

    public static WmiCompositeModel findParentParagraph(WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel = null;
        for (WmiCompositeModel wmiCompositeModel2 = wmiModel.getParent(); wmiCompositeModel2 != null; wmiCompositeModel2 = wmiCompositeModel2.getParent()) {
            if (!(wmiCompositeModel2 instanceof WmiParagraphModel)) continue;
            wmiCompositeModel = wmiCompositeModel2;
            break;
        }
        return wmiCompositeModel;
    }

    public static WmiModel findFirstDescendantOfClass(WmiModel wmiModel, Class clazz) throws WmiNoReadAccessException {
        ModelUtilClassMatch modelUtilClassMatch = new ModelUtilClassMatch(wmiModel, clazz);
        return WmiModelUtil.depthFirstSearch(wmiModel, defaultChildOp, modelUtilClassMatch, 1);
    }

    public static WmiModel findFirstDescendantOfTag(WmiModel wmiModel, WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        ModelUtilTagMatch modelUtilTagMatch = new ModelUtilTagMatch(wmiModel, wmiModelTag);
        return WmiModelUtil.depthFirstSearch(wmiModel, defaultChildOp, modelUtilTagMatch, 1);
    }

    public static WmiModel findFirstDescendantOfTag(WmiModel wmiModel, WmiModelTag[] wmiModelTagArray) throws WmiNoReadAccessException {
        ModelUtilTagsMatch modelUtilTagsMatch = new ModelUtilTagsMatch(wmiModel, wmiModelTagArray);
        return WmiModelUtil.depthFirstSearch(wmiModel, defaultChildOp, modelUtilTagsMatch, 1);
    }

    public static WmiModel findLastDescendantOfTag(WmiModel wmiModel, WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        ModelUtilTagMatch modelUtilTagMatch = new ModelUtilTagMatch(wmiModel, wmiModelTag);
        return WmiModelUtil.depthFirstSearch(wmiModel, defaultChildOp, modelUtilTagMatch, -1);
    }

    public static WmiModel findFirstDescendantWithAttribute(WmiModel wmiModel, Object object) throws WmiNoReadAccessException {
        ModelUtilAttributeFind modelUtilAttributeFind = new ModelUtilAttributeFind(wmiModel, object);
        return WmiModelUtil.depthFirstSearch(wmiModel, defaultChildOp, modelUtilAttributeFind, 1);
    }

    public static WmiModel findFirstDescendantWithAttribute(WmiModel wmiModel, Object object, Object object2) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch modelUtilAttributeMatch = new ModelUtilAttributeMatch(wmiModel, object, object2);
        return WmiModelUtil.depthFirstSearch(wmiModel, defaultChildOp, modelUtilAttributeMatch, 1);
    }

    public static WmiModel findLastDescendantWithAttribute(WmiModel wmiModel, Object object, Object object2) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch modelUtilAttributeMatch = new ModelUtilAttributeMatch(wmiModel, object, object2);
        return WmiModelUtil.depthFirstSearch(wmiModel, defaultChildOp, modelUtilAttributeMatch, -1);
    }

    public static WmiModel findFirstDescendantLeaf(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        ModelUtilClassNotMatch modelUtilClassNotMatch = new ModelUtilClassNotMatch(WmiCompositeModel.class);
        return WmiModelUtil.depthFirstSearch(wmiCompositeModel, defaultChildOp, modelUtilClassNotMatch, 1);
    }

    public static WmiModel findLastDescendantLeaf(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        ModelUtilClassNotMatch modelUtilClassNotMatch = new ModelUtilClassNotMatch(WmiCompositeModel.class);
        return WmiModelUtil.depthFirstSearch(wmiCompositeModel, defaultChildOp, modelUtilClassNotMatch, -1);
    }

    public static WmiModel findNextDescendantLeaf(WmiCompositeModel wmiCompositeModel, WmiModel wmiModel) throws WmiNoReadAccessException {
        ModelUtilClassNotMatch modelUtilClassNotMatch = new ModelUtilClassNotMatch(WmiCompositeModel.class);
        return WmiModelUtil.searchFromReference(wmiCompositeModel, wmiModel, modelUtilClassNotMatch, 1);
    }

    public static WmiModel findPreviousDescendantLeaf(WmiCompositeModel wmiCompositeModel, WmiModel wmiModel) throws WmiNoReadAccessException {
        ModelUtilClassNotMatch modelUtilClassNotMatch = new ModelUtilClassNotMatch(WmiCompositeModel.class);
        return WmiModelUtil.searchFromReference(wmiCompositeModel, wmiModel, modelUtilClassNotMatch, -1);
    }

    public static WmiModel findFirstTraversalOrderedDescendantOfTag(WmiModel wmiModel, WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        ModelUtilTagMatch modelUtilTagMatch = new ModelUtilTagMatch(wmiModel, wmiModelTag);
        return WmiModelUtil.depthFirstSearch(wmiModel, traversalChildOp, modelUtilTagMatch, 1);
    }

    public static WmiModel findLastTraversalOrderedDescendantOfTag(WmiModel wmiModel, WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        ModelUtilTagMatch modelUtilTagMatch = new ModelUtilTagMatch(wmiModel, wmiModelTag);
        return WmiModelUtil.depthFirstSearch(wmiModel, traversalChildOp, modelUtilTagMatch, -1);
    }

    public static WmiModel findFirstTraversalOrderedDescendantWithAttribute(WmiModel wmiModel, Object object, Object object2) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch modelUtilAttributeMatch = new ModelUtilAttributeMatch(wmiModel, object, object2);
        return WmiModelUtil.depthFirstSearch(wmiModel, traversalChildOp, modelUtilAttributeMatch, 1);
    }

    public static WmiModel findLastTraversalOrderedDescendantWithAttribute(WmiModel wmiModel, Object object, Object object2) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch modelUtilAttributeMatch = new ModelUtilAttributeMatch(wmiModel, object, object2);
        return WmiModelUtil.depthFirstSearch(wmiModel, traversalChildOp, modelUtilAttributeMatch, -1);
    }

    public static WmiModel findNextModel(WmiModel wmiModel, WmiModel wmiModel2, Class clazz) throws WmiNoReadAccessException {
        ModelUtilClassMatch modelUtilClassMatch = new ModelUtilClassMatch(wmiModel2, clazz);
        return WmiModelUtil.searchFromReference(wmiModel, wmiModel2, modelUtilClassMatch, 1);
    }

    public static WmiModel findNextModel(WmiModel wmiModel, WmiModel wmiModel2, WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        ModelUtilTagMatch modelUtilTagMatch = new ModelUtilTagMatch(wmiModel2, wmiModelTag);
        return WmiModelUtil.searchFromReference(wmiModel, wmiModel2, modelUtilTagMatch, 1);
    }

    public static WmiModel findNextModel(WmiModel wmiModel, WmiModel wmiModel2, WmiModelTag[] wmiModelTagArray) throws WmiNoReadAccessException {
        ModelUtilTagsMatch modelUtilTagsMatch = new ModelUtilTagsMatch(wmiModel2, wmiModelTagArray);
        return WmiModelUtil.searchFromReference(wmiModel, wmiModel2, modelUtilTagsMatch, 1);
    }

    public static WmiModel findNextModelWithAttribute(WmiModel wmiModel, WmiModel wmiModel2, Object object, Object object2) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch modelUtilAttributeMatch = new ModelUtilAttributeMatch(wmiModel2, object, object2);
        return WmiModelUtil.searchFromReference(wmiModel, wmiModel2, modelUtilAttributeMatch, 1);
    }

    public static WmiModel findNextModelWithAttribute(WmiModel wmiModel, WmiModel wmiModel2, Object object) throws WmiNoReadAccessException {
        ModelUtilAttributeFind modelUtilAttributeFind = new ModelUtilAttributeFind(wmiModel2, object);
        return WmiModelUtil.searchFromReference(wmiModel, wmiModel2, modelUtilAttributeFind, 1);
    }

    public static WmiModel findNextModel(WmiModel wmiModel, WmiModel wmiModel2, Object object, Object object2) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch modelUtilAttributeMatch = new ModelUtilAttributeMatch(wmiModel2, object, object2);
        return WmiModelUtil.searchFromReference(wmiModel, wmiModel2, modelUtilAttributeMatch, 1);
    }

    public static WmiModel findPreviousModel(WmiModel wmiModel, WmiModel wmiModel2, Class clazz) throws WmiNoReadAccessException {
        ModelUtilClassMatch modelUtilClassMatch = new ModelUtilClassMatch(wmiModel2, clazz);
        return WmiModelUtil.searchFromReference(wmiModel, wmiModel2, modelUtilClassMatch, -1);
    }

    public static WmiModel findPreviousModel(WmiModel wmiModel, WmiModel wmiModel2, WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        ModelUtilTagMatch modelUtilTagMatch = new ModelUtilTagMatch(wmiModel2, wmiModelTag);
        return WmiModelUtil.searchFromReference(wmiModel, wmiModel2, modelUtilTagMatch, -1);
    }

    public static WmiModel findPreviousModel(WmiModel wmiModel, WmiModel wmiModel2, Object object, Object object2) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch modelUtilAttributeMatch = new ModelUtilAttributeMatch(wmiModel2, object, object2);
        return WmiModelUtil.searchFromReference(wmiModel, wmiModel2, modelUtilAttributeMatch, -1);
    }

    public static WmiModel findNextTraversalOrderedModel(WmiModel wmiModel, WmiModel wmiModel2, WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        ModelUtilTagMatch modelUtilTagMatch = new ModelUtilTagMatch(wmiModel2, wmiModelTag);
        return WmiModelUtil.searchFromTraversalOrderedReference(wmiModel, wmiModel2, modelUtilTagMatch, 1);
    }

    public static WmiModel findNextTraversalOrderedModel(WmiModel wmiModel, WmiModel wmiModel2, WmiModelTag[] wmiModelTagArray) throws WmiNoReadAccessException {
        ModelUtilTagsMatch modelUtilTagsMatch = new ModelUtilTagsMatch(wmiModel2, wmiModelTagArray);
        return WmiModelUtil.searchFromTraversalOrderedReference(wmiModel, wmiModel2, modelUtilTagsMatch, 1);
    }

    public static WmiModel findNextTraversalOrderedModel(WmiModel wmiModel, WmiModel wmiModel2, Object object, Object object2) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch modelUtilAttributeMatch = new ModelUtilAttributeMatch(wmiModel2, object, object2);
        return WmiModelUtil.searchFromTraversalOrderedReference(wmiModel, wmiModel2, modelUtilAttributeMatch, 1);
    }

    public static WmiModel findNextTraversalOrderedModelWithAttribute(WmiModel wmiModel, WmiModel wmiModel2, Object object, Object object2) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch modelUtilAttributeMatch = new ModelUtilAttributeMatch(wmiModel2, object, object2);
        return WmiModelUtil.searchFromTraversalOrderedReference(wmiModel, wmiModel2, modelUtilAttributeMatch, 1);
    }

    public static WmiModel findNextTraversalOrderedModelWithAttribute(WmiModel wmiModel, WmiModel wmiModel2, Object object) throws WmiNoReadAccessException {
        ModelUtilAttributeFind modelUtilAttributeFind = new ModelUtilAttributeFind(wmiModel2, object);
        return WmiModelUtil.searchFromTraversalOrderedReference(wmiModel, wmiModel2, modelUtilAttributeFind, 1);
    }

    public static WmiModel findPreviousTraversalOrderedModel(WmiModel wmiModel, WmiModel wmiModel2, WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        ModelUtilTagMatch modelUtilTagMatch = new ModelUtilTagMatch(wmiModel2, wmiModelTag);
        return WmiModelUtil.searchFromTraversalOrderedReference(wmiModel, wmiModel2, modelUtilTagMatch, -1);
    }

    public static WmiModel findPreviousTraversalOrderedModel(WmiModel wmiModel, WmiModel wmiModel2, WmiModelTag[] wmiModelTagArray) throws WmiNoReadAccessException {
        ModelUtilTagsMatch modelUtilTagsMatch = new ModelUtilTagsMatch(wmiModel2, wmiModelTagArray);
        return WmiModelUtil.searchFromTraversalOrderedReference(wmiModel, wmiModel2, modelUtilTagsMatch, -1);
    }

    public static WmiModel findPreviousTraversalOrderedModel(WmiModel wmiModel, WmiModel wmiModel2, Object object, Object object2) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch modelUtilAttributeMatch = new ModelUtilAttributeMatch(wmiModel2, object, object2);
        return WmiModelUtil.searchFromTraversalOrderedReference(wmiModel, wmiModel2, modelUtilAttributeMatch, -1);
    }

    public static void collectModels(WmiModel wmiModel, WmiModelTag wmiModelTag, Collection collection) throws WmiNoReadAccessException {
        WmiModelUtil.collectModels(wmiModel, wmiModelTag, collection, null);
    }

    public static void collectModels(WmiModel wmiModel, WmiModelTag wmiModelTag, Collection collection, WmiModelTag wmiModelTag2) throws WmiNoReadAccessException {
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        WmiModelUtil.visitModelsWithConditions(wmiModel, new WmiModelCollector(collection), wmiModelTag, wmiModelTag2);
    }

    public static void collectModels(WmiModel wmiModel, Class clazz, Collection collection) throws WmiNoReadAccessException {
        WmiModelUtil.collectModels(wmiModel, clazz, collection, null);
    }

    public static void collectModels(WmiModel wmiModel, Class clazz, Collection collection, Class clazz2) throws WmiNoReadAccessException {
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        WmiModelUtil.visitModelsWithConditions(wmiModel, new WmiModelCollector(collection), clazz, clazz2);
    }

    private static void visitModelsWithConditions(WmiModel wmiModel, WmiSearchVisitor wmiSearchVisitor, Object object, Object object2) throws WmiNoReadAccessException {
        block8: {
            SearchAlgorithms.MatchCondition matchCondition = null;
            if (object instanceof WmiModelTag) {
                matchCondition = new ModelUtilTagMatch(wmiModel, (WmiModelTag)object);
            } else if (object instanceof Class) {
                matchCondition = new ModelUtilClassMatch(wmiModel, (Class)object);
            }
            SearchAlgorithms.MatchCondition matchCondition2 = null;
            if (object2 instanceof WmiModelTag) {
                matchCondition2 = new ModelUtilTagMatch(wmiModel, (WmiModelTag)object2);
            } else if (object2 instanceof Class) {
                matchCondition2 = new ModelUtilClassMatch(wmiModel, (Class)object2);
            }
            try {
                SearchAlgorithms.depthFirstVisit(wmiModel, defaultChildOp, matchCondition, matchCondition2, 1, wmiSearchVisitor);
            }
            catch (WmiSearchException wmiSearchException) {
                Exception exception = wmiSearchException.getOriginatingException();
                if (!(exception instanceof WmiNoReadAccessException)) break block8;
                throw (WmiNoReadAccessException)exception;
            }
        }
    }

    public static void visitModels(WmiModel wmiModel, WmiSearchVisitor wmiSearchVisitor) throws WmiNoReadAccessException {
        WmiModelUtil.visitModelsWithConditions(wmiModel, wmiSearchVisitor, null, null);
    }

    public static void visitModels(WmiModel wmiModel, WmiSearchVisitor wmiSearchVisitor, WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        WmiModelUtil.visitModelsWithConditions(wmiModel, wmiSearchVisitor, wmiModelTag, null);
    }

    public static void visitModels(WmiModel wmiModel, WmiSearchVisitor wmiSearchVisitor, WmiModelTag wmiModelTag, WmiModelTag wmiModelTag2) throws WmiNoReadAccessException {
        WmiModelUtil.visitModelsWithConditions(wmiModel, wmiSearchVisitor, wmiModelTag, wmiModelTag2);
    }

    public static WmiModel commonParent(WmiModelPosition wmiModelPosition, WmiModelPosition wmiModelPosition2) throws WmiNoReadAccessException {
        return WmiModelUtil.commonParent(wmiModelPosition.getModel(), wmiModelPosition2.getModel());
    }

    public static WmiModel commonParent(WmiModel wmiModel, WmiModel wmiModel2) throws WmiNoReadAccessException {
        WmiModel wmiModel3;
        WmiModel wmiModel4 = null;
        Stack<WmiModel> stack = new Stack<WmiModel>();
        Stack<WmiModel> stack2 = new Stack<WmiModel>();
        for (wmiModel3 = wmiModel; wmiModel3 != null; wmiModel3 = wmiModel3.getParent()) {
            stack.push(wmiModel3);
        }
        for (wmiModel3 = wmiModel2; wmiModel3 != null; wmiModel3 = wmiModel3.getParent()) {
            stack2.push(wmiModel3);
        }
        wmiModel4 = (WmiModel)stack.pop();
        stack2.pop();
        while (!stack.isEmpty() && !stack2.isEmpty() && stack.peek() == stack2.peek()) {
            wmiModel4 = (WmiModel)stack.pop();
            stack2.pop();
        }
        return wmiModel4;
    }

    public static void visitModels(WmiModel wmiModel, WmiSearchVisitor wmiSearchVisitor, Class clazz, Class clazz2) throws WmiNoReadAccessException {
        WmiModelUtil.visitModelsWithConditions(wmiModel, wmiSearchVisitor, clazz, clazz2);
    }

    public static WmiModel deepCopy(WmiModel wmiModel, WmiMathDocumentModel wmiMathDocumentModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (parser == null || formatter == null) {
            throw new IllegalStateException("setDeepCopyIOHandlers must be called prior to invoking deepCopy.");
        }
        WmiGenericCompositeModel wmiGenericCompositeModel = new WmiGenericCompositeModel(wmiMathDocumentModel, null);
        StringWriter stringWriter = new StringWriter();
        try {
            formatter.format(stringWriter, wmiModel);
        }
        catch (WmiFormatException wmiFormatException) {
            WmiErrorLog.log(wmiFormatException);
            return null;
        }
        StringReader stringReader = new StringReader(((Object)stringWriter).toString());
        try {
            parser.parse(stringReader, (WmiCompositeModel)wmiGenericCompositeModel, 0);
        }
        catch (WmiParseException wmiParseException) {
            WmiErrorLog.log(wmiParseException);
            return null;
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            return null;
        }
        WmiModel wmiModel2 = wmiGenericCompositeModel.getChild(0);
        wmiModel2.setParent(null);
        return wmiModel2;
    }

    public static void setDeepCopyIOHandlers(WmiImportParser wmiImportParser, WmiExportFormatter wmiExportFormatter) {
        parser = wmiImportParser;
        formatter = wmiExportFormatter;
    }

    private static WmiModel depthFirstSearch(WmiModel wmiModel, SearchAlgorithms.ChildOperation childOperation, SearchAlgorithms.MatchCondition matchCondition, int n) throws WmiNoReadAccessException {
        WmiModel wmiModel2;
        block2: {
            wmiModel2 = null;
            try {
                wmiModel2 = (WmiModel)SearchAlgorithms.depthFirstSearch(wmiModel, childOperation, matchCondition, n);
            }
            catch (WmiSearchException wmiSearchException) {
                Exception exception = wmiSearchException.getOriginatingException();
                if (!(exception instanceof WmiNoReadAccessException)) break block2;
                throw (WmiNoReadAccessException)exception;
            }
        }
        return wmiModel2;
    }

    private static WmiCompositeModel parentSearch(WmiModel wmiModel, SearchAlgorithms.MatchCondition matchCondition) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel;
        block2: {
            wmiCompositeModel = null;
            try {
                wmiCompositeModel = (WmiCompositeModel)SearchAlgorithms.parentSearch(wmiModel, parentOp, matchCondition);
            }
            catch (WmiSearchException wmiSearchException) {
                Exception exception = wmiSearchException.getOriginatingException();
                if (!(exception instanceof WmiNoReadAccessException)) break block2;
                throw (WmiNoReadAccessException)exception;
            }
        }
        return wmiCompositeModel;
    }

    public static boolean shareAncestorOfTag(WmiModel wmiModel, WmiModel wmiModel2, WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel;
        WmiCompositeModel wmiCompositeModel2 = WmiModelUtil.findAncestorOfTag(wmiModel, wmiModelTag);
        return wmiCompositeModel2 == (wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModel2, wmiModelTag));
    }

    private static WmiModel searchFromReference(WmiModel wmiModel, WmiModel wmiModel2, SearchAlgorithms.MatchCondition matchCondition, int n) throws WmiNoReadAccessException {
        WmiModel wmiModel3 = null;
        WmiCompositeModel wmiCompositeModel = wmiModel2 != null ? wmiModel2.getParent() : null;
        int n2 = wmiCompositeModel != null ? wmiCompositeModel.indexOf(wmiModel2) : -1;
        n2 += n == 1 ? 1 : -1;
        if (wmiCompositeModel != null) {
            if (n2 >= 0 && n2 < wmiCompositeModel.getChildCount()) {
                WmiModel wmiModel4 = wmiCompositeModel.getChild(n2);
                wmiModel3 = matchCondition.matchesCondition(wmiModel4) ? wmiModel4 : WmiModelUtil.depthFirstSearch(wmiModel4, defaultChildOp, matchCondition, n);
                if (wmiModel3 == null) {
                    wmiModel3 = WmiModelUtil.searchFromReference(wmiModel, wmiModel4, matchCondition, n);
                }
            } else if (wmiCompositeModel != null && wmiCompositeModel != wmiModel) {
                wmiModel3 = WmiModelUtil.searchFromReference(wmiModel, wmiCompositeModel, matchCondition, n);
            }
        }
        return wmiModel3;
    }

    private static WmiModel searchFromTraversalOrderedReference(WmiModel wmiModel, WmiModel wmiModel2, SearchAlgorithms.MatchCondition matchCondition, int n) throws WmiNoReadAccessException {
        WmiModel wmiModel3 = null;
        WmiCompositeModel wmiCompositeModel = wmiModel2.getParent();
        int n2 = wmiCompositeModel != null ? wmiCompositeModel.indexOfInTraversalOrder(wmiModel2) : -1;
        n2 += n == 1 ? 1 : -1;
        if (wmiCompositeModel != null) {
            if (n2 >= 0 && n2 < wmiCompositeModel.getChildCount()) {
                WmiModel wmiModel4 = wmiCompositeModel.getChildInTraversalOrder(n2);
                wmiModel3 = matchCondition.matchesCondition(wmiModel4) ? wmiModel4 : WmiModelUtil.depthFirstSearch(wmiModel4, traversalChildOp, matchCondition, n);
                if (wmiModel3 == null) {
                    wmiModel3 = WmiModelUtil.searchFromTraversalOrderedReference(wmiModel, wmiModel4, matchCondition, n);
                }
            } else if (wmiCompositeModel != null && wmiCompositeModel != wmiModel) {
                wmiModel3 = WmiModelUtil.searchFromTraversalOrderedReference(wmiModel, wmiCompositeModel, matchCondition, n);
            }
        }
        return wmiModel3;
    }

    public static int getRemainingChildCount(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        int n = wmiCompositeModel.getChildCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (wmiCompositeModel.getChild(i) instanceof WmiDeletePlaceholderModel) continue;
            ++n2;
        }
        return n2;
    }

    public static int getDeletedChildCount(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        int n = wmiCompositeModel.getChildCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!(wmiCompositeModel.getChild(i) instanceof WmiDeletePlaceholderModel)) continue;
            ++n2;
        }
        return n2;
    }

    public static int getFirstNonDeletePlaceHolderPosition(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        int n = wmiCompositeModel.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (wmiCompositeModel.getChild(i) instanceof WmiDeletePlaceholderModel) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstDeletePlaceHolderPosition(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        int n = wmiCompositeModel.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (!(wmiCompositeModel.getChild(i) instanceof WmiDeletePlaceholderModel)) continue;
            return i;
        }
        return -1;
    }

    private WmiModelUtil() {
    }

    public static WmiModel getPreviousSibling(WmiModel wmiModel) throws WmiNoReadAccessException {
        int n;
        int n2;
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        WmiModel wmiModel2 = null;
        if (wmiCompositeModel != null && (n2 = (n = wmiCompositeModel.indexOf(wmiModel)) - 1) > -1) {
            wmiModel2 = wmiCompositeModel.getChild(n2);
        }
        return wmiModel2;
    }

    public static WmiModel getNextSibling(WmiModel wmiModel) throws WmiNoReadAccessException {
        int n;
        int n2;
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        WmiModel wmiModel2 = null;
        if (wmiCompositeModel != null && (n2 = (n = wmiCompositeModel.indexOf(wmiModel)) + 1) < wmiCompositeModel.getChildCount()) {
            wmiModel2 = wmiCompositeModel.getChild(n2);
        }
        return wmiModel2;
    }

    public static int getNumEmptyIdentifiers(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        if (wmiCompositeModel == null) {
            return 0;
        }
        int n = 0;
        int n2 = wmiCompositeModel.getChildCount();
        for (int i = 0; i < n2; ++i) {
            WmiModel wmiModel = wmiCompositeModel.getChild(i);
            if (!WmiModelUtil.isEmptyIdentifierModel(wmiModel)) continue;
            ++n;
        }
        return n;
    }

    public static boolean isEmptyModel(WmiModel wmiModel) throws WmiNoReadAccessException {
        return WmiModelUtil.isEmptyModel(wmiModel, null);
    }

    public static boolean isEmptyModel(WmiModel wmiModel, WmiModel wmiModel2) throws WmiNoReadAccessException {
        WmiModelTag wmiModelTag;
        boolean bl = false;
        WmiModelTag wmiModelTag2 = wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
        if (wmiModelTag == WmiModelTag.MATH_NUMERIC || wmiModelTag == WmiModelTag.MATH_IDENTIFIER || wmiModelTag == WmiModelTag.MATH_OPERATOR) {
            if (wmiModel != wmiModel2) {
                bl = ((WmiTextModel)wmiModel).getLength() == 0;
            }
        } else if (wmiModelTag != WmiModelTag.MATH_SPACE && wmiModelTag != WmiModelTag.MATH_SQUARE_ROOT && wmiModelTag != WmiModelTag.MATH_NROOT && wmiModelTag != WmiModelTag.MATH_FRAC && wmiModelTag != WmiModelTag.MATH_FENCED && wmiModelTag != WmiModelTag.MATH_TABLE_CELL) {
            if (wmiModelTag == WmiModelTag.MATH_ROW && wmiModel.getAttributesForRead().getAttribute("Typesetting:-msemantics") != null && wmiModel.getAttributesForRead().getAttribute("Typesetting:-msemantics").equals("donotprune")) {
                bl = false;
            } else if (wmiModel instanceof WmiCompositeModel) {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
                bl = true;
                int n = wmiCompositeModel.getChildCount();
                for (int i = 0; i < n && (bl = WmiModelUtil.isEmptyModel(wmiCompositeModel.getChild(i), wmiModel2)); ++i) {
                }
            }
        }
        return bl;
    }

    private static class ModelUtilTagsMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiModel origin = null;
        private WmiModelTag[] tags = null;

        private ModelUtilTagsMatch(WmiModel wmiModel, WmiModelTag[] wmiModelTagArray) {
            this.origin = wmiModel;
            this.tags = wmiModelTagArray;
        }

        public boolean matchesCondition(Object object) {
            boolean bl = false;
            for (int i = 0; i < this.tags.length && !(bl |= object != this.origin && ((WmiModel)object).getTag() == this.tags[i]); ++i) {
            }
            return bl;
        }
    }

    protected static class WmiModelCollector
    implements WmiSearchVisitor {
        private Collection collection;

        protected WmiModelCollector(Collection collection) {
            this.collection = collection;
        }

        public int visitMatch(Object object) {
            int n = 2;
            try {
                this.collection.add(object);
                n = 0;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return n;
        }
    }

    private static class ModelUtilEqualityMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiModel toMatch = null;

        private ModelUtilEqualityMatch(WmiModel wmiModel) {
            this.toMatch = wmiModel;
        }

        public boolean matchesCondition(Object object) {
            return object == this.toMatch;
        }
    }

    private static class ModelUtilAttributeFind
    implements SearchAlgorithms.MatchCondition {
        private WmiModel origin = null;
        private Object attribute = null;

        private ModelUtilAttributeFind(WmiModel wmiModel, Object object) {
            this.origin = wmiModel;
            this.attribute = object;
        }

        public boolean matchesCondition(Object object) {
            boolean bl = false;
            if (object != this.origin) {
                WmiModel wmiModel = (WmiModel)object;
                try {
                    Object object2;
                    WmiAttributeSet wmiAttributeSet = wmiModel.getAttributesForRead();
                    if (wmiAttributeSet != null && (object2 = wmiAttributeSet.getAttribute(this.attribute)) != null) {
                        bl = true;
                    }
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
            }
            return bl;
        }
    }

    private static class ModelUtilAttributeMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiModel origin = null;
        private Object attribute = null;
        private Object value = null;

        private ModelUtilAttributeMatch(WmiModel wmiModel, Object object, Object object2) {
            this.origin = wmiModel;
            this.attribute = object;
            this.value = object2;
        }

        public boolean matchesCondition(Object object) {
            boolean bl = false;
            if (object != this.origin) {
                WmiModel wmiModel = (WmiModel)object;
                try {
                    WmiAttributeSet wmiAttributeSet = wmiModel.getAttributesForRead();
                    Object object2 = wmiAttributeSet.getAttribute(this.attribute);
                    if (object2 != null && object2.equals(this.value)) {
                        bl = true;
                    }
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
            }
            return bl;
        }
    }

    private static class ModelUtilTagMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiModel origin = null;
        private WmiModelTag tag = null;

        private ModelUtilTagMatch(WmiModel wmiModel, WmiModelTag wmiModelTag) {
            this.origin = wmiModel;
            this.tag = wmiModelTag;
        }

        public boolean matchesCondition(Object object) {
            return object instanceof WmiModel && object != this.origin && ((WmiModel)object).getTag() == this.tag;
        }
    }

    private static class ModelUtilClassNotMatch
    implements SearchAlgorithms.MatchCondition {
        private Class toMatch = null;

        private ModelUtilClassNotMatch(Class clazz) {
            this.toMatch = clazz;
        }

        public boolean matchesCondition(Object object) {
            return !this.toMatch.isInstance(object);
        }
    }

    private static class ModelUtilClassMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiModel model = null;
        private Class toMatch = null;

        private ModelUtilClassMatch(WmiModel wmiModel, Class clazz) {
            this.model = wmiModel;
            this.toMatch = clazz;
        }

        public boolean matchesCondition(Object object) {
            return (this.model == null || this.model != object) && this.toMatch.isInstance(object);
        }
    }

    private static class ModelUtilParentOperation
    implements SearchAlgorithms.ParentOperation {
        private ModelUtilParentOperation() {
        }

        public Object getParent(Object object) throws WmiSearchException {
            WmiModel wmiModel = (WmiModel)object;
            WmiCompositeModel wmiCompositeModel = null;
            try {
                wmiCompositeModel = wmiModel.getParent();
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                throw new WmiSearchException(wmiNoReadAccessException);
            }
            return wmiCompositeModel;
        }
    }

    private static class ModelUtilTraversalOrderedChildOperation
    extends ModelUtilChildOperation {
        private ModelUtilTraversalOrderedChildOperation() {
        }

        public Object getChild(Object object, int n) throws WmiSearchException {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)object;
            WmiModel wmiModel = null;
            try {
                wmiModel = wmiCompositeModel.getChildInTraversalOrder(n);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                throw new WmiSearchException(wmiNoReadAccessException);
            }
            return wmiModel;
        }
    }

    private static class ModelUtilChildOperation
    implements SearchAlgorithms.ChildOperation {
        private ModelUtilChildOperation() {
        }

        public Object getChild(Object object, int n) throws WmiSearchException {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)object;
            WmiModel wmiModel = null;
            try {
                wmiModel = wmiCompositeModel.getChild(n);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                throw new WmiSearchException(wmiNoReadAccessException);
            }
            return wmiModel;
        }

        public int getChildCount(Object object) throws WmiSearchException {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)object;
            int n = 0;
            try {
                n = wmiCompositeModel.getChildCount();
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                throw new WmiSearchException(wmiNoReadAccessException);
            }
            return n;
        }

        public boolean hasChildren(Object object) {
            return object instanceof WmiCompositeModel;
        }
    }
}

